/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.measure.hllc.HLLCounter;

public class CubeStatsWriter {
    public static void writeCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage) throws IOException {
        CubeStatsWriter.writeCuboidStatistics(conf, outputPath, cuboidHLLMap, samplingPercentage, 0, 0.0, 0L);
    }

    public static void writeCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, long sourceRecordCoun) throws IOException {
        CubeStatsWriter.writeCuboidStatistics(conf, outputPath, cuboidHLLMap, samplingPercentage, 0, 0.0, sourceRecordCoun);
    }

    public static void writeCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, int mapperNumber, double mapperOverlapRatio, long sourceRecordCoun) throws IOException {
        Path seqFilePath = new Path(outputPath, "cuboid_statistics.seq");
        CubeStatsWriter.writeCuboidStatisticsInner(conf, seqFilePath, cuboidHLLMap, samplingPercentage, mapperNumber, mapperOverlapRatio, sourceRecordCoun);
    }

    public static void writePartialCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, int mapperNumber, double mapperOverlapRatio, int shard) throws IOException {
        Path seqFilePath = new Path(outputPath, "statistics_" + shard);
        CubeStatsWriter.writeCuboidStatisticsInner(conf, seqFilePath, cuboidHLLMap, samplingPercentage, mapperNumber, mapperOverlapRatio, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCuboidStatisticsInner(Configuration conf, Path outputFilePath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, int mapperNumber, double mapperOverlapRatio, long sourceRecordCount) throws IOException {
        ArrayList allCuboids = Lists.newArrayList();
        allCuboids.addAll(cuboidHLLMap.keySet());
        Collections.sort(allCuboids);
        ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)outputFilePath), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(BytesWritable.class)});
        try {
            writer.append((Writable)new LongWritable(-1L), (Writable)new BytesWritable(Bytes.toBytes((double)mapperOverlapRatio)));
            writer.append((Writable)new LongWritable(-2L), (Writable)new BytesWritable(Bytes.toBytes((int)mapperNumber)));
            writer.append((Writable)new LongWritable(0L), (Writable)new BytesWritable(Bytes.toBytes((int)samplingPercentage)));
            writer.append((Writable)new LongWritable(-3L), (Writable)new BytesWritable(Bytes.toBytes((long)sourceRecordCount)));
            Iterator iterator = allCuboids.iterator();
            while (iterator.hasNext()) {
                long i = (Long)iterator.next();
                valueBuf.clear();
                cuboidHLLMap.get(i).writeRegisters(valueBuf);
                valueBuf.flip();
                writer.append((Writable)new LongWritable(i), (Writable)new BytesWritable(valueBuf.array(), valueBuf.limit()));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
    }
}

