/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config.impl;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.knox.gateway.config.ConfigurationAdapter;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.config.spi.ConfigurationAdapterDescriptor;

public class ConfigurationAdapterFactory {
    private static Map<Class<?>, Class<? extends ConfigurationAdapter>> ADAPTERS;

    private static synchronized Map<Class<?>, Class<? extends ConfigurationAdapter>> getAdapters() {
        if (ADAPTERS == null) {
            ConfigurationAdapterFactory.loadAdapters();
        }
        return ADAPTERS;
    }

    private static void loadAdapters() {
        Iterator<ConfigurationAdapterDescriptor> i;
        HashMap all = new HashMap();
        ServiceLoader<ConfigurationAdapterDescriptor> loader = ServiceLoader.load(ConfigurationAdapterDescriptor.class);
        if (loader != null && (i = loader.iterator()) != null) {
            while (i.hasNext()) {
                ConfigurationAdapterDescriptor descriptor = i.next();
                Map<Class<?>, Class<? extends ConfigurationAdapter>> add = descriptor.providedConfigurationAdapters();
                if (add == null) continue;
                all.putAll(add);
            }
        }
        ADAPTERS = Collections.unmodifiableMap(all);
    }

    public static ConfigurationAdapter get(Object config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("Configuration adapter instantiation impossible for null config object.");
        }
        try {
            Map<Class<?>, Class<? extends ConfigurationAdapter>> adapters = ConfigurationAdapterFactory.getAdapters();
            Class<?> configType = config.getClass();
            Class<? extends ConfigurationAdapter> adapterType = ConfigurationAdapterFactory.findAdapterTypeForConfigTypeOrParent(adapters, configType);
            if (adapterType == null) {
                throw new ConfigurationException("No configuration adapter found for config type " + configType.getName());
            }
            Constructor c = ConfigurationAdapterFactory.findConstructorForConfigType(adapterType, configType);
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            Object adapter = c.newInstance(config);
            return (ConfigurationAdapter)ConfigurationAdapter.class.cast(adapter);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Configuration adapter instantiation failed.", e);
        }
    }

    public static Constructor findConstructorForConfigType(Class<?> adapterType, Class<?> configType) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = constructors = adapterType.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType;
            Constructor<?> candidate = constructorArray[n2];
            Class<?>[] paramTypes = candidate.getParameterTypes();
            if (paramTypes.length == 1 && (paramType = paramTypes[0]).isAssignableFrom(configType)) {
                constructor = candidate;
                break;
            }
            ++n2;
        }
        if (constructor == null) {
            throw new NoSuchMethodException("No constructor for " + adapterType.getName() + " that will accept " + configType.getName());
        }
        return constructor;
    }

    public static Class<? extends ConfigurationAdapter> findAdapterTypeForConfigTypeOrParent(Map<Class<?>, Class<? extends ConfigurationAdapter>> adapters, Class<?> configType) {
        Class<? extends ConfigurationAdapter> adapterType = null;
        while (configType != null) {
            adapterType = ConfigurationAdapterFactory.findAdapterTypeForConfigType(adapters, configType);
            if (adapterType != null) break;
            configType = configType.getSuperclass();
        }
        return adapterType;
    }

    public static Class<? extends ConfigurationAdapter> findAdapterTypeForConfigType(Map<Class<?>, Class<? extends ConfigurationAdapter>> adapters, Class<?> configType) {
        Class<? extends ConfigurationAdapter> adapterType = adapters.get(configType);
        if (adapterType == null) {
            Class<?>[] classArray = configType.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceType = classArray[n2];
                adapterType = ConfigurationAdapterFactory.findAdapterTypeForConfigTypeOrParent(adapters, interfaceType);
                if (adapterType != null) break;
                ++n2;
            }
        }
        return adapterType;
    }
}

