/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.servlet.SessionCookieConfig;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayCommandLine;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.GatewayServerLifecycleListener;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.cm.descriptor.ClouderaManagerDescriptorMonitor;
import org.apache.knox.gateway.cm.descriptor.ClouderaManagerDescriptorParser;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.config.GatewayConfigurationException;
import org.apache.knox.gateway.config.impl.GatewayConfigImpl;
import org.apache.knox.gateway.deploy.DeploymentException;
import org.apache.knox.gateway.deploy.DeploymentFactory;
import org.apache.knox.gateway.filter.CorrelationHandler;
import org.apache.knox.gateway.filter.PortMappingHelperHandler;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.service.definition.ServiceDefinitionChangeListener;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.ServiceRegistry;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.SSLService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Application;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.TopologyEvent;
import org.apache.knox.gateway.topology.TopologyListener;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigChangeListener;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigurationMonitor;
import org.apache.knox.gateway.trace.AccessHandler;
import org.apache.knox.gateway.trace.KnoxErrorHandler;
import org.apache.knox.gateway.trace.TraceHandler;
import org.apache.knox.gateway.util.Urls;
import org.apache.knox.gateway.util.XmlUtils;
import org.apache.knox.gateway.websockets.GatewayWebsocketHandler;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GatewayServer {
    private static final GatewayResources res = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private static final String TOPOLOGY_EXTENSION = ".topo.";
    static final String KNOXSESSIONCOOKIENAME = "KNOXSESSIONID";
    private static GatewayServer server;
    private static GatewayServices services;
    private static Properties buildProperties;
    private Server jetty;
    private GatewayConfig config;
    private ContextHandlerCollection contexts;
    private TopologyService monitor;
    private TopologyListener listener;
    private Map<String, WebAppContext> deployments;
    private AtomicBoolean stopped = new AtomicBoolean(false);

    public static void main(String[] args) {
        try {
            GatewayServer.configureLogging();
            GatewayServer.logSysProps();
            CommandLine cmd = GatewayCommandLine.parse(args);
            if (cmd.hasOption("help")) {
                GatewayCommandLine.printHelp();
            } else if (cmd.hasOption("version")) {
                GatewayServer.printVersion();
            } else if (cmd.hasOption("redeploy")) {
                GatewayServer.redeployTopologies(cmd.getOptionValue("redeploy"));
            } else {
                buildProperties = GatewayServer.loadBuildProperties();
                services = GatewayServer.instantiateGatewayServices();
                if (services == null) {
                    log.failedToInstantiateGatewayServices();
                }
                GatewayConfigImpl config = new GatewayConfigImpl();
                GatewayServer.validateConfigurableGatewayDirectories(config);
                if (config.isHadoopKerberosSecured()) {
                    GatewayServer.validateKerberosConfig(config);
                    GatewayServer.configureKerberosSecurity(config);
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("persist-master", Boolean.toString(cmd.hasOption("persist-master")));
                services.init((GatewayConfig)config, options);
                if (!cmd.hasOption("nostart")) {
                    GatewayServer.startGateway(config, services);
                }
            }
        }
        catch (ParseException e) {
            log.failedToParseCommandLine(e);
            GatewayCommandLine.printHelp();
        }
        catch (Exception e) {
            log.failedToStartGateway(e);
            System.exit(1);
        }
    }

    private static void printVersion() {
        System.out.println(res.gatewayVersionMessage(GatewayServer.getBuildVersion(), GatewayServer.getBuildHash()));
    }

    public static String getBuildHash() {
        String hash = "unknown";
        if (buildProperties != null) {
            hash = buildProperties.getProperty("build.hash", hash);
        }
        return hash;
    }

    public static String getBuildVersion() {
        String version = "unknown";
        if (buildProperties != null) {
            version = buildProperties.getProperty("build.version", version);
        }
        return version;
    }

    private static GatewayServices instantiateGatewayServices() {
        ServiceLoader<GatewayServices> loader = ServiceLoader.load(GatewayServices.class);
        Iterator<GatewayServices> services = loader.iterator();
        if (services.hasNext()) {
            return services.next();
        }
        return null;
    }

    public static synchronized GatewayServices getGatewayServices() {
        return services;
    }

    private static void logSysProp(String name) {
        log.logSysProp(name, System.getProperty(name));
    }

    private static void logSysProps() {
        GatewayServer.logSysProp("user.name");
        GatewayServer.logSysProp("user.dir");
        GatewayServer.logSysProp("java.runtime.name");
        GatewayServer.logSysProp("java.runtime.version");
        GatewayServer.logSysProp("java.home");
    }

    private static void configureLogging() {
        PropertyConfigurator.configure((String)System.getProperty("log4j.configuration"));
    }

    private static void configureKerberosSecurity(GatewayConfig config) {
        GatewayServer.setSystemProperty("gateway.hadoop.kerberos.secured", "true");
        GatewayServer.setSystemProperty("java.security.krb5.conf", config.getKerberosConfig());
        GatewayServer.setSystemProperty("sun.security.krb5.debug", Boolean.toString(config.isKerberosDebugEnabled()));
        GatewayServer.setSystemProperty("java.security.auth.login.config", config.getKerberosLoginConfig());
        GatewayServer.setSystemProperty("javax.security.auth.useSubjectCredsOnly", "false");
    }

    private static void validateConfigurableGatewayDirectories(GatewayConfig config) throws GatewayConfigurationException {
        HashSet<String> errors = new HashSet<String>();
        GatewayServer.checkIfDirectoryExistsAndCanBeRead(Paths.get(config.getGatewayConfDir(), new String[0]), "KNOX_GATEWAY_CONF_DIR", errors);
        GatewayServer.checkIfDirectoryExistsAndCanBeWritten(Paths.get(config.getGatewayDataDir(), new String[0]), "KNOX_GATEWAY_DATA_DIR", errors);
        if (!errors.isEmpty()) {
            throw new GatewayConfigurationException(errors);
        }
    }

    private static void validateKerberosConfig(GatewayConfig config) throws GatewayConfigurationException {
        HashSet<String> errors = new HashSet<String>();
        if (config.isHadoopKerberosSecured()) {
            if (config.getKerberosConfig() != null) {
                GatewayServer.checkIfFileExistsAndCanBeRead(Paths.get(config.getKerberosConfig(), new String[0]), "java.security.krb5.conf", errors);
            }
            if (config.getKerberosLoginConfig() != null) {
                GatewayServer.checkIfFileExistsAndCanBeRead(Paths.get(config.getKerberosLoginConfig(), new String[0]), "java.security.auth.login.config", errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new GatewayConfigurationException(errors);
        }
    }

    private static void checkIfFileExistsAndCanBeRead(Path toBeChecked, String propertyName, Set<String> errors) {
        GatewayServer.checkIfFileExistsAndCanBeReadOrWrite(toBeChecked, propertyName, errors, false, false);
    }

    private static void checkIfDirectoryExistsAndCanBeRead(Path toBeChecked, String propertyName, Set<String> errors) {
        GatewayServer.checkIfFileExistsAndCanBeReadOrWrite(toBeChecked, propertyName, errors, false, true);
    }

    private static void checkIfDirectoryExistsAndCanBeWritten(Path toBeChecked, String propertyName, Set<String> errors) {
        GatewayServer.checkIfFileExistsAndCanBeReadOrWrite(toBeChecked, propertyName, errors, true, true);
    }

    private static void checkIfFileExistsAndCanBeReadOrWrite(Path toBeChecked, String propertyName, Set<String> errors, boolean checkForWritePermission, boolean directory) {
        File fileToBeChecked = toBeChecked.toFile();
        if (!fileToBeChecked.exists()) {
            errors.add(propertyName + " is set to a non-existing " + (directory ? "directory: " : "file: ") + fileToBeChecked);
        } else {
            if (!fileToBeChecked.canRead()) {
                errors.add(propertyName + " is set to a non-readable " + (directory ? "directory: " : "file: ") + fileToBeChecked);
            }
            if (checkForWritePermission && !fileToBeChecked.canWrite()) {
                errors.add(propertyName + " is set to a non-writeable " + (directory ? "directory: " : "file: ") + fileToBeChecked);
            }
            if (directory && !fileToBeChecked.isDirectory()) {
                errors.add(propertyName + " is not a directory: " + fileToBeChecked);
            }
        }
    }

    private static void setSystemProperty(String name, String value) {
        System.setProperty(name, value);
        log.logSysProp(name, System.getProperty(name));
    }

    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = GatewayServer.class.getClassLoader().getResourceAsStream("build.properties");){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static void redeployTopologies(String topologyName) {
        TopologyService ts = (TopologyService)GatewayServer.getGatewayServices().getService(ServiceType.TOPOLOGY_SERVICE);
        ts.reloadTopologies();
        ts.redeployTopologies(topologyName);
    }

    private void cleanupTopologyDeployments() {
        File deployDir = new File(this.config.getGatewayDeploymentDir());
        TopologyService ts = (TopologyService)GatewayServer.getGatewayServices().getService(ServiceType.TOPOLOGY_SERVICE);
        for (Topology topology : ts.getTopologies()) {
            this.cleanupTopologyDeployments(deployDir, topology);
        }
    }

    private void cleanupTopologyDeployments(File deployDir, Topology topology) {
        log.cleanupDeployments(topology.getName());
        File[] files = deployDir.listFiles(new RegexFilenameFilter(topology.getName() + "\\.(war|topo)\\.[0-9A-Fa-f]+"));
        if (files != null) {
            Arrays.sort(files, new FileModificationTimeDescendingComparator());
            int verLimit = this.config.getGatewayDeploymentsBackupVersionLimit();
            long ageLimit = this.config.getGatewayDeploymentsBackupAgeLimit();
            long keepTime = System.currentTimeMillis() - ageLimit;
            for (int i = 1; i < files.length; ++i) {
                File file = files[i];
                if ((verLimit < 0 || i <= verLimit) && (ageLimit < 0L || file.lastModified() >= keepTime)) continue;
                log.cleanupDeployment(file.getAbsolutePath());
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GatewayServer startGateway(GatewayConfig config, GatewayServices svcs) throws Exception {
        log.startingGateway();
        GatewayServer gatewayServer = server = new GatewayServer(config);
        synchronized (gatewayServer) {
            Connector[] connectors;
            services = svcs;
            services.start();
            DeploymentFactory.setGatewayServices(services);
            server.start();
            for (Connector connector : connectors = GatewayServer.server.jetty.getConnectors()) {
                NetworkConnector networkConnector = (NetworkConnector)connector;
                if (networkConnector == null) continue;
                for (ConnectionFactory x : networkConnector.getConnectionFactories()) {
                    if (!(x instanceof HttpConnectionFactory)) continue;
                    ((HttpConnectionFactory)x).getHttpConfiguration().setSendServerVersion(config.isGatewayServerHeaderEnabled());
                }
                if (networkConnector.getName() == null) {
                    log.startedGateway(networkConnector.getLocalPort());
                    continue;
                }
                log.startedGateway(networkConnector.getName(), networkConnector.getLocalPort());
            }
            return server;
        }
    }

    public GatewayServer(GatewayConfig config) {
        this.config = config;
        this.listener = new InternalTopologyListener();
    }

    private Connector createConnector(Server server, GatewayConfig config, int port, String topologyName) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, AliasServiceException {
        long idleTimeout;
        ServerConnector connector;
        InetSocketAddress address = config.getGatewayAddress();
        GatewayServer.checkAddressAvailability(address);
        int connectorPort = port > 0 ? port : address.getPort();
        this.checkPortConflict(connectorPort, topologyName, config);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(config.getHttpServerRequestHeaderBuffer());
        httpConfig.setResponseHeaderSize(config.getHttpServerResponseHeaderBuffer());
        httpConfig.setOutputBufferSize(config.getHttpServerResponseBuffer());
        if (config.isSSLEnabled()) {
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.setSecureScheme("https");
            httpsConfig.setSecurePort(connectorPort);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SSLService ssl = (SSLService)services.getService(ServiceType.SSL_SERVICE);
            SslContextFactory sslContextFactory = (SslContextFactory)ssl.buildSslContextFactory(config);
            connector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{new HttpConnectionFactory(httpsConfig)});
        } else {
            connector = new ServerConnector(server);
        }
        connector.setHost(address.getHostName());
        connector.setPort(connectorPort);
        if (!StringUtils.isBlank((CharSequence)topologyName)) {
            connector.setName(topologyName);
        }
        if ((idleTimeout = config.getGatewayIdleTimeout()) > 0L) {
            connector.setIdleTimeout(idleTimeout);
        }
        return connector;
    }

    private static HandlerCollection createHandlers(GatewayConfig config, GatewayServices services, ContextHandlerCollection contexts, Map<String, Integer> topologyPortMap) {
        HashMap contextToHandlerMap = new HashMap();
        if (contexts.getHandlers() != null) {
            Arrays.asList(contexts.getHandlers()).stream().filter(h -> h instanceof WebAppContext).forEach(h -> contextToHandlerMap.put(((WebAppContext)h).getContextPath(), h));
        }
        HandlerCollection handlers = new HandlerCollection();
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)new AccessHandler());
        TraceHandler traceHandler = new TraceHandler();
        traceHandler.setHandler((Handler)contexts);
        traceHandler.setTracedBodyFilter(System.getProperty("org.apache.knox.gateway.trace.body.status.filter"));
        CorrelationHandler correlationHandler = new CorrelationHandler();
        correlationHandler.setHandler((Handler)traceHandler);
        PortMappingHelperHandler portMappingHandler = new PortMappingHelperHandler(config);
        portMappingHandler.setHandler((Handler)correlationHandler);
        if (config.isGatewayPortMappingEnabled()) {
            topologyPortMap.entrySet().stream().filter(e -> !((Integer)e.getValue()).equals(config.getGatewayPort())).forEach(entry -> {
                log.createJettyHandler((String)entry.getKey());
                Handler context = (Handler)contextToHandlerMap.get("/" + config.getGatewayPath() + "/" + (String)entry.getKey());
                if (context != null) {
                    ((WebAppContext)context).setVirtualHosts(new String[]{"@" + ((String)entry.getKey()).toLowerCase(Locale.ROOT)});
                } else {
                    log.noMappedTopologyFound((String)entry.getKey());
                }
            });
        }
        handlers.addHandler((Handler)logHandler);
        if (config.isWebsocketEnabled()) {
            GatewayWebsocketHandler websocketHandler = new GatewayWebsocketHandler(config, services);
            websocketHandler.setHandler((Handler)portMappingHandler);
            handlers.addHandler((Handler)websocketHandler);
        } else {
            handlers.addHandler((Handler)portMappingHandler);
        }
        return handlers;
    }

    public void checkPortConflict(int port, String topologyName, GatewayConfig config) throws IOException {
        if (GatewayServer.isPortInUse(port)) {
            if (topologyName == null) {
                log.portAlreadyInUse(port);
            } else {
                log.portAlreadyInUse(port, topologyName);
            }
            throw new IOException(String.format(Locale.ROOT, "Port %d already in use.", port));
        }
        if (StringUtils.isBlank((CharSequence)topologyName)) {
            if (config.getGatewayPortMappings().containsValue(port) && !StringUtils.isBlank((CharSequence)config.getDefaultTopologyName())) {
                log.portAlreadyInUse(port);
                throw new IOException(String.format(Locale.ROOT, " Please map port %d using either \"gateway.port.mapping.sandbox\" or \"default.app.topology.name\" property, specifying both is not a valid configuration. ", port));
            }
        } else {
            Connector[] connectors;
            for (Connector connector : connectors = this.jetty.getConnectors()) {
                if (!(connector instanceof ServerConnector) || ((ServerConnector)connector).getPort() != port) continue;
                log.portAlreadyInUse(port, topologyName);
                throw new IOException(String.format(Locale.ROOT, " Port %d used by topology %s is used by other topology, ports for topologies (if defined) have to be unique. ", port, topologyName));
            }
        }
        if (config.getDefaultTopologyName() != null && config.getGatewayPortMappings().containsKey(config.getDefaultTopologyName())) {
            log.defaultTopologyInPortmappedTopology(config.getDefaultTopologyName());
            throw new IOException(String.format(Locale.ROOT, "Default topology cannot be in port mapping list, please remove %s from port mapping list or don't make it a default topology.", config.getDefaultTopologyName()));
        }
    }

    private synchronized void start() throws Exception {
        this.contexts = new ContextHandlerCollection();
        this.deployments = new ConcurrentHashMap<String, WebAppContext>();
        this.jetty = new Server((ThreadPool)new QueuedThreadPool(this.config.getThreadPoolMax()));
        this.jetty.addConnector(this.createConnector(this.jetty, this.config, this.config.getGatewayPort(), null));
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.jetty);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        File topologiesDir = this.calculateAbsoluteTopologiesDir();
        log.loadingTopologiesFromDirectory(topologiesDir.getAbsolutePath());
        this.monitor = (TopologyService)services.getService(ServiceType.TOPOLOGY_SERVICE);
        this.monitor.addTopologyChangeListener(this.listener);
        this.monitor.reloadTopologies();
        List autoDeploys = this.config.getAutoDeployTopologyNames();
        if (autoDeploys != null) {
            for (String topologyName : autoDeploys) {
                this.monitor.redeployTopologies(topologyName);
            }
        }
        ServiceDefinitionRegistry serviceDefinitionRegistry = (ServiceDefinitionRegistry)services.getService(ServiceType.SERVICE_DEFINITION_REGISTRY);
        serviceDefinitionRegistry.addServiceDefinitionChangeListener((ServiceDefinitionChangeListener)this.monitor);
        Collection topologies = this.monitor.getTopologies();
        Map topologyPortMap = this.config.getGatewayPortMappings();
        ArrayList<String> deployedTopologyList = new ArrayList<String>();
        for (Object t : topologies) {
            deployedTopologyList.add(t.getName());
        }
        this.checkMappedTopologiesExist(topologyPortMap, deployedTopologyList);
        HandlerCollection handlers = GatewayServer.createHandlers(this.config, services, this.contexts, topologyPortMap);
        log.gatewayTopologyPortMappingEnabled(this.config.isGatewayPortMappingEnabled());
        if (this.config.isGatewayPortMappingEnabled()) {
            for (Map.Entry entry : topologyPortMap.entrySet()) {
                if (!deployedTopologyList.contains(entry.getKey()) || ((Integer)entry.getValue()).intValue() == this.config.getGatewayPort()) continue;
                log.createJettyConnector(((String)entry.getKey()).toLowerCase(Locale.ROOT), (Integer)entry.getValue());
                try {
                    this.jetty.addConnector(this.createConnector(this.jetty, this.config, (Integer)entry.getValue(), ((String)entry.getKey()).toLowerCase(Locale.ROOT)));
                }
                catch (IOException e) {
                    if (e.toString().contains("ports for topologies (if defined) have to be unique.")) {
                        log.startedGatewayPortConflict(((String)entry.getKey()).toLowerCase(Locale.ROOT), (Integer)entry.getValue());
                        continue;
                    }
                    throw e;
                }
            }
        }
        this.jetty.setHandler((Handler)handlers);
        this.jetty.addLifeCycleListener((LifeCycle.Listener)new GatewayServerLifecycleListener(this.config));
        try {
            this.jetty.start();
        }
        catch (IOException e) {
            log.failedToStartGateway(e);
            throw e;
        }
        this.cleanupTopologyDeployments();
        this.monitor.startMonitor();
        this.handleClouderaManagerDescriptors();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void handleClouderaManagerDescriptors() {
        ClouderaManagerDescriptorParser cmDescriptorParser = new ClouderaManagerDescriptorParser();
        ClouderaManagerDescriptorMonitor cmDescriptorMonitor = new ClouderaManagerDescriptorMonitor(this.config, cmDescriptorParser);
        AdvancedServiceDiscoveryConfigurationMonitor advancedServiceDiscoveryConfigurationMonitor = new AdvancedServiceDiscoveryConfigurationMonitor(this.config);
        advancedServiceDiscoveryConfigurationMonitor.registerListener((AdvancedServiceDiscoveryConfigChangeListener)cmDescriptorParser);
        advancedServiceDiscoveryConfigurationMonitor.registerListener((AdvancedServiceDiscoveryConfigChangeListener)cmDescriptorMonitor);
        advancedServiceDiscoveryConfigurationMonitor.init();
        cmDescriptorMonitor.setupMonitor();
    }

    public synchronized void stop() throws Exception {
        if (!this.stopped.get()) {
            try {
                log.stoppingGateway();
                services.stop();
                this.monitor.stopMonitor();
                this.jetty.stop();
                this.jetty.join();
                log.stoppedGateway();
                this.stopped.set(true);
            }
            catch (Exception e) {
                log.failedToStopGateway(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortInUse(int port) {
        try (Socket socket = new Socket("localhost", port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void checkMappedTopologiesExist(Map<String, Integer> configTopologies, List<String> topologies) {
        for (Map.Entry<String, Integer> entry : configTopologies.entrySet()) {
            if (topologies.contains(entry.getKey())) continue;
            log.topologyPortMappingCannotFindTopology(entry.getKey(), entry.getValue());
        }
    }

    public URI getURI() {
        return this.jetty.getURI();
    }

    public InetSocketAddress[] getAddresses() {
        InetSocketAddress[] addresses = new InetSocketAddress[this.jetty.getConnectors().length];
        int n = addresses.length;
        for (int i = 0; i < n; ++i) {
            NetworkConnector connector = (NetworkConnector)this.jetty.getConnectors()[i];
            String host = connector.getHost();
            addresses[i] = host == null ? new InetSocketAddress(connector.getLocalPort()) : new InetSocketAddress(host, connector.getLocalPort());
        }
        return addresses;
    }

    private KnoxErrorHandler createErrorHandler() {
        KnoxErrorHandler errorHandler = new KnoxErrorHandler();
        errorHandler.setShowStacks(false);
        errorHandler.setTracedBodyFilter(System.getProperty("org.apache.knox.gateway.trace.body.status.filter"));
        return errorHandler;
    }

    private WebAppContext createWebAppContext(Topology topology, File warFile, String warPath) {
        String topoName = topology.getName();
        WebAppContext context = new WebAppContext();
        String contextPath = "/" + Urls.trimLeadingAndTrailingSlashJoin((String[])new String[]{this.config.getGatewayPath(), topoName, warPath});
        context.setContextPath(contextPath);
        SessionCookieConfig sessionCookieConfig = context.getServletContext().getSessionCookieConfig();
        sessionCookieConfig.setName(KNOXSESSIONCOOKIENAME);
        context.setWar(warFile.getAbsolutePath());
        context.setAttribute("org.apache.knox.gateway.gateway.cluster", (Object)topoName);
        context.setAttribute("org.apache.knox.gateway.frontend.uri", (Object)this.getFrontendUri(context, this.config));
        context.setAttribute("org.apache.knox.gateway.config", (Object)this.config);
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        context.setTempDirectory(FileUtils.getFile((File)warFile, (String[])new String[]{"META-INF", "temp"}));
        context.setErrorHandler((ErrorHandler)this.createErrorHandler());
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        context.setClassLoader((ClassLoader)jspClassLoader);
        return context;
    }

    private static void explodeWar(File source, File target) throws IOException {
        if (source.isDirectory()) {
            FileUtils.copyDirectory((File)source, (File)target);
        } else {
            WebArchive webArchive = (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)source);
            ((ExplodedExporter)webArchive.as(ExplodedExporter.class)).exportExploded(target);
        }
    }

    private void mergeWebXmlOverrides(File webInfDir) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Document webXmlDoc;
        File webXmlFile = new File(webInfDir, "web.xml");
        if (webXmlFile.exists()) {
            File originalWebXmlFile = new File(webInfDir, "original-web.xml");
            FileUtils.copyFile((File)webXmlFile, (File)originalWebXmlFile);
            webXmlDoc = XmlUtils.readXml((File)webXmlFile);
        } else {
            webXmlDoc = XmlUtils.createDocument();
            webXmlDoc.appendChild(webXmlDoc.createElement("web-app"));
        }
        File overrideWebXmlFile = new File(webInfDir, "override-web.xml");
        if (overrideWebXmlFile.exists()) {
            Document overrideWebXmlDoc = XmlUtils.readXml((File)overrideWebXmlFile);
            Element originalRoot = webXmlDoc.getDocumentElement();
            Element overrideRoot = overrideWebXmlDoc.getDocumentElement();
            NodeList overrideNodes = overrideRoot.getChildNodes();
            int n = overrideNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node overrideNode = overrideNodes.item(i);
                if (overrideNode.getNodeType() != 1) continue;
                Node importedNode = webXmlDoc.importNode(overrideNode, true);
                originalRoot.appendChild(importedNode);
            }
            try (OutputStream outputStream = Files.newOutputStream(webXmlFile.toPath(), new OpenOption[0]);
                 OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                XmlUtils.writeXml((Document)webXmlDoc, (Writer)outputStreamWriter);
            }
        }
    }

    private synchronized void internalDeployApplications(Topology topology, File topoDir) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        Collection applications;
        if (topology != null && (applications = topology.getApplications()) != null) {
            for (Application application : applications) {
                List urls = application.getUrls();
                if (urls == null || urls.isEmpty()) {
                    this.internalDeployApplication(topoDir, application, application.getName());
                    continue;
                }
                for (String url : urls) {
                    this.internalDeployApplication(topoDir, application, url);
                }
            }
        }
    }

    private synchronized void internalDeployApplication(File topoDir, Application application, String url) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        File appsDir = new File(this.config.getGatewayApplicationsDir());
        File appDir = new File(appsDir, application.getName());
        File[] implFiles = appDir.listFiles(new RegexFilenameFilter("app|app\\..*"));
        if (implFiles == null || implFiles.length == 0) {
            throw new DeploymentException("Failed to find application in " + appDir);
        }
        File implFile = implFiles[0];
        File warDir = new File(topoDir, Urls.encode((String)("/" + Urls.trimLeadingAndTrailingSlash((String)url))));
        File webInfDir = new File(warDir, "WEB-INF");
        GatewayServer.explodeWar(implFile, warDir);
        this.mergeWebXmlOverrides(webInfDir);
        this.createArchiveTempDir(warDir);
    }

    private synchronized void internalActivateTopology(Topology topology, File topoDir) {
        log.activatingTopology(topology.getName());
        File[] files = topoDir.listFiles(new RegexFilenameFilter("%.*"));
        if (files != null) {
            for (File file : files) {
                this.internalActivateArchive(topology, file);
            }
        }
    }

    private synchronized void internalActivateArchive(Topology topology, File warDir) {
        log.activatingTopologyArchive(topology.getName(), warDir.getName());
        try {
            WebAppContext newContext = this.createWebAppContext(topology, warDir, Urls.decode((String)warDir.getName()));
            WebAppContext oldContext = this.deployments.get(newContext.getContextPath());
            this.deployments.put(newContext.getContextPath(), newContext);
            if (oldContext != null) {
                this.contexts.removeHandler((Handler)oldContext);
            }
            this.contexts.addHandler((Handler)newContext);
            if (this.contexts.isRunning() && !newContext.isRunning()) {
                newContext.start();
                if (!newContext.isAvailable()) {
                    throw newContext.getUnavailableException();
                }
            }
        }
        catch (Throwable e) {
            auditor.audit("deploy", topology.getName(), "topology", "failure");
            log.failedToDeployTopology(topology.getName(), e);
        }
    }

    private synchronized void internalDeactivateTopology(Topology topology) {
        log.deactivatingTopology(topology.getName());
        String topoName = topology.getName();
        String topoPath = "/" + Urls.trimLeadingAndTrailingSlashJoin((String[])new String[]{this.config.getGatewayPath(), topoName});
        String topoPathSlash = topoPath + "/";
        ServiceRegistry sr = (ServiceRegistry)GatewayServer.getGatewayServices().getService(ServiceType.SERVICE_REGISTRY_SERVICE);
        if (sr != null) {
            sr.removeClusterServices(topoName);
        }
        if (this.deployments != null) {
            ArrayList<WebAppContext> deactivate = new ArrayList<WebAppContext>();
            for (WebAppContext app : this.deployments.values()) {
                String appPath = app.getContextPath();
                if (!appPath.equals(topoPath) && !appPath.startsWith(topoPathSlash)) continue;
                deactivate.add(app);
            }
            for (WebAppContext context : deactivate) {
                String contextPath = context.getContextPath();
                this.deployments.remove(contextPath);
                this.contexts.removeHandler((Handler)context);
                try {
                    context.stop();
                }
                catch (Exception e) {
                    auditor.audit("undeploy", topology.getName(), "topology", "failure");
                    log.failedToUndeployTopology(topology.getName(), e);
                }
            }
            deactivate.clear();
        }
    }

    private File createArchiveTempDir(File warDir) {
        File tempDir = FileUtils.getFile((File)warDir, (String[])new String[]{"META-INF", "temp"});
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new DeploymentException("Failed to create archive temporary directory: " + tempDir.getAbsolutePath());
        }
        return tempDir;
    }

    private static File calculateAbsoluteTopologiesDir(GatewayConfig config) {
        File topoDir = new File(config.getGatewayTopologyDir());
        topoDir = topoDir.getAbsoluteFile();
        return topoDir;
    }

    private static File calculateAbsoluteDeploymentsDir(GatewayConfig config) {
        File deployDir = new File(config.getGatewayDeploymentDir());
        deployDir = deployDir.getAbsoluteFile();
        return deployDir;
    }

    private File calculateAbsoluteTopologiesDir() {
        return GatewayServer.calculateAbsoluteTopologiesDir(this.config);
    }

    private File calculateAbsoluteDeploymentsDir() {
        return GatewayServer.calculateAbsoluteDeploymentsDir(this.config);
    }

    private File calculateDeploymentDir(Topology topology) {
        return new File(this.calculateAbsoluteDeploymentsDir(), this.calculateDeploymentName(topology));
    }

    private String calculateDeploymentExtension() {
        return TOPOLOGY_EXTENSION;
    }

    private String calculateDeploymentName(Topology topology) {
        return topology.getName() + this.calculateDeploymentExtension() + Long.toHexString(topology.getTimestamp());
    }

    private static void checkAddressAvailability(InetSocketAddress address) throws IOException {
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(address);
        }
    }

    public URI getFrontendUri(WebAppContext context, GatewayConfig config) {
        URI frontendUri = null;
        String frontendStr = config.getFrontendUrl();
        if (frontendStr != null && !frontendStr.trim().isEmpty()) {
            String topoName = (String)context.getAttribute("org.apache.knox.gateway.gateway.cluster");
            try {
                frontendStr = frontendStr.trim();
                frontendUri = frontendStr.endsWith("/") ? new URI(frontendStr + topoName) : new URI(frontendStr + "/" + topoName);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return frontendUri;
    }

    private static class FileModificationTimeDescendingComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = -2269785204848916823L;

        private FileModificationTimeDescendingComparator() {
        }

        @Override
        public int compare(File left, File right) {
            long leftTime = left == null ? Long.MIN_VALUE : left.lastModified();
            long rightTime = right == null ? Long.MIN_VALUE : right.lastModified();
            return Long.compare(rightTime, leftTime);
        }
    }

    private static class RegexFilenameFilter
    implements FilenameFilter {
        Pattern pattern;

        RegexFilenameFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.pattern.matcher(name).matches();
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTopologyEvent(List<TopologyEvent> events) {
            GatewayServer gatewayServer = GatewayServer.this;
            synchronized (gatewayServer) {
                for (TopologyEvent event : events) {
                    Topology topology = event.getTopology();
                    File deployDir = GatewayServer.this.calculateAbsoluteDeploymentsDir();
                    if (event.getType().equals((Object)TopologyEvent.Type.DELETED)) {
                        this.handleDeleteDeployment(topology, deployDir);
                        continue;
                    }
                    this.handleCreateDeployment(topology, deployDir);
                }
            }
        }

        private void handleDeleteDeployment(Topology topology, File deployDir) {
            log.deletingTopology(topology.getName());
            File[] files = deployDir.listFiles(new RegexFilenameFilter(topology.getName() + "\\.(war|topo)\\.[0-9A-Fa-f]+"));
            if (files != null) {
                auditor.audit("undeploy", topology.getName(), "topology", "unavailable");
                GatewayServer.this.internalDeactivateTopology(topology);
                for (File file : files) {
                    log.deletingDeployment(file.getAbsolutePath());
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }

        private void handleCreateDeployment(Topology topology, File deployDir) {
            try {
                File topoDir = GatewayServer.this.calculateDeploymentDir(topology);
                if (!topoDir.exists()) {
                    auditor.audit("deploy", topology.getName(), "topology", "unavailable");
                    if (topology.getProviders().isEmpty()) {
                        throw new DeploymentException("No providers found inside topology.");
                    }
                    log.deployingTopology(topology.getName(), topoDir.getAbsolutePath());
                    GatewayServer.this.internalDeactivateTopology(topology);
                    EnterpriseArchive ear = DeploymentFactory.createDeployment(GatewayServer.this.config, topology);
                    if (!deployDir.exists() && !deployDir.mkdirs()) {
                        throw new DeploymentException("Failed to create topology deployment temporary directory: " + deployDir.getAbsolutePath());
                    }
                    File tmp = ((ExplodedExporter)ear.as(ExplodedExporter.class)).exportExploded(deployDir, topoDir.getName() + ".tmp");
                    if (!tmp.renameTo(topoDir)) {
                        FileUtils.deleteQuietly((File)tmp);
                        throw new DeploymentException("Failed to create topology deployment directory: " + topoDir.getAbsolutePath());
                    }
                    GatewayServer.this.internalDeployApplications(topology, topoDir);
                    GatewayServer.this.internalActivateTopology(topology, topoDir);
                    log.deployedTopology(topology.getName());
                } else {
                    auditor.audit("redeploy", topology.getName(), "topology", "unavailable");
                    log.redeployingTopology(topology.getName(), topoDir.getAbsolutePath());
                    GatewayServer.this.internalActivateTopology(topology, topoDir);
                    log.redeployedTopology(topology.getName());
                }
                GatewayServer.this.cleanupTopologyDeployments(deployDir, topology);
            }
            catch (Throwable e) {
                auditor.audit("deploy", topology.getName(), "topology", "failure");
                log.failedToDeployTopology(topology.getName(), e);
            }
        }
    }
}

