/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.Cluster;
import kafka.common.KafkaException;
import kafka.common.NoEpochForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZkUtils$
implements Logging,
ScalaObject {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String TopicConfigPath;
    private final String TopicConfigChangesPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ZkUtils$();
    }

    public String createSequentialPersistentPath$default$3() {
        return "";
    }

    public String createPersistentPath$default$3() {
        return "";
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String TopicConfigPath() {
        return this.TopicConfigPath;
    }

    public String TopicConfigChangesPath() {
        return this.TopicConfigChangesPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicConfigPath(String topic) {
        return new StringBuilder().append((Object)this.TopicConfigPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public int getController(ZkClient zkClient) {
        Option option = (Option)this.readDataMaybeNull(zkClient, this.ControllerPath())._1();
        if (option instanceof Some) {
            return KafkaController$.MODULE$.parseControllerId((String)((Some)option).x());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new KafkaException("Controller doesn't exist");
        }
        throw new MatchError((Object)option);
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public Seq<Object> getSortedBrokerList(ZkClient zkClient) {
        return (Seq)((SeqLike)this.getChildren(zkClient, this.BrokerIdsPath()).map((Function1)new anonfun.getSortedBrokerList.1(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering$Int$.MODULE$);
    }

    public Seq<Broker> getAllBrokersInCluster(ZkClient zkClient$4) {
        Seq brokerIds = (Seq)this.getChildrenParentMayNotExist(zkClient$4, this.BrokerIdsPath()).sorted((Ordering)Ordering$String$.MODULE$);
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)brokerIds.map((Function1)new anonfun.getAllBrokersInCluster.1(), Seq$.MODULE$.canBuildFrom())).map((Function1)new anonfun.getAllBrokersInCluster.2(zkClient$4), Seq$.MODULE$.canBuildFrom())).filter((Function1)new anonfun.getAllBrokersInCluster.3())).map((Function1)new anonfun.getAllBrokersInCluster.4(), Seq$.MODULE$.canBuildFrom());
    }

    public Option<LeaderIsrAndControllerEpoch> getLeaderIsrAndEpochForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    String leaderAndIsrPath = this.getTopicPartitionLeaderAndIsrPath(topic, partition);
                    Tuple2<Option<String>, Stat> leaderAndIsrInfo = this.readDataMaybeNull(zkClient, leaderAndIsrPath);
                    Option leaderAndIsrOpt = (Option)leaderAndIsrInfo._1();
                    Stat stat = (Stat)leaderAndIsrInfo._2();
                    option = leaderAndIsrOpt;
                    if (!(option instanceof Some)) break block2;
                    none$ = this.parseLeaderAndIsr((String)((Some)option).x(), topic, partition, stat);
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public Option<LeaderAndIsr> getLeaderAndIsrForPartition(ZkClient zkClient, String topic, int partition) {
        return this.getLeaderIsrAndEpochForPartition(zkClient, topic, partition).map((Function1)new anonfun.getLeaderAndIsrForPartition.1());
    }

    public void setupCommonPaths(ZkClient zkClient$8) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumersPath(), this.BrokerIdsPath(), this.BrokerTopicsPath(), this.TopicConfigChangesPath(), this.TopicConfigPath(), this.DeleteTopicsPath()}))).foreach((Function1)new anonfun.setupCommonPaths.1(zkClient$8));
    }

    public Option<LeaderIsrAndControllerEpoch> parseLeaderAndIsr(String leaderAndIsrStr, String topic$1, int partition$1, Stat stat) {
        Option<Object> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    Object object;
                    option = Json$.MODULE$.parseFull(leaderAndIsrStr);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object m = object = some.x();
                    Map leaderIsrAndEpochInfo = (Map)m;
                    int leader$1 = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader").get());
                    int epoch$1 = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"leader_epoch").get());
                    List isr$1 = (List)leaderIsrAndEpochInfo.get((Object)"isr").get();
                    int controllerEpoch = BoxesRunTime.unboxToInt((Object)leaderIsrAndEpochInfo.get((Object)"controller_epoch").get());
                    int zkPathVersion$1 = stat.getVersion();
                    this.debug((Function0<String>)new anonfun.parseLeaderAndIsr.1(topic$1, partition$1, leader$1, epoch$1, isr$1, zkPathVersion$1));
                    none$ = new Some((Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader$1, epoch$1, (List<Object>)isr$1, zkPathVersion$1), controllerEpoch));
                    break block3;
                }
                None$ none$2 = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$2 != null ? !none$2.equals(option2) : option2 != null) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    public Option<Object> getLeaderForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block6: {
            None$ none$;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string = (String)some.x();
                            String leaderAndIsr = string;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            none$ = new Some(((Map)((Some)option2).x()).get((Object)"leader").get());
                            break block4;
                        }
                        None$ none$2 = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$2 != null ? !none$2.equals(option3) : option3 != null) break block5;
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$3 = None$.MODULE$;
                Option option4 = option;
                if (none$3 != null ? !none$3.equals(option4) : option4 != null) break block6;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public int getEpochForPartition(ZkClient zkClient, String topic, int partition) {
        Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
        Option option = leaderAndIsrOpt;
        if (option instanceof Some) {
            String string;
            Some some = (Some)option;
            String leaderAndIsr = string = (String)some.x();
            Option<Object> option2 = Json$.MODULE$.parseFull(leaderAndIsr);
            None$ none$ = None$.MODULE$;
            Option<Object> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, leaderAndISR data for partition [%s,%d] is invalid").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
            }
            if (option2 instanceof Some) {
                return BoxesRunTime.unboxToInt((Object)((Map)((Some)option2).x()).get((Object)"leader_epoch").get());
            }
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new NoEpochForPartitionException(Predef$.MODULE$.augmentString("No epoch, ISR path for partition [%s,%d] is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})));
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> getInSyncReplicasForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block6: {
            Seq seq;
            block4: {
                block2: {
                    Option<Object> option2;
                    block5: {
                        block3: {
                            Option leaderAndIsrOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPartitionLeaderAndIsrPath(topic, partition))._1();
                            option = leaderAndIsrOpt;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String string = (String)some.x();
                            String leaderAndIsr = string;
                            option2 = Json$.MODULE$.parseFull(leaderAndIsr);
                            if (!(option2 instanceof Some)) break block3;
                            seq = (Seq)((Map)((Some)option2).x()).get((Object)"isr").get();
                            break block4;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block4;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public Seq<Object> getReplicasForPartition(ZkClient zkClient, String topic, int partition) {
        Option option;
        block10: {
            Seq seq;
            block6: {
                block2: {
                    Option<Object> option2;
                    block9: {
                        block3: {
                            Option option3;
                            block8: {
                                block4: {
                                    Option option4;
                                    block7: {
                                        block5: {
                                            Option jsonPartitionMapOpt = (Option)this.readDataMaybeNull(zkClient, this.getTopicPath(topic))._1();
                                            option = jsonPartitionMapOpt;
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            String string = (String)some.x();
                                            String jsonPartitionMap = string;
                                            option2 = Json$.MODULE$.parseFull(jsonPartitionMap);
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            Object object = some2.x();
                                            Object m = object;
                                            option3 = ((Map)m).get((Object)"partitions");
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            Object object2 = some3.x();
                                            Object replicaMap = object2;
                                            option4 = ((Map)replicaMap).get((Object)((Object)BoxesRunTime.boxToInteger((int)partition)).toString());
                                            if (!(option4 instanceof Some)) break block5;
                                            seq = (Seq)((Some)option4).x();
                                            break block6;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option5 = option4;
                                        if (none$ != null ? !none$.equals(option5) : option5 != null) break block7;
                                        seq = (Seq)Seq$.MODULE$.empty();
                                        break block6;
                                    }
                                    throw new MatchError((Object)option4);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option6 = option3;
                                if (none$ != null ? !none$.equals(option6) : option6 != null) break block8;
                                seq = (Seq)Seq$.MODULE$.empty();
                                break block6;
                            }
                            throw new MatchError((Object)option3);
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Object> option7 = option2;
                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block9;
                        seq = (Seq)Seq$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option option8 = option;
                if (none$ != null ? !none$.equals(option8) : option8 != null) break block10;
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public void registerBrokerInZk(ZkClient zkClient, int id$1, String host$1, int port$1, int timeout, int jmxPort) {
        String brokerIdPath$1 = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)id$1)).toString();
        String timestamp = ((Object)BoxesRunTime.boxToLong((long)SystemTime$.MODULE$.milliseconds())).toString();
        String brokerInfo = Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"host").$minus$greater((Object)host$1), Predef$.MODULE$.any2ArrowAssoc((Object)"port").$minus$greater((Object)BoxesRunTime.boxToInteger((int)port$1)), Predef$.MODULE$.any2ArrowAssoc((Object)"jmx_port").$minus$greater((Object)BoxesRunTime.boxToInteger((int)jmxPort)), Predef$.MODULE$.any2ArrowAssoc((Object)"timestamp").$minus$greater((Object)timestamp)})));
        Broker expectedBroker = new Broker(id$1, host$1, port$1);
        try {
            this.createEphemeralPathExpectConflictHandleZKBug(zkClient, brokerIdPath$1, brokerInfo, expectedBroker, (Function2<String, Object, Object>)new anonfun.registerBrokerInZk.1(), timeout);
            this.info((Function0<String>)new anonfun.registerBrokerInZk.2(id$1, host$1, port$1, brokerIdPath$1));
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new RuntimeException(new StringBuilder().append((Object)"A broker is already registered on the path ").append((Object)brokerIdPath$1).append((Object)". This probably ").append((Object)"indicates that you either have configured a brokerid that is already in use, or ").append((Object)"else you have shutdown this broker and restarted it faster than the zookeeper ").append((Object)"timeout so it appears to be re-registering.").toString());
        }
    }

    public String getConsumerPartitionOwnerPath(String group, String topic, int partition) {
        ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(group, topic);
        return new StringBuilder().append((Object)topicDirs.consumerOwnerDir()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)partition)).toString();
    }

    public String leaderAndIsrZkData(LeaderAndIsr leaderAndIsr, int controllerEpoch) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"leader").$minus$greater((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leader())), Predef$.MODULE$.any2ArrowAssoc((Object)"leader_epoch").$minus$greater((Object)BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())), Predef$.MODULE$.any2ArrowAssoc((Object)"controller_epoch").$minus$greater((Object)BoxesRunTime.boxToInteger((int)controllerEpoch)), Predef$.MODULE$.any2ArrowAssoc((Object)"isr").$minus$greater(leaderAndIsr.isr())})));
    }

    public String replicaAssignmentZkData(Map<String, Seq<Object>> map) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater(map)})));
    }

    public void makeSurePersistentPathExists(ZkClient client, String path) {
        if (!client.exists(path)) {
            client.createPersistent(path, true);
        }
    }

    private void createParentPath(ZkClient client, String path) {
        String parentDir = path.substring(0, path.lastIndexOf(47));
        if (parentDir.length() != 0) {
            client.createPersistent(parentDir, true);
        }
    }

    private void createEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.createEphemeral(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    public void createEphemeralPathExpectConflict(ZkClient client, String path$4, String data$3) {
        ObjectRef storedData$1;
        ZkNodeExistsException zkNodeExistsException2;
        block6: {
            try {
                this.createEphemeralPath(client, path$4, data$3);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException2) {
                storedData$1 = new ObjectRef(null);
                try {
                    storedData$1.elem = (String)this.readData(client, path$4)._1();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    // empty catch block
                }
                if ((String)storedData$1.elem == null) break block6;
                String string = (String)storedData$1.elem;
                String string2 = data$3;
                if (string != null ? !string.equals(string2) : string2 != null) break block6;
                this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.2(path$4, data$3));
            }
            return;
        }
        this.info((Function0<String>)new anonfun.createEphemeralPathExpectConflict.1(path$4, data$3, storedData$1));
        throw zkNodeExistsException2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createEphemeralPathExpectConflictHandleZKBug(ZkClient zkClient, String path$2, String data$2, Object expectedCallerData, Function2<String, Object, Object> checker, int backoffTime) {
        this.createEphemeralPathExpectConflict(zkClient, path$2, data$2);
        return;
    }

    public void createPersistentPath(ZkClient client, String path, String data) {
        try {
            client.createPersistent(path, (Object)data);
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createPersistent(path, (Object)data);
        }
    }

    public String createSequentialPersistentPath(ZkClient client, String path, String data) {
        return client.createPersistentSequential(path, (Object)data);
    }

    public void updatePersistentPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            try {
                client.createPersistent(path, (Object)data);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                client.writeData(path, (Object)data);
            }
        }
    }

    public Tuple2<Object, Object> conditionalUpdatePersistentPath(ZkClient client, String path$1, String data$1, int expectVersion$1) {
        Tuple2 exceptionResult1 = null;
        try {
            Stat stat$1 = client.writeDataReturnStat(path$1, (Object)data$1, expectVersion$1);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPath.1(path$1, data$1, expectVersion$1, stat$1));
            exceptionResult1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat$1.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPath.2(path$1, data$1, expectVersion$1, exception));
            exceptionResult1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        return exceptionResult1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Object> conditionalUpdatePersistentPathIfExists(ZkClient client, String path$5, String data$4, int expectVersion$2) {
        Tuple2 exceptionResult2 = null;
        try {
            Stat stat$2 = client.writeDataReturnStat(path$5, (Object)data$4, expectVersion$2);
            this.debug((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.1(path$5, data$4, expectVersion$2, stat$2));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)stat$2.getVersion()));
        }
        catch (Exception exception) {
            this.error((Function0<String>)new anonfun.conditionalUpdatePersistentPathIfExists.2(path$5, data$4, expectVersion$2, exception));
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw zkNoNodeException;
        }
    }

    public void updateEphemeralPath(ZkClient client, String path, String data) {
        try {
            client.writeData(path, (Object)data);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.createParentPath(client, path);
            client.createEphemeral(path, (Object)data);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean deletePath(ZkClient client, String path$3) {
        void var3_3;
        boolean exceptionResult3 = false;
        try {
            exceptionResult3 = client.delete(path$3);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePath.1(path$3));
            exceptionResult3 = false;
        }
        return (boolean)var3_3;
    }

    public void deletePathRecursive(ZkClient client, String path$6) {
        try {
            client.deleteRecursive(path$6);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            this.info((Function0<String>)new anonfun.deletePathRecursive.1(path$6));
        }
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public Tuple2<String, Stat> readData(ZkClient client, String path) {
        Stat stat = new Stat();
        String dataStr = (String)client.readData(path, stat);
        return new Tuple2((Object)dataStr, (Object)stat);
    }

    public Tuple2<Option<String>, Stat> readDataMaybeNull(ZkClient client, String path) {
        Stat stat = new Stat();
        Tuple2 exceptionResult4 = null;
        try {
            exceptionResult4 = new Tuple2((Object)new Some(client.readData(path, stat)), (Object)stat);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            exceptionResult4 = new Tuple2((Object)None$.MODULE$, (Object)stat);
        }
        Tuple2 dataAndStat = exceptionResult4;
        return dataAndStat;
    }

    public Seq<String> getChildren(ZkClient client, String path) {
        return JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
    }

    public Seq<String> getChildrenParentMayNotExist(ZkClient client, String path) {
        Buffer exceptionResult5 = null;
        try {
            exceptionResult5 = JavaConversions$.MODULE$.asScalaBuffer(client.getChildren(path));
            return exceptionResult5;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (ZkNoNodeException zkNoNodeException) {
            return Nil$.MODULE$;
        }
    }

    public boolean pathExists(ZkClient client, String path) {
        return client.exists(path);
    }

    /*
     * WARNING - void declaration
     */
    public Cluster getCluster(ZkClient zkClient$5) {
        void var2_2;
        Cluster cluster$1 = new Cluster();
        Seq<String> nodes = this.getChildrenParentMayNotExist(zkClient$5, this.BrokerIdsPath());
        nodes.foreach((Function1)new anonfun.getCluster.1(zkClient$5, cluster$1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> getPartitionLeaderAndIsrForTopics(ZkClient zkClient$7, Set<TopicAndPartition> topicAndPartitions) {
        void var3_3;
        HashMap ret$1 = new HashMap();
        topicAndPartitions.foreach((Function1)new anonfun.getPartitionLeaderAndIsrForTopics.1(zkClient$7, ret$1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> getReplicaAssignmentForTopics(ZkClient zkClient$1, Seq<String> topics) {
        void var3_3;
        HashMap ret$2 = new HashMap();
        topics.foreach((Function1)new anonfun.getReplicaAssignmentForTopics.1(zkClient$1, ret$2));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.mutable.Map<String, Map<Object, Seq<Object>>> getPartitionAssignmentForTopics(ZkClient zkClient$2, Seq<String> topics) {
        void var3_3;
        HashMap ret$3 = new HashMap();
        topics.foreach((Function1)new anonfun.getPartitionAssignmentForTopics.1(zkClient$2, ret$3));
        return var3_3;
    }

    public scala.collection.mutable.Map<String, Seq<Object>> getPartitionsForTopics(ZkClient zkClient, Seq<String> topics) {
        return (scala.collection.mutable.Map)this.getPartitionAssignmentForTopics(zkClient, topics).map((Function1)new anonfun.getPartitionsForTopics.1(), Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicAndPartition, ReassignedPartitionsContext> getPartitionsBeingReassigned(ZkClient zkClient) {
        Option option;
        block4: {
            scala.collection.immutable.Map map;
            block3: {
                block2: {
                    String string;
                    Option jsonPartitionMapOpt = (Option)this.readDataMaybeNull(zkClient, this.ReassignPartitionsPath())._1();
                    option = jsonPartitionMapOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String jsonPartitionMap = string = (String)some.x();
                    Map<TopicAndPartition, Seq<Object>> reassignedPartitions = this.parsePartitionReassignmentData(jsonPartitionMap);
                    map = (Map)reassignedPartitions.map((Function1)new anonfun.getPartitionsBeingReassigned.1(), scala.collection.Map$.MODULE$.canBuildFrom());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                map = scala.collection.Map$.MODULE$.empty();
            }
            return map;
        }
        throw new MatchError((Object)option);
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        Option<Object> option;
        block9: {
            scala.collection.mutable.Map reassignedPartitions$1;
            block8: {
                block7: {
                    reassignedPartitions$1 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object object = some.x();
                    Object m = object;
                    Option option2 = ((Map)m).get((Object)"partitions");
                    if (option2 instanceof Some) {
                        ((Seq)((Some)option2).x()).foreach((Function1)new anonfun.parsePartitionReassignmentData.1(reassignedPartitions$1));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError((Object)option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return reassignedPartitions$1;
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<Object> option;
        block9: {
            ObjectRef topics$1;
            block8: {
                block7: {
                    topics$1 = new ObjectRef((Object)List$.MODULE$.empty());
                    option = Json$.MODULE$.parseFull(jsonData);
                    if (!(option instanceof Some)) break block7;
                    Some some = (Some)option;
                    Object object = some.x();
                    Object m = object;
                    Option option2 = ((Map)m).get((Object)"topics");
                    if (option2 instanceof Some) {
                        Object object2;
                        Some some2 = (Some)option2;
                        Object partitionsSeq = object2 = some2.x();
                        Seq mapPartitionSeq = (Seq)partitionsSeq;
                        mapPartitionSeq.foreach((Function1)new anonfun.parseTopicsData.1(topics$1));
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ == null ? option3 != null : !none$.equals(option3)) {
                            throw new MatchError((Object)option2);
                        }
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block9;
            }
            return (List)topics$1.elem;
        }
        throw new MatchError(option);
    }

    public String getPartitionReassignmentZkData(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater(partitionsToBeReassigned.map((Function1)new anonfun.getPartitionReassignmentZkData.1(), Iterable$.MODULE$.canBuildFrom()))})));
    }

    public void updatePartitionReassignmentData(ZkClient zkClient, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        String zkPath$1 = this.ReassignPartitionsPath();
        int n = partitionsToBeReassigned.size();
        if (n == 0) {
            this.deletePath(zkClient, zkPath$1);
            this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.1(zkPath$1));
        } else {
            String jsonData$1 = this.getPartitionReassignmentZkData(partitionsToBeReassigned);
            try {
                this.updatePersistentPath(zkClient, zkPath$1, jsonData$1);
                this.info((Function0<String>)new anonfun.updatePartitionReassignmentData.2(jsonData$1));
            }
            catch (Throwable throwable) {
                throw new AdminOperationException(throwable.toString());
            }
            catch (ZkNoNodeException zkNoNodeException) {
                this.createPersistentPath(zkClient, zkPath$1, jsonData$1);
                this.debug((Function0<String>)new anonfun.updatePartitionReassignmentData.3(zkPath$1, jsonData$1));
            }
        }
    }

    public Set<TopicAndPartition> getPartitionsUndergoingPreferredReplicaElection(ZkClient zkClient) {
        Option option;
        block4: {
            Set set;
            block3: {
                block2: {
                    Option jsonPartitionListOpt = (Option)this.readDataMaybeNull(zkClient, this.PreferredReplicaLeaderElectionPath())._1();
                    option = jsonPartitionListOpt;
                    if (!(option instanceof Some)) break block2;
                    set = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData((String)((Some)option).x());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                set = Set$.MODULE$.empty();
            }
            return set;
        }
        throw new MatchError((Object)option);
    }

    public void deletePartition(ZkClient zkClient, int brokerId, String topic) {
        String brokerIdPath = new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerIdPath);
        String brokerPartTopicPath = new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString();
        zkClient.delete(brokerPartTopicPath);
    }

    public Seq<String> getConsumersInGroup(ZkClient zkClient, String group) {
        ZKGroupDirs dirs = new ZKGroupDirs(group);
        return this.getChildren(zkClient, dirs.consumerRegistryDir());
    }

    public scala.collection.mutable.Map<String, List<String>> getConsumersPerTopic(ZkClient zkClient$6, String group$1) {
        ZKGroupDirs dirs = new ZKGroupDirs(group$1);
        Seq<String> consumers = this.getChildrenParentMayNotExist(zkClient$6, dirs.consumerRegistryDir());
        HashMap consumersPerTopicMap$1 = new HashMap();
        consumers.foreach((Function1)new anonfun.getConsumersPerTopic.1(zkClient$6, group$1, consumersPerTopicMap$1));
        consumersPerTopicMap$1.foreach((Function1)new anonfun.getConsumersPerTopic.2(consumersPerTopicMap$1));
        return consumersPerTopicMap$1;
    }

    public Option<Broker> getBrokerInfo(ZkClient zkClient, int brokerId) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = (Option)this.readDataMaybeNull(zkClient, new StringBuilder().append((Object)this.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString())._1();
                    if (!(option instanceof Some)) break block2;
                    some = new Some((Object)Broker$.MODULE$.createBroker(brokerId, (String)((Some)option).x()));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Seq<String> getAllTopics(ZkClient zkClient) {
        Seq topics = this.getChildrenParentMayNotExist(zkClient, this.BrokerTopicsPath());
        return topics == null ? (Seq)Seq$.MODULE$.empty() : topics;
    }

    public Set<TopicAndPartition> getAllPartitions(ZkClient zkClient$3) {
        Seq<String> topics = this.getChildrenParentMayNotExist(zkClient$3, this.BrokerTopicsPath());
        return topics == null ? Set$.MODULE$.empty() : ((GenericTraversableTemplate)topics.map((Function1)new anonfun.getAllPartitions.1(zkClient$3), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms()).toSet();
    }

    private ZkUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.TopicConfigPath = "/config/topics";
        this.TopicConfigChangesPath = "/config/changes";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
    }
}

