/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.api.FetchRequestBuilder;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.DefaultMessageFormatter;
import kafka.consumer.MessageFormatter;
import kafka.consumer.MessageFormatter$;
import kafka.consumer.SimpleConsumer;
import kafka.tools.SimpleConsumerShell$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleConsumerShell$
implements Logging,
ScalaObject {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    public int UseLeaderReplica() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        ObjectRef fetchTargetBroker$1;
        FetchRequestBuilder fetchRequestBuilder$1;
        Properties formatterArgs;
        Class<?> messageFormatterClass;
        boolean noWaitAtEndOfLog$1;
        boolean printOffsets$1;
        boolean skipMessageOnError$1;
        int maxMessages$1;
        String clientId;
        int fetchSize$1;
        LongRef startingOffset$1;
        int replicaId$1;
        int partitionId$1;
        String topic$1;
        block14: {
            Seq<PartitionMetadata> partitionsMetadata;
            Option partitionMetadataOpt;
            OptionParser parser$1 = new OptionParser();
            ArgumentAcceptingOptionSpec brokerListOpt = parser$1.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
            ArgumentAcceptingOptionSpec topicOpt = parser$1.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
            ArgumentAcceptingOptionSpec partitionIdOpt = parser$1.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec replicaIdOpt = parser$1.accepts("replica", "The replica id to consume from, default -1 means leader broker.").withRequiredArg().describedAs("replica id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(this.UseLeaderReplica()), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec offsetOpt = parser$1.accepts("offset", "The offset id to consume from, default to -2 which means from beginning; while value -1 means from end").withRequiredArg().describedAs("consume offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(OffsetRequest$.MODULE$.EarliestTime()), (Object[])new Long[0]);
            ArgumentAcceptingOptionSpec clientIdOpt = parser$1.accepts("clientId", "The ID of this client.").withRequiredArg().describedAs("clientId").ofType(String.class).defaultsTo((Object)"SimpleConsumerShell", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec fetchSizeOpt = parser$1.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec messageFormatterOpt = parser$1.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
            ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser$1.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
            OptionSpecBuilder printOffsetOpt = parser$1.accepts("print-offsets", "Print the offsets returned by the iterator");
            ArgumentAcceptingOptionSpec maxWaitMsOpt = parser$1.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec maxMessagesOpt = parser$1.accepts("max-messages", "The number of messages to consume").withRequiredArg().describedAs("max-messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            OptionSpecBuilder skipMessageOnErrorOpt = parser$1.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
            OptionSpecBuilder noWaitAtEndOfLogOpt = parser$1.accepts("no-wait-at-logend", "If set, when the simple consumer reaches the end of the Log, it will stop, not waiting for new produced messages");
            OptionSet options$1 = parser$1.parse(args);
            List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{brokerListOpt, topicOpt, partitionIdOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
            topic$1 = (String)options$1.valueOf((OptionSpec)topicOpt);
            partitionId$1 = (Integer)options$1.valueOf((OptionSpec)partitionIdOpt);
            replicaId$1 = (Integer)options$1.valueOf((OptionSpec)replicaIdOpt);
            startingOffset$1 = new LongRef(((Long)options$1.valueOf((OptionSpec)offsetOpt)).longValue());
            fetchSize$1 = (Integer)options$1.valueOf((OptionSpec)fetchSizeOpt);
            clientId = ((String)options$1.valueOf((OptionSpec)clientIdOpt)).toString();
            int maxWaitMs = (Integer)options$1.valueOf((OptionSpec)maxWaitMsOpt);
            maxMessages$1 = (Integer)options$1.valueOf((OptionSpec)maxMessagesOpt);
            skipMessageOnError$1 = options$1.has((OptionSpec)skipMessageOnErrorOpt);
            printOffsets$1 = options$1.has((OptionSpec)printOffsetOpt);
            noWaitAtEndOfLog$1 = options$1.has((OptionSpec)noWaitAtEndOfLogOpt);
            messageFormatterClass = Class.forName((String)options$1.valueOf((OptionSpec)messageFormatterOpt));
            formatterArgs = MessageFormatter$.MODULE$.tryParseFormatterArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)messageFormatterArgOpt)));
            fetchRequestBuilder$1 = new FetchRequestBuilder().clientId(clientId).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWaitMs).minBytes(ConsumerConfig$.MODULE$.MinFetchBytes());
            this.info((Function0<String>)new anonfun.main.2());
            Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList((String)options$1.valueOf((OptionSpec)brokerListOpt));
            Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
            if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.apply(0)).topic().equals(topic$1)) {
                System.err.println(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s, what we get from server is only: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1, topicsMetadata})));
                System.exit(1);
            }
            if (!(partitionMetadataOpt = (partitionsMetadata = ((TopicMetadata)topicsMetadata.apply(0)).partitionsMetadata()).find((Function1)new anonfun.1(partitionId$1))).isDefined()) {
                System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not exist for topic %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId$1), topic$1})));
                System.exit(1);
            }
            fetchTargetBroker$1 = new ObjectRef(null);
            Option replicaOpt = null;
            if (replicaId$1 == this.UseLeaderReplica()) {
                replicaOpt = ((PartitionMetadata)partitionMetadataOpt.get()).leader();
                if (!replicaOpt.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: user speicifies to fetch from leader for partition (%s, %d) which has not been elected yet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topic$1, BoxesRunTime.boxToInteger((int)partitionId$1)})));
                    System.exit(1);
                }
            } else {
                Seq<Broker> replicasForPartition2 = ((PartitionMetadata)partitionMetadataOpt.get()).replicas();
                replicaOpt = replicasForPartition2.find((Function1)new anonfun.main.3(replicaId$1));
                if (!replicaOpt.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: replica %d does not exist for partition (%s, %d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topic$1, BoxesRunTime.boxToInteger((int)partitionId$1)})));
                    System.exit(1);
                }
            }
            fetchTargetBroker$1.elem = (Broker)replicaOpt.get();
            if (startingOffset$1.elem < OffsetRequest$.MODULE$.EarliestTime()) {
                System.err.println(Predef$.MODULE$.augmentString("Invalid starting offset: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startingOffset$1.elem)})));
                System.exit(1);
            }
            if (startingOffset$1.elem < 0L) {
                SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)fetchTargetBroker$1.elem).host(), ((Broker)fetchTargetBroker$1.elem).port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize(), clientId);
                try {
                    startingOffset$1.elem = simpleConsumer.earliestOrLatestOffset(new TopicAndPartition(topic$1, partitionId$1), startingOffset$1.elem, Request$.MODULE$.DebuggingConsumerId());
                    if (simpleConsumer != null) {
                        simpleConsumer.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(new StringBuilder().append((Object)"Error in getting earliest or latest offset due to: ").append((Object)Utils$.MODULE$.stackTrace(throwable)).toString());
                        System.exit(1);
                    }
                    finally {
                        if (simpleConsumer == null) break block14;
                        simpleConsumer.close();
                    }
                }
            }
        }
        MessageFormatter formatter$1 = (MessageFormatter)messageFormatterClass.newInstance();
        formatter$1.init(formatterArgs);
        String replicaString$1 = replicaId$1 > 0 ? "leader" : "replica";
        this.info((Function0<String>)new anonfun.main.4(topic$1, partitionId$1, replicaId$1, startingOffset$1, fetchTargetBroker$1, replicaString$1));
        SimpleConsumer simpleConsumer$1 = new SimpleConsumer(((Broker)fetchTargetBroker$1.elem).host(), ((Broker)fetchTargetBroker$1.elem).port(), 10000, 65536, clientId);
        Thread thread = Utils$.MODULE$.newThread("kafka-simpleconsumer-shell", new anon.1(topic$1, partitionId$1, replicaId$1, startingOffset$1, fetchSize$1, maxMessages$1, skipMessageOnError$1, printOffsets$1, noWaitAtEndOfLog$1, fetchRequestBuilder$1, formatter$1, simpleConsumer$1), false);
        thread.start();
        thread.join();
        System.out.flush();
        formatter$1.close();
        simpleConsumer$1.close();
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

