/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.tools.KafkaMigrationTool;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MirrorMaker$
implements Logging,
ScalaObject {
    public static final MirrorMaker$ MODULE$;
    private Seq<ZookeeperConsumerConnector> connectors;
    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads;
    private ListBuffer<KafkaMigrationTool.ProducerThread> kafka$tools$MirrorMaker$$producerThreads;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    private Seq<ZookeeperConsumerConnector> connectors() {
        return this.connectors;
    }

    private void connectors_$eq(Seq<ZookeeperConsumerConnector> seq) {
        this.connectors = seq;
    }

    private Seq<MirrorMaker.MirrorMakerThread> consumerThreads() {
        return this.consumerThreads;
    }

    private void consumerThreads_$eq(Seq<MirrorMaker.MirrorMakerThread> seq) {
        this.consumerThreads = seq;
    }

    public final ListBuffer<KafkaMigrationTool.ProducerThread> kafka$tools$MirrorMaker$$producerThreads() {
        return this.kafka$tools$MirrorMaker$$producerThreads;
    }

    private void kafka$tools$MirrorMaker$$producerThreads_$eq(ListBuffer<KafkaMigrationTool.ProducerThread> listBuffer) {
        this.kafka$tools$MirrorMaker$$producerThreads = listBuffer;
    }

    public void main(String[] args) {
        this.info((Function0<String>)new anonfun.main.1());
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec producerConfigOpt$1 = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec bufferSizeOpt = parser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        OptionSet options$1 = parser.parse(args);
        if (options$1.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options$1, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt$1}));
        if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count((Function1)new anonfun.main.2(options$1)) != 1) {
            Predef$.MODULE$.println((Object)"Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        Integer numStreams$1 = (Integer)options$1.valueOf((OptionSpec)numStreamsOpt);
        int bufferSize = (Integer)options$1.valueOf((OptionSpec)bufferSizeOpt);
        IndexedSeq producers$1 = (IndexedSeq)Predef$.MODULE$.intWrapper(1).to(((Integer)options$1.valueOf((OptionSpec)numProducersOpt)).intValue()).map((Function1)new anonfun.1(producerConfigOpt$1, options$1), IndexedSeq$.MODULE$.canBuildFrom());
        this.connectors_$eq((Seq<ZookeeperConsumerConnector>)((Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)consumerConfigOpt)).toList().map((Function1)new anonfun.main.3(), List$.MODULE$.canBuildFrom())).map((Function1)new anonfun.main.4(), List$.MODULE$.canBuildFrom())));
        TopicFilter filterSpec$1 = options$1.has((OptionSpec)whitelistOpt) ? new Whitelist((String)options$1.valueOf((OptionSpec)whitelistOpt)) : new Blacklist((String)options$1.valueOf((OptionSpec)blacklistOpt));
        Nil$ streams2 = Nil$.MODULE$;
        try {
            streams2 = (Seq)((GenericTraversableTemplate)this.connectors().map((Function1)new anonfun.main.5(numStreams$1, filterSpec$1), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new anonfun.main.6());
            this.connectors().foreach((Function1)new anonfun.main.7());
        }
        KafkaMigrationTool.ProducerDataChannel producerDataChannel$1 = new KafkaMigrationTool.ProducerDataChannel(bufferSize);
        this.consumerThreads_$eq((Seq<MirrorMaker.MirrorMakerThread>)((Seq)((TraversableLike)streams2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new anonfun.main.8(producers$1, producerDataChannel$1), Seq$.MODULE$.canBuildFrom())));
        this.kafka$tools$MirrorMaker$$producerThreads_$eq((ListBuffer<KafkaMigrationTool.ProducerThread>)new ListBuffer());
        Runtime.getRuntime().addShutdownHook(new anon.2());
        IntRef i$1 = new IntRef(1);
        producers$1.foreach((Function1)new anonfun.main.9(producerDataChannel$1, i$1));
        this.consumerThreads().foreach((Function1)new anonfun.main.10());
        this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new anonfun.main.11());
        this.consumerThreads().foreach((Function1)new anonfun.main.12());
        this.cleanShutdown();
    }

    public void cleanShutdown() {
        if (this.connectors() != null) {
            this.connectors().foreach((Function1)new anonfun.cleanShutdown.1());
        }
        if (this.consumerThreads() != null) {
            this.consumerThreads().foreach((Function1)new anonfun.cleanShutdown.2());
        }
        if (this.kafka$tools$MirrorMaker$$producerThreads() != null) {
            this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new anonfun.cleanShutdown.3());
            this.kafka$tools$MirrorMaker$$producerThreads().foreach((Function1)new anonfun.cleanShutdown.4());
        }
        this.info((Function0<String>)new anonfun.cleanShutdown.5());
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.connectors = null;
        this.consumerThreads = null;
        this.kafka$tools$MirrorMaker$$producerThreads = null;
    }
}

