/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import kafka.common.Config;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.producer.ProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProducerConfig$
implements Config,
ScalaObject {
    public static final ProducerConfig$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ProducerConfig$();
    }

    public void validate(ProducerConfig config) {
        this.validateClientId(config.clientId());
        this.validateBatchSize(config.batchNumMessages(), config.queueBufferingMaxMessages());
        this.validateProducerType(config.producerType());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateBatchSize(int batchSize, int queueSize) {
        if (batchSize > queueSize) {
            throw new InvalidConfigException(new StringBuilder().append((Object)"Batch size = ").append((Object)BoxesRunTime.boxToInteger((int)batchSize)).append((Object)" can't be larger than queue size = ").append((Object)BoxesRunTime.boxToInteger((int)queueSize)).toString());
        }
    }

    public void validateProducerType(String producerType) {
        block3: {
            block2: {
                String string;
                String string2 = string = producerType;
                String string3 = "sync";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = string;
                String string5 = "async";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
            }
            return;
        }
        throw new InvalidConfigException(new StringBuilder().append((Object)"Invalid value ").append((Object)producerType).append((Object)" for producer.type, valid values are sync/async").toString());
    }

    private ProducerConfig$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
    }
}

