/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.TopicMetadata;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u00052wM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u000511m\u001c8gS\u001e,\u0012\u0001\t\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\n\u0001\u0003\u0006\u0004%I\u0001K\u0001\rKZ,g\u000e\u001e%b]\u0012dWM]\u000b\u0002SA!!&L\u0018;\u001b\u0005Y#B\u0001\u0017\u0003\u0003\u0015\t7/\u001f8d\u0013\tq3F\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u00021c1\u0001A\u0001\u0003\u001a\u0001\t\u0003\u0005)\u0019A\u001a\u0003\u0003-\u000b\"\u0001N\u001c\u0011\u0005a)\u0014B\u0001\u001c\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0007\u001d\n\u0005eJ\"aA!osB\u0011\u0001g\u000f\u0003\ty\u0001!\t\u0011!b\u0001g\t\ta\u000b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003*\u00035)g/\u001a8u\u0011\u0006tG\r\\3sA!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"2AQ\"E!\u0011\t\u0003a\f\u001e\t\u000byy\u0004\u0019\u0001\u0011\t\u000b\u001dz\u0004\u0019A\u0015\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\u0006Y\u0001.Y:TQV$Hm\\<o+\u0005A\u0005CA%Q\u001b\u0005Q%BA&M\u0003\u0019\tGo\\7jG*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(\u000e\u0003\u0011)H/\u001b7\n\u0005ES%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004T\u0001\u0001\u0006I\u0001S\u0001\rQ\u0006\u001c8\u000b[;uI><h\u000e\t\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0003\u0015\tX/Z;f+\u00059\u0006c\u0001-Z76\tA*\u0003\u0002[\u0019\n\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vKB!\u0011\u0005X\u0018;\u0013\ti&A\u0001\u0007LKf,G-T3tg\u0006<W\r\u0003\u0004`\u0001\u0001\u0006IaV\u0001\u0007cV,W/\u001a\u0011\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\u0006!1/\u001f8d+\u0005\u0019\u0007C\u0001\re\u0013\t)\u0017DA\u0004C_>dW-\u00198\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\u0006A1/\u001f8d?\u0012*\u0017\u000f\u0006\u0002jYB\u0011\u0001D[\u0005\u0003Wf\u0011A!\u00168ji\"9QNZA\u0001\u0002\u0004\u0019\u0017a\u0001=%c!1q\u000e\u0001Q!\n\r\fQa]=oG\u0002Bq!\u001d\u0001A\u0002\u0013%!/\u0001\nqe>$WoY3s'\u0016tG\r\u00165sK\u0006$W#A:\u0011\t)\"xFO\u0005\u0003k.\u0012!\u0003\u0015:pIV\u001cWM]*f]\u0012$\u0006N]3bI\"9q\u000f\u0001a\u0001\n\u0013A\u0018A\u00069s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012|F%Z9\u0015\u0005%L\bbB7w\u0003\u0003\u0005\ra\u001d\u0005\u0007w\u0002\u0001\u000b\u0015B:\u0002'A\u0014x\u000eZ;dKJ\u001cVM\u001c3UQJ,\u0017\r\u001a\u0011\t\u000fu\u0004!\u0019!C\u0005}\u0006!An\\2l+\u0005I\u0001bBA\u0001\u0001\u0001\u0006I!C\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000f\t!\u0003\u001d:pIV\u001cWM\u001d+pa&\u001c7\u000b^1ugV\u0011\u0011\u0011\u0002\t\u0004C\u0005-\u0011bAA\u0007\u0005\t\u0011\u0002K]8ek\u000e,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011!\t\t\u0002\u0001Q\u0001\n\u0005%\u0011a\u00059s_\u0012,8-\u001a:U_BL7m\u0015;biN\u0004\u0003B\u0002!\u0001\t\u0003\t)\u0002F\u0002C\u0003/AaAHA\n\u0001\u0004\u0001\u0003bBA\u000e\u0001\u0011\u0005\u0011QD\u0001\u0005g\u0016tG\rF\u0002j\u0003?A\u0001\"!\t\u0002\u001a\u0001\u0007\u00111E\u0001\t[\u0016\u001c8/Y4fgB!\u0001$!\n\\\u0013\r\t9#\u0007\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBA\u0016\u0001\u0011%\u0011QF\u0001\fe\u0016\u001cwN\u001d3Ti\u0006$8\u000fF\u0002j\u0003_A\u0001\"!\t\u0002*\u0001\u0007\u0011\u0011\u0007\t\u0006\u0003g\t\u0019e\u0017\b\u0005\u0003k\tyD\u0004\u0003\u00028\u0005uRBAA\u001d\u0015\r\tYDB\u0001\u0007yI|w\u000e\u001e \n\u0003iI1!!\u0011\u001a\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0012\u0002H\t\u00191+Z9\u000b\u0007\u0005\u0005\u0013\u0004C\u0004\u0002L\u0001!I!!\u0014\u0002\u0013\u0005\u001c\u0018P\\2TK:$GcA5\u0002P!A\u0011\u0011EA%\u0001\u0004\t\t\u0004C\u0004\u0002T\u0001!\t!!\u0016\u0002\u000b\rdwn]3\u0015\u0003%\u0004")
public class Producer<K, V>
implements Logging,
ScalaObject {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final Object lock;
    private final ProducerTopicStats kafka$producer$Producer$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue() {
        return this.kafka$producer$Producer$$queue;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> producerSendThread) {
        this.producerSendThread = producerSendThread;
    }

    private Object lock() {
        return this.lock;
    }

    public final ProducerTopicStats kafka$producer$Producer$$producerTopicStats() {
        return this.kafka$producer$Producer$$producerTopicStats;
    }

    public Producer(ProducerConfig config) {
        this(config, new DefaultEventHandler(config, (Partitioner)Utils$.MODULE$.createObject(config.partitionerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)Utils$.MODULE$.createObject(config.serializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), (Encoder)Utils$.MODULE$.createObject(config.keySerializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{config.props()})), new ProducerPool(config), (HashMap<String, TopicMetadata>)DefaultEventHandler$.MODULE$.init$default$6()));
    }

    public void send(Seq<KeyedMessage<K, V>> messages) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block9: {
                block8: {
                    BoxedUnit boxedUnit;
                    block7: {
                        if (this.hasShutdown().get()) {
                            throw new ProducerClosedException();
                        }
                        this.recordStats(messages);
                        bl = this.sync();
                        if (!bl) break block7;
                        this.eventHandler().handle(messages);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    if (bl) break block9;
                    this.asyncSend(messages);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
    }

    private void recordStats(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach((Function1)new $anonfun$recordStats$1(this));
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> messages) {
        messages.foreach((Function1)new $anonfun$asyncSend$1(this));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            boolean canShutdown = this.hasShutdown().compareAndSet(false, true);
            if (canShutdown) {
                this.info((Function0<String>)new $anonfun$close$1(this));
                if (this.producerSendThread() != null) {
                    this.producerSendThread().shutdown();
                }
                this.eventHandler().close();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Producer(ProducerConfig config, EventHandler<K, V> eventHandler) {
        String string;
        block3: {
            block2: {
                this.config = config;
                this.eventHandler = eventHandler;
                Logging$class.$init$(this);
                this.hasShutdown = new AtomicBoolean(false);
                this.kafka$producer$Producer$$queue = new LinkedBlockingQueue(config.queueBufferingMaxMessages());
                this.sync = true;
                this.producerSendThread = null;
                this.lock = new Object();
                String string2 = string = config.producerType();
                String string3 = "sync";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = string;
                String string5 = "async";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                this.sync_$eq(false);
                this.producerSendThread_$eq(new ProducerSendThread<K, V>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)config.clientId()).toString(), this.kafka$producer$Producer$$queue(), eventHandler, config.queueBufferingMaxMs(), config.batchNumMessages(), config.clientId()));
                this.producerSendThread().start();
            }
            this.kafka$producer$Producer$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(config.clientId());
            KafkaMetricsReporter$.MODULE$.startReporters(config.props());
            return;
        }
        throw new MatchError(string);
    }
}

