/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kafka.api.FetchRequest;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel$;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$Request$;
import kafka.network.RequestChannel$SendAction$;
import kafka.network.RequestMetrics;
import kafka.network.RequestMetrics$;
import kafka.network.Send;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011=t!B\u0001\u0003\u0011\u000b9\u0011A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1\u0001B\u0003\u0002\u0005\u0002\u0003E)a\u0003\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m'\u0011IA\u0002\u0006\u000e\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\"\u0013\u0011\u0005!%\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9A%\u0003b\u0001\n\u0003)\u0013aB!mY\u0012{g.Z\u000b\u0002MA\u0011q\u0005K\u0007\u0002\u0013\u0019A\u0011&\u0003C\u0001\u0002\u0003\u0005%FA\u0004SKF,Xm\u001d;\u0014\t!b!d\u000b\t\u000371J!!\f\u000f\u0003\u000fA\u0013x\u000eZ;di\"Aq\u0006\u000bBK\u0002\u0013\u0005\u0001'A\u0005qe>\u001cWm]:peV\t\u0011\u0007\u0005\u0002\u001ce%\u00111\u0007\b\u0002\u0004\u0013:$\b\u0002C\u001b)\u0005#\u0005\u000b\u0011B\u0019\u0002\u0015A\u0014xnY3tg>\u0014\b\u0005\u0003\u00058Q\tU\r\u0011\"\u00019\u0003)\u0011X-];fgR\\U-_\u000b\u0002sA\u00111DO\u0005\u0003wq\u00111!\u00118z\u0011!i\u0004F!E!\u0002\u0013I\u0014a\u0003:fcV,7\u000f^&fs\u0002B\u0001b\u0010\u0015\u0003\u0002\u0004%I\u0001Q\u0001\u0007EV4g-\u001a:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\t\u0002\u00079Lw.\u0003\u0002G\u0007\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011!C#\u00111A\u0005\n%\u000b!BY;gM\u0016\u0014x\fJ3r)\tQU\n\u0005\u0002\u001c\u0017&\u0011A\n\b\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019A!\u0002\u0007a$\u0013\u0007\u0003\u0005QQ\tE\t\u0015)\u0003B\u0003\u001d\u0011WO\u001a4fe\u0002B\u0001B\u0015\u0015\u0003\u0016\u0004%\taU\u0001\fgR\f'\u000f\u001e+j[\u0016l5/F\u0001U!\tYR+\u0003\u0002W9\t!Aj\u001c8h\u0011!A\u0006F!E!\u0002\u0013!\u0016\u0001D:uCJ$H+[7f\u001bN\u0004\u0003\u0002\u0003.)\u0005+\u0007I\u0011A.\u0002\u001bI,Wn\u001c;f\u0003\u0012$'/Z:t+\u0005a\u0006CA/a\u001b\u0005q&BA0\u0011\u0003\rqW\r^\u0005\u0003Cz\u0013QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\b\u0002C2)\u0005#\u0005\u000b\u0011\u0002/\u0002\u001dI,Wn\u001c;f\u0003\u0012$'/Z:tA!)\u0011\u0005\u000bC\u0001KR1aEZ4iS*DQa\f3A\u0002EBQa\u000e3A\u0002eBQa\u00103A\u0002\u0005CQA\u00153A\u0002QCqA\u00173\u0011\u0002\u0003\u0007A\fC\u0004mQ\u0001\u0007I\u0011A*\u0002)I,\u0017/^3ti\u0012+\u0017/^3vKRKW.Z't\u0011\u001dq\u0007\u00061A\u0005\u0002=\f\u0001D]3rk\u0016\u001cH\u000fR3rk\u0016,X\rV5nK6\u001bx\fJ3r)\tQ\u0005\u000fC\u0004O[\u0006\u0005\t\u0019\u0001+\t\rID\u0003\u0015)\u0003U\u0003U\u0011X-];fgR$U-];fk\u0016$\u0016.\\3Ng\u0002B#!\u001d;\u0011\u0005m)\u0018B\u0001<\u001d\u0005!1x\u000e\\1uS2,\u0007b\u0002=)\u0001\u0004%\taU\u0001\u0017CBLGj\\2bY\u000e{W\u000e\u001d7fi\u0016$\u0016.\\3Ng\"9!\u0010\u000ba\u0001\n\u0003Y\u0018AG1qS2{7-\u00197D_6\u0004H.\u001a;f)&lW-T:`I\u0015\fHC\u0001&}\u0011\u001dq\u00150!AA\u0002QCaA \u0015!B\u0013!\u0016aF1qS2{7-\u00197D_6\u0004H.\u001a;f)&lW-T:!Q\tiH\u000f\u0003\u0005\u0002\u0004!\u0002\r\u0011\"\u0001T\u0003Y\u0011Xm\u001d9p]N,7i\\7qY\u0016$X\rV5nK6\u001b\b\"CA\u0004Q\u0001\u0007I\u0011AA\u0005\u0003i\u0011Xm\u001d9p]N,7i\\7qY\u0016$X\rV5nK6\u001bx\fJ3r)\rQ\u00151\u0002\u0005\t\u001d\u0006\u0015\u0011\u0011!a\u0001)\"9\u0011q\u0002\u0015!B\u0013!\u0016a\u0006:fgB|gn]3D_6\u0004H.\u001a;f)&lW-T:!Q\r\ti\u0001\u001e\u0005\t\u0003+A\u0003\u0019!C\u0001'\u0006)\"/Z:q_:\u001cX\rR3rk\u0016,X\rV5nK6\u001b\b\"CA\rQ\u0001\u0007I\u0011AA\u000e\u0003e\u0011Xm\u001d9p]N,G)Z9vKV,G+[7f\u001bN|F%Z9\u0015\u0007)\u000bi\u0002\u0003\u0005O\u0003/\t\t\u00111\u0001U\u0011\u001d\t\t\u0003\u000bQ!\nQ\u000baC]3ta>t7/\u001a#fcV,W/\u001a+j[\u0016l5\u000f\t\u0015\u0004\u0003?!\b\"CA\u0014Q\t\u0007I\u0011AA\u0015\u0003%\u0011X-];fgRLE-\u0006\u0002\u0002,A\u00191$!\f\n\u0007\u0005=BDA\u0003TQ>\u0014H\u000f\u0003\u0005\u00024!\u0002\u000b\u0011BA\u0016\u0003)\u0011X-];fgRLE\r\t\u0005\n\u0003oA#\u0019!C\u0001\u0003s\t!B]3rk\u0016\u001cHo\u00142k+\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005B\u0001\u0004CBL\u0017\u0002BA#\u0003\u007f\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011!\tI\u0005\u000bQ\u0001\n\u0005m\u0012a\u0003:fcV,7\u000f^(cU\u0002B\u0011\"!\u0014)\u0005\u0004%I!a\u0014\u0002\u001bI,\u0017/^3ti2{wmZ3s+\t\t\t\u0006\u0005\u0003\u0002T\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u000b1|w\r\u000e6\u000b\t\u0005m\u0013QL\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0013aA8sO&!\u00111MA+\u0005\u0019aunZ4fe\"A\u0011q\r\u0015!\u0002\u0013\t\t&\u0001\bsKF,Xm\u001d;M_\u001e<WM\u001d\u0011\t\u000f\u0005-\u0004\u0006\"\u0001\u0002n\u0005!R\u000f\u001d3bi\u0016\u0014V-];fgRlU\r\u001e:jGN$\u0012A\u0013\u0005\n\u0003cB\u0013\u0011!C\u0001\u0003g\nAaY8qsRYa%!\u001e\u0002x\u0005e\u00141PA?\u0011!y\u0013q\u000eI\u0001\u0002\u0004\t\u0004\u0002C\u001c\u0002pA\u0005\t\u0019A\u001d\t\u0011}\ny\u0007%AA\u0002\u0005C\u0001BUA8!\u0003\u0005\r\u0001\u0016\u0005\t5\u0006=\u0004\u0013!a\u00019\"I\u0011\u0011\u0011\u0015\u0012\u0002\u0013\u0005\u00111Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)IK\u00022\u0003\u000f[#!!#\u0011\t\u0005-\u0015QS\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'c\u0012AC1o]>$\u0018\r^5p]&!\u0011qSAG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u00037C\u0013\u0013!C\u0001\u0003;\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002 *\u001a\u0011(a\"\t\u0013\u0005\r\u0006&%A\u0005\u0002\u0005\u0015\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003OS3!QAD\u0011%\tY\u000bKI\u0001\n\u0003\ti+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=&f\u0001+\u0002\b\"I\u00111\u0017\u0015\u0012\u0002\u0013\u0005\u0011QW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\t9LK\u0002]\u0003\u000fC\u0001\"a/)\u0013\u0003%\t\u0001Q\u0001\tEV4g-\u001a:%c!Q\u0011q\u0018\u0015\u0005\u0002\u0003%\t%!1\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\r\u0005\u000b\u0003\u000bDC\u0011!A\u0005B\u0005\u001d\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0007\u0003BAf\u0003#t1aGAg\u0013\r\ty\rH\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0017Q\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=G\u0004\u0003\u0006\u0002Z\"\"\t\u0011!C!\u00037\fa!Z9vC2\u001cH\u0003BAo\u0003G\u00042aGAp\u0013\r\t\t\u000f\b\u0002\b\u0005>|G.Z1o\u0011!q\u0015q[A\u0001\u0002\u0004I\u0004BCAtQ\u0011\u0005\t\u0011\"\u0011\u0002j\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a;\u0011\u00075\ti/C\u0002\u0002T:A\u0011\"!=)\t\u0003\u0005I\u0011\t\u0019\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005U\b\u0006\"A\u0001\n\u0003\n90\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007e\nI\u0010\u0003\u0005O\u0003g\f\t\u00111\u00012\u0011)\ti\u0010\u000bC\u0001\u0002\u0013\u0005\u0013q`\u0001\tG\u0006tW)];bYR!\u0011Q\u001cB\u0001\u0011!q\u00151`A\u0001\u0002\u0004I\u0004f\u0001\u0015\u0003\u0006A\u00191Da\u0002\n\u0007\t%AD\u0001\u0007tKJL\u0017\r\\5{C\ndW\rC\u0004\u0003\u000e%\u0001\u000b\u0011\u0002\u0014\u0002\u0011\u0005cG\u000eR8oK\u0002BqA!\u0005\n\t\u0003\u0011\u0019\"\u0001\nhKR\u001c\u0006.\u001e;e_^t'+Z2fSZ,G#A!\b\u0013\t]\u0011\"!A\t\u0006\te\u0011a\u0002*fcV,7\u000f\u001e\t\u0004O\tma!C\u0015\n\t\u0007\u0005\tR\u0001B\u000f'\u0015\u0011YBa\b\u001b!)\u0011\tCa\n2s\u0005#FLJ\u0007\u0003\u0005GQ1A!\n\u001d\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u000b\u0003$\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000f\u0005\u0012Y\u0002\"\u0001\u0003.Q\u0011!\u0011\u0004\u0005\u000b\u0005c\u0011Y\"!A\u0005\u0002\nM\u0012!B1qa2LHc\u0003\u0014\u00036\t]\"\u0011\bB\u001e\u0005{Aaa\fB\u0018\u0001\u0004\t\u0004BB\u001c\u00030\u0001\u0007\u0011\b\u0003\u0004@\u0005_\u0001\r!\u0011\u0005\u0007%\n=\u0002\u0019\u0001+\t\u0011i\u0013y\u0003%AA\u0002qC!B!\u0011\u0003\u001c\u0005\u0005I\u0011\u0011B\"\u0003\u001d)h.\u00199qYf$BA!\u0012\u0003RA)1Da\u0012\u0003L%\u0019!\u0011\n\u000f\u0003\r=\u0003H/[8o!!Y\"QJ\u0019:\u0003Rc\u0016b\u0001B(9\t1A+\u001e9mKVBqAa\u0015\u0003@\u0001\u0007a%A\u0002yIAB!Ba\u0016\u0003\u001cE\u0005I\u0011AA[\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIUB!Ba\u0017\u0003\u001cE\u0005I\u0011AA[\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0004b\u0003B0\u00057!\t\u0011!C\t\u0005C\n1B]3bIJ+7o\u001c7wKR\tA\u0002\u000b\u0003\u0003\u001c\t\u0015aA\u0003B4\u0013\u0011\u0005\t\u0011!!\u0003j\tA!+Z:q_:\u001cXmE\u0003\u0003f1Q2\u0006C\u00050\u0005K\u0012)\u001a!C\u0001a!IQG!\u001a\u0003\u0012\u0003\u0006I!\r\u0005\u000b\u0005c\u0012)G!f\u0001\n\u0003)\u0013a\u0002:fcV,7\u000f\u001e\u0005\u000b\u0005k\u0012)G!E!\u0002\u00131\u0013\u0001\u0003:fcV,7\u000f\u001e\u0011\t\u0017\te$Q\rBK\u0002\u0013\u0005!1P\u0001\re\u0016\u001c\bo\u001c8tKN+g\u000eZ\u000b\u0003\u0005{\u00022\u0001\u0003B@\u0013\r\u0011\tI\u0001\u0002\u0005'\u0016tG\rC\u0006\u0003\u0006\n\u0015$\u0011#Q\u0001\n\tu\u0014!\u0004:fgB|gn]3TK:$\u0007\u0005C\u0006\u0003\n\n\u0015$Q3A\u0005\u0002\t-\u0015A\u0004:fgB|gn]3BGRLwN\\\u000b\u0003\u0005\u001b\u00032a\nBH\r)\u0011\t*\u0003C\u0011\u0002G\u0005!1\u0013\u0002\u000f%\u0016\u001c\bo\u001c8tK\u0006\u001bG/[8o'\r\u0011y\t\u0004\u0005\f\u0005/\u0013)G!E!\u0002\u0013\u0011i)A\bsKN\u0004xN\\:f\u0003\u000e$\u0018n\u001c8!\u0011\u001d\t#Q\rC\u0001\u00057#\"B!(\u0003 \n\u0005&1\u0015BS!\r9#Q\r\u0005\u0007_\te\u0005\u0019A\u0019\t\u000f\tE$\u0011\u0014a\u0001M!A!\u0011\u0010BM\u0001\u0004\u0011i\b\u0003\u0005\u0003\n\ne\u0005\u0019\u0001BG\u0011\u001d\t#Q\rC\u0001\u0005S#\u0002B!(\u0003,\n5&q\u0016\u0005\u0007_\t\u001d\u0006\u0019A\u0019\t\u000f\tE$q\u0015a\u0001M!A!\u0011\u0010BT\u0001\u0004\u0011i\bC\u0004\"\u0005K\"\tAa-\u0015\r\tu%Q\u0017B\\\u0011\u001d\u0011\tH!-A\u0002\u0019B\u0001B!/\u00032\u0002\u0007!QP\u0001\u0005g\u0016tG\r\u0003\u0006\u0002r\t\u0015\u0014\u0011!C\u0001\u0005{#\"B!(\u0003@\n\u0005'1\u0019Bc\u0011!y#1\u0018I\u0001\u0002\u0004\t\u0004\"\u0003B9\u0005w\u0003\n\u00111\u0001'\u0011)\u0011IHa/\u0011\u0002\u0003\u0007!Q\u0010\u0005\u000b\u0005\u0013\u0013Y\f%AA\u0002\t5\u0005BCAA\u0005K\n\n\u0011\"\u0001\u0002\u0004\"Q\u00111\u0014B3#\u0003%\tAa3\u0016\u0005\t5'f\u0001\u0014\u0002\b\"Q\u00111\u0015B3#\u0003%\tA!5\u0016\u0005\tM'\u0006\u0002B?\u0003\u000fC!\"a+\u0003fE\u0005I\u0011\u0001Bl+\t\u0011IN\u000b\u0003\u0003\u000e\u0006\u001d\u0005bCA`\u0005K\"\t\u0011!C!\u0003\u0003D1\"!2\u0003f\u0011\u0005\t\u0011\"\u0011\u0002H\"Y\u0011\u0011\u001cB3\t\u0003\u0005I\u0011\tBq)\u0011\tiNa9\t\u00119\u0013y.!AA\u0002eB1\"a:\u0003f\u0011\u0005\t\u0011\"\u0011\u0002j\"Q\u0011\u0011\u001fB3\t\u0003\u0005I\u0011\t\u0019\t\u0017\u0005U(Q\rC\u0001\u0002\u0013\u0005#1\u001e\u000b\u0004s\t5\b\u0002\u0003(\u0003j\u0006\u0005\t\u0019A\u0019\t\u0017\u0005u(Q\rC\u0001\u0002\u0013\u0005#\u0011\u001f\u000b\u0005\u0003;\u0014\u0019\u0010\u0003\u0005O\u0005_\f\t\u00111\u0001:Q\u0011\u0011)G!\u0002\b\u0013\te\u0018\"!A\t\u0006\tm\u0018\u0001\u0003*fgB|gn]3\u0011\u0007\u001d\u0012iP\u0002\u0006\u0003h%!\u0019\u0011!E\u0003\u0005\u007f\u001cRA!@\u0004\u0002i\u0001BB!\t\u0004\u0004E2#Q\u0010BG\u0005;KAa!\u0002\u0003$\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000f\u0005\u0012i\u0010\"\u0001\u0004\nQ\u0011!1 \u0005\u000b\u0005c\u0011i0!A\u0005\u0002\u000e5AC\u0003BO\u0007\u001f\u0019\tba\u0005\u0004\u0016!1qfa\u0003A\u0002EBqA!\u001d\u0004\f\u0001\u0007a\u0005\u0003\u0005\u0003z\r-\u0001\u0019\u0001B?\u0011!\u0011Iia\u0003A\u0002\t5\u0005B\u0003B!\u0005{\f\t\u0011\"!\u0004\u001aQ!11DB\u0012!\u0015Y\"qIB\u000f!%Y2qD\u0019'\u0005{\u0012i)C\u0002\u0004\"q\u0011a\u0001V;qY\u0016$\u0004\u0002\u0003B*\u0007/\u0001\rA!(\t\u0017\t}#Q C\u0001\u0002\u0013E!\u0011\r\u0015\u0005\u0005{\u0014)aB\u0004\u0004,%A)i!\f\u0002\u0015M+g\u000eZ!di&|g\u000eE\u0002(\u0007_1!b!\r\n\t\u0003\u0005\tRQB\u001a\u0005)\u0019VM\u001c3BGRLwN\\\n\b\u0007_a!Q\u0012\u000e,\u0011\u001d\t3q\u0006C\u0001\u0007o!\"a!\f\t\u0017\u0005\u00157q\u0006C\u0001\u0002\u0013\u001531\b\u000b\u0003\u0003WD1\"a:\u00040\u0011\u0005\t\u0011\"\u0011\u0002j\"Q\u0011\u0011_B\u0018\t\u0003\u0005I\u0011\t\u0019\t\u0017\u0005U8q\u0006C\u0001\u0002\u0013\u000531\t\u000b\u0004s\r\u0015\u0003\u0002\u0003(\u0004B\u0005\u0005\t\u0019A\u0019\t\u0017\u0005u8q\u0006C\u0001\u0002\u0013\u00053\u0011\n\u000b\u0005\u0003;\u001cY\u0005\u0003\u0005O\u0007\u000f\n\t\u00111\u0001:\u0011-\u0011yfa\f\u0005\u0002\u0003%\tB!\u0019)\t\r=\"QA\u0004\b\u0007'J\u0001RQB+\u0003)qun\u00149BGRLwN\u001c\t\u0004O\r]cACB-\u0013\u0011\u0005\t\u0011#\"\u0004\\\tQaj\\(q\u0003\u000e$\u0018n\u001c8\u0014\u000f\r]CB!$\u001bW!9\u0011ea\u0016\u0005\u0002\r}CCAB+\u0011-\t)ma\u0016\u0005\u0002\u0003%)ea\u000f\t\u0017\u0005\u001d8q\u000bC\u0001\u0002\u0013\u0005\u0013\u0011\u001e\u0005\u000b\u0003c\u001c9\u0006\"A\u0001\n\u0003\u0002\u0004bCA{\u0007/\"\t\u0011!C!\u0007S\"2!OB6\u0011!q5qMA\u0001\u0002\u0004\t\u0004bCA\u007f\u0007/\"\t\u0011!C!\u0007_\"B!!8\u0004r!Aaj!\u001c\u0002\u0002\u0003\u0007\u0011\bC\u0006\u0003`\r]C\u0011!A\u0005\u0012\t\u0005\u0004\u0006BB,\u0005\u000b9qa!\u001f\n\u0011\u000b\u001bY(A\u000bDY>\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u000e$\u0018n\u001c8\u0011\u0007\u001d\u001aiH\u0002\u0006\u0004\u0000%!\t\u0011!EC\u0007\u0003\u0013Qc\u00117pg\u0016\u001cuN\u001c8fGRLwN\\!di&|gnE\u0004\u0004~1\u0011iIG\u0016\t\u000f\u0005\u001ai\b\"\u0001\u0004\u0006R\u001111\u0010\u0005\f\u0003\u000b\u001ci\b\"A\u0001\n\u000b\u001aY\u0004C\u0006\u0002h\u000euD\u0011!A\u0005B\u0005%\bBCAy\u0007{\"\t\u0011!C!a!Y\u0011Q_B?\t\u0003\u0005I\u0011IBH)\rI4\u0011\u0013\u0005\t\u001d\u000e5\u0015\u0011!a\u0001c!Y\u0011Q`B?\t\u0003\u0005I\u0011IBK)\u0011\tina&\t\u00119\u001b\u0019*!AA\u0002eB1Ba\u0018\u0004~\u0011\u0005\t\u0011\"\u0005\u0003b!\"1Q\u0010B\u0003\r%Q!\u0001\"A\u0001\u0002\u0003\u0019yj\u0005\u0004\u0004\u001e2\u0019\tK\u0007\t\u0005\u0007G\u001bI+\u0004\u0002\u0004&*\u00191q\u0015\u0003\u0002\u000f5,GO]5dg&!11VBS\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\u0005\u000b\u0007_\u001biJ!b\u0001\n\u0003\u0001\u0014!\u00048v[B\u0013xnY3tg>\u00148\u000f\u0003\u0006\u00044\u000eu%\u0011!Q\u0001\nE\naB\\;n!J|7-Z:t_J\u001c\b\u0005\u0003\u0006\u00048\u000eu%Q1A\u0005\u0002A\n\u0011\"];fk\u0016\u001c\u0016N_3\t\u0015\rm6Q\u0014B\u0001B\u0003%\u0011'\u0001\u0006rk\u0016,XmU5{K\u0002Bq!IBO\t\u0003\u0019y\f\u0006\u0004\u0004B\u000e\r7Q\u0019\t\u0004\u0011\ru\u0005bBBX\u0007{\u0003\r!\r\u0005\b\u0007o\u001bi\f1\u00012\u0011)\u0019Im!(A\u0002\u0013%11Z\u0001\u0012e\u0016\u001c\bo\u001c8tK2K7\u000f^3oKJ\u001cXCABg!\u0019\u0019yma8\u0004f:!1\u0011[Bn\u001d\u0011\u0019\u0019n!7\u000e\u0005\rU'bABl\r\u00051AH]8pizJ\u0011!H\u0005\u0004\u0007;d\u0012a\u00029bG.\fw-Z\u0005\u0005\u0007C\u001c\u0019O\u0001\u0003MSN$(bABo9A)1da:2\u0015&\u00191\u0011\u001e\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004BCBw\u0007;\u0003\r\u0011\"\u0003\u0004p\u0006)\"/Z:q_:\u001cX\rT5ti\u0016tWM]:`I\u0015\fHc\u0001&\u0004r\"Iaja;\u0002\u0002\u0003\u00071Q\u001a\u0005\n\u0007k\u001ci\n)Q\u0005\u0007\u001b\f!C]3ta>t7/\u001a'jgR,g.\u001a:tA!Q1\u0011`BO\u0005\u0004%Iaa?\u0002\u0019I,\u0017/^3tiF+X-^3\u0016\u0005\ru\bCBB\u0000\t\u0013!i!\u0004\u0002\u0005\u0002)!A1\u0001C\u0003\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\t\u000f\u0001\u0012\u0001B;uS2LA\u0001b\u0003\u0005\u0002\t\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\r!y\u0001\u000b\b\u0003\u0011\u0001A\u0011\u0002b\u0005\u0004\u001e\u0002\u0006Ia!@\u0002\u001bI,\u0017/^3tiF+X-^3!\u0011)!9b!(C\u0002\u0013%A\u0011D\u0001\u000fe\u0016\u001c\bo\u001c8tKF+X-^3t+\t!Y\u0002E\u0003\u001c\t;!\t#C\u0002\u0005 q\u0011Q!\u0011:sCf\u0004baa@\u0005$\u0011\u001d\u0012\u0002\u0002C\u0013\t\u0003\u0011QB\u00117pG.LgnZ)vKV,\u0007\u0003\u0002C\b\u0005KB\u0011\u0002b\u000b\u0004\u001e\u0002\u0006I\u0001b\u0007\u0002\u001fI,7\u000f]8og\u0016\fV/Z;fg\u0002B\u0001\u0002b\f\u0004\u001e\u0012\u0005A\u0011G\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000fF\u0002K\tgA\u0001B!\u001d\u0005.\u0001\u0007AQ\u0002\u0005\t\to\u0019i\n\"\u0001\u0005:\u0005a1/\u001a8e%\u0016\u001c\bo\u001c8tKR\u0019!\nb\u000f\t\u0011\u0011uBQ\u0007a\u0001\tO\t\u0001B]3ta>t7/\u001a\u0005\t\t\u0003\u001ai\n\"\u0001\u0005D\u0005Yan\\(qKJ\fG/[8o)\u0015QEQ\tC$\u0011\u0019yCq\ba\u0001c!A!\u0011\u000fC \u0001\u0004!i\u0001\u0003\u0005\u0005L\ruE\u0011\u0001C'\u0003=\u0019Gn\\:f\u0007>tg.Z2uS>tG#\u0002&\u0005P\u0011E\u0003BB\u0018\u0005J\u0001\u0007\u0011\u0007\u0003\u0005\u0003r\u0011%\u0003\u0019\u0001C\u0007\u0011!!)f!(\u0005\u0002\u0011]\u0013A\u0004:fG\u0016Lg/\u001a*fcV,7\u000f\u001e\u000b\u0003\t\u001bA\u0001\u0002b\u0017\u0004\u001e\u0012\u0005AQL\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR!Aq\u0005C0\u0011\u0019yC\u0011\fa\u0001c!AA1MBO\t\u0003!)'A\nbI\u0012\u0014Vm\u001d9p]N,G*[:uK:,'\u000fF\u0002K\tOB\u0001\u0002\"\u001b\u0005b\u0001\u00071Q]\u0001\u000b_:\u0014Vm\u001d9p]N,\u0007\u0002\u0003C7\u0007;#\t!!\u001c\u0002\u0011MDW\u000f\u001e3po:\u0004")
public class RequestChannel
implements KafkaMetricsGroup,
ScalaObject {
    private final int numProcessors;
    private final int queueSize;
    private List<Function1<Object, BoxedUnit>> responseListeners;
    private final ArrayBlockingQueue<Request> kafka$network$RequestChannel$$requestQueue;
    private final BlockingQueue<Response>[] kafka$network$RequestChannel$$responseQueues;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final ByteBuffer getShutdownReceive() {
        return RequestChannel$.MODULE$.getShutdownReceive();
    }

    public static final Request AllDone() {
        return RequestChannel$.MODULE$.AllDone();
    }

    public int numProcessors() {
        return this.numProcessors;
    }

    public int queueSize() {
        return this.queueSize;
    }

    private List<Function1<Object, BoxedUnit>> responseListeners() {
        return this.responseListeners;
    }

    private void responseListeners_$eq(List<Function1<Object, BoxedUnit>> list) {
        this.responseListeners = list;
    }

    public final ArrayBlockingQueue<Request> kafka$network$RequestChannel$$requestQueue() {
        return this.kafka$network$RequestChannel$$requestQueue;
    }

    public final BlockingQueue<Response>[] kafka$network$RequestChannel$$responseQueues() {
        return this.kafka$network$RequestChannel$$responseQueues;
    }

    public void sendRequest(Request request) {
        this.kafka$network$RequestChannel$$requestQueue().put(request);
    }

    public void sendResponse(Response response$1) {
        this.kafka$network$RequestChannel$$responseQueues()[response$1.processor()].put(response$1);
        this.responseListeners().foreach((Function1)new $anonfun$sendResponse$1(this, response$1));
    }

    public void noOperation(int processor$4, Request request) {
        this.kafka$network$RequestChannel$$responseQueues()[processor$4].put(new Response(processor$4, request, null, RequestChannel$NoOpAction$.MODULE$));
        this.responseListeners().foreach((Function1)new $anonfun$noOperation$1(this, processor$4));
    }

    public void closeConnection(int processor$3, Request request) {
        this.kafka$network$RequestChannel$$responseQueues()[processor$3].put(new Response(processor$3, request, null, RequestChannel$CloseConnectionAction$.MODULE$));
        this.responseListeners().foreach((Function1)new $anonfun$closeConnection$1(this, processor$3));
    }

    public Request receiveRequest() {
        return this.kafka$network$RequestChannel$$requestQueue().take();
    }

    /*
     * WARNING - void declaration
     */
    public Response receiveResponse(int processor) {
        void var2_2;
        Response response = (Response)this.kafka$network$RequestChannel$$responseQueues()[processor].poll();
        if (response != null) {
            response.request().responseDequeueTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        }
        return var2_2;
    }

    public void addResponseListener(Function1<Object, BoxedUnit> onResponse) {
        this.responseListeners_$eq((List<Function1<Object, BoxedUnit>>)this.responseListeners().$colon$colon(onResponse));
    }

    public void shutdown() {
        this.kafka$network$RequestChannel$$requestQueue().clear();
    }

    public RequestChannel(int numProcessors, int queueSize) {
        this.numProcessors = numProcessors;
        this.queueSize = queueSize;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.responseListeners = Nil$.MODULE$;
        this.kafka$network$RequestChannel$$requestQueue = new ArrayBlockingQueue(queueSize);
        this.kafka$network$RequestChannel$$responseQueues = new BlockingQueue[numProcessors];
        Predef$.MODULE$.intWrapper(0).until(numProcessors).foreach$mVc$sp((Function1)new $anonfun$1(this));
        this.newGauge("RequestQueueSize", new $anon$1(this));
        Predef$.MODULE$.intWrapper(0).until(numProcessors).foreach((Function1)new $anonfun$3(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    implements ScalaObject,
    Product,
    Serializable {
        private final int processor;
        private final Object requestKey;
        private ByteBuffer kafka$network$RequestChannel$Request$$buffer;
        private final long startTimeMs;
        private final SocketAddress remoteAddress;
        private volatile long requestDequeueTimeMs;
        private volatile long apiLocalCompleteTimeMs;
        private volatile long responseCompleteTimeMs;
        private volatile long responseDequeueTimeMs;
        private final short requestId;
        private final RequestOrResponse requestObj;
        private final Logger requestLogger;

        public SocketAddress copy$default$5() {
            return this.remoteAddress();
        }

        public long copy$default$4() {
            return this.startTimeMs();
        }

        public ByteBuffer copy$default$3() {
            return this.kafka$network$RequestChannel$Request$$buffer();
        }

        public Object copy$default$2() {
            return this.requestKey();
        }

        public int copy$default$1() {
            return this.processor();
        }

        public int processor() {
            return this.processor;
        }

        public Object requestKey() {
            return this.requestKey;
        }

        public final ByteBuffer kafka$network$RequestChannel$Request$$buffer() {
            return this.kafka$network$RequestChannel$Request$$buffer;
        }

        private void kafka$network$RequestChannel$Request$$buffer_$eq(ByteBuffer byteBuffer) {
            this.kafka$network$RequestChannel$Request$$buffer = byteBuffer;
        }

        public long startTimeMs() {
            return this.startTimeMs;
        }

        public SocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        public long requestDequeueTimeMs() {
            return this.requestDequeueTimeMs;
        }

        public void requestDequeueTimeMs_$eq(long l) {
            this.requestDequeueTimeMs = l;
        }

        public long apiLocalCompleteTimeMs() {
            return this.apiLocalCompleteTimeMs;
        }

        public void apiLocalCompleteTimeMs_$eq(long l) {
            this.apiLocalCompleteTimeMs = l;
        }

        public long responseCompleteTimeMs() {
            return this.responseCompleteTimeMs;
        }

        public void responseCompleteTimeMs_$eq(long l) {
            this.responseCompleteTimeMs = l;
        }

        public long responseDequeueTimeMs() {
            return this.responseDequeueTimeMs;
        }

        public void responseDequeueTimeMs_$eq(long l) {
            this.responseDequeueTimeMs = l;
        }

        public short requestId() {
            return this.requestId;
        }

        public RequestOrResponse requestObj() {
            return this.requestObj;
        }

        private Logger requestLogger() {
            return this.requestLogger;
        }

        public void updateRequestMetrics() {
            long endTimeMs = SystemTime$.MODULE$.milliseconds();
            if (this.apiLocalCompleteTimeMs() < 0L) {
                this.apiLocalCompleteTimeMs_$eq(this.responseCompleteTimeMs());
            }
            long requestQueueTime$1 = Predef$.MODULE$.longWrapper(this.requestDequeueTimeMs() - this.startTimeMs()).max(0L);
            long apiLocalTime$1 = Predef$.MODULE$.longWrapper(this.apiLocalCompleteTimeMs() - this.requestDequeueTimeMs()).max(0L);
            long apiRemoteTime$1 = Predef$.MODULE$.longWrapper(this.responseCompleteTimeMs() - this.apiLocalCompleteTimeMs()).max(0L);
            long responseQueueTime$1 = Predef$.MODULE$.longWrapper(this.responseDequeueTimeMs() - this.responseCompleteTimeMs()).max(0L);
            long responseSendTime$1 = Predef$.MODULE$.longWrapper(endTimeMs - this.responseDequeueTimeMs()).max(0L);
            long totalTime$1 = endTimeMs - this.startTimeMs();
            List metricsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RequestMetrics[]{(RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestKeys$.MODULE$.nameForKey(this.requestId()))}));
            if (this.requestId() == RequestKeys$.MODULE$.FetchKey()) {
                boolean isFromFollower = ((FetchRequest)this.requestObj()).isFromFollower();
                metricsList = metricsList.$colon$colon(isFromFollower ? RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestMetrics$.MODULE$.followFetchMetricName()) : RequestMetrics$.MODULE$.metricsMap().apply((Object)RequestMetrics$.MODULE$.consumerFetchMetricName()));
            }
            metricsList.foreach((Function1)new Request$$anonfun$updateRequestMetrics$1(this, requestQueueTime$1, apiLocalTime$1, apiRemoteTime$1, responseQueueTime$1, responseSendTime$1, totalTime$1));
            if (this.requestLogger().isTraceEnabled()) {
                this.requestLogger().trace((Object)Predef$.MODULE$.augmentString("Completed request:%s from client %s;totalTime:%d,requestQueueTime:%d,localTime:%d,remoteTime:%d,responseQueueTime:%d,sendTime:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.requestObj().describe(true), this.remoteAddress(), BoxesRunTime.boxToLong((long)totalTime$1), BoxesRunTime.boxToLong((long)requestQueueTime$1), BoxesRunTime.boxToLong((long)apiLocalTime$1), BoxesRunTime.boxToLong((long)apiRemoteTime$1), BoxesRunTime.boxToLong((long)responseQueueTime$1), BoxesRunTime.boxToLong((long)responseSendTime$1)})));
            } else if (this.requestLogger().isDebugEnabled()) {
                this.requestLogger().debug((Object)Predef$.MODULE$.augmentString("Completed request:%s from client %s;totalTime:%d,requestQueueTime:%d,localTime:%d,remoteTime:%d,responseQueueTime:%d,sendTime:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.requestObj().describe(false), this.remoteAddress(), BoxesRunTime.boxToLong((long)totalTime$1), BoxesRunTime.boxToLong((long)requestQueueTime$1), BoxesRunTime.boxToLong((long)apiLocalTime$1), BoxesRunTime.boxToLong((long)apiRemoteTime$1), BoxesRunTime.boxToLong((long)responseQueueTime$1), BoxesRunTime.boxToLong((long)responseSendTime$1)})));
            }
        }

        public Request copy(int processor, Object requestKey, ByteBuffer buffer, long startTimeMs, SocketAddress remoteAddress) {
            return new Request(processor, requestKey, buffer, startTimeMs, remoteAddress);
        }

        public ByteBuffer buffer$1() {
            return this.kafka$network$RequestChannel$Request$$buffer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            SocketAddress socketAddress;
            SocketAddress remoteAddress$1;
            long l;
            long startTimeMs$1;
            ByteBuffer byteBuffer;
            ByteBuffer buffer$1$1;
            Object object2;
            Object requestKey$1;
            if (this == object) return true;
            Object object3 = object;
            if (!(object3 instanceof Request)) return false;
            Request request = (Request)object3;
            int n = request.processor();
            int processor$1 = n;
            if (!this.gd1$1(processor$1, requestKey$1 = (object2 = request.requestKey()), buffer$1$1 = (byteBuffer = request.buffer$1()), startTimeMs$1 = (l = request.startTimeMs()), remoteAddress$1 = (socketAddress = request.remoteAddress()))) return false;
            boolean bl = ((Request)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "Request";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 4: {
                    object = this.remoteAddress();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.startTimeMs());
                    break;
                }
                case 2: {
                    object = this.buffer$1();
                    break;
                }
                case 1: {
                    object = this.requestKey();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.processor());
                }
            }
            return object;
        }

        public boolean canEqual(Object object) {
            return object instanceof Request;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(int n, Object object, ByteBuffer byteBuffer, long l, SocketAddress socketAddress) {
            if (n != this.processor()) return false;
            if (!BoxesRunTime.equals((Object)object, (Object)this.requestKey())) return false;
            ByteBuffer byteBuffer2 = byteBuffer;
            ByteBuffer byteBuffer3 = this.buffer$1();
            if (byteBuffer2 == null) {
                if (byteBuffer3 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer2).equals(byteBuffer3)) return false;
            if (l != this.startTimeMs()) return false;
            SocketAddress socketAddress2 = socketAddress;
            SocketAddress socketAddress3 = this.remoteAddress();
            if (socketAddress2 == null) {
                if (socketAddress3 == null) return true;
                return false;
            } else {
                if (!socketAddress2.equals(socketAddress3)) return false;
                return true;
            }
        }

        public Request(int processor, Object requestKey, ByteBuffer buffer, long startTimeMs, SocketAddress remoteAddress) {
            this.processor = processor;
            this.requestKey = requestKey;
            this.kafka$network$RequestChannel$Request$$buffer = buffer;
            this.startTimeMs = startTimeMs;
            this.remoteAddress = remoteAddress;
            Product.class.$init$((Product)this);
            this.requestDequeueTimeMs = -1L;
            this.apiLocalCompleteTimeMs = -1L;
            this.responseCompleteTimeMs = -1L;
            this.responseDequeueTimeMs = -1L;
            this.requestId = this.kafka$network$RequestChannel$Request$$buffer().getShort();
            this.requestObj = (RequestOrResponse)RequestKeys$.MODULE$.deserializerForKey(this.requestId()).apply((Object)this.kafka$network$RequestChannel$Request$$buffer());
            this.kafka$network$RequestChannel$Request$$buffer_$eq(null);
            this.requestLogger = Logger.getLogger((String)"kafka.request.logger");
            RequestChannel$.MODULE$.trace((Function0<String>)new Request$$anonfun$2(this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    implements ScalaObject,
    Product,
    Serializable {
        private final int processor;
        private final Request request;
        private final Send responseSend;
        private final ResponseAction responseAction;

        public ResponseAction copy$default$4() {
            return this.responseAction();
        }

        public Send copy$default$3() {
            return this.responseSend();
        }

        public Request copy$default$2() {
            return this.request();
        }

        public int copy$default$1() {
            return this.processor();
        }

        public int processor() {
            return this.processor;
        }

        public Request request() {
            return this.request;
        }

        public Send responseSend() {
            return this.responseSend;
        }

        public ResponseAction responseAction() {
            return this.responseAction;
        }

        public Response(int processor, Request request, Send responseSend) {
            this(processor, request, responseSend, (ResponseAction)(responseSend == null ? RequestChannel$NoOpAction$.MODULE$ : RequestChannel$SendAction$.MODULE$));
        }

        public Response(Request request, Send send2) {
            this(request.processor(), request, send2);
        }

        public Response copy(int processor, Request request, Send responseSend, ResponseAction responseAction) {
            return new Response(processor, request, responseSend, responseAction);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            ResponseAction responseAction;
            ResponseAction responseAction$1;
            Send send2;
            Send responseSend$1;
            Request request;
            Request request$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof Response)) return false;
            Response response = (Response)object2;
            int n = response.processor();
            int processor$2 = n;
            if (!this.gd2$1(processor$2, request$1 = (request = response.request()), responseSend$1 = (send2 = response.responseSend()), responseAction$1 = (responseAction = response.responseAction()))) return false;
            boolean bl = ((Response)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "Response";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 3: {
                    object = this.responseAction();
                    break;
                }
                case 2: {
                    object = this.responseSend();
                    break;
                }
                case 1: {
                    object = this.request();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.processor());
                }
            }
            return object;
        }

        public boolean canEqual(Object object) {
            return object instanceof Response;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd2$1(int n, Request request, Send send2, ResponseAction responseAction) {
            if (n != this.processor()) return false;
            Request request2 = request;
            Request request3 = this.request();
            if (request2 == null) {
                if (request3 != null) {
                    return false;
                }
            } else if (!((Object)request2).equals(request3)) return false;
            Send send3 = send2;
            Send send4 = this.responseSend();
            if (send3 == null) {
                if (send4 != null) {
                    return false;
                }
            } else if (!send3.equals(send4)) return false;
            ResponseAction responseAction2 = responseAction;
            ResponseAction responseAction3 = this.responseAction();
            if (responseAction2 == null) {
                if (responseAction3 == null) return true;
                return false;
            } else {
                if (!responseAction2.equals(responseAction3)) return false;
                return true;
            }
        }

        public Response(int processor, Request request, Send responseSend, ResponseAction responseAction) {
            this.processor = processor;
            this.request = request;
            this.responseSend = responseSend;
            this.responseAction = responseAction;
            Product.class.$init$((Product)this);
            request.responseCompleteTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
        }
    }

    public static interface ResponseAction {
    }
}

