/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u00151{wmU3h[\u0016tGO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"A1\u0001\u0001BC\u0002\u0013\u0005Q$F\u0001\u001f!\ty\u0002%D\u0001\u0003\u0013\t\t#A\u0001\bGS2,W*Z:tC\u001e,7+\u001a;\t\u0011\r\u0002!\u0011!Q\u0001\ny\tA\u0001\\8hA!AQ\u0005\u0001BC\u0002\u0013\u0005a%A\u0003j]\u0012,\u00070F\u0001(!\ty\u0002&\u0003\u0002*\u0005\tYqJ\u001a4tKRLe\u000eZ3y\u0011!Y\u0003A!A!\u0002\u00139\u0013AB5oI\u0016D\b\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0002_A\u0011q\u0003M\u0005\u0003ca\u0011A\u0001T8oO\"A1\u0007\u0001B\u0001B\u0003%q&A\u0006cCN,wJ\u001a4tKR\u0004\u0003\u0002C\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm]\u000b\u0002oA\u0011q\u0003O\u0005\u0003sa\u00111!\u00138u\u0011!Y\u0004A!A!\u0002\u00139\u0014aE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN\u0004\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\tQLW.\u001a\t\u0003#}J!\u0001\u0011\n\u0003\tQKW.\u001a\u0005\u0006\u0005\u0002!\taQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0011+ei\u0012%J!\ty\u0002\u0001C\u0003\u0004\u0003\u0002\u0007a\u0004C\u0003&\u0003\u0002\u0007q\u0005C\u0003.\u0003\u0002\u0007q\u0006C\u00036\u0003\u0002\u0007q\u0007C\u0003>\u0003\u0002\u0007a\bC\u0004L\u0001\u0001\u0007I\u0011\u0001\u0018\u0002\u000f\r\u0014X-\u0019;fI\"9Q\n\u0001a\u0001\n\u0003q\u0015aC2sK\u0006$X\rZ0%KF$\"a\u0014*\u0011\u0005]\u0001\u0016BA)\u0019\u0005\u0011)f.\u001b;\t\u000fMc\u0015\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\rU\u0003\u0001\u0015)\u00030\u0003!\u0019'/Z1uK\u0012\u0004\u0003bB,\u0001\u0001\u0004%IAN\u0001\u0019Ef$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\bbB-\u0001\u0001\u0004%IAW\u0001\u001dEf$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJLx\fJ3r)\ty5\fC\u0004T1\u0006\u0005\t\u0019A\u001c\t\ru\u0003\u0001\u0015)\u00038\u0003e\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0011\t\u000b\t\u0003A\u0011A0\u0015\r\u0011\u0003\u0007N[6n\u0011\u0015\tg\f1\u0001c\u0003\r!\u0017N\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K2\t!![8\n\u0005\u001d$'\u0001\u0002$jY\u0016DQ!\u001b0A\u0002=\n1b\u001d;beR|eMZ:fi\")QG\u0018a\u0001o!)AN\u0018a\u0001o\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\")QH\u0018a\u0001}!)q\u000e\u0001C\u0001]\u0005!1/\u001b>f\u0011\u0015\t\b\u0001\"\u0001s\u0003\u0019\t\u0007\u000f]3oIR\u0019qj];\t\u000bQ\u0004\b\u0019A\u0018\u0002\r=4gm]3u\u0011\u00151\b\u000f1\u0001x\u0003!iWm]:bO\u0016\u001c\bC\u0001=|\u001b\u0005I(B\u0001>\u0005\u0003\u001diWm]:bO\u0016L!\u0001`=\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3uQ\t\u0001h\u0010\u0005\u0002\u0012\u007f&\u0019\u0011\u0011\u0001\n\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0011!\t)\u0001\u0001C\u0001\u0005\u0005\u001d\u0011a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\u0005%\u0011qBA\t!\ry\u00121B\u0005\u0004\u0003\u001b\u0011!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\u0007i\u0006\r\u0001\u0019A\u0018\t\u0013\u0005M\u00111\u0001I\u0001\u0002\u00049\u0014\u0001F:uCJ$\u0018N\\4GS2,\u0007k\\:ji&|g\u000e\u000b\u0003\u0002\u0004\u0005]\u0001cA\t\u0002\u001a%\u0019\u00111\u0004\n\u0003\u0015QD'/Z1eg\u00064W\rC\u0004\u0002 \u0001!\t!!\t\u0002\tI,\u0017\r\u001a\u000b\t\u0003G\tI#a\u000b\u00026A\u0019\u00010!\n\n\u0007\u0005\u001d\u0012P\u0001\u0006NKN\u001c\u0018mZ3TKRDa![A\u000f\u0001\u0004y\u0003\u0002CA\u0017\u0003;\u0001\r!a\f\u0002\u00135\f\u0007p\u00144gg\u0016$\b\u0003B\f\u00022=J1!a\r\u0019\u0005\u0019y\u0005\u000f^5p]\"9\u0011qGA\u000f\u0001\u00049\u0014aB7bqNK'0\u001a\u0015\u0005\u0003;\t9\u0002C\u0004\u0002>\u0001!\t!a\u0010\u0002\u000fI,7m\u001c<feR\u0019q'!\u0011\t\u000f\u0005\r\u00131\ba\u0001o\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007fAA\u001e}\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0003cA\u0005\u0002P%\u0019\u0011\u0011\u000b\u0006\u0003\rM#(/\u001b8h\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n!\u0002\u001e:v]\u000e\fG/\u001a+p)\r9\u0014\u0011\f\u0005\u0007i\u0006M\u0003\u0019A\u0018)\u0007\u0005Mc\u0010C\u0004\u0002`\u0001!\t!!\u0019\u0002\u00159,\u0007\u0010^(gMN,G\u000fF\u00010Q\u0011\ti&a\u0006\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005)a\r\\;tQR\tq\n\u000b\u0003\u0002f\u0005]\u0001bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u0013G\"\fgnZ3GS2,7+\u001e4gSb,7\u000fF\u0003P\u0003g\n\u0019\t\u0003\u0005\u0002v\u00055\u0004\u0019AA<\u0003%yG\u000eZ*vM\u001aL\u0007\u0010\u0005\u0003\u0002z\u0005}dbA\f\u0002|%\u0019\u0011Q\u0010\r\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t&!!\u000b\u0007\u0005u\u0004\u0004\u0003\u0005\u0002\u0006\u00065\u0004\u0019AA<\u0003%qWm^*vM\u001aL\u0007\u0010C\u0004\u0002\n\u0002!\t!!\u001b\u0002\u000b\rdwn]3\t\u000f\u00055\u0005\u0001\"\u0001\u0002j\u00051A-\u001a7fi\u0016Da!!%\u0001\t\u0003q\u0013\u0001\u00047bgRlu\u000eZ5gS\u0016$\u0007bBAK\u0001\u0011\u0005\u0011qS\u0001\u0011Y\u0006\u001cH/T8eS\u001aLW\rZ0%KF$B!!'\u0002 B\u0019q#a'\n\u0007\u0005u\u0005DA\u0004C_>dW-\u00198\t\u000f\u0005\u0005\u00161\u0013a\u0001_\u0005\u0011Qn\u001d\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003O\u000b\u0011\u0004\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0004o\u0005-6FAAW!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]\u0006$\u0001\u0006b]:|G/\u0019;j_:LA!a/\u00022\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u0005\u0001q\b")
public class LogSegment
implements Logging,
ScalaObject {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int translateOffset$default$2() {
        return 0;
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long l) {
        this.created = l;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, Time time) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset)), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, time);
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset$1, ByteBufferMessageSet messages$1) {
        if (messages$1.sizeInBytes() > 0) {
            this.trace((Function0<String>)new $anonfun$append$1(this, offset$1, messages$1));
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset$1, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages$1);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages$1.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public MessageSet read(long startOffset, Option<Object> maxOffset, int maxSize) {
        Option<Object> option;
        block9: {
            int n;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    if (maxSize == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    option = maxOffset;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    n = maxSize;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long l = BoxesRunTime.unboxToLong((Object)some.x());
                long offset = l;
                if (offset < startOffset) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToLong((long)startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = package$.MODULE$.min(endPosition - startPosition.position(), maxSize);
            }
            int length = n;
            return this.log().read(startPosition.position(), length);
        }
        throw new MatchError(option);
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long startOffset = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? entry2.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(entry2.message()).head()).offset();
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option option;
        block5: {
            long l;
            block3: {
                block4: {
                    MessageSet ms;
                    block2: {
                        ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes());
                        if (ms != null) break block2;
                        l = this.baseOffset();
                        break block3;
                    }
                    option = ms.lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                    l = this.baseOffset();
                    break block3;
                }
                if (!(option instanceof Some)) break block5;
                l = ((MessageAndOffset)((Some)option).x()).nextOffset();
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new $anonfun$flush$1(this));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
        }
        throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new $anonfun$close$1(this));
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new $anonfun$close$2(this));
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, long baseOffset, int indexIntervalBytes, Time time) {
        this.log = log;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }
}

