/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.locks.Condition;
import kafka.api.RequestOrResponse;
import kafka.api.StopReplicaResponse;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003)Q{\u0007/[2EK2,G/[8o\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u001e!\tqr$D\u0001\u0003\u0013\t\u0001#AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013\u0001G5oSRL\u0017\r\u001c+pa&\u001c7\u000fV8CK\u0012+G.\u001a;fIB\u0019AeJ\u0015\u000e\u0003\u0015R!A\n\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002)K\t\u00191+\u001a;\u0011\u0005)jcBA\f,\u0013\ta\u0003$\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u0019\u0011!\t\u0004A!A!\u0002\u0013\u0019\u0013AI5oSRL\u0017\r\u001c+pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eC\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0005kY:\u0004\b\u0005\u0002\u001f\u0001!)1A\ra\u0001;!9!E\rI\u0001\u0002\u0004\u0019\u0003bB\u00193!\u0003\u0005\ra\t\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u000b\u0002yA\u0011a$P\u0005\u0003}\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u0011\u001d\u0011\u0005A1A\u0005\u0002\r\u000bQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-F\u0001E!\tqR)\u0003\u0002G\u0005\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007B\u0002%\u0001A\u0003%A)\u0001\fqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000b1C]3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016,\u0012\u0001\u0014\t\u0003=5K!A\u0014\u0002\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\t\rA\u0003\u0001\u0015!\u0003M\u0003Q\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!9!\u000b\u0001a\u0001\n\u0003\u0019\u0016!\u0005;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fIV\tA\u000bE\u0002V1&j\u0011A\u0016\u0006\u0003/\u0016\nq!\\;uC\ndW-\u0003\u0002)-\"9!\f\u0001a\u0001\n\u0003Y\u0016!\u0006;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI~#S-\u001d\u000b\u00039~\u0003\"aF/\n\u0005yC\"\u0001B+oSRDq\u0001Y-\u0002\u0002\u0003\u0007A+A\u0002yIEBaA\u0019\u0001!B\u0013!\u0016A\u0005;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\u0002Bq\u0001\u001a\u0001A\u0002\u0013\u00051+A\u000eu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\bM\u0002\u0001\r\u0011\"\u0001h\u0003}!x\u000e]5dg&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]~#S-\u001d\u000b\u00039\"Dq\u0001Y3\u0002\u0002\u0003\u0007A\u000b\u0003\u0004k\u0001\u0001\u0006K\u0001V\u0001\u001di>\u0004\u0018nY:J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8!\u0011\u001da\u0007A1A\u0005\u00025\f\u0001\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\u000b1|7m[:\u000b\u0005M$\u0018AC2p]\u000e,(O]3oi*\u0011Q\u000fD\u0001\u0005kRLG.\u0003\u0002xa\nI1i\u001c8eSRLwN\u001c\u0005\u0007s\u0002\u0001\u000b\u0011\u00028\u0002#\u0011,G.\u001a;f)>\u0004\u0018nY:D_:$\u0007\u0005C\u0004|\u0001\u0001\u0007I\u0011\u0001?\u0002/\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$W#A?\u0011\u0005]q\u0018BA@\u0019\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0001\u0001\u0001\u0004%\t!!\u0002\u00027\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$w\fJ3r)\ra\u0016q\u0001\u0005\tA\u0006\u0005\u0011\u0011!a\u0001{\"9\u00111\u0002\u0001!B\u0013i\u0018\u0001\u00073fY\u0016$X\rV8qS\u000e\u001cF/\u0019;f\u0007\"\fgnZ3eA!I\u0011q\u0002\u0001A\u0002\u0013\u0005\u0011\u0011C\u0001\u0013I\u0016dW\r^3U_BL7m\u001d+ie\u0016\fG-\u0006\u0002\u0002\u0014A!\u0011QCA\f\u001b\u0005\u0001aACA\r\u0001\u0011\u0005\t\u0011!\u0001\u0002\u001c\t\u0011B)\u001a7fi\u0016$v\u000e]5dgRC'/Z1e'\u0015\t9\"!\b\u0017!\r\t\u0012qD\u0005\u0004\u0003C\u0011\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012DqaMA\f\t\u0003\t)\u0003\u0006\u0002\u0002\u0014!Q\u0011\u0011FA\f\u0005\u0004%\t!a\u000b\u0002\u0011i\\7\t\\5f]R,\"!!\f\u0011\t\u0005=\u0012QH\u0007\u0003\u0003cQA!a\r\u00026\u0005A!p[2mS\u0016tGO\u0003\u0003\u00028\u0005e\u0012AB%1\u0013R,7M\u0003\u0002\u0002<\u0005\u0019qN]4\n\t\u0005}\u0012\u0011\u0007\u0002\t5.\u001cE.[3oi\"I\u00111IA\fA\u0003%\u0011QF\u0001\nu.\u001cE.[3oi\u0002B\u0001\"a\u0012\u0002\u0018\u0011\u0005\u0013\u0011J\u0001\u0007I><vN]6\u0015\u0003qC\u0011\"!\u0014\u0001\u0001\u0004%\t!a\u0014\u0002-\u0011,G.\u001a;f)>\u0004\u0018nY:UQJ,\u0017\rZ0%KF$2\u0001XA)\u0011%\u0001\u00171JA\u0001\u0002\u0004\t\u0019\u0002\u0003\u0005\u0002V\u0001\u0001\u000b\u0015BA\n\u0003M!W\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193!\u0011\u001d\tI\u0006\u0001C\u0001\u0003\u0013\nQa\u001d;beRDq!!\u0018\u0001\t\u0003\tI%\u0001\u0005tQV$Hm\\<o\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n\u0001$\u001a8rk\u0016,X\rV8qS\u000e\u001chi\u001c:EK2,G/[8o)\ra\u0016Q\r\u0005\b\u0003O\ny\u00061\u0001$\u0003\u0019!x\u000e]5dg\"9\u00111\u000e\u0001\u0005\u0002\u00055\u0014a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\ra\u0016q\u000e\u0005\n\u0003O\nI\u0007%AA\u0002\rBq!a\u001d\u0001\t\u0003\t)(A\ngC&d'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002]\u0003oB\u0001\"!\u001f\u0002r\u0001\u0007\u00111P\u0001\te\u0016\u0004H.[2bgB!AeJA?!\rq\u0012qP\u0005\u0004\u0003\u0003\u0013!a\u0005)beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007bBAC\u0001\u0011\u0005\u0011qQ\u0001\u001f[\u0006\u00148\u000eV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$2\u0001XAE\u0011\u001d\t9'a!A\u0002\rBq!!$\u0001\t\u0003\ty)\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007u\f\t\nC\u0004\u0002\u0014\u0006-\u0005\u0019A\u0015\u0002\u000bQ|\u0007/[2\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006I\u0012n\u001d+pa&\u001cG)\u001a7fi&|g.\u00138Qe><'/Z:t)\ri\u00181\u0014\u0005\b\u0003'\u000b)\n1\u0001*\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000b!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$2!`AR\u0011\u001d\t\u0019*!(A\u0002%Bq!a*\u0001\t\u0013\tI%\u0001\u0010bo\u0006LG\u000fV8qS\u000e$U\r\\3uS>tgj\u001c;jM&\u001c\u0017\r^5p]\"9\u00111\u0016\u0001\u0005\n\u0005%\u0013!\u0007:fgVlW\rV8qS\u000e$U\r\\3uS>tG\u000b\u001b:fC\u0012Dq!a,\u0001\t\u0013\t\t,A\fd_6\u0004H.\u001a;f%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019A,a-\t\u0011\u0005e\u0014Q\u0016a\u0001\u0003wBq!a.\u0001\t\u0013\tI,\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002~\u0003wCq!a%\u00026\u0002\u0007\u0011\u0006C\u0004\u0002@\u0002!I!!1\u000235\f'o\u001b+pa&\u001cgi\u001c:EK2,G/[8o%\u0016$(/\u001f\u000b\u00049\u0006\r\u0007bBAJ\u0003{\u0003\r!\u000b\u0005\b\u0003\u000f\u0004A\u0011BAe\u0003M\u0019w.\u001c9mKR,G)\u001a7fi\u0016$v\u000e]5d)\ra\u00161\u001a\u0005\b\u0003'\u000b)\r1\u0001*\u0011\u001d\ty\r\u0001C\u0005\u0003#\fqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u00049\u0006M\u0007bBA4\u0003\u001b\u0004\ra\t\u0005\b\u0003/\u0004A\u0011BAm\u0003Q\u0019H/\u0019:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019A,a7\t\u0011\u0005u\u0017Q\u001ba\u0001\u0003w\nAD]3qY&\u001c\u0017m\u001d$peR{\u0007/[2t)>\u0014U\rR3mKR,G\rC\u0004\u0002b\u0002!I!a9\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0007q\u000b)\u000f\u0003\u0005\u0002h\u0006}\u0007\u0019AAu\u0003U\u0001\u0018M\u001d;ji&|gn\u001d+p\u0005\u0016$U\r\\3uK\u0012\u0004B\u0001J\u0014\u0002lB!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r\u0012\taaY8n[>t\u0017\u0002BA{\u0003_\u0014\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\tI\u0010\u0001C\u0005\u0003w\fa\u0004Z3mKR,Gk\u001c9jGN#x\u000e\u001d*fa2L7-Y\"bY2\u0014\u0017mY6\u0015\u000bq\u000biP!\u0004\t\u0011\u0005}\u0018q\u001fa\u0001\u0005\u0003\tac\u001d;paJ+\u0007\u000f\\5dCJ+7\u000f]8og\u0016|%M\u001b\t\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!q\u0001\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\f\t\u0015!!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\"A!qBA|\u0001\u0004\u0011\t\"A\u0005sKBd\u0017nY1JIB\u0019qCa\u0005\n\u0007\tU\u0001DA\u0002J]RD\u0011B!\u0007\u0001#\u0003%\tAa\u0007\u0002CI,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu!fA\u0012\u0003 -\u0012!\u0011\u0005\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0003,a\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yC!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0005\u00034\t\t\t\u0011#\u0002\u00036\u0005!Bk\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u00042A\bB\u001c\r%\t!\u0001bA\u0001\u0012\u000b\u0011Id\u0005\u0003\u00038!1\u0002bB\u001a\u00038\u0011\u0005!Q\b\u000b\u0003\u0005kA!B!\u0011\u00038E\u0005I\u0011\u0001B\u000e\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIIB!B!\u0012\u00038E\u0005I\u0011\u0001B\u000e\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIM\u0002")
public class TopicDeletionManager
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private scala.collection.mutable.Set<String> topicsToBeDeleted;
    private scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private boolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Set init$default$3() {
        return TopicDeletionManager$.MODULE$.init$default$3();
    }

    public static final Set init$default$2() {
        return TopicDeletionManager$.MODULE$.init$default$2();
    }

    public Set resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public void topicsToBeDeleted_$eq(scala.collection.mutable.Set<String> set) {
        this.topicsToBeDeleted = set;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public void topicsIneligibleForDeletion_$eq(scala.collection.mutable.Set<String> set) {
        this.topicsIneligibleForDeletion = set;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public boolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public void deleteTopicStateChanged_$eq(boolean bl) {
        this.deleteTopicStateChanged = bl;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread deleteTopicsThread) {
        this.deleteTopicsThread = deleteTopicsThread;
    }

    public void start() {
        this.deleteTopicsThread_$eq(new DeleteTopicsThread(this));
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsThread().start();
    }

    public void shutdown() {
        this.deleteTopicsThread().shutdown();
        this.topicsToBeDeleted().clear();
        this.topicsIneligibleForDeletion().clear();
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        this.topicsToBeDeleted().$plus$plus$eq(topics);
        this.resumeTopicDeletionThread();
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion = topics.$amp(this.topicsToBeDeleted());
        if (topicsToResumeDeletion.size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete$1 = (Set)replicas.filter((Function1)new $anonfun$1(this));
        if (replicasThatFailedToDelete$1.size() > 0) {
            Set topics$1 = (Set)replicasThatFailedToDelete$1.map((Function1)new $anonfun$2(this), Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new $anonfun$failReplicaDeletion$1(this, replicasThatFailedToDelete$1, topics$1));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)replicasThatFailedToDelete$1, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics$1);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        scala.collection.mutable.Set newTopicsToHaltDeletion$1 = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
        this.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion$1);
        if (newTopicsToHaltDeletion$1.size() > 0) {
            this.info((Function0<String>)new $anonfun$markTopicIneligibleForDeletion$1(this, newTopicsToHaltDeletion$1));
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return this.topicsIneligibleForDeletion().contains((Object)topic);
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic);
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic);
    }

    public final void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        while (true) {
            if (this.deleteTopicStateChanged()) {
                this.deleteTopicStateChanged_$eq(false);
                return;
            }
            this.info((Function0<String>)new $anonfun$kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification$1(this));
            this.deleteTopicsCond().await();
        }
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged_$eq(true);
        this.deleteTopicsCond().signal();
    }

    public final void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas$1 = (Set)replicas.filter((Function1)new $anonfun$3(this));
        this.debug((Function0<String>)new $anonfun$kafka$controller$TopicDeletionManager$$completeReplicaDeletion$1(this, successfullyDeletedReplicas$1));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges((Set<PartitionAndReplica>)successfullyDeletedReplicas$1, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public final boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains((Object)topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public final void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public final void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        this.controllerContext().zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicConfigPath(topic));
        this.controllerContext().zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public final void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics$2) {
        this.info((Function0<String>)new $anonfun$kafka$controller$TopicDeletionManager$$onTopicDeletion$1(this, topics$2));
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq());
        Map partitionReplicaAssignmentByTopic$1 = this.controllerContext().partitionReplicaAssignment().groupBy((Function1)new $anonfun$4(this));
        topics$2.foreach((Function1)new $anonfun$kafka$controller$TopicDeletionManager$$onTopicDeletion$2(this, partitionReplicaAssignmentByTopic$1));
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted$1) {
        replicasForTopicsToBeDeleted$1.groupBy((Function1)new $anonfun$startReplicaDeletion$1(this)).foreach((Function1)new $anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted$1));
    }

    public final void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted$1) {
        this.info((Function0<String>)new $anonfun$kafka$controller$TopicDeletionManager$$onPartitionDeletion$1(this, partitionsToBeDeleted$1));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted$1);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public final void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(RequestOrResponse stopReplicaResponseObj, int replicaId$1) {
        StopReplicaResponse stopReplicaResponse$1 = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)new $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$2(this, stopReplicaResponse$1));
        Set partitionsInError$1 = stopReplicaResponse$1.errorCode() != ErrorMapping$.MODULE$.NoError() ? stopReplicaResponse$1.responseMap().keySet() : ((TraversableOnce)((TraversableLike)stopReplicaResponse$1.responseMap().filter((Function1)new $anonfun$6(this))).map((Function1)new $anonfun$7(this), Iterable$.MODULE$.canBuildFrom())).toSet();
        Set replicasInError$1 = (Set)partitionsInError$1.map((Function1)new $anonfun$8(this, replicaId$1), Set$.MODULE$.canBuildFrom());
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1(this, replicaId$1, stopReplicaResponse$1, partitionsInError$1, replicasInError$1));
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.controllerContext().controllerLock().newCondition();
        this.deleteTopicStateChanged = false;
        this.deleteTopicsThread = null;
    }

    public class DeleteTopicsThread
    extends ShutdownableThread
    implements ScalaObject {
        private final ZkClient zkClient;
        public final TopicDeletionManager $outer;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void doWork() {
            Utils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new DeleteTopicsThread$$anonfun$doWork$1(this));
        }

        public TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return this.$outer;
        }

        public DeleteTopicsThread(TopicDeletionManager $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("delete-topics-thread", ShutdownableThread$.MODULE$.init$default$2());
            this.zkClient = $outer.controllerContext().zkClient();
        }
    }
}

