/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0011\u0005yyR\"\u0001\u0002\n\u0005\u0001\u0012!aD&bM.\f7i\u001c8ue>dG.\u001a:\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u001f\u0001!)1!\ta\u0001;!9q\u0005\u0001b\u0001\n\u0013A\u0013!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\t\u0011\u0006\u0005\u0002\u001fU%\u00111F\u0001\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\bBB\u0017\u0001A\u0003%\u0011&\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002cA\u0011qCM\u0005\u0003ga\u00111!\u00138u\u0011\u0019)\u0004\u0001)A\u0005c\u0005i1m\u001c8ue>dG.\u001a:JI\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003!Q8n\u00197jK:$(B\u0001 @\u0003\u0019I\u0005'\u0013;fG*\t\u0001)A\u0002pe\u001eL!AQ\u001e\u0003\u0011i[7\t\\5f]RDa\u0001\u0012\u0001!\u0002\u0013I\u0014!\u0003>l\u00072LWM\u001c;!\u0011\u001d1\u0005\u00011A\u0005\u0002\u001d\u000bAB]3qY&\u001c\u0017m\u0015;bi\u0016,\u0012\u0001\u0013\t\u0005\u0013:\u00036+D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055C\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0010R\u0013\t\u0011&AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\r\u0005\u0002\u001f)&\u0011QK\u0001\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\b/\u0002\u0001\r\u0011\"\u0001Y\u0003A\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011qCW\u0005\u00037b\u0011A!\u00168ji\"9QLVA\u0001\u0002\u0004A\u0015a\u0001=%c!1q\f\u0001Q!\n!\u000bQB]3qY&\u001c\u0017m\u0015;bi\u0016\u0004\u0003bB1\u0001\u0005\u0004%\tAY\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001d!\tqB-\u0003\u0002f\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007BB4\u0001A\u0003%1-A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u0015!\f7o\u0015;beR,G-F\u0001l!\ta7/D\u0001n\u0015\tqw.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003aF\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0011H\"\u0001\u0003vi&d\u0017B\u0001;n\u00055\tEo\\7jG\n{w\u000e\\3b]\"1a\u000f\u0001Q\u0001\n-\f1\u0002[1t'R\f'\u000f^3eA!9\u0001\u0010\u0001b\u0001\n\u0013I\u0018!E:uCR,7\t[1oO\u0016dunZ4feV\t!\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fQ\u0001\\8hi)T!a` \u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t\u0019\u0001 \u0002\u0007\u0019><w-\u001a:\t\u000f\u0005\u001d\u0001\u0001)A\u0005u\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tqa\u001d;beR,\b\u000fF\u0001Z\u0011\u001d\t\t\u0002\u0001C\u0001\u0003\u001b\t\u0011C]3hSN$XM\u001d'jgR,g.\u001a:t\u0011\u001d\t)\u0002\u0001C\u0001\u0003\u001b\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u00033\u0001A\u0011AA\u000e\u0003IA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:\u0015\u000fe\u000bi\"!\u000b\u0002.!A\u0011qDA\f\u0001\u0004\t\t#\u0001\u0005sKBd\u0017nY1t!\u0015\t\u0019#!\nQ\u001b\u0005a\u0015bAA\u0014\u0019\n\u00191+\u001a;\t\u000f\u0005-\u0012q\u0003a\u0001'\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0011)\ty#a\u0006\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\nG\u0006dGNY1dWN\u00042AHA\u001a\u0013\r\t)D\u0001\u0002\n\u0007\u0006dGNY1dWNDq!!\u000f\u0001\t\u0003\tY$A\tiC:$G.Z*uCR,7\t[1oO\u0016$r!WA\u001f\u0003\u0003\n\u0019\u0005C\u0004\u0002@\u0005]\u0002\u0019\u0001)\u0002'A\f'\u000f^5uS>t\u0017I\u001c3SKBd\u0017nY1\t\u000f\u0005-\u0012q\u0007a\u0001'\"A\u0011qFA\u001c\u0001\u0004\t\t\u0004C\u0004\u0002H\u0001!\t!!\u0013\u0002;\u0005\u0014X-\u00117m%\u0016\u0004H.[2bg\u001a{'\u000fV8qS\u000e$U\r\\3uK\u0012$B!a\u0013\u0002RA\u0019q#!\u0014\n\u0007\u0005=\u0003DA\u0004C_>dW-\u00198\t\u0011\u0005M\u0013Q\ta\u0001\u0003+\nQ\u0001^8qS\u000e\u0004B!a\u0016\u0002^9\u0019q#!\u0017\n\u0007\u0005m\u0003$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tG\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037B\u0002bBA3\u0001\u0011\u0005\u0011qM\u0001*SN\fE\u000fT3bgR|e.\u001a*fa2L7-Y%o\t\u0016dW\r^5p]N#\u0018M\u001d;fIN#\u0018\r^3\u0015\t\u0005-\u0013\u0011\u000e\u0005\t\u0003'\n\u0019\u00071\u0001\u0002V!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014a\u0004:fa2L7-Y:J]N#\u0018\r^3\u0015\r\u0005\u0005\u0012\u0011OA:\u0011!\t\u0019&a\u001bA\u0002\u0005U\u0003bBA;\u0003W\u0002\raU\u0001\u0006gR\fG/\u001a\u0005\b\u0003s\u0002A\u0011AA>\u0003a\u0011X\r\u001d7jG\u0006\u001c\u0018J\u001c#fY\u0016$\u0018n\u001c8Ti\u0006$Xm\u001d\u000b\u0005\u0003C\ti\b\u0003\u0005\u0002T\u0005]\u0004\u0019AA+\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007\u000b\u0011$Y:tKJ$h+\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fgR9\u0011,!\"\u0002\b\u0006E\u0005bBA \u0003\u007f\u0002\r\u0001\u0015\u0005\t\u0003\u0013\u000by\b1\u0001\u0002\f\u0006QaM]8n'R\fG/Z:\u0011\u000b\u0005\r\u0012QR*\n\u0007\u0005=EJA\u0002TKFDq!a\u000b\u0002\u0000\u0001\u00071\u000bC\u0004\u0002\u0016\u0002!I!a&\u00029I,w-[:uKJ\u0014%o\\6fe\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR\u0011\u0011\u0011\u0014\t\u0007\u00037\u000bi*!)\u000e\u0003EL1!a(r\u0005\u0011a\u0015n\u001d;\u0011\u0007%\t\u0019+C\u0002\u0002`)Aq!a*\u0001\t\u0013\ti!\u0001\fj]&$\u0018.\u00197ju\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f\u0011\u001d\tY\u000b\u0001C\u0001\u0003[\u000b!\u0004]1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR{'I]8lKJ$b!a,\u0002>\u0006\r\u0007CBA\u0012\u0003\u001b\u000b\t\f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9\fB\u0001\u0007G>lWn\u001c8\n\t\u0005m\u0016Q\u0017\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0002CA`\u0003S\u0003\r!!1\u0002\rQ|\u0007/[2t!\u0019\t\u0019#!$\u0002V!9\u0011QYAU\u0001\u0004\t\u0014\u0001\u00032s_.,'/\u00133\u0007\u0015\u0005%\u0007\u0001\"A\u0001\u0002\u0003\tYM\u0001\u000bCe>\\WM]\"iC:<W\rT5ti\u0016tWM]\n\b\u0003\u000fD\u0011Q\u001a\t\u0017!\rQ\u0014qZ\u0005\u0004\u0003#\\$\u0001E%[W\u000eC\u0017\u000e\u001c3MSN$XM\\3s\u0011\u001d\u0011\u0013q\u0019C\u0001\u0003+$\"!a6\u0011\t\u0005e\u0017qY\u0007\u0002\u0001!A\u0011Q\\Ad\t\u0003\ty.A\tiC:$G.Z\"iS2$7\t[1oO\u0016$R!WAq\u0003KD\u0001\"a9\u0002\\\u0002\u0007\u0011QK\u0001\u000ba\u0006\u0014XM\u001c;QCRD\u0007\u0002CAt\u00037\u0004\r!!;\u0002#\r,(O]3oi\n\u0013xn[3s\u0019&\u001cH\u000f\u0005\u0004\u0002\u001c\u0006u\u0015Q\u000b\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003_\fA\u0004[1oI2,7\u000b^1uK\u000eC\u0017M\\4fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r*\"\u0011\u0011GAzW\t\t)\u0010\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00001\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicaStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas$1, ReplicaState targetState$1, Callbacks callbacks$1) {
        if (replicas$1.size() > 0) {
            this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, replicas$1, targetState$1));
            try {
                this.brokerRequestBatch().newBatch();
                replicas$1.foreach((Function1)new $anonfun$handleStateChanges$2(this, targetState$1, callbacks$1));
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, targetState$1), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block14: {
            TopicAndPartition topicAndPartition;
            int replicaId$1;
            block15: {
                String topic = partitionAndReplica.topic();
                int partition = partitionAndReplica.partition();
                replicaId$1 = partitionAndReplica.replica();
                topicAndPartition = new TopicAndPartition(topic, partition);
                if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) break block15;
                ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new $anonfun$1(this));
                try {
                    ReplicaState replicaState;
                    block25: {
                        Option option;
                        block30: {
                            boolean leaderAndIsrIsEmpty;
                            block28: {
                                boolean bl;
                                block26: {
                                    Option<LeaderIsrAndControllerEpoch> option2;
                                    block29: {
                                        block27: {
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                                            Seq replicaAssignment;
                                            block20: {
                                                Option option3;
                                                block24: {
                                                    block22: {
                                                        block23: {
                                                            block21: {
                                                                block16: {
                                                                    Option<LeaderIsrAndControllerEpoch> option4;
                                                                    block19: {
                                                                        block18: {
                                                                            block17: {
                                                                                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt;
                                                                                replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                                replicaState = targetState;
                                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                                ReplicaState replicaState2 = replicaState;
                                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState2) : replicaState2 != null) break block16;
                                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), targetState);
                                                                                option4 = leaderIsrAndControllerEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), topic, partition);
                                                                                if (!(option4 instanceof Some)) break block17;
                                                                                Some some = (Some)option4;
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)some.x();
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch3 = leaderIsrAndControllerEpoch2;
                                                                                if (leaderIsrAndControllerEpoch3.leaderAndIsr().leader() == replicaId$1) {
                                                                                    throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                                                                                }
                                                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, leaderIsrAndControllerEpoch3, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                                break block18;
                                                                            }
                                                                            None$ none$ = None$.MODULE$;
                                                                            Option<LeaderIsrAndControllerEpoch> option5 = option4;
                                                                            if (none$ != null ? !none$.equals(option5) : option5 != null) break block19;
                                                                        }
                                                                        this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                        break block14;
                                                                    }
                                                                    throw new MatchError(option4);
                                                                }
                                                                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                                                                ReplicaState replicaState3 = replicaState;
                                                                if (!(replicaDeletionStarted$ != null ? !replicaDeletionStarted$.equals(replicaState3) : replicaState3 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionIneligible$ replicaDeletionIneligible$ = ReplicaDeletionIneligible$.MODULE$;
                                                                ReplicaState replicaState4 = replicaState;
                                                                if (!(replicaDeletionIneligible$ != null ? !replicaDeletionIneligible$.equals(replicaState4) : replicaState4 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                                                                ReplicaState replicaState5 = replicaState;
                                                                if (!(replicaDeletionSuccessful$ != null ? !replicaDeletionSuccessful$.equals(replicaState5) : replicaState5 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                                                                ReplicaState replicaState6 = replicaState;
                                                                if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState6) : replicaState6 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionSuccessful$[]{ReplicaDeletionSuccessful$.MODULE$})), targetState);
                                                                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                    this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)new $anonfun$handleStateChange$1(this, replicaId$1)));
                                                                    this.replicaState().remove((Object)partitionAndReplica);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                                                                ReplicaState replicaState7 = replicaState;
                                                                if (onlineReplica$ != null ? !onlineReplica$.equals(replicaState7) : replicaState7 != null) break block20;
                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                                                ReplicaState replicaState8 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                ReplicaState replicaState9 = replicaState8;
                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState9) : replicaState9 != null) break block21;
                                                                Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId$1), Seq$.MODULE$.canBuildFrom()));
                                                                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                break block22;
                                                            }
                                                            option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                            if (!(option3 instanceof Some)) break block23;
                                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, (LeaderIsrAndControllerEpoch)((Some)option3).x(), (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                            break block22;
                                                        }
                                                        None$ none$ = None$.MODULE$;
                                                        Option option6 = option3;
                                                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block24;
                                                    }
                                                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                    break block14;
                                                }
                                                throw new MatchError((Object)option3);
                                            }
                                            OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                                            ReplicaState replicaState10 = replicaState;
                                            if (offlineReplica$ != null ? !offlineReplica$.equals(replicaState10) : replicaState10 != null) break block25;
                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, false, (Function2<RequestOrResponse, Object, BoxedUnit>)this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                            option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                            if (!(option instanceof Some)) break block26;
                                            option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic, partition, replicaId$1);
                                            if (!(option2 instanceof Some)) break block27;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{updatedLeaderIsrAndControllerEpoch.leaderAndIsr().leader()})), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                            bl = false;
                                            break block28;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<LeaderIsrAndControllerEpoch> option7 = option2;
                                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block29;
                                        bl = true;
                                        break block28;
                                    }
                                    throw new MatchError(option2);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option8 = option;
                                if (none$ != null ? !none$.equals(option8) : option8 != null) break block30;
                                bl = leaderAndIsrIsEmpty = true;
                            }
                            if (leaderAndIsrIsEmpty) {
                                throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition})));
                            }
                            break block14;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)replicaState);
                }
                catch (Throwable throwable) {
                    this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topic, BoxesRunTime.boxToInteger((int)partition), currState, targetState})), throwable);
                }
            }
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, targetState})));
        }
    }

    public boolean areAllReplicasForTopicDeleted(String topic$1) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic$1);
        scala.collection.immutable.Map replicaStatesForTopic$1 = ((TraversableOnce)replicasForTopic2.map((Function1)new $anonfun$2(this), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.debug((Function0<String>)new $anonfun$areAllReplicasForTopicDeleted$1(this, topic$1, replicaStatesForTopic$1));
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new $anonfun$areAllReplicasForTopicDeleted$2(this)));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new $anonfun$3(this), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new $anonfun$isAtLeastOneReplicaInDeletionStartedState$1(this)));
    }

    public Set<PartitionAndReplica> replicasInState(String topic$2, ReplicaState state$1) {
        return ((MapLike)this.replicaState().filter((Function1)new $anonfun$replicasInState$1(this, topic$2, state$1))).keySet();
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic$3) {
        Set deletionStates$1 = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1)new $anonfun$replicasInDeletionStates$1(this, topic$3, deletionStates$1))).keySet();
    }

    private void assertValidPreviousStates(PartitionAndReplica partitionAndReplica$1, Seq<ReplicaState> fromStates$1, ReplicaState targetState$2) {
        Predef$.MODULE$.assert(fromStates$1.contains(this.replicaState().apply((Object)partitionAndReplica$1)), (Function0)new $anonfun$assertValidPreviousStates$1(this, partitionAndReplica$1, fromStates$1, targetState$2));
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener(this));
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().foreach((Function1)new $anonfun$initializeReplicaState$1(this));
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId$1) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new $anonfun$partitionsAssignedToBroker$1(this, brokerId$1))).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        public final ReplicaStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleChildChange(String parentPath$1, List<String> currentBrokerList$1) {
            this.info((Function0<String>)new BrokerChangeListener$$anonfun$handleChildChange$2(this, parentPath$1, currentBrokerList$1));
            Utils$.MODULE$.inLock(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock(), new BrokerChangeListener$$anonfun$handleChildChange$1(this, currentBrokerList$1));
        }

        public ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return this.$outer;
        }

        public BrokerChangeListener(ReplicaStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

