/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.controller.PartitionStateMachine$AddPartitionsListener$;
import kafka.controller.PartitionStateMachine$DeleteTopicsListener$;
import kafka.controller.PartitionStateMachine$TopicChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003+A\u000b'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oK*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005;A\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005y\u0001\u0001\"B\u0002\"\u0001\u0004i\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\u0015\u0011\u0005yQ\u0013BA\u0016\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\b_\u0001\u0011\r\u0011\"\u00031\u00031\u0019wN\u001c;s_2dWM]%e+\u0005\t\u0004CA\f3\u0013\t\u0019\u0004DA\u0002J]RDa!\u000e\u0001!\u0002\u0013\t\u0014!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\u0011i\\7\t\\5f]R,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0001B_6dY&,g\u000e\u001e\u0006\u0003}}\na!\u0013\u0019Ji\u0016\u001c'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cw\tA!l[\"mS\u0016tG\u000f\u0003\u0004E\u0001\u0001\u0006I!O\u0001\nu.\u001cE.[3oi\u0002BqA\u0012\u0001A\u0002\u0013\u0005q)\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0016\u0003!\u0003B!\u0013(Q-6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u00131!T1q!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0004d_6lwN\\\u0005\u0003+J\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\tqr+\u0003\u0002Y\u0005\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007b\u0002.\u0001\u0001\u0004%\taW\u0001\u0013a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002]?B\u0011q#X\u0005\u0003=b\u0011A!\u00168ji\"9\u0001-WA\u0001\u0002\u0004A\u0015a\u0001=%c!1!\r\u0001Q!\n!\u000bq\u0002]1si&$\u0018n\u001c8Ti\u0006$X\r\t\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0003I\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0016\u0003\u0019\u0004\"AH4\n\u0005!\u0014!\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0005\u0007U\u0002\u0001\u000b\u0011\u00024\u0002'\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0011\t\u000f1\u0004!\u0019!C\u0005[\u0006Q\u0001.Y:Ti\u0006\u0014H/\u001a3\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\r\u0005$x.\\5d\u0015\t\u0019H/\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001e\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003oB\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB=\u0001A\u0003%a.A\u0006iCN\u001cF/\u0019:uK\u0012\u0004\u0003bB>\u0001\u0005\u0004%I\u0001`\u0001\u001c]>|\u0005\u000fU1si&$\u0018n\u001c8MK\u0006$WM]*fY\u0016\u001cGo\u001c:\u0016\u0003u\u0004\"A\b@\n\u0005}\u0014!A\u0005(p\u001fBdU-\u00193feN+G.Z2u_JDq!a\u0001\u0001A\u0003%Q0\u0001\u000fo_>\u0003\b+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0011!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0015awn\u001a\u001bk\u0015\r\t)bP\u0001\u0007CB\f7\r[3\n\t\u0005e\u0011q\u0002\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u0017\t!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA!I\u0011\u0011\u0005\u0001A\u0002\u0013%\u00111E\u0001\u0014i>\u0004\u0018nY\"iC:<W\rT5ti\u0016tWM]\u000b\u0003\u0003K\u0001B!a\n\u0002*5\t\u0001A\u0002\u0006\u0002,\u0001!\t\u0011!A\u0001\u0003[\u00111\u0003V8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001cr!!\u000b\t\u0003_\u0001b\u0003E\u0002;\u0003cI1!a\r<\u0005AI%l[\"iS2$G*[:uK:,'\u000fC\u0004#\u0003S!\t!a\u000e\u0015\u0005\u0005\u0015\u0002\u0002CA\u001e\u0003S!\t!!\u0010\u0002#!\fg\u000e\u001a7f\u0007\"LG\u000eZ\"iC:<W\rF\u0003]\u0003\u007f\t\t\u0006\u0003\u0005\u0002B\u0005e\u0002\u0019AA\"\u0003)\u0001\u0018M]3oiB\u000bG\u000f\u001b\t\u0005\u0003\u000b\nYED\u0002\u0018\u0003\u000fJ1!!\u0013\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011QJA(\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\n\r\t\u0011\u0005M\u0013\u0011\ba\u0001\u0003+\n\u0001b\u00195jY\u0012\u0014XM\u001c\t\u0007\u0003/\nI&a\u0011\u000e\u0003QL1!a\u0017u\u0005\u0011a\u0015n\u001d;)\r\u0005e\u0012qLA3!\r9\u0012\u0011M\u0005\u0004\u0003GB\"A\u0002;ie><8o\t\u0002\u0002hA!\u0011\u0011NA=\u001d\u0011\tY'!\u001e\u000f\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d\u0007\u0003\u0019a$o\\8u}%\t\u0011$C\u0002\u0002xa\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002|\u0005u$!C#yG\u0016\u0004H/[8o\u0015\r\t9\b\u0007\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007\u000bq\u0003^8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ|F%Z9\u0015\u0007q\u000b)\tC\u0005a\u0003\u007f\n\t\u00111\u0001\u0002&!A\u0011\u0011\u0012\u0001!B\u0013\t)#\u0001\u000bu_BL7m\u00115b]\u001e,G*[:uK:,'\u000f\t\u0005\n\u0003\u001b\u0003\u0001\u0019!C\u0005\u0003\u001f\u000bA\u0003Z3mKR,Gk\u001c9jGNd\u0015n\u001d;f]\u0016\u0014XCAAI!\u0011\t9#a%\u0007\u0015\u0005U\u0005\u0001\"A\u0001\u0002\u0003\t9J\u0001\u000bEK2,G/\u001a+pa&\u001c7\u000fT5ti\u0016tWM]\n\b\u0003'C\u0011q\u0006\t\u0017\u0011\u001d\u0011\u00131\u0013C\u0001\u00037#\"!!%\t\u0011]\n\u0019J1A\u0005\u0002aBq\u0001RAJA\u0003%\u0011\b\u0003\u0005\u0002<\u0005ME\u0011AAR)\u0015a\u0016QUAT\u0011!\t\t%!)A\u0002\u0005\r\u0003\u0002CA*\u0003C\u0003\r!!\u0016)\r\u0005\u0005\u0016qLA3\u0011!\ti+a%\u0005\u0002\u0005=\u0016!\u00055b]\u0012dW\rR1uC\u0012+G.\u001a;fIR\u0019A,!-\t\u0011\u0005M\u00161\u0016a\u0001\u0003\u0007\n\u0001\u0002Z1uCB\u000bG\u000f\u001b\u0015\u0007\u0003W\u000by&!\u001a\t\u0013\u0005e\u0006\u00011A\u0005\n\u0005m\u0016\u0001\u00073fY\u0016$X\rV8qS\u000e\u001cH*[:uK:,'o\u0018\u0013fcR\u0019A,!0\t\u0013\u0001\f9,!AA\u0002\u0005E\u0005\u0002CAa\u0001\u0001\u0006K!!%\u0002+\u0011,G.\u001a;f)>\u0004\u0018nY:MSN$XM\\3sA!I\u0011Q\u0019\u0001A\u0002\u0013%\u0011qY\u0001\u0016C\u0012$\u0007+\u0019:uSRLwN\\:MSN$XM\\3s+\t\tI\r\u0005\u0004J\u001d\u0006\r\u00131\u001a\t\u0005\u0003O\tiM\u0002\u0006\u0002P\u0002!\t\u0011!A\u0001\u0003#\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH*[:uK:,'oE\u0004\u0002N\"\t\u0019\u000e\u0005\f\u0011\u0007i\n).C\u0002\u0002Xn\u0012q\"\u0013.l\t\u0006$\u0018\rT5ti\u0016tWM\u001d\u0005\f\u00037\fiM!A!\u0002\u0013\t\u0019%A\u0003u_BL7\rC\u0004#\u0003\u001b$\t!a8\u0015\t\u0005-\u0017\u0011\u001d\u0005\t\u00037\fi\u000e1\u0001\u0002D!A\u0011Q]Ag\t\u0003\t9/\u0001\tiC:$G.\u001a#bi\u0006\u001c\u0005.\u00198hKR)A,!;\u0002l\"A\u00111WAr\u0001\u0004\t\u0019\u0005C\u0004\u0002n\u0006\r\b\u0019\u0001\u0005\u0002\t\u0011\fG/\u0019\u0015\u0007\u0003G\fy&!\u001a\t\u0011\u00055\u0016Q\u001aC\u0001\u0003g$2\u0001XA{\u0011!\t\t%!=A\u0002\u0005\r\u0003FBAy\u0003?\n)\u0007C\u0005\u0002|\u0002\u0001\r\u0011\"\u0003\u0002~\u0006I\u0012\r\u001a3QCJ$\u0018\u000e^5p]Nd\u0015n\u001d;f]\u0016\u0014x\fJ3r)\ra\u0016q \u0005\nA\u0006e\u0018\u0011!a\u0001\u0003\u0013D\u0001Ba\u0001\u0001A\u0003&\u0011\u0011Z\u0001\u0017C\u0012$\u0007+\u0019:uSRLwN\\:MSN$XM\\3sA!9!q\u0001\u0001\u0005\u0002\t%\u0011aB:uCJ$X\u000f\u001d\u000b\u00029\"9!Q\u0002\u0001\u0005\u0002\t%\u0011!\u0005:fO&\u001cH/\u001a:MSN$XM\\3sg\"9!\u0011\u0003\u0001\u0005\u0002\t%\u0011\u0001C:ikR$wn\u001e8\t\u000f\tU\u0001\u0001\"\u0001\u0003\n\u0005\tCO]5hO\u0016\u0014xJ\u001c7j]\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\u0005.\u00198hK\"9!\u0011\u0004\u0001\u0005\u0002\tm\u0011!\u00059beRLG/[8og&s7\u000b^1uKR!!Q\u0004B\u0013!\u0015\u0011yB!\tQ\u001b\u0005a\u0015b\u0001B\u0012\u0019\n\u00191+\u001a;\t\u000f\t\u001d\"q\u0003a\u0001-\u0006)1\u000f^1uK\"9!1\u0006\u0001\u0005\u0002\t5\u0012A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$\u0012\u0002\u0018B\u0018\u0005g\u00119D!\u0011\t\u0011\tE\"\u0011\u0006a\u0001\u0005;\t!\u0002]1si&$\u0018n\u001c8t\u0011\u001d\u0011)D!\u000bA\u0002Y\u000b1\u0002^1sO\u0016$8\u000b^1uK\"Q!\u0011\bB\u0015!\u0003\u0005\rAa\u000f\u0002\u001d1,\u0017\rZ3s'\u0016dWm\u0019;peB\u0019aD!\u0010\n\u0007\t}\"AA\fQCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;pe\"Q!1\tB\u0015!\u0003\u0005\rA!\u0012\u0002\u0013\r\fG\u000e\u001c2bG.\u001c\bc\u0001\u0010\u0003H%\u0019!\u0011\n\u0002\u0003\u0013\r\u000bG\u000e\u001c2bG.\u001c\bb\u0002B'\u0001\u0011%!qJ\u0001\u0012Q\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,Gc\u0003/\u0003R\tM#q\u000bB-\u00057B\u0001\"a7\u0003L\u0001\u0007\u00111\t\u0005\b\u0005+\u0012Y\u00051\u00012\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u00036\t-\u0003\u0019\u0001,\t\u0011\te\"1\na\u0001\u0005wA\u0001Ba\u0011\u0003L\u0001\u0007!Q\t\u0005\b\u0005?\u0002A\u0011\u0002B\u0005\u0003aIg.\u001b;jC2L'0\u001a)beRLG/[8o'R\fG/\u001a\u0005\b\u0005G\u0002A\u0011\u0002B3\u0003e\t7o]3siZ\u000bG.\u001b3Qe\u00164\u0018n\\;t'R\fG/Z:\u0015\u000fq\u00139Ga\u001b\u0003v!9!\u0011\u000eB1\u0001\u0004\u0001\u0016!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A!Q\u000eB1\u0001\u0004\u0011y'\u0001\u0006ge>l7\u000b^1uKN\u0004RAa\b\u0003rYK1Aa\u001dM\u0005\r\u0019V-\u001d\u0005\b\u0005k\u0011\t\u00071\u0001W\u0011\u001d\u0011I\b\u0001C\u0005\u0005w\n!$Y:tS\u001et'+\u001a9mS\u000e\f7\u000fV8QCJ$\u0018\u000e^5p]N$R\u0001\u0018B?\u0005\u007fB\u0001\"a7\u0003x\u0001\u0007\u00111\t\u0005\b\u0005+\u00129\b1\u00012\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000b\u000b!%\u001b8ji&\fG.\u001b>f\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d$peB\u000b'\u000f^5uS>tGc\u0001/\u0003\b\"9!\u0011\u000eBA\u0001\u0004\u0001\u0006b\u0002BF\u0001\u0011\u0005!QR\u0001\u0018K2,7\r\u001e'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:$r\u0001\u0018BH\u0005#\u0013\u0019\n\u0003\u0005\u0002\\\n%\u0005\u0019AA\"\u0011\u001d\u0011)F!#A\u0002EB\u0001B!\u000f\u0003\n\u0002\u0007!1\b\u0005\b\u0005/\u0003A\u0011\u0002BM\u0003m\u0011XmZ5ti\u0016\u0014Hk\u001c9jG\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feR\u0011!1\u0014\t\u0007\u0003/\nIF!(\u0011\u0007%\u0011y*C\u0002\u0002N)AqAa)\u0001\t\u0003\u0011)+A\u0010sK\u001eL7\u000f^3s!\u0006\u0014H/\u001b;j_:\u001c\u0005.\u00198hK2K7\u000f^3oKJ$2\u0001\u0018BT\u0011!\tYN!)A\u0002\u0005\r\u0003b\u0002BV\u0001\u0011\u0005!QV\u0001\"I\u0016\u0014XmZ5ti\u0016\u0014\b+\u0019:uSRLwN\\\"iC:<W\rT5ti\u0016tWM\u001d\u000b\u00049\n=\u0006\u0002CAn\u0005S\u0003\r!a\u0011\t\u000f\tM\u0006\u0001\"\u0003\u0003\u001a\u0006Y\"/Z4jgR,'\u000fR3mKR,Gk\u001c9jG2K7\u000f^3oKJDqAa.\u0001\t\u0013\u0011I,\u0001\u0013hKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r[(s)\"\u0014xn^#yG\u0016\u0004H/[8o)\u0019\u0011YL!1\u0003DB\u0019aD!0\n\u0007\t}&AA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\t\u00037\u0014)\f1\u0001\u0002D!9!Q\u000bB[\u0001\u0004\t\u0004\"\u0003Bd\u0001E\u0005I\u0011\u0001Be\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"Aa3+\t\tm\"QZ\u0016\u0003\u0005\u001f\u0004BA!5\u0003\\6\u0011!1\u001b\u0006\u0005\u0005+\u00149.A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u001c\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\nM'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u001d\u0001\u0012\u0002\u0013\u0005!1]\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)O\u000b\u0003\u0003F\t5\u0007")
public class PartitionStateMachine
implements Logging,
ScalaObject {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final Logger stateChangeLogger;
    private TopicChangeListener topicChangeListener;
    private DeleteTopicsListener deleteTopicsListener;
    private Map<String, AddPartitionsListener> addPartitionsListener;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public Callbacks handleStateChanges$default$4() {
        return new Callbacks.CallbackBuilder().build();
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> map) {
        this.partitionState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private TopicChangeListener topicChangeListener() {
        return this.topicChangeListener;
    }

    private void topicChangeListener_$eq(TopicChangeListener topicChangeListener) {
        this.topicChangeListener = topicChangeListener;
    }

    private DeleteTopicsListener deleteTopicsListener() {
        return this.deleteTopicsListener;
    }

    private void deleteTopicsListener_$eq(DeleteTopicsListener deleteTopicsListener) {
        this.deleteTopicsListener = deleteTopicsListener;
    }

    private Map<String, AddPartitionsListener> addPartitionsListener() {
        return this.addPartitionsListener;
    }

    private void addPartitionsListener_$eq(Map<String, AddPartitionsListener> map) {
        this.addPartitionsListener = map;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new $anonfun$startup$1(this));
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
        this.registerDeleteTopicListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            this.partitionState().withFilter((Function1)new $anonfun$triggerOnlinePartitionStateChange$1(this)).foreach((Function1)new $anonfun$triggerOnlinePartitionStateChange$2(this));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$triggerOnlinePartitionStateChange$3(this), (Function0<Throwable>)new $anonfun$triggerOnlinePartitionStateChange$4(this, throwable));
        }
    }

    public Set<TopicAndPartition> partitionsInState(PartitionState state$1) {
        return ((MapLike)this.partitionState().filter((Function1)new $anonfun$partitionsInState$1(this, state$1))).keySet();
    }

    public void handleStateChanges(Set<TopicAndPartition> partitions$1, PartitionState targetState$1, PartitionLeaderSelector leaderSelector$1, Callbacks callbacks$1) {
        this.info((Function0<String>)new $anonfun$handleStateChanges$1(this, partitions$1, targetState$1));
        try {
            this.brokerRequestBatch().newBatch();
            partitions$1.foreach((Function1)new $anonfun$handleStateChanges$2(this, targetState$1, leaderSelector$1, callbacks$1));
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$handleStateChanges$3(this, targetState$1), (Function0<Throwable>)new $anonfun$handleStateChanges$4(this, throwable));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void kafka$controller$PartitionStateMachine$$handleStateChange(String topic, int partition, PartitionState targetState, PartitionLeaderSelector leaderSelector, Callbacks callbacks) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, targetState})));
        PartitionState currState = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new $anonfun$2(this));
        try {
            PartitionState partitionState = targetState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState2 = partitionState;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState2) : partitionState2 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(topic, partition);
                this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String assignedReplicas = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s with assigned replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, assignedReplicas})));
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState3 = partitionState;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState3) : partitionState3 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState4 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState5 = partitionState4;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState5) : partitionState5 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState6 = partitionState4;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState6) : partitionState6 != null)) {
                            this.electLeaderForPartition(topic, partition, leaderSelector);
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState7 = partitionState4;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState7) : partitionState7 != null)) {
                                this.electLeaderForPartition(topic, partition, leaderSelector);
                            }
                        }
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int leader = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to %s with leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState, BoxesRunTime.boxToInteger((int)leader)})));
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState8 = partitionState;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                        this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState9 = partitionState;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState9) : partitionState9 != null) throw new MatchError((Object)partitionState);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})));
                        this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, currState, targetState})), throwable);
        }
    }

    private void initializePartitionState() {
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().foreach((Function1)new $anonfun$initializePartitionState$1(this));
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> fromStates, PartitionState targetState) {
        if (fromStates.contains(this.partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, fromStates.mkString(","), targetState}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String topic, int partition) {
        Seq<Object> assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), topic, partition);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(topic, partition)).$minus$greater(assignedReplicas));
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition$1) {
        Seq replicaAssignment = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$1);
        Seq liveAssignedReplicas$1 = (Seq)replicaAssignment.filter((Function1)new $anonfun$1(this));
        int n = liveAssignedReplicas$1.size();
        if (n == 0) {
            String failMsg = Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$1, replicaAssignment.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
            throw new StateChangeFailedException(failMsg);
        }
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$1(this, topicAndPartition$1, liveAssignedReplicas$1));
        int leader = BoxesRunTime.unboxToInt((Object)liveAssignedReplicas$1.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1 = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, (List<Object>)liveAssignedReplicas$1.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new $anonfun$initializeLeaderAndIsrForPartition$2(this, topicAndPartition$1, leaderIsrAndControllerEpoch$1));
        try {
            ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition$1.topic(), topicAndPartition$1.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch$1.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition$1, (Object)leaderIsrAndControllerEpoch$1);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)liveAssignedReplicas$1, topicAndPartition$1.topic(), topicAndPartition$1.partition(), leaderIsrAndControllerEpoch$1, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition$1.topic(), topicAndPartition$1.partition()).get();
            String failMsg = Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$1, leaderIsrAndEpoch.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndEpoch.controllerEpoch())}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
            throw new StateChangeFailedException(failMsg);
        }
    }

    public void electLeaderForPartition(String topic, int partition, PartitionLeaderSelector leaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            boolean zookeeperPathUpdateSucceeded = false;
            LeaderAndIsr newLeaderAndIsr = null;
            Seq replicasForThisPartition = (Seq)Seq$.MODULE$.empty();
            while (true) {
                if (zookeeperPathUpdateSucceeded) {
                    LeaderIsrAndControllerEpoch newLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(newLeaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
                    this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(topic, partition), (Object)newLeaderIsrAndControllerEpoch);
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)newLeaderAndIsr.leader()), topicAndPartition})));
                    Seq replicas = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(topic, partition));
                    this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)replicasForThisPartition, topic, partition, newLeaderIsrAndControllerEpoch, (Seq<Object>)replicas, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                    break;
                }
                LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = this.getLeaderIsrAndEpochOrThrowException(topic, partition);
                LeaderAndIsr currentLeaderAndIsr = currentLeaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = currentLeaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                    String failMsg = Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)controllerEpoch)}));
                    this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
                    throw new StateChangeFailedException(failMsg);
                }
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2 = leaderSelector.selectLeader(topicAndPartition, currentLeaderAndIsr);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple22._1();
                Seq replicas = (Seq)tuple22._2();
                Tuple2<Object, Object> tuple23 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch()), currentLeaderAndIsr.zkVersion());
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple24._1());
                int newVersion = tuple24._2$mcI$sp();
                newLeaderAndIsr = leaderAndIsr;
                newLeaderAndIsr.zkVersion_$eq(newVersion);
                zookeeperPathUpdateSucceeded = updateSucceeded;
                replicasForThisPartition = replicas;
            }
        }
        catch (Throwable throwable) {
            String failMsg = Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)failMsg).toString());
            throw new StateChangeFailedException(failMsg, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new $anonfun$electLeaderForPartition$1(this));
    }

    private java.util.List<String> registerTopicChangeListener() {
        this.topicChangeListener_$eq(new TopicChangeListener(this));
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)this.topicChangeListener());
    }

    public void registerPartitionChangeListener(String topic) {
        this.addPartitionsListener().put((Object)topic, (Object)new AddPartitionsListener(this, topic));
        this.kafka$controller$PartitionStateMachine$$zkClient().subscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    public void deregisterPartitionChangeListener(String topic) {
        this.kafka$controller$PartitionStateMachine$$zkClient().unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPath(topic), (IZkDataListener)this.addPartitionsListener().apply((Object)topic));
    }

    private java.util.List<String> registerDeleteTopicListener() {
        this.deleteTopicsListener_$eq(new DeleteTopicsListener(this));
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.DeleteTopicsPath(), (IZkChildListener)this.deleteTopicsListener());
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String topic, int partition) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topic, partition);
        if (option instanceof Some) {
            return (LeaderIsrAndControllerEpoch)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String failMsg = Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
            throw new StateChangeFailedException(failMsg);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController controller) {
        this.kafka$controller$PartitionStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.topicChangeListener = null;
        this.deleteTopicsListener = null;
        this.addPartitionsListener = Map$.MODULE$.empty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleChildChange(String parentPath$1, java.util.List<String> children$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new TopicChangeListener$$anonfun$handleChildChange$1(this, parentPath$1, children$1));
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return this.$outer;
        }

        public TopicChangeListener(PartitionStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeleteTopicsListener
    implements IZkChildListener,
    Logging,
    ScalaObject {
        private final ZkClient zkClient;
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public ZkClient zkClient() {
            return this.zkClient;
        }

        public void handleChildChange(String parentPath, java.util.List<String> children$2) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new DeleteTopicsListener$$anonfun$handleChildChange$2(this, children$2));
        }

        public void handleDataDeleted(String dataPath) throws Exception {
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$DeleteTopicsListener$$$outer() {
            return this.$outer;
        }

        public DeleteTopicsListener(PartitionStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[DeleteTopicsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
            this.zkClient = $outer.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddPartitionsListener
    implements IZkDataListener,
    Logging,
    ScalaObject {
        public final String kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic;
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleDataChange(String dataPath$1, Object data$1) throws Exception {
            Utils$.MODULE$.inLock(this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock(), new AddPartitionsListener$$anonfun$handleDataChange$1(this, dataPath$1, data$1));
        }

        public void handleDataDeleted(String parentPath) throws Exception {
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$AddPartitionsListener$$$outer() {
            return this.$outer;
        }

        public AddPartitionsListener(PartitionStateMachine $outer, String topic) {
            this.kafka$controller$PartitionStateMachine$AddPartitionsListener$$topic = topic;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[AddPartitionsListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

