/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.TimeUnit;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.common.ControllerMovedException;
import kafka.common.KafkaException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControlledShutdownLeaderSelector;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEpochListener;
import kafka.controller.KafkaController$;
import kafka.controller.KafkaController$$anonfun$kafka$controller$KafkaController$;
import kafka.controller.KafkaController$SessionExpirationListener$;
import kafka.controller.KafkaControllerMBean;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderSelector;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PartitionsReassignedListener;
import kafka.controller.PreferredReplicaElectionListener;
import kafka.controller.PreferredReplicaPartitionLeaderSelector;
import kafka.controller.ReassignedPartitionLeaderSelector;
import kafka.controller.ReassignedPartitionsContext;
import kafka.controller.ReassignedPartitionsIsrChangeListener;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.KafkaConfig;
import kafka.server.ZookeeperLeaderElector;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011-q!B\u0001\u0003\u0011\u000b9\u0011aD&bM.\f7i\u001c8ue>dG.\u001a:\u000b\u0005\r!\u0011AC2p]R\u0014x\u000e\u001c7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u0011)\u0011A\u0011!A\t\u0006-\u0011qbS1gW\u0006\u001cuN\u001c;s_2dWM]\n\u0005\u00131!\"\u0004\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0003vi&d7/\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"aC*dC2\fwJ\u00196fGRDQ!I\u0005\u0005\u0002\t\na\u0001P5oSRtD#A\u0004\t\u000f\u0011J!\u0019!C\u0001K\u0005IQJQ3b]:\u000bW.Z\u000b\u0002MA\u0011QbJ\u0005\u0003Q9\u0011aa\u0015;sS:<\u0007B\u0002\u0016\nA\u0003%a%\u0001\u0006N\u0005\u0016\fgNT1nK\u0002Bq\u0001L\u0005C\u0002\u0013\u0005Q%A\tti\u0006$Xm\u00115b]\u001e,Gj\\4hKJDaAL\u0005!\u0002\u00131\u0013AE:uCR,7\t[1oO\u0016dunZ4fe\u0002Bq\u0001M\u0005C\u0002\u0013\u0005\u0011'\u0001\fJ]&$\u0018.\u00197D_:$(o\u001c7mKJ,\u0005o\\2i+\u0005\u0011\u0004CA\u000e4\u0013\t!DDA\u0002J]RDaAN\u0005!\u0002\u0013\u0011\u0014aF%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0011\u001dA\u0014B1A\u0005\u0002E\nq$\u00138ji&\fGnQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8o\u0011\u0019Q\u0014\u0002)A\u0005e\u0005\u0001\u0013J\\5uS\u0006d7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8!\u0011\u0015a\u0014\u0002\"\u0001>\u0003E\u0001\u0018M]:f\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u000b\u0003eyBQaP\u001eA\u0002\u0001\u000bAcY8oiJ|G\u000e\\3s\u0013:4wn\u0015;sS:<\u0007CA!E\u001d\tY\")\u0003\u0002D9\u00051\u0001K]3eK\u001aL!\u0001K#\u000b\u0005\rcb\u0001\u0003\u0006\u0003\t\u0003\u0005\t\u0011A$\u0014\r\u0019cA\u0003\u0013(\u001b!\tIE*D\u0001K\u0015\tYE!A\u0004nKR\u0014\u0018nY:\n\u00055S%!E&bM.\fW*\u001a;sS\u000e\u001cxI]8vaB\u0011\u0001bT\u0005\u0003!\n\u0011AcS1gW\u0006\u001cuN\u001c;s_2dWM]'CK\u0006t\u0007\u0002\u0003*G\u0005\u000b\u0007I\u0011A*\u0002\r\r|gNZ5h+\u0005!\u0006CA+Y\u001b\u00051&BA,\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011L\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005\\\r\n\u0005\t\u0015!\u0003U\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\"\u0018$\u0003\u0002\u0003\u0006IAX\u0001\tu.\u001cE.[3oiB\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\tu.\u001cG.[3oi*\u00111\rZ\u0001\u0007\u0013BJE/Z2\u000b\u0003\u0015\f1a\u001c:h\u0013\t9\u0007M\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011\u0015\tc\t\"\u0001j)\rQ7\u000e\u001c\t\u0003\u0011\u0019CQA\u00155A\u0002QCQ!\u00185A\u0002yCqA\u001c$A\u0002\u0013%q.A\u0005jgJ+hN\\5oOV\t\u0001\u000f\u0005\u0002\u001cc&\u0011!\u000f\b\u0002\b\u0005>|G.Z1o\u0011\u001d!h\t1A\u0005\nU\fQ\"[:Sk:t\u0017N\\4`I\u0015\fHC\u0001<z!\tYr/\u0003\u0002y9\t!QK\\5u\u0011\u001dQ8/!AA\u0002A\f1\u0001\u001f\u00132\u0011\u0019ah\t)Q\u0005a\u0006Q\u0011n\u001d*v]:Lgn\u001a\u0011\t\u000f12%\u0019!C\u0005}V\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005%A-\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0004M_\u001e<WM\u001d\u0005\u0007]\u0019\u0003\u000b\u0011B@\t\u0013\u0005MaI1A\u0005\u0002\u0005U\u0011!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\u0011\u0011q\u0003\t\u0004\u0011\u0005e\u0011bAA\u000e\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\u0011\u0005}a\t)A\u0005\u0003/\t!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!I\u00111\u0005$C\u0002\u0013\u0005\u0011QE\u0001\u0016a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\t\t9\u0003E\u0002\t\u0003SI1!a\u000b\u0003\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016D\u0001\"a\fGA\u0003%\u0011qE\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!I\u00111\u0007$C\u0002\u0013\u0005\u0011QG\u0001\u0014e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.Z\u000b\u0003\u0003o\u00012\u0001CA\u001d\u0013\r\tYD\u0001\u0002\u0014%\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0005\t\u0003\u007f1\u0005\u0015!\u0003\u00028\u0005!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002B\u0011\"a\u0011G\u0005\u0004%I!!\u0012\u0002#\r|g\u000e\u001e:pY2,'/\u00127fGR|'/\u0006\u0002\u0002HA\u0019Q+!\u0013\n\u0007\u0005-cK\u0001\f[_>\\W-\u001a9fe2+\u0017\rZ3s\u000b2,7\r^8s\u0011!\tyE\u0012Q\u0001\n\u0005\u001d\u0013AE2p]R\u0014x\u000e\u001c7fe\u0016cWm\u0019;pe\u0002B\u0011\"a\u0015G\u0005\u0004%I!!\u0016\u0002-\u0005,Ho\u001c*fE\u0006d\u0017M\\2f'\u000eDW\rZ;mKJ,\"!a\u0016\u0011\u0007U\tI&C\u0002\u0002\\Y\u0011abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u0005\u0002`\u0019\u0003\u000b\u0011BA,\u0003]\tW\u000f^8SK\n\fG.\u00198dKN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0005C\u0005\u0002d\u0019\u0003\r\u0011\"\u0001\u0002f\u0005\u0011B-\u001a7fi\u0016$v\u000e]5d\u001b\u0006t\u0017mZ3s+\t\t9\u0007E\u0002\t\u0003SJ1!a\u001b\u0003\u0005Q!v\u000e]5d\t\u0016dW\r^5p]6\u000bg.Y4fe\"I\u0011q\u000e$A\u0002\u0013\u0005\u0011\u0011O\u0001\u0017I\u0016dW\r^3U_BL7-T1oC\u001e,'o\u0018\u0013fcR\u0019a/a\u001d\t\u0013i\fi'!AA\u0002\u0005\u001d\u0004\u0002CA<\r\u0002\u0006K!a\u001a\u0002'\u0011,G.\u001a;f)>\u0004\u0018nY'b]\u0006<WM\u001d\u0011\t\u0013\u0005mdI1A\u0005\u0002\u0005u\u0014\u0001G8gM2Lg.\u001a)beRLG/[8o'\u0016dWm\u0019;peV\u0011\u0011q\u0010\t\u0004\u0011\u0005\u0005\u0015bAAB\u0005\tqrJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0005\t\u0003\u000f3\u0005\u0015!\u0003\u0002\u0000\u0005IrN\u001a4mS:,\u0007+\u0019:uSRLwN\\*fY\u0016\u001cGo\u001c:!\u0011%\tYI\u0012b\u0001\n\u0013\ti)A\u0011sK\u0006\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'/\u0006\u0002\u0002\u0010B\u0019\u0001\"!%\n\u0007\u0005M%AA\u0011SK\u0006\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0003\u0005\u0002\u0018\u001a\u0003\u000b\u0011BAH\u0003\t\u0012X-Y:tS\u001etW\r\u001a)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8sA!I\u00111\u0014$C\u0002\u0013%\u0011QT\u0001(aJ,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'/\u0006\u0002\u0002 B\u0019\u0001\"!)\n\u0007\u0005\r&AA\u0014Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dCB\u000b'\u000f^5uS>tG*Z1eKJ\u001cV\r\\3di>\u0014\b\u0002CAT\r\u0002\u0006I!a(\u0002QA\u0014XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0011\t\u0013\u0005-fI1A\u0005\n\u00055\u0016!K2p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'/\u0006\u0002\u00020B\u0019\u0001\"!-\n\u0007\u0005M&A\u0001\u0011D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^tG*Z1eKJ\u001cV\r\\3di>\u0014\b\u0002CA\\\r\u0002\u0006I!a,\u0002U\r|g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8sA!I\u00111\u0018$C\u0002\u0013%\u0011QX\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.\u0006\u0002\u0002@B\u0019\u0001\"!1\n\u0007\u0005\r'A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u0011\u0005\u001dg\t)A\u0005\u0003\u007f\u000b1C\u0019:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002Ba!a3G\t\u0003\t\u0014!B3q_\u000eD\u0007bBAh\r\u0012\u0005\u0011\u0011[\u0001\tG2LWM\u001c;JIV\t\u0001\tC\u0004\u0002V\u001a#\t!a6\u0002\u001dMDW\u000f\u001e3po:\u0014%o\\6feR!\u0011\u0011\\Ay!\u0019\tY.!9\u0002f6\u0011\u0011Q\u001c\u0006\u0004\u0003?d\u0012AC2pY2,7\r^5p]&!\u00111]Ao\u0005\r\u0019V\r\u001e\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111\u001e\u0003\u0002\r\r|W.\\8o\u0013\u0011\ty/!;\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002t\u0006M\u0007\u0019\u0001\u001a\u0002\u0005%$\u0007bBA|\r\u0012\u0005\u0011\u0011`\u0001\u0015_:\u001cuN\u001c;s_2dWM\u001d$bS2|g/\u001a:\u0015\u0003YDq!!@G\t\u0003\tI0A\fp]\u000e{g\u000e\u001e:pY2,'OU3tS\u001et\u0017\r^5p]\"9!\u0011\u0001$\u0005\u0002\t\r\u0011\u0001C5t\u0003\u000e$\u0018N^3\u0015\u0003ADqAa\u0002G\t\u0003\u0011I!A\bp]\n\u0013xn[3s'R\f'\u000f^;q)\r1(1\u0002\u0005\t\u0005\u001b\u0011)\u00011\u0001\u0003\u0010\u0005Qa.Z<Ce>\\WM]:\u0011\u000b\u0005m'\u0011\u0003\u001a\n\t\tM\u0011Q\u001c\u0002\u0004'\u0016\f\bb\u0002B\f\r\u0012\u0005!\u0011D\u0001\u0010_:\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKR\u0019aOa\u0007\t\u0011\tu!Q\u0003a\u0001\u0005\u001f\t1\u0002Z3bI\n\u0013xn[3sg\"9!\u0011\u0005$\u0005\u0002\t\r\u0012AE8o\u001d\u0016<Hk\u001c9jG\u000e\u0013X-\u0019;j_:$RA\u001eB\u0013\u0005WA\u0001Ba\n\u0003 \u0001\u0007!\u0011F\u0001\u0007i>\u0004\u0018nY:\u0011\u000b\u0005m\u0017\u0011\u001d!\t\u0011\t5\"q\u0004a\u0001\u00033\fQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\bb\u0002B\u0019\r\u0012\u0005!1G\u0001\u0017_:tUm\u001e)beRLG/[8o\u0007J,\u0017\r^5p]R\u0019aO!\u000e\t\u0011\t5\"q\u0006a\u0001\u00033DqA!\u000fG\t\u0003\u0011Y$A\fp]B\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiR)aO!\u0010\u0003B!A!q\bB\u001c\u0001\u0004\t)/A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001Ba\u0011\u00038\u0001\u0007!QI\u0001\u001be\u0016\f7o]5h]\u0016$\u0007+\u0019:uSRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004\u0011\t\u001d\u0013b\u0001B%\u0005\tY\"+Z1tg&<g.\u001a3QCJ$\u0018\u000e^5p]N\u001cuN\u001c;fqRDqA!\u0014G\t\u0013\u0011y%A\u0013xCR\u001c\u0007.S:s\u0007\"\fgnZ3t\r>\u0014(+Z1tg&<g.\u001a3QCJ$\u0018\u000e^5p]R9aO!\u0015\u0003V\te\u0003b\u0002B*\u0005\u0017\u0002\r\u0001Q\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005/\u0012Y\u00051\u00013\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0003\u0005\u0003D\t-\u0003\u0019\u0001B#\u0011\u001d\u0011iF\u0012C\u0001\u0005?\n\u0011&\u001b8ji&\fG/\u001a*fCN\u001c\u0018n\u001a8SKBd\u0017nY1t\r>\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tG#\u0002<\u0003b\t\r\u0004\u0002\u0003B \u00057\u0002\r!!:\t\u0011\t\r#1\fa\u0001\u0005\u000bBqAa\u001aG\t\u0003\u0011I'\u0001\u000ep]B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fW\t\\3di&|g\u000eF\u0003w\u0005W\u0012y\u0007\u0003\u0005\u0003n\t\u0015\u0004\u0019AAm\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\n\u0005c\u0012)\u0007%AA\u0002A\f!$[:Ue&<w-\u001a:fI\nK\u0018)\u001e;p%\u0016\u0014\u0017\r\\1oG\u0016DqA!\u001eG\t\u0003\tI0A\u0004ti\u0006\u0014H/\u001e9\t\u000f\ted\t\"\u0001\u0002z\u0006A1\u000f[;uI><h\u000eC\u0004\u0003~\u0019#\tAa \u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\bm\n\u0005%Q\u0011BK\u0011\u001d\u0011\u0019Ia\u001fA\u0002I\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\t\u0005\u000f\u0013Y\b1\u0001\u0003\n\u00069!/Z9vKN$\b\u0003\u0002BF\u0005#k!A!$\u000b\u0007\t=E!A\u0002ba&LAAa%\u0003\u000e\n\t\"+Z9vKN$xJ\u001d*fgB|gn]3\t\u0015\t]%1\u0010I\u0001\u0002\u0004\u0011I*\u0001\u0005dC2d'-Y2l!\u0019Y\"1\u0014BEm&\u0019!Q\u0014\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002BQ\r\u0012\u0005!1U\u0001\u0019S:\u001c'/Z7f]R\u001cuN\u001c;s_2dWM]#q_\u000eDGc\u0001<\u0003&\"1QLa(A\u0002yCqA!+G\t\u0013\tI0A\u0011sK\u001eL7\u000f^3s'\u0016\u001c8/[8o\u000bb\u0004\u0018N]1uS>tG*[:uK:,'\u000fC\u0004\u0003.\u001a#I!!?\u00027%t\u0017\u000e^5bY&TXmQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u001d\u0011\tL\u0012C\u0005\u0003s\f!%\u001b8ji&\fG.\u001b>f!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006,E.Z2uS>t\u0007b\u0002B[\r\u0012%\u0011\u0011`\u0001 S:LG/[1mSj,\u0007+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$\bb\u0002B]\r\u0012%\u0011\u0011`\u0001\u0018S:LG/[1mSj,Gk\u001c9jG\u0012+G.\u001a;j_:DqA!0G\t\u0013\tI0A\u0011nCf\u0014W\r\u0016:jO\u001e,'\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000fC\u0004\u0003B\u001a#I!!?\u0002I5\f\u0017PY3Ue&<w-\u001a:Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:DqA!2G\t\u0013\tI0A\nti\u0006\u0014Ho\u00115b]:,G.T1oC\u001e,'\u000fC\u0004\u0003J\u001a#I!!?\u0002/U\u0004H-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012L5O]\"bG\",\u0007b\u0002Bg\r\u0012%!qZ\u0001\u0011CJ,'+\u001a9mS\u000e\f7/\u00138JgJ$r\u0001\u001dBi\u0005'\u0014)\u000eC\u0004\u0003T\t-\u0007\u0019\u0001!\t\u000f\t]#1\u001aa\u0001e!A!q\u001bBf\u0001\u0004\u0011y!\u0001\u0005sKBd\u0017nY1t\u0011\u001d\u0011YN\u0012C\u0005\u0005;\fq%\\8wKJ+\u0017m]:jO:,G\rU1si&$\u0018n\u001c8MK\u0006$WM]%g%\u0016\fX/\u001b:fIR)aOa8\u0003b\"A!q\bBm\u0001\u0004\t)\u000f\u0003\u0005\u0003D\te\u0007\u0019\u0001B#\u0011\u001d\u0011)O\u0012C\u0005\u0005O\fAe\u001d;pa>cGMU3qY&\u001c\u0017m](g%\u0016\f7o]5h]\u0016$\u0007+\u0019:uSRLwN\u001c\u000b\bm\n%(1\u001eBw\u0011!\u0011yDa9A\u0002\u0005\u0015\b\u0002\u0003B\"\u0005G\u0004\rA!\u0012\t\u0011\t=(1\u001da\u0001\u0005c\f1b\u001c7e%\u0016\u0004H.[2bgB)\u00111\\Aqe!9!Q\u001f$\u0005\n\t]\u0018AI;qI\u0006$X-Q:tS\u001etW\r\u001a*fa2L7-Y:G_J\u0004\u0016M\u001d;ji&|g\u000eF\u0003w\u0005s\u0014Y\u0010\u0003\u0005\u0003@\tM\b\u0019AAs\u0011!\u00119Na=A\u0002\t=\u0001b\u0002B\u0000\r\u0012%1\u0011A\u0001'gR\f'\u000f\u001e(foJ+\u0007\u000f\\5dCN4uN\u001d*fCN\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>tGc\u0002<\u0004\u0004\r\u00151q\u0001\u0005\t\u0005\u007f\u0011i\u00101\u0001\u0002f\"A!1\tB\u007f\u0001\u0004\u0011)\u0005\u0003\u0005\u0004\n\tu\b\u0019\u0001By\u0003-qWm\u001e*fa2L7-Y:\t\u000f\r5a\t\"\u0003\u0004\u0010\u0005yR\u000f\u001d3bi\u0016dU-\u00193fe\u0016\u0003xn\u00195B]\u0012\u001cVM\u001c3SKF,Xm\u001d;\u0015\u000fY\u001c\tba\u0005\u0004\u0018!A!qHB\u0006\u0001\u0004\t)\u000f\u0003\u0005\u0004\u0016\r-\u0001\u0019\u0001B\b\u0003a\u0011X\r\u001d7jG\u0006\u001cHk\u001c*fG\u0016Lg/\u001a*fcV,7\u000f\u001e\u0005\t\u00073\u0019Y\u00011\u0001\u0003\u0010\u0005\u0019b.Z<BgNLwM\\3e%\u0016\u0004H.[2bg\"91Q\u0004$\u0005\n\u0005e\u0018\u0001\n:fO&\u001cH/\u001a:SK\u0006\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d'jgR,g.\u001a:\t\u000f\r\u0005b\t\"\u0003\u0002z\u0006A#/Z4jgR,'\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8o\u0019&\u001cH/\u001a8fe\"91Q\u0005$\u0005\n\u0005e\u0018!\t:fO&\u001cH/\u001a:D_:$(o\u001c7mKJ\u001c\u0005.\u00198hK\u0012d\u0015n\u001d;f]\u0016\u0014\bbBB\u0015\r\u0012\u000511F\u0001(e\u0016lwN^3QCJ$\u0018\u000e^5p]\u001a\u0013x.\u001c*fCN\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>t7\u000fF\u0002w\u0007[A\u0001Ba\u0010\u0004(\u0001\u0007\u0011Q\u001d\u0005\b\u0005k4E\u0011AB\u0019)\u0015181GB\u001b\u0011!\u0011yda\fA\u0002\u0005\u0015\b\u0002CB\u001c\u0007_\u0001\ra!\u000f\u000299,wOU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\r>\u0014Hk\u001c9jGBA\u00111\\B\u001e\u0003K\u0014y!\u0003\u0003\u0004>\u0005u'aA'ba\"91\u0011\t$\u0005\u0002\r\r\u0013\u0001\f:f[>4X\rU1si&$\u0018n\u001c8t\rJ|W\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8o)\u001518QIB%\u0011!\u00199ea\u0010A\u0002\u0005e\u0017!\u00069beRLG/[8ogR{')\u001a*f[>4X\r\u001a\u0005\b\u0005c\u001ay\u00041\u0001q\u0011\u001d\u0019iE\u0012C\u0001\u0007\u001f\n\u0011d]3oIV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR\u0019ao!\u0015\t\u0011\rM31\na\u0001\u0005\u001f\tqA\u0019:pW\u0016\u00148\u000fC\u0004\u0004X\u0019#\ta!\u0017\u0002)I,Wn\u001c<f%\u0016\u0004H.[2b\rJ|W.S:s)!\u0019Yfa\u001a\u0004j\r-\u0004#B\u000e\u0004^\r\u0005\u0014bAB09\t1q\n\u001d;j_:\u00042\u0001CB2\u0013\r\u0019)G\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\tM3Q\u000ba\u0001\u0001\"9!qKB+\u0001\u0004\u0011\u0004bBB7\u0007+\u0002\rAM\u0001\ne\u0016\u0004H.[2b\u0013\u0012Dqa!\u001dG\t\u0013\u0019\u0019(A\tva\u0012\fG/\u001a'fC\u0012,'/\u00129pG\"$baa\u0017\u0004v\r]\u0004b\u0002B*\u0007_\u0002\r\u0001\u0011\u0005\b\u0005/\u001ay\u00071\u00013\r)\u0019YH\u0012C\u0001\u0002\u0003\u00051Q\u0010\u0002\u001a'\u0016\u001c8/[8o\u000bb\u0004\u0018N]1uS>tG*[:uK:,'oE\u0004\u0004z1\u0019y\b\u0006\u000e\u0011\u0007}\u001b\t)C\u0002\u0004\u0004\u0002\u0014\u0001#\u0013.l'R\fG/\u001a'jgR,g.\u001a:\t\u000f\u0005\u001aI\b\"\u0001\u0004\bR\u00111\u0011\u0012\t\u0005\u0007\u0017\u001bI(D\u0001G\u0011!\u0019yi!\u001f\u0005\u0002\rE\u0015A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012$2A^BJ\u0011!\u0019)j!$A\u0002\r]\u0015!B:uCR,\u0007\u0003BBM\u0007{sAaa'\u00048:!1QTBY\u001d\u0011\u0019yj!,\u000f\t\r\u000561\u0016\b\u0005\u0007G\u001bI+\u0004\u0002\u0004&*\u00191q\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0017bAA\u0005I&!1qVA\u0004\u0003%Qxn\\6fKB,'/\u0003\u0003\u00044\u000eU\u0016aB,bi\u000eDWM\u001d\u0006\u0005\u0007_\u000b9!\u0003\u0003\u0004:\u000em\u0016!B#wK:$(\u0002BBZ\u0007kKAaa0\u0004B\nY1*Z3qKJ\u001cF/\u0019;f\u0015\u0011\u0019Ila/)\r\r55QYBf!\rY2qY\u0005\u0004\u0007\u0013d\"A\u0002;ie><8o\t\u0002\u0004NB!1qZBm\u001d\u0011\u0019\tn!6\u000f\t\r\r61[\u0005\u0002;%\u00191q\u001b\u000f\u0002\u000fA\f7m[1hK&!11\\Bo\u0005%)\u0005pY3qi&|gNC\u0002\u0004XrA\u0001b!9\u0004z\u0011\u0005\u0011\u0011`\u0001\u0011Q\u0006tG\r\\3OK^\u001cVm]:j_:Dcaa8\u0004F\u000e-\u0007bBBt\r\u0012%\u0011\u0011`\u0001\"G\",7m[!oIR\u0013\u0018nZ4feB\u000b'\u000f^5uS>t'+\u001a2bY\u0006t7-\u001a\u0005\n\u0007W4\u0015\u0013!C\u0001\u0007[\fQc]3oIJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0004p*\"!\u0011TByW\t\u0019\u0019\u0010\u0005\u0003\u0004v\u000e}XBAB|\u0015\u0011\u0019Ipa?\u0002\u0013Ut7\r[3dW\u0016$'bAB\u007f9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0011\u00051q\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003C\u0003\rF\u0005I\u0011\u0001C\u0004\u0003\u0011zg\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u0005U\r\u00018\u0011\u001f")
public class KafkaController
implements Logging,
KafkaMetricsGroup,
KafkaControllerMBean,
ScalaObject {
    private final KafkaConfig config;
    private final ZkClient zkClient;
    private boolean kafka$controller$KafkaController$$isRunning;
    private final Logger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final ZookeeperLeaderElector kafka$controller$KafkaController$$controllerElector;
    private final KafkaScheduler kafka$controller$KafkaController$$autoRebalanceScheduler;
    private TopicDeletionManager deleteTopicManager;
    private final OfflinePartitionLeaderSelector offlinePartitionSelector;
    private final ReassignedPartitionLeaderSelector reassignedPartitionLeaderSelector;
    private final PreferredReplicaPartitionLeaderSelector preferredReplicaPartitionLeaderSelector;
    private final ControlledShutdownLeaderSelector kafka$controller$KafkaController$$controlledShutdownPartitionLeaderSelector;
    private final ControllerBrokerRequestBatch kafka$controller$KafkaController$$brokerRequestBatch;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int parseControllerId(String string) {
        return KafkaController$.MODULE$.parseControllerId(string);
    }

    public static final int InitialControllerEpochZkVersion() {
        return KafkaController$.MODULE$.InitialControllerEpochZkVersion();
    }

    public static final int InitialControllerEpoch() {
        return KafkaController$.MODULE$.InitialControllerEpoch();
    }

    public static final String MBeanName() {
        return KafkaController$.MODULE$.MBeanName();
    }

    public boolean onPreferredReplicaElection$default$2() {
        return true;
    }

    public Function1 sendRequest$default$3() {
        return null;
    }

    public KafkaConfig config() {
        return this.config;
    }

    private boolean kafka$controller$KafkaController$$isRunning() {
        return this.kafka$controller$KafkaController$$isRunning;
    }

    public final void kafka$controller$KafkaController$$isRunning_$eq(boolean bl) {
        this.kafka$controller$KafkaController$$isRunning = bl;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public final ZookeeperLeaderElector kafka$controller$KafkaController$$controllerElector() {
        return this.kafka$controller$KafkaController$$controllerElector;
    }

    public final KafkaScheduler kafka$controller$KafkaController$$autoRebalanceScheduler() {
        return this.kafka$controller$KafkaController$$autoRebalanceScheduler;
    }

    public TopicDeletionManager deleteTopicManager() {
        return this.deleteTopicManager;
    }

    public void deleteTopicManager_$eq(TopicDeletionManager topicDeletionManager) {
        this.deleteTopicManager = topicDeletionManager;
    }

    public OfflinePartitionLeaderSelector offlinePartitionSelector() {
        return this.offlinePartitionSelector;
    }

    private ReassignedPartitionLeaderSelector reassignedPartitionLeaderSelector() {
        return this.reassignedPartitionLeaderSelector;
    }

    private PreferredReplicaPartitionLeaderSelector preferredReplicaPartitionLeaderSelector() {
        return this.preferredReplicaPartitionLeaderSelector;
    }

    public final ControlledShutdownLeaderSelector kafka$controller$KafkaController$$controlledShutdownPartitionLeaderSelector() {
        return this.kafka$controller$KafkaController$$controlledShutdownPartitionLeaderSelector;
    }

    public final ControllerBrokerRequestBatch kafka$controller$KafkaController$$brokerRequestBatch() {
        return this.kafka$controller$KafkaController$$brokerRequestBatch;
    }

    public int epoch() {
        return this.controllerContext().epoch();
    }

    public String clientId() {
        return Predef$.MODULE$.augmentString("id_%d-host_%s-port_%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), this.config().hostName(), BoxesRunTime.boxToInteger((int)this.config().port())}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public scala.collection.Set<TopicAndPartition> shutdownBroker(int id$1) {
        if (!this.isActive()) throw new ControllerMovedException("Controller moved to another broker. Aborting controlled shutdown");
        Object object = this.controllerContext().brokerShutdownLock();
        synchronized (object) {
            this.info((Function0<String>)new $anonfun$shutdownBroker$2(this, id$1));
            Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$shutdownBroker$1(this, id$1));
            scala.collection.Set allPartitionsAndReplicationFactorOnBroker = (scala.collection.Set)Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$7(this, id$1));
            allPartitionsAndReplicationFactorOnBroker.foreach((Function1)new $anonfun$shutdownBroker$3(this, id$1));
            scala.collection.immutable.Set set = this.replicatedPartitionsBrokerLeads$1(id$1).toSet();
            return (scala.collection.Set)set;
        }
    }

    public void onControllerFailover() {
        if (this.kafka$controller$KafkaController$$isRunning()) {
            this.info((Function0<String>)new $anonfun$onControllerFailover$2(this));
            this.incrementControllerEpoch(this.zkClient);
            this.registerReassignedPartitionsListener();
            this.registerPreferredReplicaElectionListener();
            this.partitionStateMachine().registerListeners();
            this.replicaStateMachine().registerListeners();
            this.initializeControllerContext();
            this.replicaStateMachine().startup();
            this.partitionStateMachine().startup();
            this.controllerContext().allTopics().foreach((Function1)new $anonfun$onControllerFailover$3(this));
            Utils$.MODULE$.registerMBean(this, KafkaController$.MODULE$.MBeanName());
            this.info((Function0<String>)new $anonfun$onControllerFailover$4(this));
            this.maybeTriggerPartitionReassignment();
            this.maybeTriggerPreferredReplicaElection();
            this.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq());
            if (this.config().autoLeaderRebalanceEnable()) {
                this.info((Function0<String>)new $anonfun$onControllerFailover$5(this));
                this.kafka$controller$KafkaController$$autoRebalanceScheduler().startup();
                this.kafka$controller$KafkaController$$autoRebalanceScheduler().schedule("partition-rebalance-thread", (Function0<BoxedUnit>)new $anonfun$onControllerFailover$1(this), 5L, this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS);
            }
            this.deleteTopicManager().start();
        } else {
            this.info((Function0<String>)new $anonfun$onControllerFailover$6(this));
        }
    }

    public void onControllerResignation() {
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$onControllerResignation$1(this));
    }

    public boolean isActive() {
        return BoxesRunTime.unboxToBoolean(Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$isActive$1(this)));
    }

    public void onBrokerStartup(Seq<Object> newBrokers$1) {
        this.info((Function0<String>)new $anonfun$onBrokerStartup$1(this, newBrokers$1));
        scala.collection.immutable.Set newBrokersSet$1 = newBrokers$1.toSet();
        this.sendUpdateMetadataRequest(newBrokers$1);
        scala.collection.Set<PartitionAndReplica> allReplicasOnNewBrokers = this.controllerContext().replicasOnBrokers((scala.collection.Set<Object>)newBrokersSet$1);
        this.replicaStateMachine().handleStateChanges(allReplicasOnNewBrokers, OnlineReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        this.partitionStateMachine().triggerOnlinePartitionStateChange();
        scala.collection.mutable.Map partitionsWithReplicasOnNewBrokers = (scala.collection.mutable.Map)this.controllerContext().partitionsBeingReassigned().filter((Function1)new $anonfun$8(this, newBrokersSet$1));
        partitionsWithReplicasOnNewBrokers.foreach((Function1)new $anonfun$onBrokerStartup$2(this));
        scala.collection.Set replicasForTopicsToBeDeleted$1 = (scala.collection.Set)allReplicasOnNewBrokers.filter((Function1)new $anonfun$9(this));
        if (replicasForTopicsToBeDeleted$1.size() > 0) {
            this.info((Function0<String>)new $anonfun$onBrokerStartup$3(this, newBrokers$1, replicasForTopicsToBeDeleted$1));
            this.deleteTopicManager().resumeDeletionForTopics((scala.collection.Set<String>)((scala.collection.Set)replicasForTopicsToBeDeleted$1.map((Function1)new $anonfun$onBrokerStartup$4(this), Set$.MODULE$.canBuildFrom())));
        }
    }

    public void onBrokerFailure(Seq<Object> deadBrokers$1) {
        this.info((Function0<String>)new $anonfun$onBrokerFailure$1(this, deadBrokers$1));
        Seq deadBrokersThatWereShuttingDown$1 = (Seq)deadBrokers$1.filter((Function1)new $anonfun$3(this));
        this.info((Function0<String>)new $anonfun$onBrokerFailure$2(this, deadBrokersThatWereShuttingDown$1));
        scala.collection.immutable.Set deadBrokersSet$1 = deadBrokers$1.toSet();
        scala.collection.Set partitionsWithoutLeader = ((MapLike)this.controllerContext().partitionLeadershipInfo().filter((Function1)new $anonfun$10(this, deadBrokersSet$1))).keySet();
        this.partitionStateMachine().handleStateChanges((scala.collection.Set<TopicAndPartition>)partitionsWithoutLeader, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().triggerOnlinePartitionStateChange();
        scala.collection.Set<PartitionAndReplica> allReplicasOnDeadBrokers = this.controllerContext().replicasOnBrokers((scala.collection.Set<Object>)deadBrokersSet$1);
        scala.collection.Set activeReplicasOnDeadBrokers = (scala.collection.Set)allReplicasOnDeadBrokers.filterNot((Function1)new $anonfun$11(this));
        this.replicaStateMachine().handleStateChanges((scala.collection.Set<PartitionAndReplica>)activeReplicasOnDeadBrokers, OfflineReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        scala.collection.Set replicasForTopicsToBeDeleted = (scala.collection.Set)allReplicasOnDeadBrokers.filter((Function1)new $anonfun$12(this));
        if (replicasForTopicsToBeDeleted.size() > 0) {
            this.deleteTopicManager().failReplicaDeletion((scala.collection.Set<PartitionAndReplica>)replicasForTopicsToBeDeleted);
        }
    }

    public void onNewTopicCreation(scala.collection.Set<String> topics, scala.collection.Set<TopicAndPartition> newPartitions$1) {
        this.info((Function0<String>)new $anonfun$onNewTopicCreation$1(this, newPartitions$1));
        topics.foreach((Function1)new $anonfun$onNewTopicCreation$2(this));
        this.onNewPartitionCreation(newPartitions$1);
    }

    public void onNewPartitionCreation(scala.collection.Set<TopicAndPartition> newPartitions$2) {
        this.info((Function0<String>)new $anonfun$onNewPartitionCreation$1(this, newPartitions$2));
        this.partitionStateMachine().handleStateChanges(newPartitions$2, NewPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.replicaStateMachine().handleStateChanges(this.controllerContext().replicasForPartition(newPartitions$2), NewReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        this.partitionStateMachine().handleStateChanges(newPartitions$2, OnlinePartition$.MODULE$, this.offlinePartitionSelector(), this.partitionStateMachine().handleStateChanges$default$4());
        this.replicaStateMachine().handleStateChanges(this.controllerContext().replicasForPartition(newPartitions$2), OnlineReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
    }

    public void onPartitionReassignment(TopicAndPartition topicAndPartition$3, ReassignedPartitionsContext reassignedPartitionContext) {
        boolean bl;
        block4: {
            block3: {
                Seq<Object> reassignedReplicas$1;
                block2: {
                    reassignedReplicas$1 = reassignedPartitionContext.newReplicas();
                    bl = this.areReplicasInIsr(topicAndPartition$3.topic(), topicAndPartition$3.partition(), reassignedReplicas$1);
                    if (bl) break block2;
                    this.info((Function0<String>)new $anonfun$onPartitionReassignment$2(this, topicAndPartition$3, reassignedReplicas$1));
                    scala.collection.immutable.Set newReplicasNotInOldReplicaList = (scala.collection.immutable.Set)reassignedReplicas$1.toSet().$minus$minus((TraversableOnce)((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$3)).toSet());
                    scala.collection.immutable.Set newAndOldReplicas = ((TraversableOnce)reassignedPartitionContext.newReplicas().$plus$plus((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$3), Seq$.MODULE$.canBuildFrom())).toSet();
                    this.updateAssignedReplicasForPartition(topicAndPartition$3, (Seq<Object>)newAndOldReplicas.toSeq());
                    this.updateLeaderEpochAndSendRequest(topicAndPartition$3, (Seq<Object>)((Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$3)), (Seq<Object>)newAndOldReplicas.toSeq());
                    this.startNewReplicasForReassignedPartition(topicAndPartition$3, reassignedPartitionContext, (scala.collection.Set<Object>)newReplicasNotInOldReplicaList);
                    this.info((Function0<String>)new $anonfun$onPartitionReassignment$3(this, topicAndPartition$3, reassignedReplicas$1));
                    break block3;
                }
                if (!bl) break block4;
                scala.collection.immutable.Set oldReplicas = (scala.collection.immutable.Set)((TraversableOnce)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$3)).toSet().$minus$minus((TraversableOnce)reassignedReplicas$1.toSet());
                reassignedReplicas$1.foreach((Function1)new $anonfun$onPartitionReassignment$1(this, topicAndPartition$3));
                this.moveReassignedPartitionLeaderIfRequired(topicAndPartition$3, reassignedPartitionContext);
                this.stopOldReplicasOfReassignedPartition(topicAndPartition$3, reassignedPartitionContext, (scala.collection.Set<Object>)oldReplicas);
                this.updateAssignedReplicasForPartition(topicAndPartition$3, reassignedReplicas$1);
                this.removePartitionFromReassignedPartitions(topicAndPartition$3);
                this.info((Function0<String>)new $anonfun$onPartitionReassignment$4(this, topicAndPartition$3));
                this.controllerContext().partitionsBeingReassigned().remove((Object)topicAndPartition$3);
                this.sendUpdateMetadataRequest((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq());
                this.deleteTopicManager().resumeDeletionForTopics((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicAndPartition$3.topic()}))));
            }
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void watchIsrChangesForReassignedPartition(String topic, int partition, ReassignedPartitionsContext reassignedPartitionContext) {
        Seq<Object> reassignedReplicas = reassignedPartitionContext.newReplicas();
        ReassignedPartitionsIsrChangeListener isrChangeListener = new ReassignedPartitionsIsrChangeListener(this, topic, partition, (scala.collection.Set<Object>)reassignedReplicas.toSet());
        reassignedPartitionContext.isrChangeListener_$eq(isrChangeListener);
        this.zkClient.subscribeDataChanges(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), (IZkDataListener)isrChangeListener);
    }

    public void initiateReassignReplicasForTopicPartition(TopicAndPartition topicAndPartition$7, ReassignedPartitionsContext reassignedPartitionContext) {
        Seq<Object> newReplicas$2 = reassignedPartitionContext.newReplicas();
        String topic = topicAndPartition$7.topic();
        int partition = topicAndPartition$7.partition();
        Seq aliveNewReplicas = (Seq)newReplicas$2.filter((Function1)new $anonfun$4(this));
        try {
            Option assignedReplicasOpt;
            Option option = assignedReplicasOpt = this.controllerContext().partitionReplicaAssignment().get((Object)topicAndPartition$7);
            if (option instanceof Some) {
                Object object = ((Some)option).x();
                Seq<Object> seq = newReplicas$2;
                if (!(object != null ? !object.equals(seq) : seq != null)) {
                    throw new KafkaException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s to be reassigned is already assigned to replicas").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$7}))).append((Object)Predef$.MODULE$.augmentString(" %s. Ignoring request for partition reassignment").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newReplicas$2.mkString(",")}))).toString());
                }
                Seq seq2 = aliveNewReplicas;
                Seq<Object> seq3 = newReplicas$2;
                if (seq2 != null ? !seq2.equals(seq3) : seq3 != null) {
                    throw new KafkaException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Only %s replicas out of the new set of replicas").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aliveNewReplicas.mkString(",")}))).append((Object)Predef$.MODULE$.augmentString(" %s for partition %s to be reassigned are alive. ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newReplicas$2.mkString(","), topicAndPartition$7}))).append((Object)"Failing partition reassignment").toString());
                }
            } else {
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                    throw new KafkaException(Predef$.MODULE$.augmentString("Attempt to reassign partition %s that doesn't exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$7})));
                }
                throw new MatchError((Object)option);
            }
            this.info((Function0<String>)new $anonfun$initiateReassignReplicasForTopicPartition$1(this, topicAndPartition$7, newReplicas$2));
            this.watchIsrChangesForReassignedPartition(topic, partition, reassignedPartitionContext);
            this.controllerContext().partitionsBeingReassigned().put((Object)topicAndPartition$7, (Object)reassignedPartitionContext);
            this.deleteTopicManager().markTopicIneligibleForDeletion((scala.collection.Set<String>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            this.onPartitionReassignment(topicAndPartition$7, reassignedPartitionContext);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$initiateReassignReplicasForTopicPartition$2(this, topicAndPartition$7), (Function0<Throwable>)new $anonfun$initiateReassignReplicasForTopicPartition$3(this, throwable));
            this.removePartitionFromReassignedPartitions(topicAndPartition$7);
        }
    }

    public void onPreferredReplicaElection(scala.collection.Set<TopicAndPartition> partitions$1, boolean isTriggeredByAutoRebalance) {
        this.info((Function0<String>)new $anonfun$onPreferredReplicaElection$1(this, partitions$1));
        try {
            this.controllerContext().partitionsUndergoingPreferredReplicaElection().$plus$plus$eq(partitions$1);
            this.deleteTopicManager().markTopicIneligibleForDeletion((scala.collection.Set<String>)((scala.collection.Set)partitions$1.map((Function1)new $anonfun$onPreferredReplicaElection$2(this), Set$.MODULE$.canBuildFrom())));
            this.partitionStateMachine().handleStateChanges(partitions$1, OnlinePartition$.MODULE$, this.preferredReplicaPartitionLeaderSelector(), this.partitionStateMachine().handleStateChanges$default$4());
            this.removePartitionsFromPreferredReplicaElection(partitions$1, isTriggeredByAutoRebalance);
            this.deleteTopicManager().resumeDeletionForTopics((scala.collection.Set<String>)((scala.collection.Set)partitions$1.map((Function1)new $anonfun$onPreferredReplicaElection$5(this), Set$.MODULE$.canBuildFrom())));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$onPreferredReplicaElection$3(this, partitions$1), (Function0<Throwable>)new $anonfun$onPreferredReplicaElection$4(this, throwable));
        }
        return;
        {
            finally {
                this.removePartitionsFromPreferredReplicaElection(partitions$1, isTriggeredByAutoRebalance);
                this.deleteTopicManager().resumeDeletionForTopics((scala.collection.Set<String>)((scala.collection.Set)partitions$1.map((Function1)new $anonfun$onPreferredReplicaElection$5(this), Set$.MODULE$.canBuildFrom())));
            }
        }
    }

    public void startup() {
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$startup$1(this));
    }

    public void shutdown() {
        Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$shutdown$1(this));
    }

    public void sendRequest(int brokerId, RequestOrResponse request, Function1<RequestOrResponse, BoxedUnit> callback) {
        this.controllerContext().controllerChannelManager().sendRequest(brokerId, request, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void incrementControllerEpoch(ZkClient zkClient) {
        try {
            int newControllerEpoch = this.controllerContext().epoch() + 1;
            Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPathIfExists(zkClient, ZkUtils$.MODULE$.ControllerEpochPath(), ((Object)BoxesRunTime.boxToInteger((int)newControllerEpoch)).toString(), this.controllerContext().epochZkVersion());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int newVersion = tuple22._2$mcI$sp();
            if (!updateSucceeded) {
                throw new ControllerMovedException("Controller moved to another broker. Aborting controller startup procedure");
            }
            this.controllerContext().epochZkVersion_$eq(newVersion);
            this.controllerContext().epoch_$eq(newControllerEpoch);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new $anonfun$incrementControllerEpoch$3(this), (Function0<Throwable>)new $anonfun$incrementControllerEpoch$4(this, throwable));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            try {
                zkClient.createPersistent(ZkUtils$.MODULE$.ControllerEpochPath(), (Object)((Object)BoxesRunTime.boxToInteger((int)KafkaController$.MODULE$.InitialControllerEpoch())).toString());
                this.controllerContext().epoch_$eq(KafkaController$.MODULE$.InitialControllerEpoch());
                this.controllerContext().epochZkVersion_$eq(KafkaController$.MODULE$.InitialControllerEpochZkVersion());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new $anonfun$incrementControllerEpoch$1(this), (Function0<Throwable>)new $anonfun$incrementControllerEpoch$2(this, throwable));
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                throw new ControllerMovedException("Controller moved to another broker. Aborting controller startup procedure");
            }
        }
        this.info((Function0<String>)new $anonfun$incrementControllerEpoch$5(this));
    }

    public final void kafka$controller$KafkaController$$registerSessionExpirationListener() {
        this.zkClient.subscribeStateChanges((IZkStateListener)new SessionExpirationListener(this));
    }

    private void initializeControllerContext() {
        this.controllerContext().liveBrokers_$eq((scala.collection.Set<Broker>)ZkUtils$.MODULE$.getAllBrokersInCluster(this.zkClient).toSet());
        this.controllerContext().allTopics_$eq((scala.collection.Set<String>)ZkUtils$.MODULE$.getAllTopics(this.zkClient).toSet());
        this.controllerContext().partitionReplicaAssignment_$eq(ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.zkClient, (Seq<String>)this.controllerContext().allTopics().toSeq()));
        this.controllerContext().partitionLeadershipInfo_$eq((scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch>)new HashMap());
        this.controllerContext().shuttingDownBrokerIds_$eq((Set<Object>)scala.collection.mutable.Set$.MODULE$.empty());
        this.updateLeaderAndIsrCache();
        this.startChannelManager();
        this.initializePreferredReplicaElection();
        this.initializePartitionReassignment();
        this.initializeTopicDeletion();
        this.info((Function0<String>)new $anonfun$initializeControllerContext$1(this));
        this.info((Function0<String>)new $anonfun$initializeControllerContext$2(this));
        this.info((Function0<String>)new $anonfun$initializeControllerContext$3(this));
    }

    private void initializePreferredReplicaElection() {
        scala.collection.Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection$1 = ZkUtils$.MODULE$.getPartitionsUndergoingPreferredReplicaElection(this.zkClient);
        scala.collection.Set partitionsThatCompletedPreferredReplicaElection$1 = (scala.collection.Set)partitionsUndergoingPreferredReplicaElection$1.filter((Function1)new $anonfun$13(this));
        this.controllerContext().partitionsUndergoingPreferredReplicaElection().$plus$plus$eq(partitionsUndergoingPreferredReplicaElection$1);
        this.controllerContext().partitionsUndergoingPreferredReplicaElection().$minus$minus$eq((TraversableOnce)partitionsThatCompletedPreferredReplicaElection$1);
        this.info((Function0<String>)new $anonfun$initializePreferredReplicaElection$1(this, partitionsUndergoingPreferredReplicaElection$1));
        this.info((Function0<String>)new $anonfun$initializePreferredReplicaElection$2(this, partitionsThatCompletedPreferredReplicaElection$1));
        this.info((Function0<String>)new $anonfun$initializePreferredReplicaElection$3(this));
    }

    private void initializePartitionReassignment() {
        Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned$1 = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.zkClient);
        scala.collection.Iterable reassignedPartitions$1 = (scala.collection.Iterable)((TraversableLike)partitionsBeingReassigned$1.filter((Function1)new $anonfun$14(this))).map((Function1)new $anonfun$15(this), Iterable$.MODULE$.canBuildFrom());
        reassignedPartitions$1.foreach((Function1)new $anonfun$initializePartitionReassignment$1(this));
        ObjectRef partitionsToReassign$1 = new ObjectRef((Object)new HashMap());
        ((scala.collection.mutable.Map)partitionsToReassign$1.elem).$plus$plus$eq(partitionsBeingReassigned$1);
        ((scala.collection.mutable.Map)partitionsToReassign$1.elem).$minus$minus$eq((TraversableOnce)reassignedPartitions$1);
        this.controllerContext().partitionsBeingReassigned().$plus$plus$eq((TraversableOnce)((scala.collection.mutable.Map)partitionsToReassign$1.elem));
        this.info((Function0<String>)new $anonfun$initializePartitionReassignment$2(this, partitionsBeingReassigned$1));
        this.info((Function0<String>)new $anonfun$initializePartitionReassignment$3(this, reassignedPartitions$1));
        this.info((Function0<String>)new $anonfun$initializePartitionReassignment$4(this, partitionsToReassign$1));
    }

    private void initializeTopicDeletion() {
        scala.collection.immutable.Set topicsQueuedForDeletion$1 = ZkUtils$.MODULE$.getChildrenParentMayNotExist(this.zkClient, ZkUtils$.MODULE$.DeleteTopicsPath()).toSet();
        scala.collection.Set topicsWithReplicasOnDeadBrokers = (scala.collection.Set)((MapLike)this.controllerContext().partitionReplicaAssignment().filter((Function1)new $anonfun$16(this))).keySet().map((Function1)new $anonfun$17(this), Set$.MODULE$.canBuildFrom());
        Set topicsForWhichPartitionReassignmentIsInProgress = (Set)this.controllerContext().partitionsUndergoingPreferredReplicaElection().map((Function1)new $anonfun$18(this), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        scala.collection.Set topicsForWhichPreferredReplicaElectionIsInProgress = (scala.collection.Set)this.controllerContext().partitionsBeingReassigned().keySet().map((Function1)new $anonfun$19(this), Set$.MODULE$.canBuildFrom());
        scala.collection.Set topicsIneligibleForDeletion$1 = topicsWithReplicasOnDeadBrokers.$bar((scala.collection.Set)topicsForWhichPartitionReassignmentIsInProgress).$bar(topicsForWhichPreferredReplicaElectionIsInProgress);
        this.info((Function0<String>)new $anonfun$initializeTopicDeletion$1(this, topicsQueuedForDeletion$1));
        this.info((Function0<String>)new $anonfun$initializeTopicDeletion$2(this, topicsIneligibleForDeletion$1));
        this.deleteTopicManager_$eq(new TopicDeletionManager(this, (scala.collection.Set<String>)topicsQueuedForDeletion$1, (scala.collection.Set<String>)topicsIneligibleForDeletion$1));
    }

    private void maybeTriggerPartitionReassignment() {
        this.controllerContext().partitionsBeingReassigned().foreach((Function1)new $anonfun$maybeTriggerPartitionReassignment$1(this));
    }

    private void maybeTriggerPreferredReplicaElection() {
        this.onPreferredReplicaElection((scala.collection.Set<TopicAndPartition>)this.controllerContext().partitionsUndergoingPreferredReplicaElection().toSet(), this.onPreferredReplicaElection$default$2());
    }

    private void startChannelManager() {
        this.controllerContext().controllerChannelManager_$eq(new ControllerChannelManager(this.controllerContext(), this.config()));
        this.controllerContext().controllerChannelManager().startup();
    }

    private void updateLeaderAndIsrCache() {
        scala.collection.mutable.Map<TopicAndPartition, LeaderIsrAndControllerEpoch> leaderAndIsrInfo = ZkUtils$.MODULE$.getPartitionLeaderAndIsrForTopics(this.zkClient, (scala.collection.Set<TopicAndPartition>)this.controllerContext().partitionReplicaAssignment().keySet());
        leaderAndIsrInfo.foreach((Function1)new $anonfun$updateLeaderAndIsrCache$1(this));
    }

    private boolean areReplicasInIsr(String topic, int partition, Seq<Object> replicas) {
        Option<LeaderAndIsr> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    LeaderAndIsr leaderAndIsr;
                    option = ZkUtils$.MODULE$.getLeaderAndIsrForPartition(this.zkClient, topic, partition);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LeaderAndIsr leaderAndIsr$2 = leaderAndIsr = (LeaderAndIsr)some.x();
                    Seq replicasNotInIsr = (Seq)replicas.filterNot((Function1)new $anonfun$5(this, leaderAndIsr$2));
                    bl = replicasNotInIsr.isEmpty();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<LeaderAndIsr> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveReassignedPartitionLeaderIfRequired(TopicAndPartition topicAndPartition$6, ReassignedPartitionsContext reassignedPartitionContext) {
        Seq<Object> reassignedReplicas$2 = reassignedPartitionContext.newReplicas();
        int currentLeader$1 = ((LeaderIsrAndControllerEpoch)this.controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition$6)).leaderAndIsr().leader();
        Seq oldAndNewReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition$6);
        this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition$6, reassignedReplicas$2);
        if (reassignedPartitionContext.newReplicas().contains((Object)BoxesRunTime.boxToInteger((int)currentLeader$1))) {
            boolean bl = this.controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)currentLeader$1));
            if (bl) {
                this.info((Function0<String>)new $anonfun$moveReassignedPartitionLeaderIfRequired$2(this, topicAndPartition$6, reassignedReplicas$2, currentLeader$1));
                this.updateLeaderEpochAndSendRequest(topicAndPartition$6, (Seq<Object>)oldAndNewReplicas, reassignedReplicas$2);
                return;
            } else {
                if (bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                this.info((Function0<String>)new $anonfun$moveReassignedPartitionLeaderIfRequired$3(this, topicAndPartition$6, reassignedReplicas$2, currentLeader$1));
                this.partitionStateMachine().handleStateChanges((scala.collection.Set<TopicAndPartition>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition$6}))), OnlinePartition$.MODULE$, this.reassignedPartitionLeaderSelector(), this.partitionStateMachine().handleStateChanges$default$4());
            }
            return;
        } else {
            this.info((Function0<String>)new $anonfun$moveReassignedPartitionLeaderIfRequired$1(this, topicAndPartition$6, reassignedReplicas$2, currentLeader$1));
            this.partitionStateMachine().handleStateChanges((scala.collection.Set<TopicAndPartition>)((scala.collection.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{topicAndPartition$6}))), OnlinePartition$.MODULE$, this.reassignedPartitionLeaderSelector(), this.partitionStateMachine().handleStateChanges$default$4());
        }
    }

    private void stopOldReplicasOfReassignedPartition(TopicAndPartition topicAndPartition, ReassignedPartitionsContext reassignedPartitionContext, scala.collection.Set<Object> oldReplicas) {
        String topic$5 = topicAndPartition.topic();
        int partition$2 = topicAndPartition.partition();
        scala.collection.Set replicasToBeDeleted = (scala.collection.Set)oldReplicas.map((Function1)new $anonfun$20(this, topic$5, partition$2), Set$.MODULE$.canBuildFrom());
        this.replicaStateMachine().handleStateChanges((scala.collection.Set<PartitionAndReplica>)replicasToBeDeleted, OfflineReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        this.replicaStateMachine().handleStateChanges((scala.collection.Set<PartitionAndReplica>)replicasToBeDeleted, ReplicaDeletionStarted$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        this.replicaStateMachine().handleStateChanges((scala.collection.Set<PartitionAndReplica>)replicasToBeDeleted, ReplicaDeletionSuccessful$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        this.replicaStateMachine().handleStateChanges((scala.collection.Set<PartitionAndReplica>)replicasToBeDeleted, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
    }

    private void updateAssignedReplicasForPartition(TopicAndPartition topicAndPartition$4, Seq<Object> replicas$1) {
        scala.collection.mutable.Map partitionsAndReplicasForThisTopic = (scala.collection.mutable.Map)this.controllerContext().partitionReplicaAssignment().filter((Function1)new $anonfun$21(this, topicAndPartition$4));
        partitionsAndReplicasForThisTopic.put((Object)topicAndPartition$4, replicas$1);
        this.updateAssignedReplicasForPartition(topicAndPartition$4, (Map<TopicAndPartition, Seq<Object>>)partitionsAndReplicasForThisTopic);
        this.info((Function0<String>)new $anonfun$updateAssignedReplicasForPartition$1(this, topicAndPartition$4, replicas$1));
        this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition$4, replicas$1);
    }

    private void startNewReplicasForReassignedPartition(TopicAndPartition topicAndPartition$5, ReassignedPartitionsContext reassignedPartitionContext, scala.collection.Set<Object> newReplicas) {
        newReplicas.foreach((Function1)new $anonfun$startNewReplicasForReassignedPartition$1(this, topicAndPartition$5));
    }

    private void updateLeaderEpochAndSendRequest(TopicAndPartition topicAndPartition, Seq<Object> replicasToReceiveRequest, Seq<Object> newAssignedReplicas) {
        Option<LeaderIsrAndControllerEpoch> option;
        block4: {
            block3: {
                block2: {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                    this.kafka$controller$KafkaController$$brokerRequestBatch().newBatch();
                    option = this.updateLeaderEpoch(topicAndPartition.topic(), topicAndPartition.partition());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                    this.kafka$controller$KafkaController$$brokerRequestBatch().addLeaderAndIsrRequestForBrokers(replicasToReceiveRequest, topicAndPartition.topic(), topicAndPartition.partition(), updatedLeaderIsrAndControllerEpoch, newAssignedReplicas, (Function1<RequestOrResponse, BoxedUnit>)this.kafka$controller$KafkaController$$brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                    this.kafka$controller$KafkaController$$brokerRequestBatch().sendRequestsToBrokers(this.controllerContext().epoch(), this.controllerContext().correlationId().getAndIncrement());
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d sent LeaderAndIsr request %s with new assigned replica list %s to leader %d for partition being reassigned %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), BoxesRunTime.boxToInteger((int)this.controllerContext().epoch()), updatedLeaderIsrAndControllerEpoch, newAssignedReplicas.mkString(","), BoxesRunTime.boxToInteger((int)updatedLeaderIsrAndControllerEpoch.leaderAndIsr().leader()), topicAndPartition})));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<LeaderIsrAndControllerEpoch> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d failed to send LeaderAndIsr request with new assigned replica list %s to leader for partition being reassigned %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), BoxesRunTime.boxToInteger((int)this.controllerContext().epoch()), newAssignedReplicas.mkString(","), topicAndPartition})));
            }
            return;
        }
        throw new MatchError(option);
    }

    private void registerReassignedPartitionsListener() {
        this.zkClient.subscribeDataChanges(ZkUtils$.MODULE$.ReassignPartitionsPath(), (IZkDataListener)new PartitionsReassignedListener(this));
    }

    private void registerPreferredReplicaElectionListener() {
        this.zkClient.subscribeDataChanges(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath(), (IZkDataListener)new PreferredReplicaElectionListener(this));
    }

    private void registerControllerChangedListener() {
        this.zkClient.subscribeDataChanges(ZkUtils$.MODULE$.ControllerEpochPath(), (IZkDataListener)new ControllerEpochListener(this));
    }

    public void removePartitionFromReassignedPartitions(TopicAndPartition topicAndPartition) {
        if (this.controllerContext().partitionsBeingReassigned().get((Object)topicAndPartition).isDefined()) {
            this.zkClient.unsubscribeDataChanges(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), (IZkDataListener)((ReassignedPartitionsContext)this.controllerContext().partitionsBeingReassigned().apply((Object)topicAndPartition)).isrChangeListener());
        }
        Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned = ZkUtils$.MODULE$.getPartitionsBeingReassigned(this.zkClient);
        Map updatedPartitionsBeingReassigned = partitionsBeingReassigned.$minus((Object)topicAndPartition);
        ZkUtils$.MODULE$.updatePartitionReassignmentData(this.zkClient, (Map<TopicAndPartition, Seq<Object>>)updatedPartitionsBeingReassigned.mapValues((Function1)new $anonfun$removePartitionFromReassignedPartitions$1(this)));
        this.controllerContext().partitionsBeingReassigned().remove((Object)topicAndPartition);
    }

    public void updateAssignedReplicasForPartition(TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> newReplicaAssignmentForTopic) {
        try {
            String zkPath$1 = ZkUtils$.MODULE$.getTopicPath(topicAndPartition.topic());
            String jsonPartitionMap$1 = ZkUtils$.MODULE$.replicaAssignmentZkData((Map<String, Seq<Object>>)((Map)newReplicaAssignmentForTopic.map((Function1)new $anonfun$22(this), Map$.MODULE$.canBuildFrom())));
            ZkUtils$.MODULE$.updatePersistentPath(this.zkClient, zkPath$1, jsonPartitionMap$1);
            this.debug((Function0<String>)new $anonfun$updateAssignedReplicasForPartition$2(this, zkPath$1, jsonPartitionMap$1));
            return;
        }
        catch (Throwable throwable) {
            throw new KafkaException(throwable.toString());
        }
        catch (ZkNoNodeException zkNoNodeException) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("Topic %s doesn't exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic()})));
        }
    }

    public void removePartitionsFromPreferredReplicaElection(scala.collection.Set<TopicAndPartition> partitionsToBeRemoved, boolean isTriggeredByAutoRebalance) {
        partitionsToBeRemoved.foreach((Function1)new $anonfun$removePartitionsFromPreferredReplicaElection$1(this));
        Object object = isTriggeredByAutoRebalance ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)ZkUtils$.MODULE$.deletePath(this.zkClient, ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath()));
        this.controllerContext().partitionsUndergoingPreferredReplicaElection().$minus$minus$eq(partitionsToBeRemoved);
    }

    public void sendUpdateMetadataRequest(Seq<Object> brokers) {
        this.kafka$controller$KafkaController$$brokerRequestBatch().newBatch();
        this.kafka$controller$KafkaController$$brokerRequestBatch().addUpdateMetadataRequestForBrokers(brokers, (Function1<RequestOrResponse, BoxedUnit>)this.kafka$controller$KafkaController$$brokerRequestBatch().addUpdateMetadataRequestForBrokers$default$2());
        this.kafka$controller$KafkaController$$brokerRequestBatch().sendRequestsToBrokers(this.epoch(), this.controllerContext().correlationId().getAndIncrement());
    }

    public Option<LeaderIsrAndControllerEpoch> removeReplicaFromIsr(String topic, int partition, int replicaId$1) {
        Option<LeaderIsrAndControllerEpoch> option;
        TopicAndPartition topicAndPartition$8 = new TopicAndPartition(topic, partition);
        this.debug((Function0<String>)new $anonfun$removeReplicaFromIsr$1(this, replicaId$1, topicAndPartition$8));
        None$ finalLeaderIsrAndControllerEpoch = None$.MODULE$;
        boolean zkWriteCompleteOrUnnecessary = false;
        while (true) {
            boolean bl;
            if (zkWriteCompleteOrUnnecessary) {
                return finalLeaderIsrAndControllerEpoch;
            }
            Option<LeaderIsrAndControllerEpoch> leaderIsrAndEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient, topic, partition);
            option = leaderIsrAndEpochOpt;
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                Some some = (Some)option;
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                LeaderAndIsr leaderAndIsr$3 = leaderIsrAndEpoch.leaderAndIsr();
                int controllerEpoch = leaderIsrAndEpoch.controllerEpoch();
                if (controllerEpoch > this.epoch()) {
                    throw new StateChangeFailedException(new StringBuilder().append((Object)"Leader and isr path written by another controller. This probably").append((Object)Predef$.MODULE$.augmentString("means the current controller with epoch %d went through a soft failure and another ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.epoch())}))).append((Object)Predef$.MODULE$.augmentString("controller was elected with epoch %d. Aborting state change by this controller").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerEpoch)}))).toString());
                }
                if (leaderAndIsr$3.isr().contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1))) {
                    int newLeader = replicaId$1 == leaderAndIsr$3.leader() ? -1 : leaderAndIsr$3.leader();
                    LeaderAndIsr newLeaderAndIsr$1 = new LeaderAndIsr(newLeader, leaderAndIsr$3.leaderEpoch() + 1, (List<Object>)((List)leaderAndIsr$3.isr().filter((Function1)new $anonfun$6(this, replicaId$1))), leaderAndIsr$3.zkVersion() + 1);
                    Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient, ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr$1, this.epoch()), leaderAndIsr$3.zkVersion());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
                    int newVersion = tuple22._2$mcI$sp();
                    newLeaderAndIsr$1.zkVersion_$eq(newVersion);
                    finalLeaderIsrAndControllerEpoch = new Some((Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr$1, this.epoch()));
                    this.controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition$8, finalLeaderIsrAndControllerEpoch.get());
                    if (updateSucceeded) {
                        this.info((Function0<String>)new $anonfun$removeReplicaFromIsr$2(this, topicAndPartition$8, newLeaderAndIsr$1));
                    }
                    bl = updateSucceeded;
                } else {
                    this.warn((Function0<String>)new $anonfun$removeReplicaFromIsr$3(this, replicaId$1, topicAndPartition$8, leaderAndIsr$3));
                    finalLeaderIsrAndControllerEpoch = new Some((Object)new LeaderIsrAndControllerEpoch(leaderAndIsr$3, this.epoch()));
                    this.controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition$8, finalLeaderIsrAndControllerEpoch.get());
                    bl = true;
                }
            } else {
                None$ none$ = None$.MODULE$;
                Option<LeaderIsrAndControllerEpoch> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break;
                this.warn((Function0<String>)new $anonfun$removeReplicaFromIsr$4(this, replicaId$1, topicAndPartition$8));
                bl = true;
            }
            zkWriteCompleteOrUnnecessary = bl;
        }
        throw new MatchError(option);
    }

    private Option<LeaderIsrAndControllerEpoch> updateLeaderEpoch(String topic, int partition) {
        Option<LeaderIsrAndControllerEpoch> option;
        TopicAndPartition topicAndPartition$9 = new TopicAndPartition(topic, partition);
        this.debug((Function0<String>)new $anonfun$updateLeaderEpoch$1(this, topicAndPartition$9));
        None$ finalLeaderIsrAndControllerEpoch = None$.MODULE$;
        boolean zkWriteCompleteOrUnnecessary = false;
        while (true) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            if (zkWriteCompleteOrUnnecessary) {
                return finalLeaderIsrAndControllerEpoch;
            }
            Option<LeaderIsrAndControllerEpoch> leaderIsrAndEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkClient, topic, partition);
            option = leaderIsrAndEpochOpt;
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            LeaderIsrAndControllerEpoch leaderIsrAndEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
            LeaderAndIsr leaderAndIsr = leaderIsrAndEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndEpoch.controllerEpoch();
            if (controllerEpoch > this.epoch()) {
                throw new StateChangeFailedException(new StringBuilder().append((Object)"Leader and isr path written by another controller. This probably").append((Object)Predef$.MODULE$.augmentString("means the current controller with epoch %d went through a soft failure and another ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.epoch())}))).append((Object)Predef$.MODULE$.augmentString("controller was elected with epoch %d. Aborting state change by this controller").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)controllerEpoch)}))).toString());
            }
            LeaderAndIsr newLeaderAndIsr$2 = new LeaderAndIsr(leaderAndIsr.leader(), leaderAndIsr.leaderEpoch() + 1, leaderAndIsr.isr(), leaderAndIsr.zkVersion() + 1);
            Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient, ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr$2, this.epoch()), leaderAndIsr.zkVersion());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int newVersion = tuple22._2$mcI$sp();
            newLeaderAndIsr$2.zkVersion_$eq(newVersion);
            finalLeaderIsrAndControllerEpoch = new Some((Object)new LeaderIsrAndControllerEpoch(newLeaderAndIsr$2, this.epoch()));
            if (updateSucceeded) {
                this.info((Function0<String>)new $anonfun$updateLeaderEpoch$2(this, topicAndPartition$9, newLeaderAndIsr$2));
            }
            zkWriteCompleteOrUnnecessary = updateSucceeded;
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("Cannot update leader epoch for partition %s as leaderAndIsr path is empty. This could mean we somehow tried to reassign a partition that doesn't exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$9})));
        }
        throw new MatchError(option);
    }

    public final void kafka$controller$KafkaController$$checkAndTriggerPartitionRebalance() {
        if (this.isActive()) {
            this.trace((Function0<String>)new $anonfun$kafka$controller$KafkaController$$checkAndTriggerPartitionRebalance$2(this));
            ObjectRef preferredReplicasForTopicsByBrokers$1 = new ObjectRef(null);
            Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$kafka$controller$KafkaController$$checkAndTriggerPartitionRebalance$1(this, preferredReplicasForTopicsByBrokers$1));
            this.debug((Function0<String>)new $anonfun$kafka$controller$KafkaController$$checkAndTriggerPartitionRebalance$3(this, preferredReplicasForTopicsByBrokers$1));
            ((Map)preferredReplicasForTopicsByBrokers$1.elem).foreach((Function1)new $anonfun$kafka$controller$KafkaController$$checkAndTriggerPartitionRebalance$4(this));
        }
    }

    private final Iterable replicatedPartitionsBrokerLeads$1(int n) {
        return (Iterable)Utils$.MODULE$.inLock(this.controllerContext().controllerLock(), new $anonfun$replicatedPartitionsBrokerLeads$1$1(this, n));
    }

    public KafkaController(KafkaConfig config, ZkClient zkClient) {
        this.config = config;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Controller ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.kafka$controller$KafkaController$$isRunning = true;
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.controllerContext = new ControllerContext(zkClient, config.zkSessionTimeoutMs());
        this.partitionStateMachine = new PartitionStateMachine(this);
        this.replicaStateMachine = new ReplicaStateMachine(this);
        this.kafka$controller$KafkaController$$controllerElector = new ZookeeperLeaderElector(this.controllerContext(), ZkUtils$.MODULE$.ControllerPath(), (Function0<BoxedUnit>)new $anonfun$1(this), (Function0<BoxedUnit>)new $anonfun$2(this), config.brokerId());
        this.kafka$controller$KafkaController$$autoRebalanceScheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.init$default$2(), KafkaScheduler$.MODULE$.init$default$3());
        this.deleteTopicManager = null;
        this.offlinePartitionSelector = new OfflinePartitionLeaderSelector(this.controllerContext());
        this.reassignedPartitionLeaderSelector = new ReassignedPartitionLeaderSelector(this.controllerContext());
        this.preferredReplicaPartitionLeaderSelector = new PreferredReplicaPartitionLeaderSelector(this.controllerContext());
        this.kafka$controller$KafkaController$$controlledShutdownPartitionLeaderSelector = new ControlledShutdownLeaderSelector(this.controllerContext());
        this.kafka$controller$KafkaController$$brokerRequestBatch = new ControllerBrokerRequestBatch(this);
        this.registerControllerChangedListener();
        this.newGauge("ActiveControllerCount", new $anon$1(this));
        this.newGauge("OfflinePartitionsCount", new $anon$2(this));
        this.newGauge("PreferredReplicaImbalanceCount", new $anon$3(this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionExpirationListener
    implements IZkStateListener,
    Logging,
    ScalaObject {
        public final KafkaController $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
        }

        public void handleNewSession() throws Exception {
            this.info((Function0<String>)new SessionExpirationListener$$anonfun$handleNewSession$2(this));
            Utils$.MODULE$.inLock(this.kafka$controller$KafkaController$SessionExpirationListener$$$outer().controllerContext().controllerLock(), new SessionExpirationListener$$anonfun$handleNewSession$1(this));
        }

        public KafkaController kafka$controller$KafkaController$SessionExpirationListener$$$outer() {
            return this.$outer;
        }

        public SessionExpirationListener(KafkaController $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[SessionExpirationListener on ").append((Object)BoxesRunTime.boxToInteger((int)$outer.config().brokerId())).append((Object)"], ").toString());
        }
    }
}

