/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.OffsetRequest$;
import kafka.common.Config;
import kafka.common.Config$class;
import kafka.common.InvalidConfigException;
import kafka.consumer.ConsumerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsumerConfig$
implements Config,
ScalaObject {
    public static final ConsumerConfig$ MODULE$;
    private final int RefreshMetadataBackoffMs;
    private final int SocketTimeout;
    private final int SocketBufferSize;
    private final int FetchSize;
    private final int MaxFetchSize;
    private final int NumConsumerFetchers;
    private final int DefaultFetcherBackoffMs;
    private final boolean AutoCommit;
    private final int AutoCommitInterval;
    private final int MaxQueuedChunks;
    private final int MaxRebalanceRetries;
    private final String AutoOffsetReset;
    private final int ConsumerTimeoutMs;
    private final int MinFetchBytes;
    private final int MaxFetchWaitMs;
    private final String MirrorTopicsWhitelist;
    private final String MirrorTopicsBlacklist;
    private final int MirrorConsumerNumThreads;
    private final String MirrorTopicsWhitelistProp;
    private final String MirrorTopicsBlacklistProp;
    private final String MirrorConsumerNumThreadsProp;
    private final String DefaultClientId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerConfig$();
    }

    public int RefreshMetadataBackoffMs() {
        return this.RefreshMetadataBackoffMs;
    }

    public int SocketTimeout() {
        return this.SocketTimeout;
    }

    public int SocketBufferSize() {
        return this.SocketBufferSize;
    }

    public int FetchSize() {
        return this.FetchSize;
    }

    public int MaxFetchSize() {
        return this.MaxFetchSize;
    }

    public int NumConsumerFetchers() {
        return this.NumConsumerFetchers;
    }

    public int DefaultFetcherBackoffMs() {
        return this.DefaultFetcherBackoffMs;
    }

    public boolean AutoCommit() {
        return this.AutoCommit;
    }

    public int AutoCommitInterval() {
        return this.AutoCommitInterval;
    }

    public int MaxQueuedChunks() {
        return this.MaxQueuedChunks;
    }

    public int MaxRebalanceRetries() {
        return this.MaxRebalanceRetries;
    }

    public String AutoOffsetReset() {
        return this.AutoOffsetReset;
    }

    public int ConsumerTimeoutMs() {
        return this.ConsumerTimeoutMs;
    }

    public int MinFetchBytes() {
        return this.MinFetchBytes;
    }

    public int MaxFetchWaitMs() {
        return this.MaxFetchWaitMs;
    }

    public String MirrorTopicsWhitelist() {
        return this.MirrorTopicsWhitelist;
    }

    public String MirrorTopicsBlacklist() {
        return this.MirrorTopicsBlacklist;
    }

    public int MirrorConsumerNumThreads() {
        return this.MirrorConsumerNumThreads;
    }

    public String MirrorTopicsWhitelistProp() {
        return this.MirrorTopicsWhitelistProp;
    }

    public String MirrorTopicsBlacklistProp() {
        return this.MirrorTopicsBlacklistProp;
    }

    public String MirrorConsumerNumThreadsProp() {
        return this.MirrorConsumerNumThreadsProp;
    }

    public String DefaultClientId() {
        return this.DefaultClientId;
    }

    public void validate(ConsumerConfig config) {
        this.validateClientId(config.clientId());
        this.validateGroupId(config.groupId());
        this.validateAutoOffsetReset(config.autoOffsetReset());
    }

    public void validateClientId(String clientId) {
        this.validateChars("client.id", clientId);
    }

    public void validateGroupId(String groupId) {
        this.validateChars("group.id", groupId);
    }

    public void validateAutoOffsetReset(String autoOffsetReset) {
        block3: {
            block2: {
                String string;
                String string2 = string = autoOffsetReset;
                String string3 = OffsetRequest$.MODULE$.SmallestTimeString();
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = string;
                String string5 = OffsetRequest$.MODULE$.LargestTimeString();
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
            }
            return;
        }
        throw new InvalidConfigException(new StringBuilder().append((Object)"Wrong value ").append((Object)autoOffsetReset).append((Object)" of auto.offset.reset in ConsumerConfig; ").append((Object)"Valid values are ").append((Object)OffsetRequest$.MODULE$.SmallestTimeString()).append((Object)" and ").append((Object)OffsetRequest$.MODULE$.LargestTimeString()).toString());
    }

    private ConsumerConfig$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        Config$class.$init$(this);
        this.RefreshMetadataBackoffMs = 200;
        this.SocketTimeout = 30000;
        this.SocketBufferSize = 65536;
        this.FetchSize = 0x100000;
        this.MaxFetchSize = 10 * this.FetchSize();
        this.NumConsumerFetchers = 1;
        this.DefaultFetcherBackoffMs = 1000;
        this.AutoCommit = true;
        this.AutoCommitInterval = 60000;
        this.MaxQueuedChunks = 2;
        this.MaxRebalanceRetries = 4;
        this.AutoOffsetReset = OffsetRequest$.MODULE$.LargestTimeString();
        this.ConsumerTimeoutMs = -1;
        this.MinFetchBytes = 1;
        this.MaxFetchWaitMs = 100;
        this.MirrorTopicsWhitelist = "";
        this.MirrorTopicsBlacklist = "";
        this.MirrorConsumerNumThreads = 1;
        this.MirrorTopicsWhitelistProp = "mirror.topics.whitelist";
        this.MirrorTopicsBlacklistProp = "mirror.topics.blacklist";
        this.MirrorConsumerNumThreadsProp = "mirror.consumer.numthreads";
        this.DefaultClientId = "";
    }
}

