/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.IOException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0013A\u000b'\u000f^5uS>t'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nQ\u0001^8qS\u000e,\u0012!\n\t\u0003M%r!!H\u0014\n\u0005!r\u0012A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\u0010\t\u00115\u0002!\u0011!Q\u0001\n\u0015\na\u0001^8qS\u000e\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002cA\u0011QDM\u0005\u0003gy\u00111!\u00138u\u0011!)\u0004A!A!\u0002\u0013\t\u0014\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0003\u0002C\u001c\u0001\u0005\u0003\u0007I\u0011\u0001\u0019\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u0005:\u0001\t\u0005\r\u0011\"\u0001;\u0003U\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]0%KF$\"a\u000f \u0011\u0005ua\u0014BA\u001f\u001f\u0005\u0011)f.\u001b;\t\u000f}B\u0014\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005\u0003!\u0011!Q!\nE\n!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA!A1\t\u0001B\u0001B\u0003%A)\u0001\u0003uS6,\u0007CA\tF\u0013\t1%C\u0001\u0003US6,\u0007\u0002\u0003%\u0001\u0005\u000b\u0007I\u0011A%\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N\t\u000511/\u001a:wKJL!a\u0014'\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"A\u0011\u000b\u0001B\u0001B\u0003%!*A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u0019a\u0014N\\5u}Q1Qk\u0016-Z5n\u0003\"A\u0016\u0001\u000e\u0003\tAQa\t*A\u0002\u0015BQa\f*A\u0002EBQa\u000e*A\u0002EBQa\u0011*A\u0002\u0011CQ\u0001\u0013*A\u0002)Cq!\u0018\u0001C\u0002\u0013%\u0001'A\u0007m_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\u0007?\u0002\u0001\u000b\u0011B\u0019\u0002\u001d1|7-\u00197Ce>\\WM]%eA!9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017A\u00037pO6\u000bg.Y4feV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u0005\u0019An\\4\n\u0005!,'A\u0003'pO6\u000bg.Y4fe\"1!\u000e\u0001Q\u0001\n\r\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA!9A\u000e\u0001b\u0001\n\u0013i\u0017\u0001\u0003>l\u00072LWM\u001c;\u0016\u00039\u0004\"a\u001c<\u000e\u0003AT!!\u001d:\u0002\u0011i\\7\r\\5f]RT!a\u001d;\u0002\r%\u0003\u0014\n^3d\u0015\u0005)\u0018aA8sO&\u0011q\u000f\u001d\u0002\t5.\u001cE.[3oi\"1\u0011\u0010\u0001Q\u0001\n9\f\u0011B_6DY&,g\u000e\u001e\u0011\t\u000fm\u0004\u0001\u0019!C\u0001y\u0006\u0011B.Z1eKJ\u0014V\r\u001d7jG\u0006LEm\u00149u+\u0005i\bcA\u000f\u007fc%\u0011qP\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\r\u0001\u00011A\u0005\u0002\u0005\u0015\u0011A\u00067fC\u0012,'OU3qY&\u001c\u0017-\u00133PaR|F%Z9\u0015\u0007m\n9\u0001\u0003\u0005@\u0003\u0003\t\t\u00111\u0001~\u0011\u001d\tY\u0001\u0001Q!\nu\f1\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017\nZ(qi\u0002B\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\u0002\u001d%t7+\u001f8d%\u0016\u0004H.[2bgV\u0011\u00111\u0003\t\u0007\u0003+\tY\"a\b\u000e\u0005\u0005]!bAA\r=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0011q\u0003\u0002\u0004'\u0016$\bc\u0001,\u0002\"%\u0019\u00111\u0005\u0002\u0003\u000fI+\u0007\u000f\\5dC\"I\u0011q\u0005\u0001A\u0002\u0013\u0005\u0011\u0011F\u0001\u0013S:\u001c\u0016P\\2SKBd\u0017nY1t?\u0012*\u0017\u000fF\u0002<\u0003WA\u0011bPA\u0013\u0003\u0003\u0005\r!a\u0005\t\u0011\u0005=\u0002\u0001)Q\u0005\u0003'\tq\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7\u000f\t\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003k\t!#Y:tS\u001etW\r\u001a*fa2L7-Y'baV\u0011\u0011q\u0007\t\u0007#\u0005e\u0012'a\b\n\u0007\u0005m\"C\u0001\u0003Q_>d\u0007\u0002CA \u0001\u0001\u0006I!a\u000e\u0002'\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006l\u0015\r\u001d\u0011\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0013a\u00057fC\u0012,'/S:s+B$\u0017\r^3M_\u000e\\W#\u0001\u0005\t\u000f\u0005%\u0003\u0001)A\u0005\u0011\u0005!B.Z1eKJL5O]+qI\u0006$X\rT8dW\u0002B\u0001\"!\u0014\u0001\u0001\u0004%I\u0001M\u0001\nu.4VM]:j_:D\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\u0002\u001bi\\g+\u001a:tS>tw\fJ3r)\rY\u0014Q\u000b\u0005\t\u007f\u0005=\u0013\u0011!a\u0001c!9\u0011\u0011\f\u0001!B\u0013\t\u0014A\u0003>l-\u0016\u00148/[8oA!A\u0011Q\f\u0001A\u0002\u0013%\u0001'A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CA1\u0001\u0001\u0007I\u0011BA2\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fHcA\u001e\u0002f!Aq(a\u0018\u0002\u0002\u0003\u0007\u0011\u0007C\u0004\u0002j\u0001\u0001\u000b\u0015B\u0019\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\t\u0011\u00055\u0004\u00011A\u0005\nA\nqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\n1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$2aOA;\u0011!y\u0014qNA\u0001\u0002\u0004\t\u0004bBA=\u0001\u0001\u0006K!M\u0001\u0011G>tGO]8mY\u0016\u0014X\t]8dQ\u0002B\u0011\"! \u0001\u0005\u0004%I!a \u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!\u00027pORR'bAAFi\u00061\u0011\r]1dQ\u0016LA!a$\u0002\u0006\n1Aj\\4hKJD\u0001\"a%\u0001A\u0003%\u0011\u0011Q\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b\u0005C\u0004\u0002\u0018\u0002!I!!'\u0002\u001d%\u001c(+\u001a9mS\u000e\fGj\\2bYR!\u00111TAQ!\ri\u0012QT\u0005\u0004\u0003?s\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003G\u000b)\n1\u00012\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0004\u0002(\u0002!\t!!+\u0002#%\u001cXK\u001c3feJ+\u0007\u000f\\5dCR,G\r\u0006\u0002\u0002\u001c\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016AE4fi>\u00138I]3bi\u0016\u0014V\r\u001d7jG\u0006$B!a\b\u00022\"I\u00111UAV!\u0003\u0005\r!\r\u0005\b\u0003k\u0003A\u0011AA\\\u0003)9W\r\u001e*fa2L7-\u0019\u000b\u0005\u0003s\u000bY\f\u0005\u0003\u001e}\u0006}\u0001\"CAR\u0003g\u0003\n\u00111\u00012\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003\fA\u0003\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0017J\u001a'pG\u0006dGCAA]\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\fQ#\u00193e%\u0016\u0004H.[2b\u0013\u001atu\u000e^#ySN$8\u000f\u0006\u0003\u0002 \u0005%\u0007\u0002CAf\u0003\u0007\u0004\r!a\b\u0002\u000fI,\u0007\u000f\\5dC\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0017\u0001E1tg&<g.\u001a3SKBd\u0017nY1t)\t\t\u0019\u0002C\u0004\u0002V\u0002!\t!a6\u0002\u001bI,Wn\u001c<f%\u0016\u0004H.[2b)\rY\u0014\u0011\u001c\u0005\b\u0003G\u000b\u0019\u000e1\u00012\u0011\u001d\ti\u000e\u0001C\u0001\u0003?\fa\u0001Z3mKR,G#A\u001e\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\u0006qq-\u001a;MK\u0006$WM]#q_\u000eDG#A\u0019\t\u000f\u0005%\b\u0001\"\u0001\u0002l\u0006QQ.Y6f\u0019\u0016\fG-\u001a:\u0015\u0011\u0005m\u0015Q^Ay\u0005\u0003Aq!a<\u0002h\u0002\u0007\u0011'\u0001\u0007d_:$(o\u001c7mKJLE\r\u0003\u0005\u0002t\u0006\u001d\b\u0019AA{\u0003I\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016LeNZ8\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003\u007f\fIP\u0001\nQCJ$\u0018\u000e^5p]N#\u0018\r^3J]\u001a|\u0007b\u0002B\u0002\u0003O\u0004\r!M\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n\u0005aQ.Y6f\r>dGn\\<feRQ\u00111\u0014B\u0006\u0005\u001b\u0011yAa\u0007\t\u000f\u0005=(Q\u0001a\u0001c!A\u00111\u001fB\u0003\u0001\u0004\t)\u0010\u0003\u0005\u0003\u0012\t\u0015\u0001\u0019\u0001B\n\u0003\u001daW-\u00193feN\u0004b!!\u0006\u0002\u001c\tU\u0001c\u0001,\u0003\u0018%\u0019!\u0011\u0004\u0002\u0003\r\t\u0013xn[3s\u0011\u001d\u0011\u0019A!\u0002A\u0002EBqAa\b\u0001\t\u0003\u0011\t#A\u0010va\u0012\fG/\u001a'fC\u0012,'\u000fS,B]\u0012l\u0015-\u001f2f\u000bb\u0004\u0018M\u001c3JgJ$Ra\u000fB\u0012\u0005KAq!a)\u0003\u001e\u0001\u0007\u0011\u0007\u0003\u0005\u0003(\tu\u0001\u0019\u0001B\u0015\u0003\u0019ygMZ:fiB\u0019QDa\u000b\n\u0007\t5bD\u0001\u0003M_:<\u0007b\u0002B\u0019\u0001\u0011\u0005!1G\u0001\u001fG\",7m[#o_V<\u0007NU3qY&\u001c\u0017m\u001d*fC\u000eDwJ\u001a4tKR$bA!\u000e\u0003B\t\u0015\u0003cB\u000f\u00038\u0005m%1H\u0005\u0004\u0005sq\"A\u0002+va2,'\u0007E\u0002\u001e\u0005{I1Aa\u0010\u001f\u0005\u0015\u0019\u0006n\u001c:u\u0011!\u0011\u0019Ea\fA\u0002\t%\u0012A\u0004:fcVL'/\u001a3PM\u001a\u001cX\r\u001e\u0005\b\u0005\u000f\u0012y\u00031\u00012\u00031\u0011X-];je\u0016$\u0017iY6t\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001b\na#\\1zE\u0016Len\u0019:f[\u0016tG\u000fT3bI\u0016\u0014\bj\u0016\u000b\u0004w\t=\u0003\u0002\u0003B)\u0005\u0013\u0002\r!a\b\u0002\u001b1,\u0017\rZ3s%\u0016\u0004H.[2b\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/\na\"\\1zE\u0016\u001c\u0006N]5oW&\u001b(\u000fF\u0003<\u00053\u0012i\u0006\u0003\u0005\u0003\\\tM\u0003\u0019\u0001B\u0015\u0003M\u0011X\r\u001d7jG\u0006l\u0015\r\u001f'bORKW.Z't\u0011!\u0011yFa\u0015A\u0002\t%\u0012!\u0006:fa2L7-Y'bq2\u000bw-T3tg\u0006<Wm\u001d\u0005\b\u0005G\u0002A\u0011\u0001B3\u0003Q9W\r^(vi>37+\u001f8d%\u0016\u0004H.[2bgRA\u00111\u0003B4\u0005S\u0012i\u0007\u0003\u0005\u0003R\t\u0005\u0004\u0019AA\u0010\u0011!\u0011YG!\u0019A\u0002\t%\u0012\u0001E6fKBLenU=oGRKW.Z't\u0011!\u0011yG!\u0019A\u0002\t%\u0012AE6fKBLenU=oG6+7o]1hKNDqAa\u001d\u0001\t\u0003\u0011)(\u0001\fbaB,g\u000eZ'fgN\fw-Z:U_2+\u0017\rZ3s)\u0011\u00119Ha!\u0011\t\te$q\u0010\t\u0004I\nm\u0014b\u0001B?K\n\u0019Aj\\4\n\t\t\u0005%1\u0010\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u0011\t\u0015%\u0011\u000fa\u0001\u0005\u000f\u000b\u0001\"\\3tg\u0006<Wm\u001d\t\u0005\u0005\u0013\u0013y)\u0004\u0002\u0003\f*\u0019!Q\u0012\u0003\u0002\u000f5,7o]1hK&!!\u0011\u0013BF\u0005Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fi\"9!Q\u0013\u0001\u0005\n\t]\u0015!C;qI\u0006$X-S:s)\rY$\u0011\u0014\u0005\t\u00057\u0013\u0019\n1\u0001\u0002\u0014\u00051a.Z<JgJDqAa(\u0001\t\u0003\u0012\t+\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u0013\u0019\u000b\u0003\u0005\u0003&\nu\u0005\u0019\u0001BT\u0003\u0011!\b.\u0019;\u0011\u0007u\u0011I+C\u0002\u0003,z\u00111!\u00118z\u0011\u001d\u0011y\u000b\u0001C!\u0003K\f\u0001\u0002[1tQ\u000e{G-\u001a\u0005\b\u0005g\u0003A\u0011\tB[\u0003!!xn\u0015;sS:<G#A\u0013\t\u0013\te\u0006!%A\u0005\u0002\tm\u0016\u0001H4fi>\u00138I]3bi\u0016\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$H%M\u000b\u0003\u0005{S3!\rB`W\t\u0011\t\r\u0005\u0003\u0003D\n5WB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bf=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t='Q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003Bj\u0001E\u0005I\u0011\u0001B^\u0003Q9W\r\u001e*fa2L7-\u0019\u0013eK\u001a\fW\u000f\u001c;%c\u0001")
public class Partition
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final String topic;
    private final int partitionId;
    private int replicationFactor;
    public final Time kafka$cluster$Partition$$time;
    private final ReplicaManager replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager logManager;
    private final ZkClient zkClient;
    private Option<Object> leaderReplicaIdOpt;
    private Set<Replica> inSyncReplicas;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final Object leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private int leaderEpoch;
    private int controllerEpoch;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int n) {
        this.replicationFactor = n;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> option) {
        this.leaderReplicaIdOpt = option;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private Object leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    private void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int n) {
        this.leaderEpoch = n;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.kafka$cluster$Partition$$localBrokerId();
    }

    public boolean isUnderReplicated() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Boolean bl;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    bl = BoxesRunTime.boxToBoolean((this.inSyncReplicas().size() < this.assignedReplicas().size() ? 1 : 0) != 0);
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    bl = BoxesRunTime.boxToBoolean((boolean)false);
                }
                Boolean bl2 = bl;
                return BoxesRunTime.unboxToBoolean((Object)bl2);
            }
            throw new MatchError(option);
        }
    }

    public Replica getOrCreateReplica(int replicaId) {
        Option<Replica> option;
        block8: {
            Replica replica;
            block7: {
                Replica replica2;
                block6: {
                    Option<Replica> replicaOpt = this.getReplica(replicaId);
                    option = replicaOpt;
                    if (!(option instanceof Some)) break block6;
                    replica = (Replica)((Some)option).x();
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                if (this.isReplicaLocal(replicaId)) {
                    LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().toProps(), AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient(), this.topic()));
                    Log log = this.logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                    OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.replicaManager().highWatermarkCheckpoints().apply((Object)log.dir().getParent());
                    Map<TopicAndPartition, Object> offsetMap = checkpoint.read();
                    if (!offsetMap.contains((Object)new TopicAndPartition(this.topic(), this.partitionId()))) {
                        this.warn((Function0<String>)new $anonfun$getOrCreateReplica$1(this));
                    }
                    long offset = Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)new TopicAndPartition(this.topic(), this.partitionId()), (Function0)new $anonfun$1(this)))).min(log.logEndOffset());
                    Replica localReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, offset, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(localReplica);
                } else {
                    Replica remoteReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), (Option<Log>)Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(remoteReplica);
                }
                replica = (Replica)this.getReplica(replicaId).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Object> option;
            block6: {
                Option<Replica> option2;
                option = this.leaderReplicaIdOpt();
                if (option instanceof Some) {
                    option2 = BoxesRunTime.unboxToInt((Object)((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                    option2 = None$.MODULE$;
                }
                Option<Replica> option4 = option2;
                return option4;
            }
            throw new MatchError(option);
        }
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            this.liftedTree1$1();
            return;
        }
    }

    public int getLeaderEpoch() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            return this.leaderEpoch();
        }
    }

    public boolean makeLeader(int controllerId, PartitionStateInfo partitionStateInfo, int correlationId) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Set<Object> allReplicas = partitionStateInfo.allReplicas();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
            allReplicas.foreach((Function1)new $anonfun$makeLeader$2(this));
            scala.collection.immutable.Set newInSyncReplicas = ((TraversableOnce)leaderAndIsr.isr().map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom())).toSet();
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new $anonfun$makeLeader$3(this), Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new $anonfun$makeLeader$1(this));
            this.assignedReplicas().foreach((Function1)new $anonfun$makeLeader$4(this));
            this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
            this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
            this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
            this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())));
            this.maybeIncrementLeaderHW((Replica)this.getReplica(this.getReplica$default$1()).get());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean makeFollower(int controllerId, PartitionStateInfo partitionStateInfo, Set<Broker> leaders, int correlationId) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option option;
            block6: {
                Set<Object> allReplicas = partitionStateInfo.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                int newLeaderBrokerId$1 = leaderAndIsr.leader();
                this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                option = leaders.find((Function1)new $anonfun$makeFollower$2(this, newLeaderBrokerId$1));
                if (option instanceof Some) {
                    allReplicas.foreach((Function1)new $anonfun$makeFollower$3(this));
                    ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new $anonfun$makeFollower$4(this), Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new $anonfun$makeFollower$1(this));
                    this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
                    this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                    this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId$1)));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Broker %d aborted the become-follower state change with correlation id %d from controller %d epoch %d for partition [%s,%d] new leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)correlationId), BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)newLeaderBrokerId$1)})));
                }
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
            throw new MatchError((Object)option);
        }
    }

    public void updateLeaderHWAndMaybeExpandIsr(int replicaId$1, long offset$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            block7: {
                Option<Replica> option;
                block10: {
                    block9: {
                        BoxedUnit boxedUnit;
                        block8: {
                            Replica replica;
                            this.debug((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$1(this, replicaId$1, offset$1));
                            Option<Replica> replicaOpt = this.getReplica(replicaId$1);
                            if (!replicaOpt.isDefined()) break block7;
                            Replica replica2 = (Replica)replicaOpt.get();
                            replica2.logEndOffset_$eq(offset$1);
                            option = this.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block8;
                            Some some = (Some)option;
                            Replica leaderReplica = replica = (Replica)some.x();
                            Replica replica3 = (Replica)this.getReplica(replicaId$1).get();
                            long leaderHW = leaderReplica.highWatermark();
                            if (!this.inSyncReplicas().contains((Object)replica3) && ((SetLike)this.assignedReplicas().map((Function1)new $anonfun$updateLeaderHWAndMaybeExpandIsr$3(this), Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) && replica3.logEndOffset() >= leaderHW) {
                                Set newInSyncReplicas$1 = this.inSyncReplicas().$plus((Object)replica3);
                                this.info((Function0<String>)new $anonfun$updateLeaderHWAndMaybeExpandIsr$4(this, newInSyncReplicas$1));
                                this.updateIsr((Set<Replica>)newInSyncReplicas$1);
                                this.replicaManager().isrExpandRate().mark();
                            }
                            this.maybeIncrementLeaderHW(leaderReplica);
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            throw new NotAssignedReplicaException(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d for partition [%s,%d] since the replica %d is not recognized to be one of the assigned replicas %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId$1), BoxesRunTime.boxToLong((long)offset$1), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)replicaId$1), ((TraversableOnce)this.assignedReplicas().map((Function1)new $anonfun$updateLeaderHWAndMaybeExpandIsr$2(this), Set$.MODULE$.canBuildFrom())).mkString(","), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
        }
    }

    public Tuple2<Object, Object> checkEnoughReplicasReachOffset(long requiredOffset$1, int requiredAcks$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Tuple2 tuple2;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    int numAcks$1 = this.inSyncReplicas().count((Function1)new $anonfun$3(this, requiredOffset$1));
                    this.trace((Function0<String>)new $anonfun$checkEnoughReplicasReachOffset$1(this, requiredAcks$1, numAcks$1));
                    tuple2 = requiredAcks$1 < 0 && numAcks$1 >= this.inSyncReplicas().size() || requiredAcks$1 > 0 && numAcks$1 >= requiredAcks$1 ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
                }
                Tuple2 tuple22 = tuple2;
                return tuple22;
            }
            throw new MatchError(option);
        }
    }

    private void maybeIncrementLeaderHW(Replica leaderReplica) {
        long oldHighWatermark$1;
        Set allLogEndOffsets$1 = (Set)this.inSyncReplicas().map((Function1)new $anonfun$4(this), Set$.MODULE$.canBuildFrom());
        long newHighWatermark$1 = BoxesRunTime.unboxToLong((Object)allLogEndOffsets$1.min((Ordering)Ordering$Long$.MODULE$));
        if (newHighWatermark$1 > (oldHighWatermark$1 = leaderReplica.highWatermark())) {
            leaderReplica.highWatermark_$eq(newHighWatermark$1);
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$1(this, newHighWatermark$1));
        } else {
            this.debug((Function0<String>)new $anonfun$maybeIncrementLeaderHW$2(this, allLogEndOffsets$1, newHighWatermark$1, oldHighWatermark$1));
        }
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs, long replicaMaxLagMessages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        Replica replica = (Replica)some.x();
                        Replica leaderReplica = replica;
                        Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs, replicaMaxLagMessages);
                        if (outOfSyncReplicas.size() > 0) {
                            Set newInSyncReplicas$2 = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                            Predef$.MODULE$.assert(newInSyncReplicas$2.size() > 0);
                            this.info((Function0<String>)new $anonfun$maybeShrinkIsr$1(this, newInSyncReplicas$2));
                            this.updateIsr((Set<Replica>)newInSyncReplicas$2);
                            this.maybeIncrementLeaderHW(leaderReplica);
                            this.replicaManager().isrShrinkRate().mark();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long keepInSyncTimeMs$1, long keepInSyncMessages$1) {
        Set slowReplicas$1;
        long leaderLogEndOffset$1 = leaderReplica.logEndOffset();
        Set candidateReplicas = this.inSyncReplicas().$minus((Object)leaderReplica);
        Set stuckReplicas$1 = (Set)candidateReplicas.filter((Function1)new $anonfun$5(this, keepInSyncTimeMs$1));
        if (stuckReplicas$1.size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$1(this, stuckReplicas$1));
        }
        if ((slowReplicas$1 = (Set)candidateReplicas.filter((Function1)new $anonfun$6(this, keepInSyncMessages$1, leaderLogEndOffset$1))).size() > 0) {
            this.debug((Function0<String>)new $anonfun$getOutOfSyncReplicas$2(this, slowReplicas$1));
        }
        return (Set)stuckReplicas$1.$plus$plus((TraversableOnce)slowReplicas$1);
    }

    public Log.LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block5: {
                Replica replica;
                Option<Replica> leaderReplicaOpt;
                option = leaderReplicaOpt = this.leaderReplicaIfLocal();
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Replica leaderReplica = replica = (Replica)some.x();
                Log log = (Log)leaderReplica.log().get();
                Log.LogAppendInfo info = log.append(messages, true);
                this.maybeIncrementLeaderHW(leaderReplica);
                Log.LogAppendInfo logAppendInfo = info;
                return logAppendInfo;
            }
            None$ none$ = None$.MODULE$;
            Option<Replica> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
            }
            throw new MatchError(option);
        }
    }

    private void updateIsr(Set<Replica> newIsr$1) {
        this.debug((Function0<String>)new $anonfun$updateIsr$1(this, newIsr$1));
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr$1.map((Function1)new $anonfun$7(this), Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic(), this.partitionId()), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch()), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
        int newVersion = tuple22._2$mcI$sp();
        if (updateSucceeded) {
            this.inSyncReplicas_$eq(newIsr$1);
            this.kafka$cluster$Partition$$zkVersion_$eq(newVersion);
            this.trace((Function0<String>)new $anonfun$updateIsr$2(this, newIsr$1));
        } else {
            this.info((Function0<String>)new $anonfun$updateIsr$3(this));
        }
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            Partition other = (Partition)that;
            return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            StringBuilder partitionString = new StringBuilder();
            partitionString.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
            partitionString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
            partitionString.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
            partitionString.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.assignedReplicaMap().keys().mkString(",")).toString());
            partitionString.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new $anonfun$toString$1(this), Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
            String string = partitionString.toString();
            return string;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.logManager().deleteLog(new TopicAndPartition(this.topic(), this.partitionId()));
        }
        catch (IOException iOException) {
            this.fatal((Function0<String>)new $anonfun$liftedTree1$1$1(this), (Function0<Throwable>)new $anonfun$liftedTree1$1$2(this, iOException));
            Runtime.getRuntime().halt(1);
        }
    }

    public Partition(String topic, int partitionId, int replicationFactor, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.replicationFactor = replicationFactor;
        this.kafka$cluster$Partition$$time = time;
        this.replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.zkClient = replicaManager.zkClient();
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new Object();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge(new StringBuilder().append((Object)topic).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).append((Object)"-UnderReplicated").toString(), new $anon$1(this));
    }
}

