/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001}3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u0012!\u0006\u0014H/\u001b;j_:$\u0015\r^1TK:$'BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t!Y\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tqA\\3uo>\u00148.\u0003\u0002\u0016%\t!1+\u001a8e!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!Q1A\u0005\u0002y\t1\u0002]1si&$\u0018n\u001c8JIV\tq\u0004\u0005\u0002\u0018A%\u0011\u0011\u0005\u0007\u0002\u0004\u0013:$\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\nQ\u0002]1si&$\u0018n\u001c8ECR\fW#A\u0014\u0011\u0005!JS\"\u0001\u0002\n\u0005)\u0012!A\u0007$fi\u000eD'+Z:q_:\u001cX\rU1si&$\u0018n\u001c8ECR\f\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001dA\f'\u000f^5uS>tG)\u0019;bA!)a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"2\u0001M\u00193!\tA\u0003\u0001C\u0003\u001e[\u0001\u0007q\u0004C\u0003&[\u0001\u0007q\u0005C\u00045\u0001\t\u0007I\u0011\u0002\u0010\u0002\u00175,7o]1hKNK'0\u001a\u0005\u0007m\u0001\u0001\u000b\u0011B\u0010\u0002\u00195,7o]1hKNK'0\u001a\u0011\t\u000fa\u0002\u0001\u0019!C\u0005=\u0005\u0001R.Z:tC\u001e,7oU3oiNK'0\u001a\u0005\bu\u0001\u0001\r\u0011\"\u0003<\u0003QiWm]:bO\u0016\u001c8+\u001a8u'&TXm\u0018\u0013fcR\u0011Ah\u0010\t\u0003/uJ!A\u0010\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001f\n\t\u00111\u0001 \u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015B\u0010\u0002#5,7o]1hKN\u001cVM\u001c;TSj,\u0007\u0005C\u0004E\u0001\t\u0007I\u0011B#\u0002\r\t,hMZ3s+\u00051\u0005CA$K\u001b\u0005A%BA%\r\u0003\rq\u0017n\\\u0005\u0003\u0017\"\u0013!BQ=uK\n+hMZ3s\u0011\u0019i\u0005\u0001)A\u0005\r\u00069!-\u001e4gKJ\u0004\u0003\"B(\u0001\t\u0003\u0002\u0016\u0001C2p[BdW\r^3\u0016\u0003E\u0003\"a\u0006*\n\u0005MC\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006+\u0002!\tEV\u0001\boJLG/\u001a+p)\tyr\u000bC\u0003Y)\u0002\u0007\u0011,A\u0004dQ\u0006tg.\u001a7\u0011\u0005ikV\"A.\u000b\u0005qC\u0015\u0001C2iC:tW\r\\:\n\u0005y[&\u0001F$bi\",'/\u001b8h\u0005f$Xm\u00115b]:,G\u000e")
public class PartitionDataSend
implements Send,
ScalaObject {
    private final int partitionId;
    private final FetchResponsePartitionData partitionData;
    private final int messageSize;
    private int messagesSentSize;
    private final ByteBuffer buffer;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int partitionId() {
        return this.partitionId;
    }

    public FetchResponsePartitionData partitionData() {
        return this.partitionData;
    }

    private int messageSize() {
        return this.messageSize;
    }

    private int messagesSentSize() {
        return this.messagesSentSize;
    }

    private void messagesSentSize_$eq(int n) {
        this.messagesSentSize = n;
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean complete() {
        return !this.buffer().hasRemaining() && this.messagesSentSize() >= this.messageSize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int writeTo(GatheringByteChannel channel) {
        void var2_2;
        int written = 0;
        if (this.buffer().hasRemaining()) {
            written += channel.write(this.buffer());
        }
        if (!this.buffer().hasRemaining() && this.messagesSentSize() < this.messageSize()) {
            int bytesSent = this.partitionData().messages().writeTo(channel, this.messagesSentSize(), this.messageSize() - this.messagesSentSize());
            this.messagesSentSize_$eq(this.messagesSentSize() + bytesSent);
            written += bytesSent;
        }
        return (int)var2_2;
    }

    public PartitionDataSend(int partitionId, FetchResponsePartitionData partitionData) {
        this.partitionId = partitionId;
        this.partitionData = partitionData;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.messageSize = partitionData.messages().sizeInBytes();
        this.messagesSentSize = 0;
        this.buffer = ByteBuffer.allocate(4 + FetchResponsePartitionData$.MODULE$.headerSize());
        this.buffer().putInt(partitionId);
        this.buffer().putShort(partitionData.error());
        this.buffer().putLong(partitionData.hw());
        this.buffer().putInt(partitionData.messages().sizeInBytes());
        this.buffer().rewind();
    }
}

