/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.streams.tests.SystemTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=600L)
public class SystemTestUtilTest {
    private final Map<String, String> expectedParsedMap = new TreeMap<String, String>();

    @BeforeEach
    public void setUp() {
        this.expectedParsedMap.put("foo", "foo1");
        this.expectedParsedMap.put("bar", "bar1");
        this.expectedParsedMap.put("baz", "baz1");
    }

    @Test
    public void shouldParseCorrectMap() {
        String formattedConfigs = "foo=foo1,bar=bar1,baz=baz1";
        Map<String, String> parsedMap = SystemTestUtil.parseConfigs("foo=foo1,bar=bar1,baz=baz1");
        TreeMap<String, String> sortedParsedMap = new TreeMap<String, String>(parsedMap);
        Assertions.assertEquals(sortedParsedMap, this.expectedParsedMap);
    }

    @Test
    public void shouldThrowExceptionOnNull() {
        Assertions.assertThrows(NullPointerException.class, () -> SystemTestUtil.parseConfigs(null));
    }

    @Test
    public void shouldThrowExceptionIfNotCorrectKeyValueSeparator() {
        String badString = "foo:bar,baz:boo";
        Assertions.assertThrows(IllegalStateException.class, () -> SystemTestUtil.parseConfigs("foo:bar,baz:boo"));
    }

    @Test
    public void shouldThrowExceptionIfNotCorrectKeyValuePairSeparator() {
        String badString = "foo=bar;baz=boo";
        Assertions.assertThrows(IllegalStateException.class, () -> SystemTestUtil.parseConfigs("foo=bar;baz=boo"));
    }

    @Test
    public void shouldParseSingleKeyValuePairString() {
        HashMap<String, String> expectedSinglePairMap = new HashMap<String, String>();
        expectedSinglePairMap.put("foo", "bar");
        String singleValueString = "foo=bar";
        Map<String, String> parsedMap = SystemTestUtil.parseConfigs("foo=bar");
        Assertions.assertEquals(expectedSinglePairMap, parsedMap);
    }
}

