/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.assignment.AssignmentConfigs;
import org.apache.kafka.streams.processor.assignment.ProcessId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.HighAvailabilityTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockInternalTopicManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TaskAssignorConvergenceTest {
    private static Random random;
    private static final Time TIME;
    private int skewThreshold = 1;
    @Parameterized.Parameter
    public String rackAwareStrategy;

    @BeforeClass
    public static void beforeClass() {
        long seed = System.currentTimeMillis();
        System.out.println("Seed is " + seed);
        random = new Random(seed);
    }

    @Before
    public void setUp() {
        if (this.rackAwareStrategy.equals("balance_subtopology")) {
            this.skewThreshold = 4;
        }
    }

    @Parameterized.Parameters(name="rackAwareStrategy={0}")
    public static Collection<Object[]> getParamStoreType() {
        return Arrays.asList({"none"}, {"min_traffic"}, {"balance_subtopology"});
    }

    @Test
    public void staticAssignmentShouldConvergeWithTheFirstAssignment() {
        AssignmentConfigs configs = new AssignmentConfigs(100L, 2, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        Harness harness = Harness.initializeCluster(1, 1, 1, () -> 1, 1);
        TaskAssignorConvergenceTest.testForConvergence(harness, configs, 1);
        TaskAssignorConvergenceTest.verifyValidAssignment(0, harness);
        TaskAssignorConvergenceTest.verifyBalancedAssignment(harness, this.skewThreshold);
    }

    @Test
    public void assignmentShouldConvergeAfterAddingNode() {
        int numStatelessTasks = 7;
        int numStatefulTasks = 11;
        int maxWarmupReplicas = 2;
        boolean numStandbyReplicas = false;
        int numNodes = 10;
        AssignmentConfigs configs = new AssignmentConfigs(100L, 2, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        Harness harness = Harness.initializeCluster(7, 11, 1, () -> 5, 10);
        TaskAssignorConvergenceTest.testForConvergence(harness, configs, 1);
        harness.addClient();
        TaskAssignorConvergenceTest.testForConvergence(harness, configs, 6);
        TaskAssignorConvergenceTest.verifyValidAssignment(0, harness);
        if (!this.rackAwareStrategy.equals("min_traffic")) {
            TaskAssignorConvergenceTest.verifyBalancedAssignment(harness, this.skewThreshold);
        }
    }

    @Test
    public void droppingNodesShouldConverge() {
        int numStatelessTasks = 11;
        int numStatefulTasks = 13;
        int maxWarmupReplicas = 2;
        boolean numStandbyReplicas = false;
        int numNodes = 10;
        AssignmentConfigs configs = new AssignmentConfigs(100L, 2, 0, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
        Harness harness = Harness.initializeCluster(11, 13, 7, () -> 5, 10);
        TaskAssignorConvergenceTest.testForConvergence(harness, configs, 1);
        harness.dropClient();
        TaskAssignorConvergenceTest.testForConvergence(harness, configs, 8);
        TaskAssignorConvergenceTest.verifyValidAssignment(0, harness);
        if (!this.rackAwareStrategy.equals("min_traffic")) {
            TaskAssignorConvergenceTest.verifyBalancedAssignment(harness, this.skewThreshold);
        }
    }

    @Test
    public void randomClusterPerturbationsShouldConverge() {
        long deadline = System.currentTimeMillis() + 10000L;
        do {
            long seed = new Random().nextLong();
            this.runRandomizedScenario(seed);
        } while (System.currentTimeMillis() < deadline);
    }

    private void runRandomizedScenario(long seed) {
        Harness harness = null;
        try {
            Random prng = new Random(seed);
            int initialClusterSize = prng.nextInt(10) + 1;
            int numStatelessTasks = prng.nextInt(10) + 1;
            int numStatefulTasks = prng.nextInt(10) + 1;
            int maxWarmupReplicas = prng.nextInt(numStatefulTasks) + 1;
            int numStandbyReplicas = prng.nextInt(initialClusterSize + 1);
            int numNodes = numStatefulTasks + numStatelessTasks;
            int numberOfEvents = prng.nextInt(10) + 1;
            AssignmentConfigs configs = new AssignmentConfigs(100L, maxWarmupReplicas, numStandbyReplicas, 60000L, AssignmentTestUtils.EMPTY_RACK_AWARE_ASSIGNMENT_TAGS, null, null, this.rackAwareStrategy);
            harness = Harness.initializeCluster(numStatelessTasks, numStatefulTasks, initialClusterSize, () -> prng.nextInt(10) + 1, numNodes);
            TaskAssignorConvergenceTest.testForConvergence(harness, configs, 1);
            TaskAssignorConvergenceTest.verifyValidAssignment(numStandbyReplicas, harness);
            if (!this.rackAwareStrategy.equals("min_traffic")) {
                TaskAssignorConvergenceTest.verifyBalancedAssignment(harness, this.skewThreshold);
            }
            for (int i = 0; i < numberOfEvents; ++i) {
                int event = prng.nextInt(2);
                switch (event) {
                    case 0: {
                        harness.dropRandomClients(prng.nextInt(initialClusterSize), prng);
                        break;
                    }
                    case 1: {
                        harness.addOrResurrectClientsRandomly(prng, initialClusterSize);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected event: " + event);
                    }
                }
                if (harness.clientStates.isEmpty()) continue;
                TaskAssignorConvergenceTest.testForConvergence(harness, configs, 2 * (numStatefulTasks + numStatefulTasks * numStandbyReplicas));
                TaskAssignorConvergenceTest.verifyValidAssignment(numStandbyReplicas, harness);
                if (this.rackAwareStrategy.equals("min_traffic")) continue;
                TaskAssignorConvergenceTest.verifyBalancedAssignment(harness, this.skewThreshold);
            }
        }
        catch (AssertionError t) {
            throw new AssertionError("Assertion failed in randomized test. Reproduce with: `runRandomizedScenario(" + seed + ")`.", (Throwable)((Object)t));
        }
        catch (Throwable t) {
            StringBuilder builder = new StringBuilder().append("Exception in randomized scenario. Reproduce with: `runRandomizedScenario(").append(seed).append(")`. ");
            if (harness != null) {
                builder.append((CharSequence)harness.history);
            }
            throw new AssertionError(builder.toString(), t);
        }
    }

    private static void verifyBalancedAssignment(Harness harness, int skewThreshold) {
        Set<TaskId> allStatefulTasks = harness.statefulTaskEndOffsetSums.keySet();
        Map clientStates = harness.clientStates;
        StringBuilder failureContext = harness.history;
        AssignmentTestUtils.assertBalancedActiveAssignment(clientStates, failureContext);
        AssignmentTestUtils.assertBalancedStatefulAssignment(allStatefulTasks, clientStates, failureContext);
        AssignmentTestUtils.TaskSkewReport taskSkewReport = AssignmentTestUtils.analyzeTaskAssignmentBalance(harness.clientStates, skewThreshold);
        if (taskSkewReport.totalSkewedTasks() > 0) {
            Assert.fail((String)("Expected a balanced task assignment, but was: " + taskSkewReport + '\n' + failureContext));
        }
    }

    private static void verifyValidAssignment(int numStandbyReplicas, Harness harness) {
        Set<TaskId> statefulTasks = harness.statefulTaskEndOffsetSums.keySet();
        Set statelessTasks = harness.statelessTasks;
        Map assignedStates = harness.clientStates;
        StringBuilder failureContext = harness.history;
        AssignmentTestUtils.assertValidAssignment(numStandbyReplicas, statefulTasks, statelessTasks, assignedStates, failureContext);
    }

    private static void testForConvergence(Harness harness, AssignmentConfigs configs, int iterationLimit) {
        TreeSet allTasks = new TreeSet();
        allTasks.addAll(harness.statelessTasks);
        allTasks.addAll(harness.statefulTaskEndOffsetSums.keySet());
        harness.recordConfig(configs);
        boolean rebalancePending = true;
        int iteration = 0;
        RackAwareTaskAssignor rackAwareTaskAssignor = new RackAwareTaskAssignor(harness.fullMetadata, harness.partitionsForTask, harness.changelogPartitionsForTask, harness.tasksForTopicGroup, harness.racksForProcessConsumer, harness.internalTopicManager, configs, TIME);
        while (rebalancePending && iteration < iterationLimit) {
            harness.prepareForNextRebalance();
            harness.recordBefore(++iteration);
            rebalancePending = new HighAvailabilityTaskAssignor().assign(harness.clientStates, allTasks, harness.statefulTaskEndOffsetSums.keySet(), rackAwareTaskAssignor, configs);
            harness.recordAfter(iteration, rebalancePending);
        }
        if (rebalancePending) {
            StringBuilder message = new StringBuilder().append("Rebalances have not converged after iteration cutoff: ").append(iterationLimit).append((CharSequence)harness.history);
            Assert.fail((String)message.toString());
        }
    }

    static {
        TIME = new MockTime();
    }

    private static final class Harness {
        private final Set<TaskId> statelessTasks;
        private final Map<TaskId, Long> statefulTaskEndOffsetSums;
        private final Map<ProcessId, ClientState> clientStates;
        private final Map<ProcessId, ClientState> droppedClientStates;
        private final StringBuilder history = new StringBuilder();
        public final Map<TaskId, Set<TopicPartition>> partitionsForTask;
        public final Map<TaskId, Set<TopicPartition>> changelogPartitionsForTask;
        public final Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup;
        public final Cluster fullMetadata;
        public final Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer;
        public final InternalTopicManager internalTopicManager;

        private static Harness initializeCluster(int numStatelessTasks, int numStatefulTasks, int numClients, Supplier<Integer> partitionCountSupplier, int numNodes) {
            int subtopology = 0;
            TreeSet<TaskId> statelessTasks = new TreeSet<TaskId>();
            int remainingStatelessTasks = numStatelessTasks;
            List<Node> nodes = AssignmentTestUtils.getRandomNodes(numNodes);
            int nodeIndex = 0;
            HashSet<PartitionInfo> partitionInfoSet = new HashSet<PartitionInfo>();
            HashMap<TaskId, Set<TopicPartition>> partitionsForTask = new HashMap<TaskId, Set<TopicPartition>>();
            HashMap<TaskId, Set<TopicPartition>> changelogPartitionsForTask = new HashMap<TaskId, Set<TopicPartition>>();
            HashMap<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup = new HashMap<TopologyMetadata.Subtopology, Set<TaskId>>();
            while (remainingStatelessTasks > 0) {
                int partitions = Math.min(remainingStatelessTasks, partitionCountSupplier.get());
                for (int i = 0; i < partitions; ++i) {
                    TaskId taskId = new TaskId(subtopology, i);
                    statelessTasks.add(taskId);
                    --remainingStatelessTasks;
                    Node[] replica = AssignmentTestUtils.getRandomReplica(nodes, nodeIndex, i);
                    partitionInfoSet.add(new PartitionInfo("topic_" + subtopology, i, replica[0], replica, replica));
                    ++nodeIndex;
                    partitionsForTask.put(taskId, Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic_" + subtopology, i)}));
                    tasksForTopicGroup.computeIfAbsent(new TopologyMetadata.Subtopology(subtopology, null), k -> new HashSet()).add(taskId);
                }
                ++subtopology;
            }
            TreeMap<TaskId, Long> statefulTaskEndOffsetSums = new TreeMap<TaskId, Long>();
            HashMap<String, List> topicPartitionInfo = new HashMap<String, List>();
            HashSet<String> changelogNames = new HashSet<String>();
            int remainingStatefulTasks = numStatefulTasks;
            while (remainingStatefulTasks > 0) {
                String changelogTopicName = "changelog-topic_" + subtopology;
                changelogNames.add(changelogTopicName);
                int partitions = Math.min(remainingStatefulTasks, partitionCountSupplier.get());
                for (int i = 0; i < partitions; ++i) {
                    TaskId taskId = new TaskId(subtopology, i);
                    statefulTaskEndOffsetSums.put(taskId, 150000L);
                    --remainingStatefulTasks;
                    Node[] replica = AssignmentTestUtils.getRandomReplica(nodes, nodeIndex, i);
                    partitionInfoSet.add(new PartitionInfo("topic_" + subtopology, i, replica[0], replica, replica));
                    ++nodeIndex;
                    partitionsForTask.put(taskId, Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic_" + subtopology, i)}));
                    changelogPartitionsForTask.put(taskId, Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition(changelogTopicName, i)}));
                    tasksForTopicGroup.computeIfAbsent(new TopologyMetadata.Subtopology(subtopology, null), k -> new HashSet()).add(taskId);
                    int changelogNodeIndex = random.nextInt(nodes.size());
                    replica = AssignmentTestUtils.getRandomReplica(nodes, changelogNodeIndex, i);
                    TopicPartitionInfo info = new TopicPartitionInfo(i, replica[0], Arrays.asList(replica[0], replica[1]), Collections.emptyList());
                    topicPartitionInfo.computeIfAbsent(changelogTopicName, tp -> new ArrayList()).add(info);
                }
                ++subtopology;
            }
            MockTime time = new MockTime();
            StreamsConfig streamsConfig = new StreamsConfig(AssignmentTestUtils.configProps("min_traffic"));
            MockClientSupplier mockClientSupplier = new MockClientSupplier();
            MockInternalTopicManager mockInternalTopicManager = new MockInternalTopicManager((Time)time, streamsConfig, mockClientSupplier.restoreConsumer, false);
            InternalTopicManager spyTopicManager = (InternalTopicManager)Mockito.spy((Object)((Object)mockInternalTopicManager));
            ((InternalTopicManager)Mockito.doReturn(topicPartitionInfo).when((Object)spyTopicManager)).getTopicPartitionInfo(changelogNames);
            Cluster cluster = new Cluster("cluster", new HashSet<Node>(nodes), partitionInfoSet, Collections.emptySet(), Collections.emptySet());
            TreeMap<ProcessId, ClientState> clientStates = new TreeMap<ProcessId, ClientState>();
            HashMap<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer = new HashMap<ProcessId, Map<String, Optional<String>>>();
            for (int i = 0; i < numClients; ++i) {
                ProcessId uuid = AssignmentTestUtils.processIdForInt(i);
                clientStates.put(uuid, Harness.emptyInstance(uuid, statefulTaskEndOffsetSums));
                String rack = "rack" + random.nextInt(nodes.size());
                racksForProcessConsumer.put(uuid, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"consumer", Optional.of(rack))}));
            }
            return new Harness(statelessTasks, statefulTaskEndOffsetSums, clientStates, cluster, partitionsForTask, changelogPartitionsForTask, tasksForTopicGroup, racksForProcessConsumer, spyTopicManager);
        }

        private Harness(Set<TaskId> statelessTasks, Map<TaskId, Long> statefulTaskEndOffsetSums, Map<ProcessId, ClientState> clientStates, Cluster fullMetadata, Map<TaskId, Set<TopicPartition>> partitionsForTask, Map<TaskId, Set<TopicPartition>> changelogPartitionsForTask, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup, Map<ProcessId, Map<String, Optional<String>>> racksForProcessConsumer, InternalTopicManager internalTopicManager) {
            this.statelessTasks = statelessTasks;
            this.statefulTaskEndOffsetSums = statefulTaskEndOffsetSums;
            this.clientStates = clientStates;
            this.fullMetadata = fullMetadata;
            this.partitionsForTask = partitionsForTask;
            this.changelogPartitionsForTask = changelogPartitionsForTask;
            this.tasksForTopicGroup = tasksForTopicGroup;
            this.racksForProcessConsumer = racksForProcessConsumer;
            this.internalTopicManager = internalTopicManager;
            this.droppedClientStates = new TreeMap<ProcessId, ClientState>();
            this.history.append('\n');
            this.history.append("Cluster and application initial state: \n");
            this.history.append("Stateless tasks: ").append(statelessTasks).append('\n');
            this.history.append("Stateful tasks:  ").append(statefulTaskEndOffsetSums.keySet()).append('\n');
            this.history.append("Full metadata:  ").append(fullMetadata).append('\n');
            this.history.append("Partitions for tasks:  ").append(partitionsForTask).append('\n');
            this.history.append("Changelog partitions for tasks:  ").append(changelogPartitionsForTask).append('\n');
            this.history.append("Tasks for subtopology:  ").append(tasksForTopicGroup).append('\n');
            this.history.append("Racks for process consumer:  ").append(racksForProcessConsumer).append('\n');
            this.formatClientStates(true);
            this.history.append("History of the cluster: \n");
        }

        private void addClient() {
            ProcessId uuid = AssignmentTestUtils.processIdForInt(this.clientStates.size() + this.droppedClientStates.size());
            this.history.append("Adding new node ").append(uuid).append('\n');
            this.clientStates.put(uuid, Harness.emptyInstance(uuid, this.statefulTaskEndOffsetSums));
            int nodeSize = this.fullMetadata.nodes().size();
            String rack = "rack" + random.nextInt(nodeSize);
            this.racksForProcessConsumer.computeIfAbsent(uuid, k -> new HashMap()).put("consumer", Optional.of(rack));
        }

        private static ClientState emptyInstance(ProcessId uuid, Map<TaskId, Long> allTaskEndOffsetSums) {
            ClientState clientState = new ClientState(uuid, 1);
            clientState.computeTaskLags(uuid, allTaskEndOffsetSums);
            return clientState;
        }

        private void addOrResurrectClientsRandomly(Random prng, int limit) {
            int numberToAdd = prng.nextInt(limit);
            for (int i = 0; i < numberToAdd; ++i) {
                boolean addNew = prng.nextBoolean();
                if (addNew || this.droppedClientStates.isEmpty()) {
                    this.addClient();
                    continue;
                }
                ProcessId uuid = Harness.selectRandomElement(prng, this.droppedClientStates);
                this.history.append("Resurrecting node ").append(uuid).append('\n');
                this.clientStates.put(uuid, this.droppedClientStates.get(uuid));
                this.droppedClientStates.remove(uuid);
            }
        }

        private void dropClient() {
            if (this.clientStates.isEmpty()) {
                throw new NoSuchElementException("There are no nodes to drop");
            }
            ProcessId toDrop = this.clientStates.keySet().iterator().next();
            this.dropClient(toDrop);
        }

        private void dropRandomClients(int numNode, Random prng) {
            for (int dropped = 0; !this.clientStates.isEmpty() && dropped < numNode; ++dropped) {
                ProcessId toDrop = Harness.selectRandomElement(prng, this.clientStates);
                this.dropClient(toDrop);
            }
            this.history.append("Stateless tasks: ").append(this.statelessTasks).append('\n');
            this.history.append("Stateful tasks:  ").append(this.statefulTaskEndOffsetSums.keySet()).append('\n');
            this.formatClientStates(true);
        }

        private void dropClient(ProcessId toDrop) {
            ClientState clientState = this.clientStates.remove(toDrop);
            this.history.append("Dropping node ").append(toDrop).append(": ").append(clientState).append('\n');
            this.droppedClientStates.put(toDrop, clientState);
        }

        private static ProcessId selectRandomElement(Random prng, Map<ProcessId, ClientState> clients) {
            int dropIndex = prng.nextInt(clients.size());
            ProcessId toDrop = null;
            for (ProcessId uuid : clients.keySet()) {
                if (dropIndex == 0) {
                    toDrop = uuid;
                    break;
                }
                --dropIndex;
            }
            return toDrop;
        }

        private void prepareForNextRebalance() {
            TreeMap<ProcessId, ClientState> newClientStates = new TreeMap<ProcessId, ClientState>();
            for (Map.Entry<ProcessId, ClientState> entry : this.clientStates.entrySet()) {
                ProcessId uuid = entry.getKey();
                ClientState newClientState = new ClientState(uuid, 1);
                ClientState clientState = entry.getValue();
                TreeMap<TaskId, Long> taskOffsetSums = new TreeMap<TaskId, Long>();
                for (TaskId taskId : clientState.activeTasks()) {
                    if (!this.statefulTaskEndOffsetSums.containsKey(taskId)) continue;
                    taskOffsetSums.put(taskId, this.statefulTaskEndOffsetSums.get(taskId));
                }
                for (TaskId taskId : clientState.standbyTasks()) {
                    if (!this.statefulTaskEndOffsetSums.containsKey(taskId)) continue;
                    taskOffsetSums.put(taskId, this.statefulTaskEndOffsetSums.get(taskId));
                }
                newClientState.addPreviousActiveTasks(clientState.activeTasks());
                newClientState.addPreviousStandbyTasks(clientState.standbyTasks());
                newClientState.addPreviousTasksAndOffsetSums("consumer", taskOffsetSums);
                newClientState.computeTaskLags(uuid, this.statefulTaskEndOffsetSums);
                newClientStates.put(uuid, newClientState);
            }
            this.clientStates.clear();
            this.clientStates.putAll(newClientStates);
        }

        private void recordConfig(AssignmentConfigs configuration) {
            this.history.append("Creating assignor with configuration: ").append(configuration).append('\n');
        }

        private void recordBefore(int iteration) {
            this.history.append("Starting Iteration: ").append(iteration).append('\n');
            this.formatClientStates(false);
        }

        private void recordAfter(int iteration, boolean rebalancePending) {
            this.history.append("After assignment:  ").append(iteration).append('\n');
            this.history.append("Rebalance pending: ").append(rebalancePending).append('\n');
            this.formatClientStates(true);
            this.history.append('\n');
        }

        private void formatClientStates(boolean printUnassigned) {
            AssignmentTestUtils.appendClientStates(this.history, this.clientStates);
            if (printUnassigned) {
                TreeSet<TaskId> unassignedTasks = new TreeSet<TaskId>();
                unassignedTasks.addAll(this.statefulTaskEndOffsetSums.keySet());
                unassignedTasks.addAll(this.statelessTasks);
                for (Map.Entry<ProcessId, ClientState> entry : this.clientStates.entrySet()) {
                    unassignedTasks.removeAll(entry.getValue().assignedTasks());
                }
                this.history.append("Unassigned Tasks: ").append(unassignedTasks).append('\n');
            }
        }
    }
}

