/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.kstream.SessionWindowedDeserializer;
import org.apache.kafka.streams.kstream.SessionWindowedSerializer;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.TimeWindowedSerializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WindowedSerdesTest {
    private final String topic = "sample";

    @Test
    public void shouldWrapForTimeWindowedSerde() {
        Serde serde = WindowedSerdes.timeWindowedSerdeFrom(String.class, (long)Long.MAX_VALUE);
        Assertions.assertInstanceOf(TimeWindowedSerializer.class, (Object)serde.serializer());
        Assertions.assertInstanceOf(TimeWindowedDeserializer.class, (Object)serde.deserializer());
        Assertions.assertInstanceOf(StringSerializer.class, (Object)((TimeWindowedSerializer)serde.serializer()).innerSerializer());
        Assertions.assertInstanceOf(StringDeserializer.class, (Object)((TimeWindowedDeserializer)serde.deserializer()).innerDeserializer());
    }

    @Test
    public void shouldWrapForSessionWindowedSerde() {
        Serde serde = WindowedSerdes.sessionWindowedSerdeFrom(String.class);
        Assertions.assertInstanceOf(SessionWindowedSerializer.class, (Object)serde.serializer());
        Assertions.assertInstanceOf(SessionWindowedDeserializer.class, (Object)serde.deserializer());
        Assertions.assertInstanceOf(StringSerializer.class, (Object)((SessionWindowedSerializer)serde.serializer()).innerSerializer());
        Assertions.assertInstanceOf(StringDeserializer.class, (Object)((SessionWindowedDeserializer)serde.deserializer()).innerDeserializer());
    }

    @Test
    public void testTimeWindowSerdeFrom() {
        Windowed timeWindowed = new Windowed((Object)10, (Window)new TimeWindow(0L, Long.MAX_VALUE));
        Serde timeWindowedSerde = WindowedSerdes.timeWindowedSerdeFrom(Integer.class, (long)Long.MAX_VALUE);
        byte[] bytes = timeWindowedSerde.serializer().serialize("sample", (Object)timeWindowed);
        Windowed windowed = (Windowed)timeWindowedSerde.deserializer().deserialize("sample", bytes);
        Assertions.assertEquals((Object)timeWindowed, (Object)windowed);
    }

    @Test
    public void testSessionWindowedSerdeFrom() {
        Windowed sessionWindowed = new Windowed((Object)10, (Window)new SessionWindow(0L, 1L));
        Serde sessionWindowedSerde = WindowedSerdes.sessionWindowedSerdeFrom(Integer.class);
        byte[] bytes = sessionWindowedSerde.serializer().serialize("sample", (Object)sessionWindowed);
        Windowed windowed = (Windowed)sessionWindowedSerde.deserializer().deserialize("sample", bytes);
        Assertions.assertEquals((Object)sessionWindowed, (Object)windowed);
    }

    @Test
    public void timeWindowedSerializerShouldThrowNpeIfNotInitializedProperly() {
        TimeWindowedSerializer serializer = new TimeWindowedSerializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> serializer.serialize("topic", new Windowed((Object)new byte[0], (Window)new TimeWindow(0L, 1L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner serializer is `null`. User code must use constructor `TimeWindowedSerializer(final Serializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void timeWindowedSerializerShouldThrowNpeOnSerializingBaseKeyIfNotInitializedProperly() {
        TimeWindowedSerializer serializer = new TimeWindowedSerializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> serializer.serializeBaseKey("topic", new Windowed((Object)new byte[0], (Window)new TimeWindow(0L, 1L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner serializer is `null`. User code must use constructor `TimeWindowedSerializer(final Serializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void timeWindowedDeserializerShouldThrowNpeIfNotInitializedProperly() {
        TimeWindowedDeserializer deserializer = new TimeWindowedDeserializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> deserializer.deserialize("topic", new byte[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner deserializer is `null`. User code must use constructor `TimeWindowedDeserializer(final Deserializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void sessionWindowedSerializerShouldThrowNpeIfNotInitializedProperly() {
        SessionWindowedSerializer serializer = new SessionWindowedSerializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> serializer.serialize("topic", new Windowed((Object)new byte[0], (Window)new SessionWindow(0L, 0L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner serializer is `null`. User code must use constructor `SessionWindowedSerializer(final Serializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void sessionWindowedSerializerShouldThrowNpeOnSerializingBaseKeyIfNotInitializedProperly() {
        SessionWindowedSerializer serializer = new SessionWindowedSerializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> serializer.serializeBaseKey("topic", new Windowed((Object)new byte[0], (Window)new SessionWindow(0L, 0L))));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner serializer is `null`. User code must use constructor `SessionWindowedSerializer(final Serializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void sessionWindowedDeserializerShouldThrowNpeIfNotInitializedProperly() {
        SessionWindowedDeserializer deserializer = new SessionWindowedDeserializer();
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> deserializer.deserialize("topic", new byte[0]));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Inner deserializer is `null`. User code must use constructor `SessionWindowedDeserializer(final Deserializer<T> inner)` instead of the no-arg constructor."));
    }

    @Test
    public void timeWindowedSerializerShouldNotThrowOnCloseIfNotInitializedProperly() {
        new TimeWindowedSerializer().close();
    }

    @Test
    public void timeWindowedDeserializerShouldNotThrowOnCloseIfNotInitializedProperly() {
        new TimeWindowedDeserializer().close();
    }

    @Test
    public void sessionWindowedSerializerShouldNotThrowOnCloseIfNotInitializedProperly() {
        new SessionWindowedSerializer().close();
    }

    @Test
    public void sessionWindowedDeserializerShouldNotThrowOnCloseIfNotInitializedProperly() {
        new SessionWindowedDeserializer().close();
    }
}

