/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.BuiltInDslStoreSuppliers;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingVersionedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredVersionedKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class KeyValueStoreMaterializerTest {
    private static final String STORE_PREFIX = "prefix";
    private static final String STORE_NAME = "name";
    private static final String METRICS_SCOPE = "metricScope";
    @Mock
    private InternalNameProvider nameProvider;
    @Mock
    private KeyValueBytesStoreSupplier keyValueStoreSupplier;
    @Mock
    private VersionedBytesStoreSupplier versionedStoreSupplier;
    private final KeyValueStore<Bytes, byte[]> innerKeyValueStore = new InMemoryKeyValueStore("name");
    @Mock
    private VersionedBytesStore innerVersionedStore;
    @Mock
    private StreamsConfig streamsConfig;

    @Before
    public void setUp() {
        Mockito.when((Object)this.keyValueStoreSupplier.get()).thenReturn(this.innerKeyValueStore);
        Mockito.when((Object)this.keyValueStoreSupplier.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)this.keyValueStoreSupplier.metricsScope()).thenReturn((Object)METRICS_SCOPE);
        Mockito.when((Object)this.innerVersionedStore.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)this.versionedStoreSupplier.get()).thenReturn((Object)this.innerVersionedStore);
        Mockito.when((Object)this.versionedStoreSupplier.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)this.versionedStoreSupplier.metricsScope()).thenReturn((Object)METRICS_SCOPE);
        ((StreamsConfig)Mockito.doReturn(BuiltInDslStoreSuppliers.RocksDBDslStoreSuppliers.class).when((Object)this.streamsConfig)).getClass("dsl.store.suppliers.class");
    }

    @Test
    public void shouldCreateTimestampedBuilderWithCachingAndLoggingEnabledByDefault() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store"), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        StateStore logging = caching.wrapped();
        MatcherAssert.assertThat(store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateDefaultTimestampedBuilderWithCachingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateDefaultTimestampedBuilderWithLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withLoggingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching.wrapped(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateDefaultTimestampedBuilderWithCachingAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled().withLoggingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class)));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateTimestampedStoreWithProvidedSupplierAndCachingAndLoggingEnabledByDefault() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.keyValueStoreSupplier), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        StateStore logging = caching.wrapped();
        MatcherAssert.assertThat((Object)this.innerKeyValueStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat(store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateTimestampedStoreWithProvidedSupplierAndCachingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.keyValueStoreSupplier).withCachingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)this.innerKeyValueStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateTimestampedStoreWithProvidedSupplierAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.keyValueStoreSupplier).withLoggingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)this.innerKeyValueStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching.wrapped(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateTimestampedStoreWithProvidedSupplierAndCachingAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.keyValueStoreSupplier).withCachingDisabled().withLoggingDisabled(), this.nameProvider, STORE_PREFIX);
        TimestampedKeyValueStore<String, String> store = this.getTimestampedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)this.innerKeyValueStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class)));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateVersionedStoreWithProvidedSupplierAndLoggingEnabledByDefault() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.versionedStoreSupplier), this.nameProvider, STORE_PREFIX);
        VersionedKeyValueStore<String, String> store = this.getVersionedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        StateStore inner = logging.wrapped();
        MatcherAssert.assertThat((Object)this.innerVersionedStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat(store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingVersionedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)this.innerVersionedStore, (Matcher)Matchers.equalTo((Object)inner));
    }

    @Test
    public void shouldCreateVersionedStoreWithProvidedSupplierAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.versionedStoreSupplier).withLoggingDisabled(), this.nameProvider, STORE_PREFIX);
        VersionedKeyValueStore<String, String> store = this.getVersionedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        StateStore inner = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)this.innerVersionedStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat(store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        MatcherAssert.assertThat((Object)this.innerVersionedStore, (Matcher)Matchers.equalTo((Object)inner));
    }

    @Test
    public void shouldNotBuildVersionedStoreWithCachingEvenIfExplicitlySet() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)this.versionedStoreSupplier).withCachingEnabled(), this.nameProvider, STORE_PREFIX);
        VersionedKeyValueStore<String, String> store = this.getVersionedStore((MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>>)materialized);
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        StateStore inner = logging.wrapped();
        MatcherAssert.assertThat((Object)this.innerVersionedStore.name(), (Matcher)Matchers.equalTo((Object)store.name()));
        MatcherAssert.assertThat(store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingVersionedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)this.innerVersionedStore, (Matcher)Matchers.equalTo((Object)inner));
    }

    private TimestampedKeyValueStore<String, String> getTimestampedStore(MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>> materialized) {
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        materializer.configure(this.streamsConfig);
        return (TimestampedKeyValueStore)materializer.build();
    }

    private VersionedKeyValueStore<String, String> getVersionedStore(MaterializedInternal<String, String, KeyValueStore<Bytes, byte[]>> materialized) {
        KeyValueStoreMaterializer materializer = new KeyValueStoreMaterializer(materialized);
        materializer.configure(this.streamsConfig);
        return (VersionedKeyValueStore)materializer.build();
    }
}

