/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class MockInternalProcessorContext
extends MockProcessorContext
implements InternalProcessorContext<Object, Object> {
    private final Map<String, StateRestoreCallback> restoreCallbacks = new LinkedHashMap<String, StateRestoreCallback>();
    private ProcessorNode currentNode;
    private RecordCollector recordCollector;
    private long currentSystemTimeMs;
    private Task.TaskType taskType = Task.TaskType.ACTIVE;

    public MockInternalProcessorContext() {
    }

    public MockInternalProcessorContext(Properties config, TaskId taskId, File stateDir) {
        super(config, taskId, stateDir);
    }

    public void setSystemTimeMs(long timeMs) {
        this.currentSystemTimeMs = timeMs;
    }

    public long currentSystemTimeMs() {
        return this.currentSystemTimeMs;
    }

    public StreamsMetricsImpl metrics() {
        return (StreamsMetricsImpl)super.metrics();
    }

    public <K, V> void forward(Record<K, V> record) {
        this.forward(record.key(), record.value(), To.all().withTimestamp(record.timestamp()));
    }

    public <K, V> void forward(Record<K, V> record, String childName) {
        this.forward(record.key(), record.value(), To.child((String)childName).withTimestamp(record.timestamp()));
    }

    public ProcessorRecordContext recordContext() {
        return new ProcessorRecordContext(this.timestamp(), this.offset(), this.partition(), this.topic(), this.headers());
    }

    public Optional<RecordMetadata> recordMetadata() {
        return Optional.of(this.recordContext());
    }

    public void setRecordContext(ProcessorRecordContext recordContext) {
        this.setRecordMetadata(recordContext.topic(), recordContext.partition(), recordContext.offset(), recordContext.headers(), recordContext.timestamp());
    }

    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    public ProcessorNode currentNode() {
        return this.currentNode;
    }

    public ThreadCache cache() {
        return null;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }

    public RecordCollector recordCollector() {
        return this.recordCollector;
    }

    public void setRecordCollector(RecordCollector recordCollector) {
        this.recordCollector = recordCollector;
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallback) {
        this.restoreCallbacks.put(store.name(), stateRestoreCallback);
        super.register(store, stateRestoreCallback);
    }

    public StateRestoreCallback stateRestoreCallback(String storeName) {
        return this.restoreCallbacks.get(storeName);
    }

    public Task.TaskType taskType() {
        return this.taskType;
    }

    public void logChange(String storeName, Bytes key, byte[] value, long timestamp) {
    }

    public void transitionToActive(StreamTask streamTask, RecordCollector recordCollector, ThreadCache newCache) {
    }

    public void transitionToStandby(ThreadCache newCache) {
    }

    public void registerCacheFlushListener(String namespace, ThreadCache.DirtyEntryFlushListener listener) {
    }

    public String changelogFor(String storeName) {
        return "mock-changelog";
    }
}

