/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import org.apache.kafka.streams.EqualityCheck;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowsTest {
    @Test
    public void shouldSetWindowGap() {
        long anyGap = 42L;
        long anyGrace = 1024L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with((Duration)Duration.ofMillis(42L)).inactivityGap());
        Assert.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(42L)).inactivityGap());
        Assert.assertEquals((long)42L, (long)SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(42L), (Duration)Duration.ofMillis(1024L)).inactivityGap());
    }

    @Test
    public void shouldSetWindowGraceTime() {
        long anyRetentionTime = 42L;
        Assert.assertEquals((long)42L, (long)SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(42L)).gracePeriodMs());
    }

    @Test
    public void gracePeriodShouldEnforceBoundaries() {
        SessionWindows.with((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(0L));
        try {
            SessionWindows.with((Duration)Duration.ofMillis(3L)).grace(Duration.ofMillis(-1L));
            Assert.fail((String)"should not accept negatives");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void oldAPIShouldSetDefaultGracePeriod() {
        Assert.assertEquals((long)Duration.ofDays(1L).toMillis(), (long)86400000L);
        Assert.assertEquals((long)86399997L, (long)SessionWindows.with((Duration)Duration.ofMillis(3L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.with((Duration)Duration.ofMillis(86400000L)).gracePeriodMs());
        Assert.assertEquals((long)0L, (long)SessionWindows.with((Duration)Duration.ofMillis(86400001L)).gracePeriodMs());
    }

    @Test
    public void windowSizeMustNotBeNegative() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SessionWindows.with((Duration)Duration.ofMillis(-1L)));
    }

    @Test
    public void windowSizeMustNotBeZero() {
        Assert.assertThrows(IllegalArgumentException.class, () -> SessionWindows.with((Duration)Duration.ofMillis(0L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForPositiveCases() {
        EqualityCheck.verifyEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)), SessionWindows.with((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(11L)));
        EqualityCheck.verifyEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)));
        EqualityCheck.verifyEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(7L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(7L)));
        EqualityCheck.verifyEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)).grace(Duration.ofMillis(7L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)).grace(Duration.ofMillis(7L)));
    }

    @Test
    public void equalsAndHashcodeShouldBeValidForNegativeCases() {
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(9L), (Duration)Duration.ofMillis(9L)), SessionWindows.ofInactivityGapAndGrace((Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(9L)));
        EqualityCheck.verifyInEquality(SessionWindows.with((Duration)Duration.ofMillis(9L)), SessionWindows.with((Duration)Duration.ofMillis(1L)));
        EqualityCheck.verifyInEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(9L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)));
        EqualityCheck.verifyInEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(9L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(7L)));
        EqualityCheck.verifyInEquality(SessionWindows.with((Duration)Duration.ofMillis(2L)).grace(Duration.ofMillis(6L)).grace(Duration.ofMillis(7L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)));
        EqualityCheck.verifyInEquality(SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(0L)).grace(Duration.ofMillis(7L)), SessionWindows.with((Duration)Duration.ofMillis(1L)).grace(Duration.ofMillis(6L)));
    }
}

