/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.utils.MockTime;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.utils.EmbeddedKafkaCluster;
import org.apache.kafka.streams.integration.utils.IntegrationTestUtils;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={IntegrationTest.class})
public class GlobalKTableIntegrationTest {
    private static final int NUM_BROKERS = 1;
    public static final EmbeddedKafkaCluster CLUSTER = new EmbeddedKafkaCluster(1);
    private final MockTime mockTime;
    private final KeyValueMapper<String, Long, Long> keyMapper;
    private final ValueJoiner<Long, String, String> joiner;
    private final String globalStore = "globalStore";
    private StreamsBuilder builder;
    private Properties streamsConfiguration;
    private KafkaStreams kafkaStreams;
    private String globalTableTopic;
    private String streamTopic;
    private GlobalKTable<Long, String> globalTable;
    private KStream<String, Long> stream;
    private MockProcessorSupplier<String, String> supplier;
    @Rule
    public TestName testName;

    public GlobalKTableIntegrationTest() {
        this.mockTime = GlobalKTableIntegrationTest.CLUSTER.time;
        this.keyMapper = (key, value) -> value;
        this.joiner = (value1, value2) -> value1 + "+" + value2;
        this.globalStore = "globalStore";
        this.testName = new TestName();
    }

    @BeforeClass
    public static void startCluster() throws IOException {
        CLUSTER.start();
    }

    @AfterClass
    public static void closeCluster() {
        CLUSTER.stop();
    }

    @Before
    public void before() throws Exception {
        this.builder = new StreamsBuilder();
        this.createTopics();
        this.streamsConfiguration = new Properties();
        String safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        this.streamsConfiguration.put("application.id", "app-" + safeTestName);
        this.streamsConfiguration.put("bootstrap.servers", CLUSTER.bootstrapServers());
        this.streamsConfiguration.put("auto.offset.reset", "earliest");
        this.streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        this.streamsConfiguration.put("cache.max.bytes.buffering", (Object)0);
        this.streamsConfiguration.put("commit.interval.ms", (Object)100L);
        this.globalTable = this.builder.globalTable(this.globalTableTopic, Consumed.with((Serde)Serdes.Long(), (Serde)Serdes.String()), Materialized.as((String)"globalStore").withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()));
        Consumed stringLongConsumed = Consumed.with((Serde)Serdes.String(), (Serde)Serdes.Long());
        this.stream = this.builder.stream(this.streamTopic, stringLongConsumed);
        this.supplier = new MockProcessorSupplier();
    }

    @After
    public void whenShuttingDown() throws Exception {
        if (this.kafkaStreams != null) {
            this.kafkaStreams.close();
        }
        IntegrationTestUtils.purgeLocalStreamsState(this.streamsConfiguration);
    }

    @Test
    public void shouldKStreamGlobalKTableLeftJoin() throws Exception {
        KStream streamTableJoin = this.stream.leftJoin(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.process(this.supplier, new String[0]);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        long firstTimestamp = this.mockTime.milliseconds();
        this.produceTopicValues(this.streamTopic);
        HashMap<String, ValueAndTimestamp> expected = new HashMap<String, ValueAndTimestamp>();
        expected.put("a", ValueAndTimestamp.make((Object)"1+A", (long)firstTimestamp));
        expected.put("b", ValueAndTimestamp.make((Object)"2+B", (long)(firstTimestamp + 1L)));
        expected.put("c", ValueAndTimestamp.make((Object)"3+C", (long)(firstTimestamp + 2L)));
        expected.put("d", ValueAndTimestamp.make((Object)"4+D", (long)(firstTimestamp + 3L)));
        expected.put("e", ValueAndTimestamp.make((Object)"5+null", (long)(firstTimestamp + 4L)));
        TestUtils.waitForCondition(() -> {
            if (this.supplier.capturedProcessorsCount() < 2) {
                return false;
            }
            HashMap<String, ValueAndTimestamp<String>> result = new HashMap<String, ValueAndTimestamp<String>>();
            result.putAll(this.supplier.capturedProcessors(2).get(0).lastValueAndTimestampPerKey());
            result.putAll(this.supplier.capturedProcessors(2).get(1).lastValueAndTimestampPerKey());
            return result.equals(expected);
        }, (long)30000L, (String)"waiting for initial values");
        firstTimestamp = this.mockTime.milliseconds();
        this.produceGlobalTableValues();
        ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.keyValueStore());
        Assert.assertNotNull((Object)replicatedStore);
        HashMap<Long, String> expectedState = new HashMap<Long, String>();
        expectedState.put(1L, "F");
        expectedState.put(2L, "G");
        expectedState.put(3L, "H");
        expectedState.put(4L, "I");
        expectedState.put(5L, "J");
        HashMap globalState = new HashMap();
        TestUtils.waitForCondition(() -> {
            globalState.clear();
            replicatedStore.all().forEachRemaining(pair -> {
                String cfr_ignored_0 = (String)globalState.put(pair.key, pair.value);
            });
            return globalState.equals(expectedState);
        }, (long)30000L, () -> "waiting for data in replicated store\n  expected: " + expectedState + "\n  received: " + globalState);
        ReadOnlyKeyValueStore replicatedStoreWithTimestamp = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertNotNull((Object)replicatedStoreWithTimestamp);
        MatcherAssert.assertThat((Object)replicatedStoreWithTimestamp.get((Object)5L), (Matcher)IsEqual.equalTo((Object)ValueAndTimestamp.make((Object)"J", (long)(firstTimestamp + 4L))));
        firstTimestamp = this.mockTime.milliseconds();
        this.produceTopicValues(this.streamTopic);
        expected.put("a", ValueAndTimestamp.make((Object)"1+F", (long)firstTimestamp));
        expected.put("b", ValueAndTimestamp.make((Object)"2+G", (long)(firstTimestamp + 1L)));
        expected.put("c", ValueAndTimestamp.make((Object)"3+H", (long)(firstTimestamp + 2L)));
        expected.put("d", ValueAndTimestamp.make((Object)"4+I", (long)(firstTimestamp + 3L)));
        expected.put("e", ValueAndTimestamp.make((Object)"5+J", (long)(firstTimestamp + 4L)));
        TestUtils.waitForCondition(() -> {
            if (this.supplier.capturedProcessorsCount() < 2) {
                return false;
            }
            HashMap<String, ValueAndTimestamp<String>> result = new HashMap<String, ValueAndTimestamp<String>>();
            result.putAll(this.supplier.capturedProcessors(2).get(0).lastValueAndTimestampPerKey());
            result.putAll(this.supplier.capturedProcessors(2).get(1).lastValueAndTimestampPerKey());
            return result.equals(expected);
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldKStreamGlobalKTableJoin() throws Exception {
        KStream streamTableJoin = this.stream.join(this.globalTable, this.keyMapper, this.joiner);
        streamTableJoin.process(this.supplier, new String[0]);
        this.produceInitialGlobalTableValues();
        this.startStreams();
        long firstTimestamp = this.mockTime.milliseconds();
        this.produceTopicValues(this.streamTopic);
        HashMap<String, ValueAndTimestamp> expected = new HashMap<String, ValueAndTimestamp>();
        expected.put("a", ValueAndTimestamp.make((Object)"1+A", (long)firstTimestamp));
        expected.put("b", ValueAndTimestamp.make((Object)"2+B", (long)(firstTimestamp + 1L)));
        expected.put("c", ValueAndTimestamp.make((Object)"3+C", (long)(firstTimestamp + 2L)));
        expected.put("d", ValueAndTimestamp.make((Object)"4+D", (long)(firstTimestamp + 3L)));
        TestUtils.waitForCondition(() -> {
            if (this.supplier.capturedProcessorsCount() < 2) {
                return false;
            }
            HashMap<String, ValueAndTimestamp<String>> result = new HashMap<String, ValueAndTimestamp<String>>();
            result.putAll(this.supplier.capturedProcessors(2).get(0).lastValueAndTimestampPerKey());
            result.putAll(this.supplier.capturedProcessors(2).get(1).lastValueAndTimestampPerKey());
            return result.equals(expected);
        }, (long)30000L, (String)"waiting for initial values");
        firstTimestamp = this.mockTime.milliseconds();
        this.produceGlobalTableValues();
        ReadOnlyKeyValueStore replicatedStore = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.keyValueStore());
        Assert.assertNotNull((Object)replicatedStore);
        HashMap<Long, String> expectedState = new HashMap<Long, String>();
        expectedState.put(1L, "F");
        expectedState.put(2L, "G");
        expectedState.put(3L, "H");
        expectedState.put(4L, "I");
        expectedState.put(5L, "J");
        HashMap globalState = new HashMap();
        TestUtils.waitForCondition(() -> {
            globalState.clear();
            replicatedStore.all().forEachRemaining(pair -> {
                String cfr_ignored_0 = (String)globalState.put(pair.key, pair.value);
            });
            return globalState.equals(expectedState);
        }, (long)30000L, () -> "waiting for data in replicated store\n  expected: " + expectedState + "\n  received: " + globalState);
        ReadOnlyKeyValueStore replicatedStoreWithTimestamp = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertNotNull((Object)replicatedStoreWithTimestamp);
        MatcherAssert.assertThat((Object)replicatedStoreWithTimestamp.get((Object)5L), (Matcher)IsEqual.equalTo((Object)ValueAndTimestamp.make((Object)"J", (long)(firstTimestamp + 4L))));
        firstTimestamp = this.mockTime.milliseconds();
        this.produceTopicValues(this.streamTopic);
        expected.put("a", ValueAndTimestamp.make((Object)"1+F", (long)firstTimestamp));
        expected.put("b", ValueAndTimestamp.make((Object)"2+G", (long)(firstTimestamp + 1L)));
        expected.put("c", ValueAndTimestamp.make((Object)"3+H", (long)(firstTimestamp + 2L)));
        expected.put("d", ValueAndTimestamp.make((Object)"4+I", (long)(firstTimestamp + 3L)));
        expected.put("e", ValueAndTimestamp.make((Object)"5+J", (long)(firstTimestamp + 4L)));
        TestUtils.waitForCondition(() -> {
            if (this.supplier.capturedProcessorsCount() < 2) {
                return false;
            }
            HashMap<String, ValueAndTimestamp<String>> result = new HashMap<String, ValueAndTimestamp<String>>();
            result.putAll(this.supplier.capturedProcessors(2).get(0).lastValueAndTimestampPerKey());
            result.putAll(this.supplier.capturedProcessors(2).get(1).lastValueAndTimestampPerKey());
            return result.equals(expected);
        }, (long)30000L, (String)"waiting for final values");
    }

    @Test
    public void shouldRestoreGlobalInMemoryKTableOnRestart() throws Exception {
        this.builder = new StreamsBuilder();
        this.globalTable = this.builder.globalTable(this.globalTableTopic, Consumed.with((Serde)Serdes.Long(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"globalStore")));
        this.produceInitialGlobalTableValues();
        this.startStreams();
        ReadOnlyKeyValueStore store = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.keyValueStore());
        Assert.assertNotNull((Object)store);
        MatcherAssert.assertThat((Object)store.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
        ReadOnlyKeyValueStore timestampedStore = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.timestampedKeyValueStore());
        Assert.assertNotNull((Object)timestampedStore);
        MatcherAssert.assertThat((Object)timestampedStore.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
        this.kafkaStreams.close();
        this.startStreams();
        store = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.keyValueStore());
        MatcherAssert.assertThat((Object)store.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
        timestampedStore = (ReadOnlyKeyValueStore)IntegrationTestUtils.getStore("globalStore", this.kafkaStreams, QueryableStoreTypes.timestampedKeyValueStore());
        MatcherAssert.assertThat((Object)timestampedStore.approximateNumEntries(), (Matcher)IsEqual.equalTo((Object)4L));
    }

    @Test
    public void shouldGetToRunningWithOnlyGlobalTopology() throws Exception {
        this.builder = new StreamsBuilder();
        this.globalTable = this.builder.globalTable(this.globalTableTopic, Consumed.with((Serde)Serdes.Long(), (Serde)Serdes.String()), Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"globalStore")));
        this.startStreams();
        IntegrationTestUtils.waitForApplicationState(Collections.singletonList(this.kafkaStreams), KafkaStreams.State.RUNNING, Duration.ofSeconds(30L));
        this.kafkaStreams.close();
    }

    private void createTopics() throws Exception {
        String safeTestName = IntegrationTestUtils.safeUniqueTestName(this.getClass(), this.testName);
        this.streamTopic = "stream-" + safeTestName;
        this.globalTableTopic = "globalTable-" + safeTestName;
        CLUSTER.createTopics(this.streamTopic);
        CLUSTER.createTopic(this.globalTableTopic, 2, 1);
    }

    private void startStreams() {
        this.kafkaStreams = new KafkaStreams(this.builder.build(), this.streamsConfiguration);
        this.kafkaStreams.start();
    }

    private void produceTopicValues(String topic) {
        IntegrationTestUtils.produceKeyValuesSynchronously(topic, Arrays.asList(new KeyValue((Object)"a", (Object)1L), new KeyValue((Object)"b", (Object)2L), new KeyValue((Object)"c", (Object)3L), new KeyValue((Object)"d", (Object)4L), new KeyValue((Object)"e", (Object)5L)), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), StringSerializer.class, LongSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }

    private void produceInitialGlobalTableValues() {
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalTableTopic, Arrays.asList(new KeyValue((Object)1L, (Object)"A"), new KeyValue((Object)2L, (Object)"B"), new KeyValue((Object)3L, (Object)"C"), new KeyValue((Object)4L, (Object)"D")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class), (Time)this.mockTime);
    }

    private void produceGlobalTableValues() {
        IntegrationTestUtils.produceKeyValuesSynchronously(this.globalTableTopic, Arrays.asList(new KeyValue((Object)1L, (Object)"F"), new KeyValue((Object)2L, (Object)"G"), new KeyValue((Object)3L, (Object)"H"), new KeyValue((Object)4L, (Object)"I"), new KeyValue((Object)5L, (Object)"J")), TestUtils.producerConfig((String)CLUSTER.bootstrapServers(), LongSerializer.class, StringSerializer.class, (Properties)new Properties()), (Time)this.mockTime);
    }
}

