/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.TimestampedKeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;

public class StreamToTableNode<K, V>
extends StreamsGraphNode {
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final MaterializedInternal<K, V, ?> materializedInternal;

    public StreamToTableNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, MaterializedInternal<K, V, ?> materializedInternal) {
        super(nodeName);
        this.processorParameters = processorParameters;
        this.materializedInternal = materializedInternal;
    }

    @Override
    public String toString() {
        return "StreamToTableNode{, processorParameters=" + this.processorParameters + ", materializedInternal=" + this.materializedInternal + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        StoreBuilder<TimestampedKeyValueStore<K, V>> storeBuilder = new TimestampedKeyValueStoreMaterializer<K, V>(this.materializedInternal).materialize();
        String processorName = this.processorParameters.processorName();
        KTableSource<K, V> ktableSource = this.processorParameters.kTableSourceSupplier();
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (storeBuilder != null && ktableSource.materialized()) {
            topologyBuilder.addStateStore(storeBuilder, processorName);
        }
    }
}

