/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AssignedTasks;
import org.apache.kafka.streams.processor.internals.StandbyTask;

class AssignedStandbyTasks
extends AssignedTasks<StandbyTask> {
    AssignedStandbyTasks(LogContext logContext) {
        super(logContext, "standby task");
    }

    @Override
    public void shutdown(boolean clean) {
        String shutdownType = clean ? "Clean" : "Unclean";
        this.log.debug("{} shutdown of all standby tasks\nnon-initialized standby tasks to close: {}\nrunning standby tasks to close: {}", new Object[]{shutdownType, this.created.keySet(), this.running.keySet()});
        super.shutdown(clean);
    }

    @Override
    int commit() {
        int committed = super.commit();
        this.running.forEach((id, task) -> task.allowUpdateOfOffsetLimit());
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TopicPartition> closeRevokedStandbyTasks(Map<TaskId, Set<TopicPartition>> revokedTasks) {
        this.log.debug("Closing revoked standby tasks {}", revokedTasks);
        ArrayList<TopicPartition> revokedChangelogs = new ArrayList<TopicPartition>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : revokedTasks.entrySet()) {
            StandbyTask task;
            TaskId taskId = entry.getKey();
            if (this.running.containsKey(taskId)) {
                task = (StandbyTask)this.running.get(taskId);
            } else if (this.created.containsKey(taskId)) {
                task = (StandbyTask)this.created.get(taskId);
            } else {
                this.log.debug("Could not find the standby task {} while closing it, most likely it was not created because it has no state stores in its subtopology.", (Object)taskId);
                continue;
            }
            try {
                task.close(true, false);
            }
            catch (RuntimeException e) {
                this.log.error("Closing the standby task {} failed due to the following error:", (Object)task.id(), (Object)e);
            }
            finally {
                this.removeTaskFromAllStateMaps(task, Collections.emptyMap());
                revokedChangelogs.addAll(task.changelogPartitions());
            }
        }
        return revokedChangelogs;
    }
}

