/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class KTableKTableForeignKeyJoinResolutionNode<K, V, KO, VO>
extends StreamsGraphNode {
    private final ProcessorParameters<KO, SubscriptionWrapper<K>> joinOneToOneProcessorParameters;
    private final ProcessorParameters<KO, Change<VO>> joinByPrefixProcessorParameters;
    private final ProcessorParameters<K, SubscriptionResponseWrapper<VO>> resolverProcessorParameters;
    private final String finalRepartitionTopicName;
    private final String finalRepartitionSinkName;
    private final String finalRepartitionSourceName;
    private final Serde<K> keySerde;
    private final Serde<SubscriptionResponseWrapper<VO>> subResponseSerde;
    private final KTableValueGetterSupplier<K, V> originalValueGetter;

    public KTableKTableForeignKeyJoinResolutionNode(String nodeName, ProcessorParameters<KO, SubscriptionWrapper<K>> joinOneToOneProcessorParameters, ProcessorParameters<KO, Change<VO>> joinByPrefixProcessorParameters, ProcessorParameters<K, SubscriptionResponseWrapper<VO>> resolverProcessorParameters, String finalRepartitionTopicName, String finalRepartitionSinkName, String finalRepartitionSourceName, Serde<K> keySerde, Serde<SubscriptionResponseWrapper<VO>> subResponseSerde, KTableValueGetterSupplier<K, V> originalValueGetter) {
        super(nodeName);
        this.joinOneToOneProcessorParameters = joinOneToOneProcessorParameters;
        this.joinByPrefixProcessorParameters = joinByPrefixProcessorParameters;
        this.resolverProcessorParameters = resolverProcessorParameters;
        this.finalRepartitionTopicName = finalRepartitionTopicName;
        this.finalRepartitionSinkName = finalRepartitionSinkName;
        this.finalRepartitionSourceName = finalRepartitionSourceName;
        this.keySerde = keySerde;
        this.subResponseSerde = subResponseSerde;
        this.originalValueGetter = originalValueGetter;
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        topologyBuilder.addInternalTopic(this.finalRepartitionTopicName);
        topologyBuilder.addSink(this.finalRepartitionSinkName, this.finalRepartitionTopicName, this.keySerde.serializer(), this.subResponseSerde.serializer(), null, this.joinByPrefixProcessorParameters.processorName(), this.joinOneToOneProcessorParameters.processorName());
        topologyBuilder.addSource(null, this.finalRepartitionSourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), this.keySerde.deserializer(), this.subResponseSerde.deserializer(), this.finalRepartitionTopicName);
        topologyBuilder.addProcessor(this.resolverProcessorParameters.processorName(), this.resolverProcessorParameters.processorSupplier(), this.finalRepartitionSourceName);
        topologyBuilder.connectProcessorAndStateStores(this.resolverProcessorParameters.processorName(), this.originalValueGetter.storeNames());
    }
}

