/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

public class SessionWindowedSerializer<T>
implements WindowedSerializer<T> {
    private Serializer<T> inner;

    public SessionWindowedSerializer() {
    }

    public SessionWindowedSerializer(Serializer<T> inner) {
        this.inner = inner;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.inner == null) {
            String propertyName = isKey ? "default.windowed.key.serde.inner" : "default.windowed.value.serde.inner";
            String value = (String)configs.get(propertyName);
            try {
                this.inner = ((Serde)Serde.class.cast(Utils.newInstance((String)value, Serde.class))).serializer();
                this.inner.configure(configs, isKey);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(propertyName, (Object)value, "Serde class " + value + " could not be found.");
            }
        }
    }

    public byte[] serialize(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        if (data == null) {
            return null;
        }
        return SessionKeySchema.toBinary(data, this.inner, topic);
    }

    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public byte[] serializeBaseKey(String topic, Windowed<T> data) {
        WindowedSerdes.verifyInnerSerializerNotNull(this.inner, this);
        return this.inner.serialize(topic, data.key());
    }

    Serializer<T> innerSerializer() {
        return this.inner;
    }
}

