/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class InnerMeteredKeyValueStore<K, IK, V, IV>
extends WrappedStateStore.AbstractStateStore
implements KeyValueStore<K, V> {
    private final KeyValueStore<IK, IV> inner;
    private final String metricScope;
    private final TypeConverter<K, IK, V, IV> typeConverter;
    protected final Time time;
    private Sensor putTime;
    private Sensor putIfAbsentTime;
    private Sensor getTime;
    private Sensor deleteTime;
    private Sensor putAllTime;
    private Sensor allTime;
    private Sensor rangeTime;
    private Sensor flushTime;
    private StreamsMetricsImpl metrics;
    private ProcessorContext context;
    private StateStore root;

    InnerMeteredKeyValueStore(KeyValueStore<IK, IV> inner, String metricScope, TypeConverter<K, IK, V, IV> typeConverter, Time time) {
        super(inner);
        this.inner = inner;
        this.metricScope = metricScope;
        this.typeConverter = typeConverter;
        this.time = time != null ? time : Time.SYSTEM;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        String name = this.name();
        String tagKey = "task-id";
        String taskName = context.taskId().toString();
        this.context = context;
        this.root = root;
        this.metrics = (StreamsMetricsImpl)context.metrics();
        this.putTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "put", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.putIfAbsentTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "put-if-absent", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.getTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "get", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.deleteTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "delete", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.putAllTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "put-all", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.allTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "all", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.rangeTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "range", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        this.flushTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "flush", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        Sensor restoreTime = this.metrics.addLatencyAndThroughputSensor(taskName, this.metricScope, name, "restore", Sensor.RecordingLevel.DEBUG, "task-id", taskName);
        if (restoreTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    InnerMeteredKeyValueStore.this.inner.init(InnerMeteredKeyValueStore.this.context, InnerMeteredKeyValueStore.this.root);
                    return null;
                }
            }, restoreTime);
        } else {
            this.inner.init(this.context, this.root);
        }
    }

    @Override
    public long approximateNumEntries() {
        return this.inner.approximateNumEntries();
    }

    @Override
    public V get(final K key) {
        try {
            if (this.getTime.shouldRecord()) {
                return this.measureLatency(new Action<V>(){

                    @Override
                    public V execute() {
                        return InnerMeteredKeyValueStore.this.typeConverter.outerValue(InnerMeteredKeyValueStore.this.inner.get(InnerMeteredKeyValueStore.this.typeConverter.innerKey(key)));
                    }
                }, this.getTime);
            }
            return this.typeConverter.outerValue(this.inner.get(this.typeConverter.innerKey(key)));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public void put(final K key, final V value) {
        try {
            if (this.putTime.shouldRecord()) {
                this.measureLatency(new Action<V>(){

                    @Override
                    public V execute() {
                        InnerMeteredKeyValueStore.this.inner.put(InnerMeteredKeyValueStore.this.typeConverter.innerKey(key), InnerMeteredKeyValueStore.this.typeConverter.innerValue(value));
                        return null;
                    }
                }, this.putTime);
            } else {
                this.inner.put(this.typeConverter.innerKey(key), this.typeConverter.innerValue(value));
            }
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V putIfAbsent(final K key, final V value) {
        if (this.putIfAbsentTime.shouldRecord()) {
            return this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    return InnerMeteredKeyValueStore.this.typeConverter.outerValue(InnerMeteredKeyValueStore.this.inner.putIfAbsent(InnerMeteredKeyValueStore.this.typeConverter.innerKey(key), InnerMeteredKeyValueStore.this.typeConverter.innerValue(value)));
                }
            }, this.putIfAbsentTime);
        }
        return this.typeConverter.outerValue(this.inner.putIfAbsent(this.typeConverter.innerKey(key), this.typeConverter.innerValue(value)));
    }

    @Override
    public void putAll(final List<KeyValue<K, V>> entries) {
        if (this.putAllTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    InnerMeteredKeyValueStore.this.inner.putAll(InnerMeteredKeyValueStore.this.typeConverter.innerEntries(entries));
                    return null;
                }
            }, this.putAllTime);
        } else {
            this.inner.putAll(this.typeConverter.innerEntries(entries));
        }
    }

    @Override
    public V delete(final K key) {
        try {
            if (this.deleteTime.shouldRecord()) {
                return this.measureLatency(new Action<V>(){

                    @Override
                    public V execute() {
                        return InnerMeteredKeyValueStore.this.typeConverter.outerValue(InnerMeteredKeyValueStore.this.inner.delete(InnerMeteredKeyValueStore.this.typeConverter.innerKey(key)));
                    }
                }, this.deleteTime);
            }
            return this.typeConverter.outerValue(this.inner.delete(this.typeConverter.innerKey(key)));
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new MeteredKeyValueIterator(this.inner.range(this.typeConverter.innerKey(from), this.typeConverter.innerKey(to)), this.rangeTime);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(this.inner.all(), this.allTime);
    }

    @Override
    public void flush() {
        if (this.flushTime.shouldRecord()) {
            this.measureLatency(new Action<V>(){

                @Override
                public V execute() {
                    InnerMeteredKeyValueStore.this.inner.flush();
                    return null;
                }
            }, this.flushTime);
        } else {
            this.inner.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V measureLatency(Action<V> action, Sensor sensor) {
        long startNs = this.time.nanoseconds();
        try {
            V v = action.execute();
            return v;
        }
        finally {
            this.metrics.recordLatency(sensor, startNs, this.time.nanoseconds());
        }
    }

    private class MeteredKeyValueIterator
    implements KeyValueIterator<K, V> {
        private final KeyValueIterator<IK, IV> iter;
        private final Sensor sensor;
        private final long startNs;

        MeteredKeyValueIterator(KeyValueIterator<IK, IV> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = InnerMeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            return InnerMeteredKeyValueStore.this.typeConverter.outerKeyValue((KeyValue)this.iter.next());
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                InnerMeteredKeyValueStore.this.metrics.recordLatency(this.sensor, this.startNs, InnerMeteredKeyValueStore.this.time.nanoseconds());
            }
        }

        @Override
        public K peekNextKey() {
            return InnerMeteredKeyValueStore.this.typeConverter.outerKey(this.iter.peekNextKey());
        }
    }

    private static interface Action<V> {
        public V execute();
    }

    static interface TypeConverter<K, IK, V, IV> {
        public IK innerKey(K var1);

        public IV innerValue(V var1);

        public List<KeyValue<IK, IV>> innerEntries(List<KeyValue<K, V>> var1);

        public V outerValue(IV var1);

        public KeyValue<K, V> outerKeyValue(KeyValue<IK, IV> var1);

        public K outerKey(IK var1);
    }
}

