/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.StatelessProcessorNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

class RepartitionNode<K, V>
extends StatelessProcessorNode<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final String sinkName;
    private final String sourceName;
    private final String repartitionTopic;
    private final String processorName;

    RepartitionNode(String parentProcessorNodeName, String processorNodeName, String sourceName, ProcessorSupplier<K, V> processorSupplier, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, String processorName) {
        super(parentProcessorNodeName, processorNodeName, processorSupplier, false);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.repartitionTopic = repartitionTopic;
        this.processorName = processorName;
    }

    Serde<K> keySerde() {
        return this.keySerde;
    }

    Serde<V> valueSerde() {
        return this.valueSerde;
    }

    String sinkName() {
        return this.sinkName;
    }

    String sourceName() {
        return this.sourceName;
    }

    String repartitionTopic() {
        return this.repartitionTopic;
    }

    String processorName() {
        return this.processorName;
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static <K, V> RepartitionNodeBuilder<K, V> repartitionNodeBuilder() {
        return new RepartitionNodeBuilder();
    }

    static final class RepartitionNodeBuilder<K, V> {
        private String processorNodeName;
        private ProcessorSupplier<K, V> processorSupplier;
        private Serde<K> keySerde;
        private Serde<V> valueSerde;
        private String sinkName;
        private String sourceName;
        private String repartitionTopic;
        private String processorName;
        private String parentProcessorNodeName;

        private RepartitionNodeBuilder() {
        }

        RepartitionNodeBuilder<K, V> withProcessorSupplier(ProcessorSupplier<K, V> processorSupplier) {
            this.processorSupplier = processorSupplier;
            return this;
        }

        RepartitionNodeBuilder<K, V> withKeySerde(Serde<K> keySerde) {
            this.keySerde = keySerde;
            return this;
        }

        RepartitionNodeBuilder<K, V> withValueSerde(Serde<V> valueSerde) {
            this.valueSerde = valueSerde;
            return this;
        }

        RepartitionNodeBuilder<K, V> withSinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        RepartitionNodeBuilder<K, V> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        RepartitionNodeBuilder<K, V> withRepartitionTopic(String repartitionTopic) {
            this.repartitionTopic = repartitionTopic;
            return this;
        }

        RepartitionNodeBuilder<K, V> withProcessorName(String processorName) {
            this.processorName = processorName;
            return this;
        }

        RepartitionNodeBuilder<K, V> withParentProcessorNodeName(String parentProcessorNodeName) {
            this.parentProcessorNodeName = parentProcessorNodeName;
            return this;
        }

        RepartitionNodeBuilder<K, V> withProcessorNodeName(String processorNodeName) {
            this.processorNodeName = processorNodeName;
            return this;
        }

        RepartitionNode<K, V> build() {
            return new RepartitionNode<K, V>(this.parentProcessorNodeName, this.processorNodeName, this.sourceName, this.processorSupplier, this.keySerde, this.valueSerde, this.sinkName, this.repartitionTopic, this.processorName);
        }
    }
}

