/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

public class StreamsBuilder {
    private final Topology topology = new Topology();
    final InternalTopologyBuilder internalTopologyBuilder;
    private final InternalStreamsBuilder internalStreamsBuilder;

    public StreamsBuilder() {
        this.internalTopologyBuilder = this.topology.internalTopologyBuilder;
        this.internalStreamsBuilder = new InternalStreamsBuilder(this.internalTopologyBuilder);
    }

    public synchronized <K, V> KStream<K, V> stream(String topic) {
        return this.stream(Collections.singleton(topic));
    }

    public synchronized <K, V> KStream<K, V> stream(String topic, Consumed<K, V> consumed) {
        return this.stream(Collections.singleton(topic), consumed);
    }

    public synchronized <K, V> KStream<K, V> stream(Collection<String> topics) {
        return this.stream(topics, Consumed.with(null, null, null, null));
    }

    public synchronized <K, V> KStream<K, V> stream(Collection<String> topics, Consumed<K, V> consumed) {
        Objects.requireNonNull(topics, "topics can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        return this.internalStreamsBuilder.stream(topics, new ConsumedInternal<K, V>(consumed));
    }

    public synchronized <K, V> KStream<K, V> stream(Pattern topicPattern) {
        return this.stream(topicPattern, Consumed.with(null, null));
    }

    public synchronized <K, V> KStream<K, V> stream(Pattern topicPattern, Consumed<K, V> consumed) {
        Objects.requireNonNull(topicPattern, "topicPattern can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        return this.internalStreamsBuilder.stream(topicPattern, new ConsumedInternal<K, V>(consumed));
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Consumed<K, V> consumed, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        materialized.withKeySerde(consumed.keySerde).withValueSerde(consumed.valueSerde);
        return this.internalStreamsBuilder.table(topic, new ConsumedInternal<K, V>(consumed), new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic));
    }

    public synchronized <K, V> KTable<K, V> table(String topic) {
        return this.table(topic, new ConsumedInternal());
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Consumed<K, V> consumed) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        return this.internalStreamsBuilder.table(topic, new ConsumedInternal<K, V>(consumed), new MaterializedInternal(Materialized.with(consumed.keySerde, consumed.valueSerde), this.internalStreamsBuilder, topic));
    }

    public synchronized <K, V> KTable<K, V> table(String topic, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic);
        return this.internalStreamsBuilder.table(topic, new ConsumedInternal<K, V>(Consumed.with(materializedInternal.keySerde(), materializedInternal.valueSerde())), materializedInternal);
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Consumed<K, V> consumed) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        MaterializedInternal materialized = new MaterializedInternal(Materialized.with(consumed.keySerde, consumed.valueSerde), this.internalStreamsBuilder, topic);
        return this.internalStreamsBuilder.globalTable(topic, new ConsumedInternal<K, V>(consumed), materialized);
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic) {
        return this.globalTable(topic, Consumed.with(null, null));
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Consumed<K, V> consumed, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        materialized.withKeySerde(consumed.keySerde).withValueSerde(consumed.valueSerde);
        return this.internalStreamsBuilder.globalTable(topic, new ConsumedInternal<K, V>(consumed), new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic));
    }

    public synchronized <K, V> GlobalKTable<K, V> globalTable(String topic, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(topic, "topic can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.internalStreamsBuilder, topic);
        return this.internalStreamsBuilder.globalTable(topic, new ConsumedInternal<K, V>(Consumed.with(materializedInternal.keySerde(), materializedInternal.valueSerde())), materializedInternal);
    }

    public synchronized StreamsBuilder addStateStore(StoreBuilder builder) {
        Objects.requireNonNull(builder, "builder can't be null");
        this.internalStreamsBuilder.addStateStore(builder);
        return this;
    }

    public synchronized StreamsBuilder addGlobalStore(StoreBuilder storeBuilder, String topic, String sourceName, Consumed consumed, String processorName, ProcessorSupplier stateUpdateSupplier) {
        Objects.requireNonNull(storeBuilder, "storeBuilder can't be null");
        Objects.requireNonNull(consumed, "consumed can't be null");
        this.internalStreamsBuilder.addGlobalStore(storeBuilder, sourceName, topic, new ConsumedInternal(consumed), processorName, stateUpdateSupplier);
        return this;
    }

    public synchronized Topology build() {
        return this.topology;
    }
}

