/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class ProcessorContextImpl
extends AbstractProcessorContext
implements RecordCollector.Supplier {
    private final StreamTask task;
    private final RecordCollector collector;

    ProcessorContextImpl(TaskId id, StreamTask task, StreamsConfig config, RecordCollector collector, ProcessorStateManager stateMgr, StreamsMetrics metrics, ThreadCache cache) {
        super(id, task.applicationId(), config, metrics, stateMgr, cache);
        this.task = task;
        this.collector = collector;
    }

    public ProcessorStateManager getStateMgr() {
        return (ProcessorStateManager)this.stateManager;
    }

    @Override
    public RecordCollector recordCollector() {
        return this.collector;
    }

    @Override
    public StateStore getStateStore(String name) {
        if (this.currentNode() == null) {
            throw new TopologyBuilderException("Accessing from an unknown node");
        }
        StateStore global = this.stateManager.getGlobalStore(name);
        if (global != null) {
            return global;
        }
        if (!this.currentNode().stateStores.contains(name)) {
            throw new TopologyBuilderException("Processor " + this.currentNode().name() + " has no access to StateStore " + name);
        }
        return this.stateManager.getStore(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value) {
        ProcessorNode previousNode = this.currentNode();
        try {
            for (ProcessorNode<?, ?> child : this.currentNode().children()) {
                this.setCurrentNode(child);
                child.process(key, value);
            }
        }
        finally {
            this.setCurrentNode(previousNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value, int childIndex) {
        ProcessorNode previousNode = this.currentNode();
        ProcessorNode<?, ?> child = this.currentNode().children().get(childIndex);
        this.setCurrentNode(child);
        try {
            child.process(key, value);
        }
        finally {
            this.setCurrentNode(previousNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value, String childName) {
        for (ProcessorNode<?, ?> child : this.currentNode().children()) {
            if (!child.name().equals(childName)) continue;
            ProcessorNode previousNode = this.currentNode();
            this.setCurrentNode(child);
            try {
                child.process(key, value);
                return;
            }
            finally {
                this.setCurrentNode(previousNode);
            }
        }
    }

    @Override
    public void commit() {
        this.task.needCommit();
    }

    @Override
    public void schedule(long interval) {
        this.task.schedule(interval);
    }
}

