/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;

public class QueryableStoreProvider {
    private final List<StateStoreProvider> storeProviders;

    public QueryableStoreProvider(List<StateStoreProvider> storeProviders) {
        this.storeProviders = new ArrayList<StateStoreProvider>(storeProviders);
    }

    public <T> T getStore(String storeName, QueryableStoreType<T> queryableStoreType) {
        ArrayList<T> allStores = new ArrayList<T>();
        for (StateStoreProvider storeProvider : this.storeProviders) {
            allStores.addAll(storeProvider.stores(storeName, queryableStoreType));
        }
        if (allStores.isEmpty()) {
            throw new InvalidStateStoreException("the state store, " + storeName + ", may have migrated to another instance.");
        }
        return queryableStoreType.create(new WrappingStoreProvider(this.storeProviders), storeName);
    }
}

