/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingWindowIterator;

class DelegatingPeekingWindowIterator<V>
implements PeekingWindowIterator<V> {
    private final WindowStoreIterator<V> underlying;
    private KeyValue<Long, V> next;

    public DelegatingPeekingWindowIterator(WindowStoreIterator<V> underlying) {
        this.underlying = underlying;
    }

    @Override
    public KeyValue<Long, V> peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.underlying.hasNext()) {
            return false;
        }
        this.next = (KeyValue)this.underlying.next();
        return true;
    }

    @Override
    public KeyValue<Long, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue<Long, V> result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

