/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class ProcessorContextImpl
implements InternalProcessorContext,
RecordCollector.Supplier {
    public static final String NONEXIST_TOPIC = "__null_topic__";
    private final TaskId id;
    private final StreamTask task;
    private final StreamsMetrics metrics;
    private final RecordCollector collector;
    private final ProcessorStateManager stateMgr;
    private final StreamsConfig config;
    private final Serde<?> keySerde;
    private final Serde<?> valSerde;
    private final ThreadCache cache;
    private boolean initialized;
    private RecordContext recordContext;
    private ProcessorNode currentNode;

    public ProcessorContextImpl(TaskId id, StreamTask task, StreamsConfig config, RecordCollector collector, ProcessorStateManager stateMgr, StreamsMetrics metrics, ThreadCache cache) {
        this.id = id;
        this.task = task;
        this.metrics = metrics;
        this.collector = collector;
        this.stateMgr = stateMgr;
        this.config = config;
        this.keySerde = config.keySerde();
        this.valSerde = config.valueSerde();
        this.cache = cache;
        this.initialized = false;
    }

    public void initialized() {
        this.initialized = true;
    }

    public ProcessorStateManager getStateMgr() {
        return this.stateMgr;
    }

    @Override
    public TaskId taskId() {
        return this.id;
    }

    @Override
    public String applicationId() {
        return this.task.applicationId();
    }

    @Override
    public RecordCollector recordCollector() {
        return this.collector;
    }

    @Override
    public Serde<?> keySerde() {
        return this.keySerde;
    }

    @Override
    public Serde<?> valueSerde() {
        return this.valSerde;
    }

    @Override
    public File stateDir() {
        return this.stateMgr.baseDir();
    }

    @Override
    public StreamsMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void register(StateStore store, boolean loggingEnabled, StateRestoreCallback stateRestoreCallback) {
        if (this.initialized) {
            throw new IllegalStateException("Can only create state stores during initialization.");
        }
        this.stateMgr.register(store, loggingEnabled, stateRestoreCallback);
    }

    @Override
    public StateStore getStateStore(String name) {
        if (this.currentNode == null) {
            throw new TopologyBuilderException("Accessing from an unknown node");
        }
        if (!this.currentNode.stateStores.contains(name)) {
            throw new TopologyBuilderException("Processor " + this.currentNode.name() + " has no access to StateStore " + name);
        }
        return this.stateMgr.getStore(name);
    }

    @Override
    public ThreadCache getCache() {
        return this.cache;
    }

    @Override
    public String topic() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as topic() should only be called while a record is processed");
        }
        String topic = this.recordContext.topic();
        if (topic.equals(NONEXIST_TOPIC)) {
            return null;
        }
        return topic;
    }

    @Override
    public int partition() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as partition() should only be called while a record is processed");
        }
        return this.recordContext.partition();
    }

    @Override
    public long offset() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as offset() should only be called while a record is processed");
        }
        return this.recordContext.offset();
    }

    @Override
    public long timestamp() {
        if (this.recordContext == null) {
            throw new IllegalStateException("This should not happen as timestamp() should only be called while a record is processed");
        }
        return this.recordContext.timestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value) {
        ProcessorNode previousNode = this.currentNode;
        try {
            Iterator<ProcessorNode<?, ?>> i$ = this.currentNode.children().iterator();
            while (i$.hasNext()) {
                ProcessorNode<?, ?> child;
                this.currentNode = child = i$.next();
                child.process(key, value);
            }
        }
        finally {
            this.currentNode = previousNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value, int childIndex) {
        ProcessorNode<?, ?> child;
        ProcessorNode previousNode = this.currentNode;
        this.currentNode = child = this.currentNode.children().get(childIndex);
        try {
            child.process(key, value);
        }
        finally {
            this.currentNode = previousNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value, String childName) {
        for (ProcessorNode<?, ?> child : this.currentNode.children()) {
            if (!child.name().equals(childName)) continue;
            ProcessorNode previousNode = this.currentNode;
            this.currentNode = child;
            try {
                child.process(key, value);
                return;
            }
            finally {
                this.currentNode = previousNode;
            }
        }
    }

    @Override
    public void commit() {
        this.task.needCommit();
    }

    @Override
    public void schedule(long interval) {
        this.task.schedule(interval);
    }

    @Override
    public Map<String, Object> appConfigs() {
        return this.config.originals();
    }

    @Override
    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    @Override
    public void setRecordContext(RecordContext recordContext) {
        this.recordContext = recordContext;
    }

    @Override
    public RecordContext recordContext() {
        return this.recordContext;
    }

    @Override
    public void setCurrentNode(ProcessorNode currentNode) {
        this.currentNode = currentNode;
    }

    @Override
    public ProcessorNode currentNode() {
        return this.currentNode;
    }
}

