/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Map;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.TimeWindow;

public class JoinWindows
extends Windows<TimeWindow> {
    public final long before;
    public final long after;

    private JoinWindows(long before, long after) {
        if (before + after < 0L) {
            throw new IllegalArgumentException("Window interval (ie, before+after) must not be negative");
        }
        this.after = after;
        this.before = before;
    }

    public static JoinWindows of(long timeDifference) {
        return new JoinWindows(timeDifference, timeDifference);
    }

    public JoinWindows before(long timeDifference) {
        return new JoinWindows(timeDifference, this.after);
    }

    public JoinWindows after(long timeDifference) {
        return new JoinWindows(this.before, timeDifference);
    }

    @Override
    public Map<Long, TimeWindow> windowsFor(long timestamp) {
        throw new UnsupportedOperationException("windowsFor() is not supported in JoinWindows");
    }

    @Override
    public long size() {
        return this.after + this.before;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinWindows)) {
            return false;
        }
        JoinWindows other = (JoinWindows)o;
        return this.before == other.before && this.after == other.after;
    }

    public int hashCode() {
        int result = (int)(this.before ^ this.before >>> 32);
        result = 31 * result + (int)(this.after ^ this.after >>> 32);
        return result;
    }
}

