/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemoryLRUCacheStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDBWindowStoreSupplier;

public class Stores {
    public static StoreFactory create(final String name) {
        return new StoreFactory(){

            @Override
            public <K> ValueFactory<K> withKeys(final Serde<K> keySerde) {
                return new ValueFactory<K>(){

                    @Override
                    public <V> KeyValueFactory<K, V> withValues(final Serde<V> valueSerde) {
                        return new KeyValueFactory<K, V>(){

                            @Override
                            public InMemoryKeyValueFactory<K, V> inMemory() {
                                return new InMemoryKeyValueFactory<K, V>(){
                                    private int capacity = Integer.MAX_VALUE;

                                    @Override
                                    public InMemoryKeyValueFactory<K, V> maxEntries(int capacity) {
                                        if (capacity < 1) {
                                            throw new IllegalArgumentException("The capacity must be positive");
                                        }
                                        this.capacity = capacity;
                                        return this;
                                    }

                                    @Override
                                    public StateStoreSupplier build() {
                                        if (this.capacity < Integer.MAX_VALUE) {
                                            return new InMemoryLRUCacheStoreSupplier(name, this.capacity, keySerde, valueSerde);
                                        }
                                        return new InMemoryKeyValueStoreSupplier(name, keySerde, valueSerde);
                                    }
                                };
                            }

                            @Override
                            public PersistentKeyValueFactory<K, V> persistent() {
                                return new PersistentKeyValueFactory<K, V>(){
                                    private int numSegments = 0;
                                    private long retentionPeriod = 0L;
                                    private boolean retainDuplicates = false;

                                    @Override
                                    public PersistentKeyValueFactory<K, V> windowed(long retentionPeriod, int numSegments, boolean retainDuplicates) {
                                        this.numSegments = numSegments;
                                        this.retentionPeriod = retentionPeriod;
                                        this.retainDuplicates = retainDuplicates;
                                        return this;
                                    }

                                    @Override
                                    public StateStoreSupplier build() {
                                        if (this.numSegments > 0) {
                                            return new RocksDBWindowStoreSupplier(name, this.retentionPeriod, this.numSegments, this.retainDuplicates, keySerde, valueSerde);
                                        }
                                        return new RocksDBKeyValueStoreSupplier(name, keySerde, valueSerde);
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    public static interface PersistentKeyValueFactory<K, V> {
        public PersistentKeyValueFactory<K, V> windowed(long var1, int var3, boolean var4);

        public StateStoreSupplier build();
    }

    public static interface InMemoryKeyValueFactory<K, V> {
        public InMemoryKeyValueFactory<K, V> maxEntries(int var1);

        public StateStoreSupplier build();
    }

    public static interface KeyValueFactory<K, V> {
        public InMemoryKeyValueFactory<K, V> inMemory();

        public PersistentKeyValueFactory<K, V> persistent();
    }

    public static abstract class ValueFactory<K> {
        public KeyValueFactory<K, String> withStringValues() {
            return this.withValues(Serdes.String());
        }

        public KeyValueFactory<K, Integer> withIntegerValues() {
            return this.withValues(Serdes.Integer());
        }

        public KeyValueFactory<K, Long> withLongValues() {
            return this.withValues(Serdes.Long());
        }

        public KeyValueFactory<K, Double> withDoubleValues() {
            return this.withValues(Serdes.Double());
        }

        public KeyValueFactory<K, ByteBuffer> withByteBufferValues() {
            return this.withValues(Serdes.ByteBuffer());
        }

        public KeyValueFactory<K, byte[]> withByteArrayValues() {
            return this.withValues(Serdes.ByteArray());
        }

        public <V> KeyValueFactory<K, V> withValues(Class<V> valueClass) {
            return this.withValues(Serdes.serdeFrom(valueClass));
        }

        public abstract <V> KeyValueFactory<K, V> withValues(Serde<V> var1);
    }

    public static abstract class StoreFactory {
        public ValueFactory<String> withStringKeys() {
            return this.withKeys(Serdes.String());
        }

        public ValueFactory<Integer> withIntegerKeys() {
            return this.withKeys(Serdes.Integer());
        }

        public ValueFactory<Long> withLongKeys() {
            return this.withKeys(Serdes.Long());
        }

        public ValueFactory<Double> withDoubleKeys() {
            return this.withKeys(Serdes.Double());
        }

        public ValueFactory<ByteBuffer> withByteBufferKeys() {
            return this.withKeys(Serdes.ByteBuffer());
        }

        public ValueFactory<byte[]> withByteArrayKeys() {
            return this.withKeys(Serdes.ByteArray());
        }

        public <K> ValueFactory<K> withKeys(Class<K> keyClass) {
            return this.withKeys(Serdes.serdeFrom(keyClass));
        }

        public abstract <K> ValueFactory<K> withKeys(Serde<K> var1);
    }
}

