/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;

public class KTableSource<K, V>
implements ProcessorSupplier<K, V> {
    public final String topic;
    private boolean materialized = false;
    private boolean sendOldValues = false;

    public KTableSource(String topic) {
        this.topic = topic;
    }

    @Override
    public Processor<K, V> get() {
        return this.materialized ? new MaterializedKTableSourceProcessor() : new KTableSourceProcessor();
    }

    public void materialize() {
        this.materialized = true;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private class MaterializedKTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private KeyValueStore<K, V> store;

        private MaterializedKTableSourceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableSource.this.topic);
        }

        @Override
        public void process(K key, V value) {
            Object oldValue = KTableSource.this.sendOldValues ? (Object)this.store.get(key) : null;
            this.store.put(key, value);
            this.context().forward(key, new Change<Object>(value, oldValue));
        }
    }

    private class KTableSourceProcessor
    extends AbstractProcessor<K, V> {
        private KTableSourceProcessor() {
        }

        @Override
        public void process(K key, V value) {
            this.context().forward(key, new Change<Object>(value, null));
        }
    }
}

