/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

public class KTableRepartitionMap<K, V, K1, V1>
implements KTableProcessorSupplier<K, V, KeyValue<K1, V1>> {
    private final KTableImpl<K, ?, V> parent;
    private final KeyValueMapper<K, V, KeyValue<K1, V1>> mapper;

    public KTableRepartitionMap(KTableImpl<K, ?, V> parent, KeyValueMapper<K, V, KeyValue<K1, V1>> mapper) {
        this.parent = parent;
        this.mapper = mapper;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableMapProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, KeyValue<K1, V1>> view() {
        final KTableValueGetterSupplier<K, V> parentValueGetterSupplier = this.parent.valueGetterSupplier();
        return new KTableValueGetterSupplier<K, KeyValue<K1, V1>>(){

            @Override
            public KTableValueGetter<K, KeyValue<K1, V1>> get() {
                return new KTableMapValueGetter(parentValueGetterSupplier.get());
            }
        };
    }

    @Override
    public void enableSendingOldValues() {
        throw new IllegalStateException("KTableRepartitionMap should always require sending old values.");
    }

    private KeyValue<K1, V1> computeValue(K key, V value) {
        KeyValue<K1, V1> newValue = null;
        if (key != null || value != null) {
            newValue = this.mapper.apply(key, value);
        }
        return newValue;
    }

    private class KTableMapValueGetter
    implements KTableValueGetter<K, KeyValue<K1, V1>> {
        private final KTableValueGetter<K, V> parentGetter;

        public KTableMapValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public KeyValue<K1, V1> get(K key) {
            return KTableRepartitionMap.this.computeValue(key, this.parentGetter.get(key));
        }
    }

    private class KTableMapProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KTableMapProcessor() {
        }

        @Override
        public void process(K key, Change<V> change) {
            KeyValue newPair = KTableRepartitionMap.this.computeValue(key, change.newValue);
            if (newPair.key == null) {
                throw new StreamsException("Record key for KTable repartition operator should not be null.");
            }
            this.context().forward(newPair.key, new Change<Object>(newPair.value, null));
            if (change.oldValue != null) {
                KeyValue oldPair = KTableRepartitionMap.this.computeValue(key, change.oldValue);
                this.context().forward(oldPair.key, new Change<Object>(null, oldPair.value));
            }
        }
    }
}

