/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class KStreamWindowAggregate<K, V, T, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, T> {
    private final String storeName;
    private final Windows<W> windows;
    private final Initializer<T> initializer;
    private final Aggregator<K, V, T> aggregator;
    private boolean sendOldValues = false;

    public KStreamWindowAggregate(Windows<W> windows, String storeName, Initializer<T> initializer, Aggregator<K, V, T> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, T> view() {
        return new KTableValueGetterSupplier<Windowed<K>, T>(){

            @Override
            public KTableValueGetter<Windowed<K>, T> get() {
                return new KStreamWindowAggregateValueGetter();
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<K>, T> {
        private WindowStore<K, T> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public T get(Windowed<K> windowedKey) {
            Window window;
            Object key = windowedKey.key();
            WindowStoreIterator iter = this.windowStore.fetch(key, (window = windowedKey.window()).start(), window.start());
            return iter.hasNext() ? (Object)((KeyValue)iter.next()).value : null;
        }
    }

    private class KStreamWindowAggregateProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, T> windowStore;

        private KStreamWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                return;
            }
            long timestamp = this.context().timestamp();
            Map matchedWindows = KStreamWindowAggregate.this.windows.windowsFor(timestamp);
            long timeFrom = Long.MAX_VALUE;
            long timeTo = Long.MIN_VALUE;
            for (long windowStartMs : matchedWindows.keySet()) {
                timeFrom = windowStartMs < timeFrom ? windowStartMs : timeFrom;
                timeTo = windowStartMs > timeTo ? windowStartMs : timeTo;
            }
            WindowStoreIterator iter = this.windowStore.fetch(key, timeFrom, timeTo);
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                Window window = (Window)matchedWindows.get(entry.key);
                if (window == null) continue;
                Object oldAgg = entry.value;
                if (oldAgg == null) {
                    oldAgg = KStreamWindowAggregate.this.initializer.apply();
                }
                Object newAgg = KStreamWindowAggregate.this.aggregator.apply(key, value, oldAgg);
                this.windowStore.put(key, newAgg, window.start());
                if (KStreamWindowAggregate.this.sendOldValues) {
                    this.context().forward(new Windowed(key, window), new Change(newAgg, oldAgg));
                } else {
                    this.context().forward(new Windowed(key, window), new Change<Object>(newAgg, null));
                }
                matchedWindows.remove(entry.key);
            }
            iter.close();
            for (long windowStartMs : matchedWindows.keySet()) {
                Object oldAgg = KStreamWindowAggregate.this.initializer.apply();
                Object newAgg = KStreamWindowAggregate.this.aggregator.apply(key, value, oldAgg);
                this.windowStore.put(key, newAgg, windowStartMs);
                if (KStreamWindowAggregate.this.sendOldValues) {
                    this.context().forward(new Windowed(key, (Window)matchedWindows.get(windowStartMs)), new Change(newAgg, oldAgg));
                    continue;
                }
                this.context().forward(new Windowed(key, (Window)matchedWindows.get(windowStartMs)), new Change<Object>(newAgg, null));
            }
        }
    }
}

