/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.server.log.remote.metadata.storage.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.server.log.remote.metadata.storage.generated.ProducerSnapshot.*;

public class ProducerSnapshotJsonConverter {
    public static ProducerSnapshot read(JsonNode _node, short _version) {
        ProducerSnapshot _object = new ProducerSnapshot();
        JsonNode _crcNode = _node.get("crc");
        if (_crcNode == null) {
            throw new RuntimeException("ProducerSnapshot: unable to locate field 'crc', which is mandatory in version " + _version);
        } else {
            _object.crc = MessageUtil.jsonNodeToUnsignedInt(_crcNode, "ProducerSnapshot");
        }
        JsonNode _producerEntriesNode = _node.get("producerEntries");
        if (_producerEntriesNode == null) {
            throw new RuntimeException("ProducerSnapshot: unable to locate field 'producerEntries', which is mandatory in version " + _version);
        } else {
            if (!_producerEntriesNode.isArray()) {
                throw new RuntimeException("ProducerSnapshot expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<ProducerEntry> _collection = new ArrayList<ProducerEntry>(_producerEntriesNode.size());
            _object.producerEntries = _collection;
            for (JsonNode _element : _producerEntriesNode) {
                _collection.add(ProducerEntryJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(ProducerSnapshot _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("crc", new LongNode(_object.crc));
        ArrayNode _producerEntriesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ProducerEntry _element : _object.producerEntries) {
            _producerEntriesArray.add(ProducerEntryJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("producerEntries", _producerEntriesArray);
        return _node;
    }
    public static JsonNode write(ProducerSnapshot _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class ProducerEntryJsonConverter {
        public static ProducerEntry read(JsonNode _node, short _version) {
            ProducerEntry _object = new ProducerEntry();
            JsonNode _producerIdNode = _node.get("producerId");
            if (_producerIdNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'producerId', which is mandatory in version " + _version);
            } else {
                _object.producerId = MessageUtil.jsonNodeToLong(_producerIdNode, "ProducerEntry");
            }
            JsonNode _epochNode = _node.get("epoch");
            if (_epochNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'epoch', which is mandatory in version " + _version);
            } else {
                _object.epoch = MessageUtil.jsonNodeToShort(_epochNode, "ProducerEntry");
            }
            JsonNode _lastSequenceNode = _node.get("lastSequence");
            if (_lastSequenceNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'lastSequence', which is mandatory in version " + _version);
            } else {
                _object.lastSequence = MessageUtil.jsonNodeToInt(_lastSequenceNode, "ProducerEntry");
            }
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            } else {
                _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "ProducerEntry");
            }
            JsonNode _offsetDeltaNode = _node.get("offsetDelta");
            if (_offsetDeltaNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'offsetDelta', which is mandatory in version " + _version);
            } else {
                _object.offsetDelta = MessageUtil.jsonNodeToInt(_offsetDeltaNode, "ProducerEntry");
            }
            JsonNode _timestampNode = _node.get("timestamp");
            if (_timestampNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'timestamp', which is mandatory in version " + _version);
            } else {
                _object.timestamp = MessageUtil.jsonNodeToLong(_timestampNode, "ProducerEntry");
            }
            JsonNode _coordinatorEpochNode = _node.get("coordinatorEpoch");
            if (_coordinatorEpochNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'coordinatorEpoch', which is mandatory in version " + _version);
            } else {
                _object.coordinatorEpoch = MessageUtil.jsonNodeToInt(_coordinatorEpochNode, "ProducerEntry");
            }
            JsonNode _currentTxnFirstOffsetNode = _node.get("currentTxnFirstOffset");
            if (_currentTxnFirstOffsetNode == null) {
                throw new RuntimeException("ProducerEntry: unable to locate field 'currentTxnFirstOffset', which is mandatory in version " + _version);
            } else {
                _object.currentTxnFirstOffset = MessageUtil.jsonNodeToLong(_currentTxnFirstOffsetNode, "ProducerEntry");
            }
            return _object;
        }
        public static JsonNode write(ProducerEntry _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("producerId", new LongNode(_object.producerId));
            _node.set("epoch", new ShortNode(_object.epoch));
            _node.set("lastSequence", new IntNode(_object.lastSequence));
            _node.set("lastOffset", new LongNode(_object.lastOffset));
            _node.set("offsetDelta", new IntNode(_object.offsetDelta));
            _node.set("timestamp", new LongNode(_object.timestamp));
            _node.set("coordinatorEpoch", new IntNode(_object.coordinatorEpoch));
            _node.set("currentTxnFirstOffset", new LongNode(_object.currentTxnFirstOffset));
            return _node;
        }
        public static JsonNode write(ProducerEntry _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
