/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.SystemTimerReaper;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SystemTimerReaperTest {
    private <T> CompletableFuture<T> add(Timer timer, long delayMs) {
        FutureTimerTask task = new FutureTimerTask(delayMs);
        timer.add(task);
        return task.future;
    }

    @Test
    public void testReaper() throws Exception {
        try (SystemTimerReaper timer = new SystemTimerReaper("reaper", (Timer)new SystemTimer("timer"));){
            CompletableFuture t1 = this.add((Timer)timer, 100L);
            CompletableFuture t2 = this.add((Timer)timer, 200L);
            CompletableFuture t3 = this.add((Timer)timer, 300L);
            TestUtils.assertFutureThrows(TimeoutException.class, t1);
            TestUtils.assertFutureThrows(TimeoutException.class, t2);
            TestUtils.assertFutureThrows(TimeoutException.class, t3);
        }
    }

    @Test
    public void testReaperClose() throws Exception {
        Timer timer = (Timer)Mockito.mock(Timer.class);
        SystemTimerReaper timerReaper = new SystemTimerReaper("reaper", timer);
        timerReaper.close();
        ((Timer)Mockito.verify((Object)timer, (VerificationMode)Mockito.times((int)1))).close();
        TestUtils.waitForCondition(() -> ((SystemTimerReaper)timerReaper).isShutdown(), (String)"reaper not shutdown");
    }

    private static class FutureTimerTask<T>
    extends TimerTask {
        CompletableFuture<T> future = new CompletableFuture();

        FutureTimerTask(long delayMs) {
            super(delayMs);
        }

        public void run() {
            this.future.completeExceptionally((Throwable)new TimeoutException(String.format("Future failed to be completed before timeout of %sMs ms was reached", this.delayMs)));
        }
    }
}

