/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TimelineHashMapTest {
    @Test
    public void testEmptyMap() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(registry, 1);
        Assertions.assertTrue((boolean)map.isEmpty());
        Assertions.assertEquals((int)0, (int)map.size());
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testNullsForbidden() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(registry, 1);
        Assertions.assertThrows(NullPointerException.class, () -> map.put(null, (Object)true));
        Assertions.assertThrows(NullPointerException.class, () -> map.put((Object)"abc", null));
        Assertions.assertThrows(NullPointerException.class, () -> map.put(null, null));
    }

    @Test
    public void testIteration() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(registry, 1);
        map.put((Object)123, (Object)"abc");
        map.put((Object)456, (Object)"def");
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(map.keySet().iterator()).containsAll(Arrays.asList(123, 456)));
        Assertions.assertTrue((boolean)TimelineHashMapTest.iteratorToList(map.values().iterator()).containsAll(Arrays.asList("abc", "def")));
        Assertions.assertTrue((boolean)map.containsValue((Object)"abc"));
        Assertions.assertTrue((boolean)map.containsKey((Object)456));
        Assertions.assertFalse((boolean)map.isEmpty());
        registry.getOrCreateSnapshot(2L);
        Iterator iter = map.entrySet(2L).iterator();
        map.clear();
        ArrayList<String> snapshotValues = new ArrayList<String>();
        snapshotValues.add((String)((Map.Entry)iter.next()).getValue());
        snapshotValues.add((String)((Map.Entry)iter.next()).getValue());
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertTrue((boolean)snapshotValues.containsAll(Arrays.asList("abc", "def")));
        Assertions.assertFalse((boolean)map.isEmpty(2L));
        Assertions.assertTrue((boolean)map.isEmpty());
    }

    static <T> List<T> iteratorToList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    @Test
    public void testMapMethods() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(registry, 1);
        Assertions.assertNull((Object)map.putIfAbsent((Object)1, (Object)"xyz"));
        Assertions.assertEquals((Object)"xyz", (Object)map.putIfAbsent((Object)1, (Object)"123"));
        Assertions.assertEquals((Object)"xyz", (Object)map.putIfAbsent((Object)1, (Object)"ghi"));
        map.putAll(Collections.singletonMap(2, "b"));
        Assertions.assertTrue((boolean)map.containsKey((Object)2));
        Assertions.assertEquals((Object)"xyz", (Object)map.remove((Object)1));
        Assertions.assertEquals((Object)"b", (Object)map.remove((Object)2));
    }

    @Test
    public void testMapEquals() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map1 = new TimelineHashMap(registry, 1);
        Assertions.assertNull((Object)map1.putIfAbsent((Object)1, (Object)"xyz"));
        Assertions.assertNull((Object)map1.putIfAbsent((Object)2, (Object)"abc"));
        TimelineHashMap map2 = new TimelineHashMap(registry, 1);
        Assertions.assertNull((Object)map2.putIfAbsent((Object)1, (Object)"xyz"));
        Assertions.assertNotEquals((Object)map1, (Object)map2);
        Assertions.assertNull((Object)map2.putIfAbsent((Object)2, (Object)"abc"));
        Assertions.assertEquals((Object)map1, (Object)map2);
    }
}

