/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.deferred;

import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.deferred.DeferredEvent;
import org.apache.kafka.deferred.DeferredEventQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class DeferredEventQueueTest {
    @Test
    public void testCompleteEvents() {
        DeferredEventQueue deferredEventQueue = new DeferredEventQueue(new LogContext());
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        SampleDeferredEvent event3 = new SampleDeferredEvent();
        deferredEventQueue.add(1L, (DeferredEvent)event1);
        Assertions.assertEquals((Object)OptionalLong.of(1L), (Object)deferredEventQueue.highestPendingOffset());
        deferredEventQueue.add(1L, (DeferredEvent)event2);
        Assertions.assertEquals((Object)OptionalLong.of(1L), (Object)deferredEventQueue.highestPendingOffset());
        deferredEventQueue.add(3L, (DeferredEvent)event3);
        Assertions.assertEquals((Object)OptionalLong.of(3L), (Object)deferredEventQueue.highestPendingOffset());
        deferredEventQueue.completeUpTo(2L);
        Assertions.assertTrue((boolean)event1.future.isDone());
        Assertions.assertTrue((boolean)event2.future.isDone());
        Assertions.assertFalse((boolean)event3.future.isDone());
        deferredEventQueue.completeUpTo(4L);
        Assertions.assertTrue((boolean)event3.future.isDone());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)deferredEventQueue.highestPendingOffset());
    }

    @Test
    public void testFailOnIncorrectOrdering() {
        DeferredEventQueue deferredEventQueue = new DeferredEventQueue(new LogContext());
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        deferredEventQueue.add(2L, (DeferredEvent)event1);
        Assertions.assertThrows(RuntimeException.class, () -> deferredEventQueue.add(1L, (DeferredEvent)event2));
    }

    @Test
    public void testFailEvents() {
        DeferredEventQueue deferredEventQueue = new DeferredEventQueue(new LogContext());
        SampleDeferredEvent event1 = new SampleDeferredEvent();
        SampleDeferredEvent event2 = new SampleDeferredEvent();
        SampleDeferredEvent event3 = new SampleDeferredEvent();
        deferredEventQueue.add(1L, (DeferredEvent)event1);
        deferredEventQueue.add(3L, (DeferredEvent)event2);
        deferredEventQueue.add(3L, (DeferredEvent)event3);
        deferredEventQueue.completeUpTo(2L);
        Assertions.assertTrue((boolean)event1.future.isDone());
        Assertions.assertFalse((boolean)event2.future.isDone());
        Assertions.assertFalse((boolean)event3.future.isDone());
        deferredEventQueue.failAll((Exception)new RuntimeException("failed"));
        Assertions.assertTrue((boolean)event2.future.isDone());
        Assertions.assertTrue((boolean)event3.future.isDone());
        Assertions.assertEquals(RuntimeException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> event2.future.get())).getCause().getClass());
        Assertions.assertEquals(RuntimeException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> event3.future.get())).getCause().getClass());
    }

    static class SampleDeferredEvent
    implements DeferredEvent {
        private final CompletableFuture<Void> future = new CompletableFuture();

        SampleDeferredEvent() {
        }

        public void complete(Throwable exception) {
            if (exception != null) {
                this.future.completeExceptionally(exception);
            } else {
                this.future.complete(null);
            }
        }
    }
}

