/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;

public class MockScheduler
implements Scheduler {
    private final PriorityQueue<MockTask> tasks = new PriorityQueue<MockTask>(Comparator.comparing(t -> t.nextExecution()));
    private final Time time;

    public MockScheduler(Time time) {
        this.time = time;
    }

    public void startup() {
    }

    public ScheduledFuture<?> schedule(String name, Runnable task, long delayMs, long periodMs) {
        MockTask mockTask = new MockTask(name, task, this.time.milliseconds() + delayMs, periodMs, this.time);
        this.add(mockTask);
        this.tick();
        return mockTask;
    }

    public void shutdown() throws InterruptedException {
        Optional<MockTask> currentTask;
        do {
            currentTask = this.poll(t -> true);
            currentTask.ifPresent(t -> t.task.run());
        } while (currentTask.isPresent());
    }

    public void resizeThreadPool(int newSize) {
    }

    public void tick() {
        Optional<MockTask> currentTask;
        long now = this.time.milliseconds();
        do {
            currentTask = this.poll(t -> t.nextExecution() <= now);
            currentTask.ifPresent(t -> {
                t.task.run();
                if (t.rescheduleIfPeriodic()) {
                    this.add((MockTask)t);
                }
            });
        } while (currentTask.isPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        MockScheduler mockScheduler = this;
        synchronized (mockScheduler) {
            this.tasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<MockTask> poll(Predicate<MockTask> predicate) {
        MockScheduler mockScheduler = this;
        synchronized (mockScheduler) {
            Optional<MockTask> result = Optional.ofNullable(this.tasks.peek()).filter(predicate);
            result.ifPresent(t -> this.tasks.poll());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(MockTask task) {
        MockScheduler mockScheduler = this;
        synchronized (mockScheduler) {
            this.tasks.add(task);
        }
    }

    private static class MockTask
    implements ScheduledFuture<Void> {
        final String name;
        final Runnable task;
        final long period;
        final Time time;
        private final AtomicLong nextExecution;

        private MockTask(String name, Runnable task, long nextExecution, long period, Time time) {
            this.name = name;
            this.task = task;
            this.nextExecution = new AtomicLong(nextExecution);
            this.period = period;
            this.time = time;
        }

        public boolean rescheduleIfPeriodic() {
            if (this.periodic()) {
                this.nextExecution.addAndGet(this.period);
                return true;
            }
            return false;
        }

        public long nextExecution() {
            return this.nextExecution.get();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.time.milliseconds() - this.nextExecution();
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        private boolean periodic() {
            return this.period >= 0L;
        }
    }
}

