/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

public final class RecordsSnapshotWriter<T>
implements SnapshotWriter<T> {
    private final RawSnapshotWriter snapshot;
    private final BatchAccumulator<T> accumulator;
    private final Time time;
    private final long lastContainedLogTimestamp;

    private RecordsSnapshotWriter(RawSnapshotWriter snapshot, int maxBatchSize, MemoryPool memoryPool, Time time, long lastContainedLogTimestamp, CompressionType compressionType, RecordSerde<T> serde) {
        this.snapshot = snapshot;
        this.time = time;
        this.lastContainedLogTimestamp = lastContainedLogTimestamp;
        this.accumulator = new BatchAccumulator<T>(snapshot.snapshotId().epoch, 0L, Integer.MAX_VALUE, maxBatchSize, memoryPool, time, compressionType, serde);
    }

    private void initializeSnapshotWithHeader() {
        if (this.snapshot.sizeInBytes() != 0L) {
            String message = String.format("Initializing writer with a non-empty snapshot: id = '%s'.", this.snapshot.snapshotId());
            throw new IllegalStateException(message);
        }
        SnapshotHeaderRecord headerRecord = new SnapshotHeaderRecord().setVersion((short)0).setLastContainedLogTimestamp(this.lastContainedLogTimestamp);
        this.accumulator.appendSnapshotHeaderRecord(headerRecord, this.time.milliseconds());
        this.accumulator.forceDrain();
    }

    private void finalizeSnapshotWithFooter() {
        SnapshotFooterRecord footerRecord = new SnapshotFooterRecord().setVersion((short)0);
        this.accumulator.appendSnapshotFooterRecord(footerRecord, this.time.milliseconds());
        this.accumulator.forceDrain();
    }

    public static <T> Optional<SnapshotWriter<T>> createWithHeader(Supplier<Optional<RawSnapshotWriter>> supplier, int maxBatchSize, MemoryPool memoryPool, Time snapshotTime, long lastContainedLogTimestamp, CompressionType compressionType, RecordSerde<T> serde) {
        return supplier.get().map(snapshot -> {
            RecordsSnapshotWriter writer = new RecordsSnapshotWriter((RawSnapshotWriter)snapshot, maxBatchSize, memoryPool, snapshotTime, lastContainedLogTimestamp, compressionType, serde);
            super.initializeSnapshotWithHeader();
            return writer;
        });
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshot.snapshotId();
    }

    @Override
    public long lastContainedLogOffset() {
        return this.snapshot.snapshotId().offset - 1L;
    }

    @Override
    public int lastContainedLogEpoch() {
        return this.snapshot.snapshotId().epoch;
    }

    @Override
    public boolean isFrozen() {
        return this.snapshot.isFrozen();
    }

    @Override
    public void append(List<T> records) {
        if (this.snapshot.isFrozen()) {
            String message = String.format("Append not supported. Snapshot is already frozen: id = '%s'.", this.snapshot.snapshotId());
            throw new IllegalStateException(message);
        }
        this.accumulator.append(this.snapshot.snapshotId().epoch, records);
        if (this.accumulator.needsDrain(this.time.milliseconds())) {
            this.appendBatches(this.accumulator.drain());
        }
    }

    @Override
    public void freeze() {
        this.finalizeSnapshotWithFooter();
        this.appendBatches(this.accumulator.drain());
        this.snapshot.freeze();
        this.accumulator.close();
    }

    @Override
    public void close() {
        this.snapshot.close();
        this.accumulator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBatches(List<BatchAccumulator.CompletedBatch<T>> batches) {
        try {
            for (BatchAccumulator.CompletedBatch<BatchAccumulator.CompletedBatch> completedBatch : batches) {
                this.snapshot.append(completedBatch.data);
            }
        }
        finally {
            batches.forEach(BatchAccumulator.CompletedBatch::release);
        }
    }
}

