/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public final class QuorumControllerMetrics
implements ControllerMetrics {
    private static final MetricName ACTIVE_CONTROLLER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveControllerCount");
    private static final MetricName EVENT_QUEUE_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueTimeMs");
    private static final MetricName EVENT_QUEUE_PROCESSING_TIME_MS = QuorumControllerMetrics.getMetricName("ControllerEventManager", "EventQueueProcessingTimeMs");
    private static final MetricName FENCED_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "FencedBrokerCount");
    private static final MetricName ACTIVE_BROKER_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "ActiveBrokerCount");
    private static final MetricName GLOBAL_TOPIC_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalTopicCount");
    private static final MetricName GLOBAL_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "GlobalPartitionCount");
    private static final MetricName OFFLINE_PARTITION_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "OfflinePartitionsCount");
    private static final MetricName PREFERRED_REPLICA_IMBALANCE_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "PreferredReplicaImbalanceCount");
    private static final MetricName METADATA_ERROR_COUNT = QuorumControllerMetrics.getMetricName("KafkaController", "MetadataErrorCount");
    private static final MetricName LAST_APPLIED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordOffset");
    private static final MetricName LAST_COMMITTED_RECORD_OFFSET = QuorumControllerMetrics.getMetricName("KafkaController", "LastCommittedRecordOffset");
    private static final MetricName LAST_APPLIED_RECORD_TIMESTAMP = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordTimestamp");
    private static final MetricName LAST_APPLIED_RECORD_LAG_MS = QuorumControllerMetrics.getMetricName("KafkaController", "LastAppliedRecordLagMs");
    private final MetricsRegistry registry;
    private volatile boolean active;
    private volatile int fencedBrokerCount;
    private volatile int activeBrokerCount;
    private volatile int globalTopicCount;
    private volatile int globalPartitionCount;
    private volatile int offlinePartitionCount;
    private volatile int preferredReplicaImbalanceCount;
    private final AtomicInteger metadataErrorCount;
    private final AtomicLong lastAppliedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastCommittedRecordOffset = new AtomicLong(0L);
    private final AtomicLong lastAppliedRecordTimestamp = new AtomicLong(0L);
    private final Gauge<Integer> activeControllerCount;
    private final Gauge<Integer> fencedBrokerCountGauge;
    private final Gauge<Integer> activeBrokerCountGauge;
    private final Gauge<Integer> globalPartitionCountGauge;
    private final Gauge<Integer> globalTopicCountGauge;
    private final Gauge<Integer> offlinePartitionCountGauge;
    private final Gauge<Integer> preferredReplicaImbalanceCountGauge;
    private final Gauge<Integer> metadataErrorCountGauge;
    private final Gauge<Long> lastAppliedRecordOffsetGauge;
    private final Gauge<Long> lastCommittedRecordOffsetGauge;
    private final Gauge<Long> lastAppliedRecordTimestampGauge;
    private final Gauge<Long> lastAppliedRecordLagMsGauge;
    private final Histogram eventQueueTime;
    private final Histogram eventQueueProcessingTime;

    public QuorumControllerMetrics(MetricsRegistry registry, final Time time) {
        this.registry = Objects.requireNonNull(registry);
        this.active = false;
        this.fencedBrokerCount = 0;
        this.activeBrokerCount = 0;
        this.globalTopicCount = 0;
        this.globalPartitionCount = 0;
        this.offlinePartitionCount = 0;
        this.preferredReplicaImbalanceCount = 0;
        this.metadataErrorCount = new AtomicInteger(0);
        this.activeControllerCount = registry.newGauge(ACTIVE_CONTROLLER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.active ? 1 : 0;
            }
        });
        this.eventQueueTime = registry.newHistogram(EVENT_QUEUE_TIME_MS, true);
        this.eventQueueProcessingTime = registry.newHistogram(EVENT_QUEUE_PROCESSING_TIME_MS, true);
        this.fencedBrokerCountGauge = registry.newGauge(FENCED_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.fencedBrokerCount;
            }
        });
        this.activeBrokerCountGauge = registry.newGauge(ACTIVE_BROKER_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.activeBrokerCount;
            }
        });
        this.globalTopicCountGauge = registry.newGauge(GLOBAL_TOPIC_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalTopicCount;
            }
        });
        this.globalPartitionCountGauge = registry.newGauge(GLOBAL_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.globalPartitionCount;
            }
        });
        this.offlinePartitionCountGauge = registry.newGauge(OFFLINE_PARTITION_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.offlinePartitionCount;
            }
        });
        this.preferredReplicaImbalanceCountGauge = registry.newGauge(PREFERRED_REPLICA_IMBALANCE_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.preferredReplicaImbalanceCount;
            }
        });
        this.metadataErrorCountGauge = registry.newGauge(METADATA_ERROR_COUNT, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return QuorumControllerMetrics.this.metadataErrorCount.get();
            }
        });
        this.lastAppliedRecordOffsetGauge = registry.newGauge(LAST_APPLIED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordOffset.get();
            }
        });
        this.lastCommittedRecordOffsetGauge = registry.newGauge(LAST_COMMITTED_RECORD_OFFSET, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastCommittedRecordOffset.get();
            }
        });
        this.lastAppliedRecordTimestampGauge = registry.newGauge(LAST_APPLIED_RECORD_TIMESTAMP, (Gauge)new Gauge<Long>(){

            public Long value() {
                return QuorumControllerMetrics.this.lastAppliedRecordTimestamp.get();
            }
        });
        this.lastAppliedRecordLagMsGauge = registry.newGauge(LAST_APPLIED_RECORD_LAG_MS, (Gauge)new Gauge<Long>(){

            public Long value() {
                return time.milliseconds() - QuorumControllerMetrics.this.lastAppliedRecordTimestamp.get();
            }
        });
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean active() {
        return this.active;
    }

    @Override
    public void updateEventQueueTime(long durationMs) {
        this.eventQueueTime.update(durationMs);
    }

    @Override
    public void updateEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTime.update(durationMs);
    }

    @Override
    public void setFencedBrokerCount(int brokerCount) {
        this.fencedBrokerCount = brokerCount;
    }

    @Override
    public int fencedBrokerCount() {
        return this.fencedBrokerCount;
    }

    @Override
    public void setActiveBrokerCount(int brokerCount) {
        this.activeBrokerCount = brokerCount;
    }

    @Override
    public int activeBrokerCount() {
        return this.activeBrokerCount;
    }

    @Override
    public void setGlobalTopicCount(int topicCount) {
        this.globalTopicCount = topicCount;
    }

    @Override
    public int globalTopicCount() {
        return this.globalTopicCount;
    }

    @Override
    public void setGlobalPartitionCount(int partitionCount) {
        this.globalPartitionCount = partitionCount;
    }

    @Override
    public int globalPartitionCount() {
        return this.globalPartitionCount;
    }

    @Override
    public void setOfflinePartitionCount(int offlinePartitions) {
        this.offlinePartitionCount = offlinePartitions;
    }

    @Override
    public int offlinePartitionCount() {
        return this.offlinePartitionCount;
    }

    @Override
    public void setPreferredReplicaImbalanceCount(int replicaImbalances) {
        this.preferredReplicaImbalanceCount = replicaImbalances;
    }

    @Override
    public int preferredReplicaImbalanceCount() {
        return this.preferredReplicaImbalanceCount;
    }

    @Override
    public void incrementMetadataErrorCount() {
        this.metadataErrorCount.getAndIncrement();
    }

    @Override
    public int metadataErrorCount() {
        return this.metadataErrorCount.get();
    }

    @Override
    public void setLastAppliedRecordOffset(long offset) {
        this.lastAppliedRecordOffset.set(offset);
    }

    @Override
    public long lastAppliedRecordOffset() {
        return this.lastAppliedRecordOffset.get();
    }

    @Override
    public void setLastCommittedRecordOffset(long offset) {
        this.lastCommittedRecordOffset.set(offset);
    }

    @Override
    public long lastCommittedRecordOffset() {
        return this.lastCommittedRecordOffset.get();
    }

    @Override
    public void setLastAppliedRecordTimestamp(long timestamp) {
        this.lastAppliedRecordTimestamp.set(timestamp);
    }

    @Override
    public long lastAppliedRecordTimestamp() {
        return this.lastAppliedRecordTimestamp.get();
    }

    @Override
    public void close() {
        Arrays.asList(ACTIVE_CONTROLLER_COUNT, FENCED_BROKER_COUNT, ACTIVE_BROKER_COUNT, EVENT_QUEUE_TIME_MS, EVENT_QUEUE_PROCESSING_TIME_MS, GLOBAL_TOPIC_COUNT, GLOBAL_PARTITION_COUNT, OFFLINE_PARTITION_COUNT, PREFERRED_REPLICA_IMBALANCE_COUNT, METADATA_ERROR_COUNT, LAST_APPLIED_RECORD_OFFSET, LAST_COMMITTED_RECORD_OFFSET, LAST_APPLIED_RECORD_TIMESTAMP, LAST_APPLIED_RECORD_LAG_MS).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
    }

    private static MetricName getMetricName(String type, String name) {
        return KafkaYammerMetrics.getMetricName((String)"kafka.controller", (String)type, (String)name);
    }
}

