/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

import static org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection;


public class AlterPartitionRequestData implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    
    public static final Schema SCHEMA_2 =
        new Schema(
            new Field("broker_id", Type.INT32, "The ID of the requesting broker."),
            new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker."),
            new Field("topics", new CompactArrayOf(TopicData.SCHEMA_2), "The topics to alter ISRs for."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema SCHEMA_3 =
        new Schema(
            new Field("broker_id", Type.INT32, "The ID of the requesting broker."),
            new Field("broker_epoch", Type.INT64, "The epoch of the requesting broker."),
            new Field("topics", new CompactArrayOf(TopicData.SCHEMA_3), "The topics to alter ISRs for."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema[] SCHEMAS = new Schema[] {
        null,
        null,
        SCHEMA_2,
        SCHEMA_3
    };
    
    public static final short LOWEST_SUPPORTED_VERSION = 2;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;
    
    public AlterPartitionRequestData(Readable _readable, short _version) {
        read(_readable, _version);
    }
    
    public AlterPartitionRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
        this.topics = new ArrayList<TopicData>(0);
    }
    
    @Override
    public short apiKey() {
        return 56;
    }
    
    @Override
    public short lowestSupportedVersion() {
        return 2;
    }
    
    @Override
    public short highestSupportedVersion() {
        return 3;
    }
    
    @Override
    public final void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<TopicData> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    newCollection.add(new TopicData(_readable, _version));
                }
                this.topics = newCollection;
            }
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; _i++) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default:
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    break;
            }
        }
    }
    
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(brokerId);
        _writable.writeLong(brokerEpoch);
        _writable.writeUnsignedVarint(topics.size() + 1);
        for (TopicData topicsElement : topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        _writable.writeUnsignedVarint(_numTaggedFields);
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }
    
    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(topics.size() + 1));
            for (TopicData topicsElement : topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
        }
        if (_unknownTaggedFields != null) {
            _numTaggedFields += _unknownTaggedFields.size();
            for (RawTaggedField _field : _unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AlterPartitionRequestData)) return false;
        AlterPartitionRequestData other = (AlterPartitionRequestData) obj;
        if (brokerId != other.brokerId) return false;
        if (brokerEpoch != other.brokerEpoch) return false;
        if (this.topics == null) {
            if (other.topics != null) return false;
        } else {
            if (!this.topics.equals(other.topics)) return false;
        }
        return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
    }
    
    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + brokerId;
        hashCode = 31 * hashCode + ((int) (brokerEpoch >> 32) ^ (int) brokerEpoch);
        hashCode = 31 * hashCode + (topics == null ? 0 : topics.hashCode());
        return hashCode;
    }
    
    @Override
    public AlterPartitionRequestData duplicate() {
        AlterPartitionRequestData _duplicate = new AlterPartitionRequestData();
        _duplicate.brokerId = brokerId;
        _duplicate.brokerEpoch = brokerEpoch;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(topics.size());
        for (TopicData _element : topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }
    
    @Override
    public String toString() {
        return "AlterPartitionRequestData("
            + "brokerId=" + brokerId
            + ", brokerEpoch=" + brokerEpoch
            + ", topics=" + MessageUtil.deepToString(topics.iterator())
            + ")";
    }
    
    public int brokerId() {
        return this.brokerId;
    }
    
    public long brokerEpoch() {
        return this.brokerEpoch;
    }
    
    public List<TopicData> topics() {
        return this.topics;
    }
    
    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (_unknownTaggedFields == null) {
            _unknownTaggedFields = new ArrayList<>(0);
        }
        return _unknownTaggedFields;
    }
    
    public AlterPartitionRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }
    
    public AlterPartitionRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }
    
    public AlterPartitionRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }
    
    public static class TopicData implements Message {
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_2 =
            new Schema(
                new Field("topic_id", Type.UUID, "The ID of the topic to alter ISRs for."),
                new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_2), "The partitions to alter ISRs for."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema SCHEMA_3 =
            new Schema(
                new Field("topic_id", Type.UUID, "The ID of the topic to alter ISRs for."),
                new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_3), "The partitions to alter ISRs for."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            null,
            null,
            SCHEMA_2,
            SCHEMA_3
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;
        
        public TopicData(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public TopicData() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 2;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 3;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            if ((_version < 2) || (_version > 3)) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this.topicId = _readable.readUuid();
            {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<PartitionData> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new PartitionData(_readable, _version));
                    }
                    this.partitions = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(topicId);
            _writable.writeUnsignedVarint(partitions.size() + 1);
            for (PartitionData partitionsElement : partitions) {
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if ((_version < 2) || (_version > 3)) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            _size.addBytes(16);
            {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(partitions.size() + 1));
                for (PartitionData partitionsElement : partitions) {
                    partitionsElement.addSize(_size, _cache, _version);
                }
            }
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) return false;
            TopicData other = (TopicData) obj;
            if (!this.topicId.equals(other.topicId)) return false;
            if (this.partitions == null) {
                if (other.partitions != null) return false;
            } else {
                if (!this.partitions.equals(other.partitions)) return false;
            }
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + topicId.hashCode();
            hashCode = 31 * hashCode + (partitions == null ? 0 : partitions.hashCode());
            return hashCode;
        }
        
        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicId = topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(partitions.size());
            for (PartitionData _element : partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "TopicData("
                + "topicId=" + topicId.toString()
                + ", partitions=" + MessageUtil.deepToString(partitions.iterator())
                + ")";
        }
        
        public Uuid topicId() {
            return this.topicId;
        }
        
        public List<PartitionData> partitions() {
            return this.partitions;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public TopicData setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }
        
        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
    
    public static class PartitionData implements Message {
        int partitionIndex;
        int leaderEpoch;
        List<Integer> newIsr;
        List<BrokerState> newIsrWithEpochs;
        byte leaderRecoveryState;
        int partitionEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_2 =
            new Schema(
                new Field("partition_index", Type.INT32, "The partition index."),
                new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."),
                new Field("new_isr", new CompactArrayOf(Type.INT32), "The ISR for this partition. Deprecated since version 3."),
                new Field("leader_recovery_state", Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."),
                new Field("partition_epoch", Type.INT32, "The expected epoch of the partition which is being updated."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema SCHEMA_3 =
            new Schema(
                new Field("partition_index", Type.INT32, "The partition index."),
                new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."),
                new Field("new_isr_with_epochs", new CompactArrayOf(BrokerState.SCHEMA_3), "The ISR for this partition."),
                new Field("leader_recovery_state", Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."),
                new Field("partition_epoch", Type.INT32, "The expected epoch of the partition which is being updated."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            null,
            null,
            SCHEMA_2,
            SCHEMA_3
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 2;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;
        
        public PartitionData(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public PartitionData() {
            this.partitionIndex = 0;
            this.leaderEpoch = 0;
            this.newIsr = new ArrayList<Integer>(0);
            this.newIsrWithEpochs = new ArrayList<BrokerState>(0);
            this.leaderRecoveryState = (byte) 0;
            this.partitionEpoch = 0;
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 2;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 3;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            if ((_version < 2) || (_version > 3)) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            if (_version <= 2) {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field newIsr was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(_readable.readInt());
                    }
                    this.newIsr = newCollection;
                }
            } else {
                this.newIsr = new ArrayList<Integer>(0);
            }
            if (_version >= 3) {
                int arrayLength;
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field newIsrWithEpochs was serialized as null");
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<BrokerState> newCollection = new ArrayList<>(arrayLength);
                    for (int i = 0; i < arrayLength; i++) {
                        newCollection.add(new BrokerState(_readable, _version));
                    }
                    this.newIsrWithEpochs = newCollection;
                }
            } else {
                this.newIsrWithEpochs = new ArrayList<BrokerState>(0);
            }
            this.leaderRecoveryState = _readable.readByte();
            this.partitionEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(partitionIndex);
            _writable.writeInt(leaderEpoch);
            if (_version <= 2) {
                _writable.writeUnsignedVarint(newIsr.size() + 1);
                for (Integer newIsrElement : newIsr) {
                    _writable.writeInt(newIsrElement);
                }
            } else {
                if (!this.newIsr.isEmpty()) {
                    throw new UnsupportedVersionException("Attempted to write a non-default newIsr at version " + _version);
                }
            }
            if (_version >= 3) {
                _writable.writeUnsignedVarint(newIsrWithEpochs.size() + 1);
                for (BrokerState newIsrWithEpochsElement : newIsrWithEpochs) {
                    newIsrWithEpochsElement.write(_writable, _cache, _version);
                }
            } else {
                if (!this.newIsrWithEpochs.isEmpty()) {
                    throw new UnsupportedVersionException("Attempted to write a non-default newIsrWithEpochs at version " + _version);
                }
            }
            _writable.writeByte(leaderRecoveryState);
            _writable.writeInt(partitionEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if ((_version < 2) || (_version > 3)) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            if (_version <= 2) {
                {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(newIsr.size() + 1));
                    _size.addBytes(newIsr.size() * 4);
                }
            }
            if (_version >= 3) {
                {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(newIsrWithEpochs.size() + 1));
                    for (BrokerState newIsrWithEpochsElement : newIsrWithEpochs) {
                        newIsrWithEpochsElement.addSize(_size, _cache, _version);
                    }
                }
            }
            _size.addBytes(1);
            _size.addBytes(4);
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) return false;
            PartitionData other = (PartitionData) obj;
            if (partitionIndex != other.partitionIndex) return false;
            if (leaderEpoch != other.leaderEpoch) return false;
            if (this.newIsr == null) {
                if (other.newIsr != null) return false;
            } else {
                if (!this.newIsr.equals(other.newIsr)) return false;
            }
            if (this.newIsrWithEpochs == null) {
                if (other.newIsrWithEpochs != null) return false;
            } else {
                if (!this.newIsrWithEpochs.equals(other.newIsrWithEpochs)) return false;
            }
            if (leaderRecoveryState != other.leaderRecoveryState) return false;
            if (partitionEpoch != other.partitionEpoch) return false;
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + partitionIndex;
            hashCode = 31 * hashCode + leaderEpoch;
            hashCode = 31 * hashCode + (newIsr == null ? 0 : newIsr.hashCode());
            hashCode = 31 * hashCode + (newIsrWithEpochs == null ? 0 : newIsrWithEpochs.hashCode());
            hashCode = 31 * hashCode + leaderRecoveryState;
            hashCode = 31 * hashCode + partitionEpoch;
            return hashCode;
        }
        
        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = partitionIndex;
            _duplicate.leaderEpoch = leaderEpoch;
            ArrayList<Integer> newNewIsr = new ArrayList<Integer>(newIsr.size());
            for (Integer _element : newIsr) {
                newNewIsr.add(_element);
            }
            _duplicate.newIsr = newNewIsr;
            ArrayList<BrokerState> newNewIsrWithEpochs = new ArrayList<BrokerState>(newIsrWithEpochs.size());
            for (BrokerState _element : newIsrWithEpochs) {
                newNewIsrWithEpochs.add(_element.duplicate());
            }
            _duplicate.newIsrWithEpochs = newNewIsrWithEpochs;
            _duplicate.leaderRecoveryState = leaderRecoveryState;
            _duplicate.partitionEpoch = partitionEpoch;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "PartitionData("
                + "partitionIndex=" + partitionIndex
                + ", leaderEpoch=" + leaderEpoch
                + ", newIsr=" + MessageUtil.deepToString(newIsr.iterator())
                + ", newIsrWithEpochs=" + MessageUtil.deepToString(newIsrWithEpochs.iterator())
                + ", leaderRecoveryState=" + leaderRecoveryState
                + ", partitionEpoch=" + partitionEpoch
                + ")";
        }
        
        public int partitionIndex() {
            return this.partitionIndex;
        }
        
        public int leaderEpoch() {
            return this.leaderEpoch;
        }
        
        public List<Integer> newIsr() {
            return this.newIsr;
        }
        
        public List<BrokerState> newIsrWithEpochs() {
            return this.newIsrWithEpochs;
        }
        
        public byte leaderRecoveryState() {
            return this.leaderRecoveryState;
        }
        
        public int partitionEpoch() {
            return this.partitionEpoch;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }
        
        public PartitionData setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }
        
        public PartitionData setNewIsr(List<Integer> v) {
            this.newIsr = v;
            return this;
        }
        
        public PartitionData setNewIsrWithEpochs(List<BrokerState> v) {
            this.newIsrWithEpochs = v;
            return this;
        }
        
        public PartitionData setLeaderRecoveryState(byte v) {
            this.leaderRecoveryState = v;
            return this;
        }
        
        public PartitionData setPartitionEpoch(int v) {
            this.partitionEpoch = v;
            return this;
        }
    }
    
    public static class BrokerState implements Message {
        int brokerId;
        long brokerEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        
        public static final Schema SCHEMA_3 =
            new Schema(
                new Field("broker_id", Type.INT32, "The ID of the broker."),
                new Field("broker_epoch", Type.INT64, "The epoch of the broker. It will be -1 if the epoch check is not supported."),
                TaggedFieldsSection.of(
                )
            );
        
        public static final Schema[] SCHEMAS = new Schema[] {
            null,
            null,
            null,
            SCHEMA_3
        };
        
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;
        
        public BrokerState(Readable _readable, short _version) {
            read(_readable, _version);
        }
        
        public BrokerState() {
            this.brokerId = 0;
            this.brokerEpoch = -1L;
        }
        
        
        @Override
        public short lowestSupportedVersion() {
            return 2;
        }
        
        @Override
        public short highestSupportedVersion() {
            return 3;
        }
        
        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerState");
            }
            this.brokerId = _readable.readInt();
            this.brokerEpoch = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; _i++) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default:
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        break;
                }
            }
        }
        
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BrokerState");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(brokerId);
            _writable.writeLong(brokerEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }
        
        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerState");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            if (_unknownTaggedFields != null) {
                _numTaggedFields += _unknownTaggedFields.size();
                for (RawTaggedField _field : _unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }
        
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerState)) return false;
            BrokerState other = (BrokerState) obj;
            if (brokerId != other.brokerId) return false;
            if (brokerEpoch != other.brokerEpoch) return false;
            return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
        }
        
        @Override
        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + brokerId;
            hashCode = 31 * hashCode + ((int) (brokerEpoch >> 32) ^ (int) brokerEpoch);
            return hashCode;
        }
        
        @Override
        public BrokerState duplicate() {
            BrokerState _duplicate = new BrokerState();
            _duplicate.brokerId = brokerId;
            _duplicate.brokerEpoch = brokerEpoch;
            return _duplicate;
        }
        
        @Override
        public String toString() {
            return "BrokerState("
                + "brokerId=" + brokerId
                + ", brokerEpoch=" + brokerEpoch
                + ")";
        }
        
        public int brokerId() {
            return this.brokerId;
        }
        
        public long brokerEpoch() {
            return this.brokerEpoch;
        }
        
        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (_unknownTaggedFields == null) {
                _unknownTaggedFields = new ArrayList<>(0);
            }
            return _unknownTaggedFields;
        }
        
        public BrokerState setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }
        
        public BrokerState setBrokerEpoch(long v) {
            this.brokerEpoch = v;
            return this;
        }
    }
}
