/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeAclsRequestTest {
    private static final short V1 = 1;
    private static final AclBindingFilter PREFIXED_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "prefix", PatternType.PREFIXED), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter ANY_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.GROUP, "bar", PatternType.ANY), new AccessControlEntryFilter("User:*", "127.0.0.1", AclOperation.CREATE, AclPermissionType.ALLOW));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, "foo", PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.DENY));

    @Test
    public void shouldThrowIfUnknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DescribeAclsRequest.Builder(UNKNOWN_FILTER).build((short)1));
    }

    @Test
    public void shouldRoundTripPrefixedV1() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(PREFIXED_FILTER).build((short)1);
        DescribeAclsRequest result = DescribeAclsRequest.parse((Readable)original.serialize(), (short)1);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    @Test
    public void shouldRoundTripAnyV1() {
        DescribeAclsRequest original = new DescribeAclsRequest.Builder(ANY_FILTER).build((short)1);
        DescribeAclsRequest result = DescribeAclsRequest.parse((Readable)original.serialize(), (short)1);
        DescribeAclsRequestTest.assertRequestEquals(original, result);
    }

    private static void assertRequestEquals(DescribeAclsRequest original, DescribeAclsRequest actual) {
        AclBindingFilter originalFilter = original.filter();
        AclBindingFilter actualFilter = actual.filter();
        Assertions.assertEquals((Object)originalFilter, (Object)actualFilter);
    }
}

