/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData.*;

public class DescribeShareGroupOffsetsRequestDataJsonConverter {
    public static DescribeShareGroupOffsetsRequestData read(JsonNode _node, short _version) {
        DescribeShareGroupOffsetsRequestData _object = new DescribeShareGroupOffsetsRequestData();
        JsonNode _groupsNode = _node.get("groups");
        if (_groupsNode == null) {
            throw new RuntimeException("DescribeShareGroupOffsetsRequestData: unable to locate field 'groups', which is mandatory in version " + _version);
        } else {
            if (!_groupsNode.isArray()) {
                throw new RuntimeException("DescribeShareGroupOffsetsRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<DescribeShareGroupOffsetsRequestGroup> _collection = new ArrayList<DescribeShareGroupOffsetsRequestGroup>(_groupsNode.size());
            _object.groups = _collection;
            for (JsonNode _element : _groupsNode) {
                _collection.add(DescribeShareGroupOffsetsRequestGroupJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(DescribeShareGroupOffsetsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _groupsArray = new ArrayNode(JsonNodeFactory.instance);
        for (DescribeShareGroupOffsetsRequestGroup _element : _object.groups) {
            _groupsArray.add(DescribeShareGroupOffsetsRequestGroupJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("groups", _groupsArray);
        return _node;
    }
    public static JsonNode write(DescribeShareGroupOffsetsRequestData _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class DescribeShareGroupOffsetsRequestGroupJsonConverter {
        public static DescribeShareGroupOffsetsRequestGroup read(JsonNode _node, short _version) {
            DescribeShareGroupOffsetsRequestGroup _object = new DescribeShareGroupOffsetsRequestGroup();
            JsonNode _groupIdNode = _node.get("groupId");
            if (_groupIdNode == null) {
                throw new RuntimeException("DescribeShareGroupOffsetsRequestGroup: unable to locate field 'groupId', which is mandatory in version " + _version);
            } else {
                if (!_groupIdNode.isTextual()) {
                    throw new RuntimeException("DescribeShareGroupOffsetsRequestGroup expected a string type, but got " + _node.getNodeType());
                }
                _object.groupId = _groupIdNode.asText();
            }
            JsonNode _topicsNode = _node.get("topics");
            if (_topicsNode == null) {
                throw new RuntimeException("DescribeShareGroupOffsetsRequestGroup: unable to locate field 'topics', which is mandatory in version " + _version);
            } else {
                if (_topicsNode.isNull()) {
                    _object.topics = null;
                } else {
                    if (!_topicsNode.isArray()) {
                        throw new RuntimeException("DescribeShareGroupOffsetsRequestGroup expected a JSON array, but got " + _node.getNodeType());
                    }
                    ArrayList<DescribeShareGroupOffsetsRequestTopic> _collection = new ArrayList<DescribeShareGroupOffsetsRequestTopic>(_topicsNode.size());
                    _object.topics = _collection;
                    for (JsonNode _element : _topicsNode) {
                        _collection.add(DescribeShareGroupOffsetsRequestTopicJsonConverter.read(_element, _version));
                    }
                }
            }
            return _object;
        }
        public static JsonNode write(DescribeShareGroupOffsetsRequestGroup _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("groupId", new TextNode(_object.groupId));
            if (_object.topics == null) {
                _node.set("topics", NullNode.instance);
            } else {
                ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
                for (DescribeShareGroupOffsetsRequestTopic _element : _object.topics) {
                    _topicsArray.add(DescribeShareGroupOffsetsRequestTopicJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("topics", _topicsArray);
            }
            return _node;
        }
        public static JsonNode write(DescribeShareGroupOffsetsRequestGroup _object, short _version) {
            return write(_object, _version, true);
        }
    }
    
    public static class DescribeShareGroupOffsetsRequestTopicJsonConverter {
        public static DescribeShareGroupOffsetsRequestTopic read(JsonNode _node, short _version) {
            DescribeShareGroupOffsetsRequestTopic _object = new DescribeShareGroupOffsetsRequestTopic();
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("DescribeShareGroupOffsetsRequestTopic: unable to locate field 'topicName', which is mandatory in version " + _version);
            } else {
                if (!_topicNameNode.isTextual()) {
                    throw new RuntimeException("DescribeShareGroupOffsetsRequestTopic expected a string type, but got " + _node.getNodeType());
                }
                _object.topicName = _topicNameNode.asText();
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("DescribeShareGroupOffsetsRequestTopic: unable to locate field 'partitions', which is mandatory in version " + _version);
            } else {
                if (!_partitionsNode.isArray()) {
                    throw new RuntimeException("DescribeShareGroupOffsetsRequestTopic expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Integer> _collection = new ArrayList<Integer>(_partitionsNode.size());
                _object.partitions = _collection;
                for (JsonNode _element : _partitionsNode) {
                    _collection.add(MessageUtil.jsonNodeToInt(_element, "DescribeShareGroupOffsetsRequestTopic element"));
                }
            }
            return _object;
        }
        public static JsonNode write(DescribeShareGroupOffsetsRequestTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", new TextNode(_object.topicName));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.partitions) {
                _partitionsArray.add(new IntNode(_element));
            }
            _node.set("partitions", _partitionsArray);
            return _node;
        }
        public static JsonNode write(DescribeShareGroupOffsetsRequestTopic _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
